/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.StringType;

public class OperationOutcome40_50
extends VersionConvertor_40_50 {
    public static OperationOutcome convertOperationOutcome(org.hl7.fhir.r4.model.OperationOutcome src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationOutcome tgt = new OperationOutcome();
        OperationOutcome40_50.copyDomainResource(src, tgt);
        for (OperationOutcome.OperationOutcomeIssueComponent t : src.getIssue()) {
            tgt.addIssue(OperationOutcome40_50.convertOperationOutcomeIssueComponent(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.OperationOutcome convertOperationOutcome(OperationOutcome src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.OperationOutcome tgt = new org.hl7.fhir.r4.model.OperationOutcome();
        OperationOutcome40_50.copyDomainResource(src, tgt);
        for (OperationOutcome.OperationOutcomeIssueComponent t : src.getIssue()) {
            tgt.addIssue(OperationOutcome40_50.convertOperationOutcomeIssueComponent(t));
        }
        return tgt;
    }

    public static OperationOutcome.OperationOutcomeIssueComponent convertOperationOutcomeIssueComponent(OperationOutcome.OperationOutcomeIssueComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationOutcome.OperationOutcomeIssueComponent tgt = new OperationOutcome.OperationOutcomeIssueComponent();
        OperationOutcome40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSeverity()) {
            tgt.setSeverityElement(OperationOutcome40_50.convertIssueSeverity(src.getSeverityElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(OperationOutcome40_50.convertIssueType(src.getCodeElement()));
        }
        if (src.hasDetails()) {
            tgt.setDetails(OperationOutcome40_50.convertCodeableConcept(src.getDetails()));
        }
        if (src.hasDiagnostics()) {
            tgt.setDiagnosticsElement(OperationOutcome40_50.convertString(src.getDiagnosticsElement()));
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getLocation()) {
            tgt.getLocation().add(OperationOutcome40_50.convertString(t));
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getExpression()) {
            tgt.getExpression().add(OperationOutcome40_50.convertString(t));
        }
        return tgt;
    }

    public static OperationOutcome.OperationOutcomeIssueComponent convertOperationOutcomeIssueComponent(OperationOutcome.OperationOutcomeIssueComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationOutcome.OperationOutcomeIssueComponent tgt = new OperationOutcome.OperationOutcomeIssueComponent();
        OperationOutcome40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSeverity()) {
            tgt.setSeverityElement(OperationOutcome40_50.convertIssueSeverity(src.getSeverityElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(OperationOutcome40_50.convertIssueType(src.getCodeElement()));
        }
        if (src.hasDetails()) {
            tgt.setDetails(OperationOutcome40_50.convertCodeableConcept(src.getDetails()));
        }
        if (src.hasDiagnostics()) {
            tgt.setDiagnosticsElement(OperationOutcome40_50.convertString(src.getDiagnosticsElement()));
        }
        for (StringType t : src.getLocation()) {
            tgt.getLocation().add(OperationOutcome40_50.convertString(t));
        }
        for (StringType t : src.getExpression()) {
            tgt.getExpression().add(OperationOutcome40_50.convertString(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<OperationOutcome.IssueSeverity> convertIssueSeverity(Enumeration<OperationOutcome.IssueSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<OperationOutcome.IssueSeverity> tgt = new org.hl7.fhir.r5.model.Enumeration<OperationOutcome.IssueSeverity>(new OperationOutcome.IssueSeverityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((OperationOutcome.IssueSeverity)((Object)src.getValue())) {
            case FATAL: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.FATAL);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.ERROR);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.WARNING);
                break;
            }
            case INFORMATION: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.INFORMATION);
                break;
            }
            default: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<OperationOutcome.IssueSeverity> convertIssueSeverity(org.hl7.fhir.r5.model.Enumeration<OperationOutcome.IssueSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<OperationOutcome.IssueSeverity> tgt = new Enumeration<OperationOutcome.IssueSeverity>(new OperationOutcome.IssueSeverityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((OperationOutcome.IssueSeverity)((Object)src.getValue())) {
            case FATAL: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.FATAL);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.ERROR);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.WARNING);
                break;
            }
            case INFORMATION: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.INFORMATION);
                break;
            }
            default: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<OperationOutcome.IssueType> convertIssueType(Enumeration<OperationOutcome.IssueType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<OperationOutcome.IssueType> tgt = new org.hl7.fhir.r5.model.Enumeration<OperationOutcome.IssueType>(new OperationOutcome.IssueTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((OperationOutcome.IssueType)((Object)src.getValue())) {
            case INVALID: {
                tgt.setValue((Object)OperationOutcome.IssueType.INVALID);
                break;
            }
            case STRUCTURE: {
                tgt.setValue((Object)OperationOutcome.IssueType.STRUCTURE);
                break;
            }
            case REQUIRED: {
                tgt.setValue((Object)OperationOutcome.IssueType.REQUIRED);
                break;
            }
            case VALUE: {
                tgt.setValue((Object)OperationOutcome.IssueType.VALUE);
                break;
            }
            case INVARIANT: {
                tgt.setValue((Object)OperationOutcome.IssueType.INVARIANT);
                break;
            }
            case SECURITY: {
                tgt.setValue((Object)OperationOutcome.IssueType.SECURITY);
                break;
            }
            case LOGIN: {
                tgt.setValue((Object)OperationOutcome.IssueType.LOGIN);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)OperationOutcome.IssueType.UNKNOWN);
                break;
            }
            case EXPIRED: {
                tgt.setValue((Object)OperationOutcome.IssueType.EXPIRED);
                break;
            }
            case FORBIDDEN: {
                tgt.setValue((Object)OperationOutcome.IssueType.FORBIDDEN);
                break;
            }
            case SUPPRESSED: {
                tgt.setValue((Object)OperationOutcome.IssueType.SUPPRESSED);
                break;
            }
            case PROCESSING: {
                tgt.setValue((Object)OperationOutcome.IssueType.PROCESSING);
                break;
            }
            case NOTSUPPORTED: {
                tgt.setValue((Object)OperationOutcome.IssueType.NOTSUPPORTED);
                break;
            }
            case DUPLICATE: {
                tgt.setValue((Object)OperationOutcome.IssueType.DUPLICATE);
                break;
            }
            case MULTIPLEMATCHES: {
                tgt.setValue((Object)OperationOutcome.IssueType.MULTIPLEMATCHES);
                break;
            }
            case NOTFOUND: {
                tgt.setValue((Object)OperationOutcome.IssueType.NOTFOUND);
                break;
            }
            case DELETED: {
                tgt.setValue((Object)OperationOutcome.IssueType.DELETED);
                break;
            }
            case TOOLONG: {
                tgt.setValue((Object)OperationOutcome.IssueType.TOOLONG);
                break;
            }
            case CODEINVALID: {
                tgt.setValue((Object)OperationOutcome.IssueType.CODEINVALID);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)OperationOutcome.IssueType.EXTENSION);
                break;
            }
            case TOOCOSTLY: {
                tgt.setValue((Object)OperationOutcome.IssueType.TOOCOSTLY);
                break;
            }
            case BUSINESSRULE: {
                tgt.setValue((Object)OperationOutcome.IssueType.BUSINESSRULE);
                break;
            }
            case CONFLICT: {
                tgt.setValue((Object)OperationOutcome.IssueType.CONFLICT);
                break;
            }
            case TRANSIENT: {
                tgt.setValue((Object)OperationOutcome.IssueType.TRANSIENT);
                break;
            }
            case LOCKERROR: {
                tgt.setValue((Object)OperationOutcome.IssueType.LOCKERROR);
                break;
            }
            case NOSTORE: {
                tgt.setValue((Object)OperationOutcome.IssueType.NOSTORE);
                break;
            }
            case EXCEPTION: {
                tgt.setValue((Object)OperationOutcome.IssueType.EXCEPTION);
                break;
            }
            case TIMEOUT: {
                tgt.setValue((Object)OperationOutcome.IssueType.TIMEOUT);
                break;
            }
            case INCOMPLETE: {
                tgt.setValue((Object)OperationOutcome.IssueType.INCOMPLETE);
                break;
            }
            case THROTTLED: {
                tgt.setValue((Object)OperationOutcome.IssueType.THROTTLED);
                break;
            }
            case INFORMATIONAL: {
                tgt.setValue((Object)OperationOutcome.IssueType.INFORMATIONAL);
                break;
            }
            default: {
                tgt.setValue((Object)OperationOutcome.IssueType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<OperationOutcome.IssueType> convertIssueType(org.hl7.fhir.r5.model.Enumeration<OperationOutcome.IssueType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<OperationOutcome.IssueType> tgt = new Enumeration<OperationOutcome.IssueType>(new OperationOutcome.IssueTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((OperationOutcome.IssueType)((Object)src.getValue())) {
            case INVALID: {
                tgt.setValue((Object)OperationOutcome.IssueType.INVALID);
                break;
            }
            case STRUCTURE: {
                tgt.setValue((Object)OperationOutcome.IssueType.STRUCTURE);
                break;
            }
            case REQUIRED: {
                tgt.setValue((Object)OperationOutcome.IssueType.REQUIRED);
                break;
            }
            case VALUE: {
                tgt.setValue((Object)OperationOutcome.IssueType.VALUE);
                break;
            }
            case INVARIANT: {
                tgt.setValue((Object)OperationOutcome.IssueType.INVARIANT);
                break;
            }
            case SECURITY: {
                tgt.setValue((Object)OperationOutcome.IssueType.SECURITY);
                break;
            }
            case LOGIN: {
                tgt.setValue((Object)OperationOutcome.IssueType.LOGIN);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)OperationOutcome.IssueType.UNKNOWN);
                break;
            }
            case EXPIRED: {
                tgt.setValue((Object)OperationOutcome.IssueType.EXPIRED);
                break;
            }
            case FORBIDDEN: {
                tgt.setValue((Object)OperationOutcome.IssueType.FORBIDDEN);
                break;
            }
            case SUPPRESSED: {
                tgt.setValue((Object)OperationOutcome.IssueType.SUPPRESSED);
                break;
            }
            case PROCESSING: {
                tgt.setValue((Object)OperationOutcome.IssueType.PROCESSING);
                break;
            }
            case NOTSUPPORTED: {
                tgt.setValue((Object)OperationOutcome.IssueType.NOTSUPPORTED);
                break;
            }
            case DUPLICATE: {
                tgt.setValue((Object)OperationOutcome.IssueType.DUPLICATE);
                break;
            }
            case MULTIPLEMATCHES: {
                tgt.setValue((Object)OperationOutcome.IssueType.MULTIPLEMATCHES);
                break;
            }
            case NOTFOUND: {
                tgt.setValue((Object)OperationOutcome.IssueType.NOTFOUND);
                break;
            }
            case DELETED: {
                tgt.setValue((Object)OperationOutcome.IssueType.DELETED);
                break;
            }
            case TOOLONG: {
                tgt.setValue((Object)OperationOutcome.IssueType.TOOLONG);
                break;
            }
            case CODEINVALID: {
                tgt.setValue((Object)OperationOutcome.IssueType.CODEINVALID);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)OperationOutcome.IssueType.EXTENSION);
                break;
            }
            case TOOCOSTLY: {
                tgt.setValue((Object)OperationOutcome.IssueType.TOOCOSTLY);
                break;
            }
            case BUSINESSRULE: {
                tgt.setValue((Object)OperationOutcome.IssueType.BUSINESSRULE);
                break;
            }
            case CONFLICT: {
                tgt.setValue((Object)OperationOutcome.IssueType.CONFLICT);
                break;
            }
            case TRANSIENT: {
                tgt.setValue((Object)OperationOutcome.IssueType.TRANSIENT);
                break;
            }
            case LOCKERROR: {
                tgt.setValue((Object)OperationOutcome.IssueType.LOCKERROR);
                break;
            }
            case NOSTORE: {
                tgt.setValue((Object)OperationOutcome.IssueType.NOSTORE);
                break;
            }
            case EXCEPTION: {
                tgt.setValue((Object)OperationOutcome.IssueType.EXCEPTION);
                break;
            }
            case TIMEOUT: {
                tgt.setValue((Object)OperationOutcome.IssueType.TIMEOUT);
                break;
            }
            case INCOMPLETE: {
                tgt.setValue((Object)OperationOutcome.IssueType.INCOMPLETE);
                break;
            }
            case THROTTLED: {
                tgt.setValue((Object)OperationOutcome.IssueType.THROTTLED);
                break;
            }
            case INFORMATIONAL: {
                tgt.setValue((Object)OperationOutcome.IssueType.INFORMATIONAL);
                break;
            }
            default: {
                tgt.setValue((Object)OperationOutcome.IssueType.NULL);
            }
        }
        return tgt;
    }
}

