/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.OperationDefinition;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.StringType;

public class OperationDefinition40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.OperationDefinition convertOperationDefinition(OperationDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.OperationDefinition tgt = new org.hl7.fhir.r5.model.OperationDefinition();
        OperationDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(OperationDefinition40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(OperationDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(OperationDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(OperationDefinition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(OperationDefinition40_50.convertOperationKind(src.getKindElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(OperationDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(OperationDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(OperationDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(OperationDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(OperationDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(OperationDefinition40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(OperationDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(OperationDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasAffectsState()) {
            tgt.setAffectsStateElement(OperationDefinition40_50.convertBoolean(src.getAffectsStateElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(OperationDefinition40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(OperationDefinition40_50.convertMarkdown(src.getCommentElement()));
        }
        if (src.hasBase()) {
            tgt.setBaseElement(OperationDefinition40_50.convertCanonical(src.getBaseElement()));
        }
        for (CodeType codeType : src.getResource()) {
            tgt.getResource().add(OperationDefinition40_50.convertResourceEnum(codeType));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(OperationDefinition40_50.convertBoolean(src.getSystemElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(OperationDefinition40_50.convertBoolean(src.getTypeElement()));
        }
        if (src.hasInstance()) {
            tgt.setInstanceElement(OperationDefinition40_50.convertBoolean(src.getInstanceElement()));
        }
        if (src.hasInputProfile()) {
            tgt.setInputProfileElement(OperationDefinition40_50.convertCanonical(src.getInputProfileElement()));
        }
        if (src.hasOutputProfile()) {
            tgt.setOutputProfileElement(OperationDefinition40_50.convertCanonical(src.getOutputProfileElement()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent operationDefinitionParameterComponent : src.getParameter()) {
            tgt.addParameter(OperationDefinition40_50.convertOperationDefinitionParameterComponent(operationDefinitionParameterComponent));
        }
        for (OperationDefinition.OperationDefinitionOverloadComponent operationDefinitionOverloadComponent : src.getOverload()) {
            tgt.addOverload(OperationDefinition40_50.convertOperationDefinitionOverloadComponent(operationDefinitionOverloadComponent));
        }
        return tgt;
    }

    public static OperationDefinition convertOperationDefinition(org.hl7.fhir.r5.model.OperationDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition tgt = new OperationDefinition();
        OperationDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(OperationDefinition40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(OperationDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(OperationDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(OperationDefinition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(OperationDefinition40_50.convertOperationKind(src.getKindElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(OperationDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(OperationDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(OperationDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(OperationDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(OperationDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(OperationDefinition40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(OperationDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(OperationDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasAffectsState()) {
            tgt.setAffectsStateElement(OperationDefinition40_50.convertBoolean(src.getAffectsStateElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(OperationDefinition40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(OperationDefinition40_50.convertMarkdown(src.getCommentElement()));
        }
        if (src.hasBase()) {
            tgt.setBaseElement(OperationDefinition40_50.convertCanonical(src.getBaseElement()));
        }
        for (org.hl7.fhir.r5.model.CodeType codeType : src.getResource()) {
            tgt.getResource().add(OperationDefinition40_50.convertResourceEnum(codeType));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(OperationDefinition40_50.convertBoolean(src.getSystemElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(OperationDefinition40_50.convertBoolean(src.getTypeElement()));
        }
        if (src.hasInstance()) {
            tgt.setInstanceElement(OperationDefinition40_50.convertBoolean(src.getInstanceElement()));
        }
        if (src.hasInputProfile()) {
            tgt.setInputProfileElement(OperationDefinition40_50.convertCanonical(src.getInputProfileElement()));
        }
        if (src.hasOutputProfile()) {
            tgt.setOutputProfileElement(OperationDefinition40_50.convertCanonical(src.getOutputProfileElement()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent operationDefinitionParameterComponent : src.getParameter()) {
            tgt.addParameter(OperationDefinition40_50.convertOperationDefinitionParameterComponent(operationDefinitionParameterComponent));
        }
        for (OperationDefinition.OperationDefinitionOverloadComponent operationDefinitionOverloadComponent : src.getOverload()) {
            tgt.addOverload(OperationDefinition40_50.convertOperationDefinitionOverloadComponent(operationDefinitionOverloadComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<OperationDefinition.OperationKind> convertOperationKind(Enumeration<OperationDefinition.OperationKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<OperationDefinition.OperationKind> tgt = new org.hl7.fhir.r5.model.Enumeration<OperationDefinition.OperationKind>(new OperationDefinition.OperationKindEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((OperationDefinition.OperationKind)((Object)src.getValue())) {
            case OPERATION: {
                tgt.setValue((Object)OperationDefinition.OperationKind.OPERATION);
                break;
            }
            case QUERY: {
                tgt.setValue((Object)OperationDefinition.OperationKind.QUERY);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<OperationDefinition.OperationKind> convertOperationKind(org.hl7.fhir.r5.model.Enumeration<OperationDefinition.OperationKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<OperationDefinition.OperationKind> tgt = new Enumeration<OperationDefinition.OperationKind>(new OperationDefinition.OperationKindEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((OperationDefinition.OperationKind)((Object)src.getValue())) {
            case OPERATION: {
                tgt.setValue((Object)OperationDefinition.OperationKind.OPERATION);
                break;
            }
            case QUERY: {
                tgt.setValue((Object)OperationDefinition.OperationKind.QUERY);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationKind.NULL);
            }
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        OperationDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(OperationDefinition40_50.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(OperationDefinition40_50.convertOperationParameterUse(src.getUseElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(OperationDefinition40_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(OperationDefinition40_50.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(OperationDefinition40_50.convertString(src.getDocumentationElement()));
        }
        if (src.hasType()) {
            tgt.getTypeElement().setValue((Object)Enumerations.FHIRAllTypes.fromCode(src.getType()));
        }
        for (CanonicalType canonicalType : src.getTargetProfile()) {
            tgt.getTargetProfile().add(OperationDefinition40_50.convertCanonical(canonicalType));
        }
        if (src.hasSearchType()) {
            tgt.setSearchTypeElement(Enumerations40_50.convertSearchParamType(src.getSearchTypeElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(OperationDefinition40_50.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        }
        for (OperationDefinition.OperationDefinitionParameterReferencedFromComponent operationDefinitionParameterReferencedFromComponent : src.getReferencedFrom()) {
            tgt.addReferencedFrom(OperationDefinition40_50.convertOperationDefinitionParameterReferencedFromComponent(operationDefinitionParameterReferencedFromComponent));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent operationDefinitionParameterComponent : src.getPart()) {
            tgt.addPart(OperationDefinition40_50.convertOperationDefinitionParameterComponent(operationDefinitionParameterComponent));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        OperationDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(OperationDefinition40_50.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(OperationDefinition40_50.convertOperationParameterUse(src.getUseElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(OperationDefinition40_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(OperationDefinition40_50.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(OperationDefinition40_50.convertString(src.getDocumentationElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(new CodeType(src.getType().toCode()));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getTargetProfile()) {
            tgt.getTargetProfile().add(OperationDefinition40_50.convertCanonical(canonicalType));
        }
        if (src.hasSearchType()) {
            tgt.setSearchTypeElement(Enumerations40_50.convertSearchParamType(src.getSearchTypeElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(OperationDefinition40_50.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        }
        for (OperationDefinition.OperationDefinitionParameterReferencedFromComponent operationDefinitionParameterReferencedFromComponent : src.getReferencedFrom()) {
            tgt.addReferencedFrom(OperationDefinition40_50.convertOperationDefinitionParameterReferencedFromComponent(operationDefinitionParameterReferencedFromComponent));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent operationDefinitionParameterComponent : src.getPart()) {
            tgt.addPart(OperationDefinition40_50.convertOperationDefinitionParameterComponent(operationDefinitionParameterComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.OperationParameterUse> convertOperationParameterUse(Enumeration<OperationDefinition.OperationParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.OperationParameterUse> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.OperationParameterUse>(new Enumerations.OperationParameterUseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((OperationDefinition.OperationParameterUse)((Object)src.getValue())) {
            case IN: {
                tgt.setValue((Object)Enumerations.OperationParameterUse.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)Enumerations.OperationParameterUse.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.OperationParameterUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<OperationDefinition.OperationParameterUse> convertOperationParameterUse(org.hl7.fhir.r5.model.Enumeration<Enumerations.OperationParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<OperationDefinition.OperationParameterUse> tgt = new Enumeration<OperationDefinition.OperationParameterUse>(new OperationDefinition.OperationParameterUseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.OperationParameterUse)((Object)src.getValue())) {
            case IN: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.NULL);
            }
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        OperationDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(Enumerations40_50.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSetElement(OperationDefinition40_50.convertCanonical(src.getValueSetElement()));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        OperationDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(Enumerations40_50.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSetElement(OperationDefinition40_50.convertCanonical(src.getValueSetElement()));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterReferencedFromComponent convertOperationDefinitionParameterReferencedFromComponent(OperationDefinition.OperationDefinitionParameterReferencedFromComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterReferencedFromComponent tgt = new OperationDefinition.OperationDefinitionParameterReferencedFromComponent();
        OperationDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSource()) {
            tgt.setSourceElement(OperationDefinition40_50.convertString(src.getSourceElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(OperationDefinition40_50.convertString(src.getSourceIdElement()));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterReferencedFromComponent convertOperationDefinitionParameterReferencedFromComponent(OperationDefinition.OperationDefinitionParameterReferencedFromComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterReferencedFromComponent tgt = new OperationDefinition.OperationDefinitionParameterReferencedFromComponent();
        OperationDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSource()) {
            tgt.setSourceElement(OperationDefinition40_50.convertString(src.getSourceElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(OperationDefinition40_50.convertString(src.getSourceIdElement()));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionOverloadComponent convertOperationDefinitionOverloadComponent(OperationDefinition.OperationDefinitionOverloadComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionOverloadComponent tgt = new OperationDefinition.OperationDefinitionOverloadComponent();
        OperationDefinition40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.StringType t : src.getParameterName()) {
            tgt.getParameterName().add(OperationDefinition40_50.convertString(t));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(OperationDefinition40_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionOverloadComponent convertOperationDefinitionOverloadComponent(OperationDefinition.OperationDefinitionOverloadComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionOverloadComponent tgt = new OperationDefinition.OperationDefinitionOverloadComponent();
        OperationDefinition40_50.copyElement(src, tgt, new String[0]);
        for (StringType t : src.getParameterName()) {
            tgt.getParameterName().add(OperationDefinition40_50.convertString(t));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(OperationDefinition40_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }
}

