/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ObservationDefinition;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ObservationDefinition;

public class ObservationDefinition40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.ObservationDefinition convertObservationDefinition(ObservationDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ObservationDefinition tgt = new org.hl7.fhir.r5.model.ObservationDefinition();
        ObservationDefinition40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(ObservationDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(ObservationDefinition40_50.convertCodeableConcept(src.getCode()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.setIdentifier(ObservationDefinition40_50.convertIdentifier(identifier));
        }
        tgt.setPermittedDataType(src.getPermittedDataType().stream().map(ObservationDefinition40_50::convertObservationDataType).collect(Collectors.toList()));
        if (src.hasMultipleResultsAllowed()) {
            tgt.setMultipleResultsAllowedElement(ObservationDefinition40_50.convertBoolean(src.getMultipleResultsAllowedElement()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(ObservationDefinition40_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasPreferredReportName()) {
            tgt.setPreferredReportNameElement(ObservationDefinition40_50.convertString(src.getPreferredReportNameElement()));
        }
        if (src.hasQuantitativeDetails()) {
            tgt.setQuantitativeDetails(ObservationDefinition40_50.convertObservationDefinitionQuantitativeDetailsComponent(src.getQuantitativeDetails()));
        }
        for (ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent observationDefinitionQualifiedIntervalComponent : src.getQualifiedInterval()) {
            tgt.addQualifiedInterval(ObservationDefinition40_50.convertObservationDefinitionQualifiedIntervalComponent(observationDefinitionQualifiedIntervalComponent));
        }
        if (src.hasValidCodedValueSet()) {
            tgt.setValidCodedValueSet(ObservationDefinition40_50.convertReference(src.getValidCodedValueSet()));
        }
        if (src.hasNormalCodedValueSet()) {
            tgt.setNormalCodedValueSet(ObservationDefinition40_50.convertReference(src.getNormalCodedValueSet()));
        }
        if (src.hasAbnormalCodedValueSet()) {
            tgt.setAbnormalCodedValueSet(ObservationDefinition40_50.convertReference(src.getAbnormalCodedValueSet()));
        }
        if (src.hasCriticalCodedValueSet()) {
            tgt.setCriticalCodedValueSet(ObservationDefinition40_50.convertReference(src.getCriticalCodedValueSet()));
        }
        return tgt;
    }

    public static ObservationDefinition convertObservationDefinition(org.hl7.fhir.r5.model.ObservationDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ObservationDefinition tgt = new ObservationDefinition();
        ObservationDefinition40_50.copyDomainResource(src, tgt);
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(ObservationDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(ObservationDefinition40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(ObservationDefinition40_50.convertIdentifier(src.getIdentifier()));
        }
        tgt.setPermittedDataType(src.getPermittedDataType().stream().map(ObservationDefinition40_50::convertObservationDataType).collect(Collectors.toList()));
        if (src.hasMultipleResultsAllowed()) {
            tgt.setMultipleResultsAllowedElement(ObservationDefinition40_50.convertBoolean(src.getMultipleResultsAllowedElement()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(ObservationDefinition40_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasPreferredReportName()) {
            tgt.setPreferredReportNameElement(ObservationDefinition40_50.convertString(src.getPreferredReportNameElement()));
        }
        if (src.hasQuantitativeDetails()) {
            tgt.setQuantitativeDetails(ObservationDefinition40_50.convertObservationDefinitionQuantitativeDetailsComponent(src.getQuantitativeDetails()));
        }
        for (ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent observationDefinitionQualifiedIntervalComponent : src.getQualifiedInterval()) {
            tgt.addQualifiedInterval(ObservationDefinition40_50.convertObservationDefinitionQualifiedIntervalComponent(observationDefinitionQualifiedIntervalComponent));
        }
        if (src.hasValidCodedValueSet()) {
            tgt.setValidCodedValueSet(ObservationDefinition40_50.convertReference(src.getValidCodedValueSet()));
        }
        if (src.hasNormalCodedValueSet()) {
            tgt.setNormalCodedValueSet(ObservationDefinition40_50.convertReference(src.getNormalCodedValueSet()));
        }
        if (src.hasAbnormalCodedValueSet()) {
            tgt.setAbnormalCodedValueSet(ObservationDefinition40_50.convertReference(src.getAbnormalCodedValueSet()));
        }
        if (src.hasCriticalCodedValueSet()) {
            tgt.setCriticalCodedValueSet(ObservationDefinition40_50.convertReference(src.getCriticalCodedValueSet()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ObservationDefinition.ObservationDataType> convertObservationDataType(Enumeration<ObservationDefinition.ObservationDataType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ObservationDefinition.ObservationDataType> tgt = new org.hl7.fhir.r5.model.Enumeration<ObservationDefinition.ObservationDataType>(new ObservationDefinition.ObservationDataTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ObservationDefinition.ObservationDataType)((Object)src.getValue())) {
            case QUANTITY: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.QUANTITY);
                break;
            }
            case CODEABLECONCEPT: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.CODEABLECONCEPT);
                break;
            }
            case STRING: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.STRING);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.BOOLEAN);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.INTEGER);
                break;
            }
            case RANGE: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.RANGE);
                break;
            }
            case RATIO: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.RATIO);
                break;
            }
            case SAMPLEDDATA: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.SAMPLEDDATA);
                break;
            }
            case TIME: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.TIME);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.DATETIME);
                break;
            }
            case PERIOD: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.PERIOD);
                break;
            }
            default: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ObservationDefinition.ObservationDataType> convertObservationDataType(org.hl7.fhir.r5.model.Enumeration<ObservationDefinition.ObservationDataType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ObservationDefinition.ObservationDataType> tgt = new Enumeration<ObservationDefinition.ObservationDataType>(new ObservationDefinition.ObservationDataTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ObservationDefinition.ObservationDataType)((Object)src.getValue())) {
            case QUANTITY: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.QUANTITY);
                break;
            }
            case CODEABLECONCEPT: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.CODEABLECONCEPT);
                break;
            }
            case STRING: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.STRING);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.BOOLEAN);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.INTEGER);
                break;
            }
            case RANGE: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.RANGE);
                break;
            }
            case RATIO: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.RATIO);
                break;
            }
            case SAMPLEDDATA: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.SAMPLEDDATA);
                break;
            }
            case TIME: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.TIME);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.DATETIME);
                break;
            }
            case PERIOD: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.PERIOD);
                break;
            }
            default: {
                tgt.setValue((Object)ObservationDefinition.ObservationDataType.NULL);
            }
        }
        return tgt;
    }

    public static ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent convertObservationDefinitionQuantitativeDetailsComponent(ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent tgt = new ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent();
        ObservationDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCustomaryUnit()) {
            tgt.setCustomaryUnit(ObservationDefinition40_50.convertCodeableConcept(src.getCustomaryUnit()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(ObservationDefinition40_50.convertCodeableConcept(src.getUnit()));
        }
        if (src.hasConversionFactor()) {
            tgt.setConversionFactorElement(ObservationDefinition40_50.convertDecimal(src.getConversionFactorElement()));
        }
        if (src.hasDecimalPrecision()) {
            tgt.setDecimalPrecisionElement(ObservationDefinition40_50.convertInteger(src.getDecimalPrecisionElement()));
        }
        return tgt;
    }

    public static ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent convertObservationDefinitionQuantitativeDetailsComponent(ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent tgt = new ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent();
        ObservationDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCustomaryUnit()) {
            tgt.setCustomaryUnit(ObservationDefinition40_50.convertCodeableConcept(src.getCustomaryUnit()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(ObservationDefinition40_50.convertCodeableConcept(src.getUnit()));
        }
        if (src.hasConversionFactor()) {
            tgt.setConversionFactorElement(ObservationDefinition40_50.convertDecimal(src.getConversionFactorElement()));
        }
        if (src.hasDecimalPrecision()) {
            tgt.setDecimalPrecisionElement(ObservationDefinition40_50.convertInteger(src.getDecimalPrecisionElement()));
        }
        return tgt;
    }

    public static ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent convertObservationDefinitionQualifiedIntervalComponent(ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent tgt = new ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent();
        ObservationDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategoryElement(ObservationDefinition40_50.convertObservationRangeCategory(src.getCategoryElement()));
        }
        if (src.hasRange()) {
            tgt.setRange(ObservationDefinition40_50.convertRange(src.getRange()));
        }
        if (src.hasContext()) {
            tgt.setContext(ObservationDefinition40_50.convertCodeableConcept(src.getContext()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getAppliesTo()) {
            tgt.addAppliesTo(ObservationDefinition40_50.convertCodeableConcept(t));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(Enumerations40_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasAge()) {
            tgt.setAge(ObservationDefinition40_50.convertRange(src.getAge()));
        }
        if (src.hasGestationalAge()) {
            tgt.setGestationalAge(ObservationDefinition40_50.convertRange(src.getGestationalAge()));
        }
        if (src.hasCondition()) {
            tgt.setConditionElement(ObservationDefinition40_50.convertString(src.getConditionElement()));
        }
        return tgt;
    }

    public static ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent convertObservationDefinitionQualifiedIntervalComponent(ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent tgt = new ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent();
        ObservationDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategoryElement(ObservationDefinition40_50.convertObservationRangeCategory(src.getCategoryElement()));
        }
        if (src.hasRange()) {
            tgt.setRange(ObservationDefinition40_50.convertRange(src.getRange()));
        }
        if (src.hasContext()) {
            tgt.setContext(ObservationDefinition40_50.convertCodeableConcept(src.getContext()));
        }
        for (CodeableConcept t : src.getAppliesTo()) {
            tgt.addAppliesTo(ObservationDefinition40_50.convertCodeableConcept(t));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(Enumerations40_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasAge()) {
            tgt.setAge(ObservationDefinition40_50.convertRange(src.getAge()));
        }
        if (src.hasGestationalAge()) {
            tgt.setGestationalAge(ObservationDefinition40_50.convertRange(src.getGestationalAge()));
        }
        if (src.hasCondition()) {
            tgt.setConditionElement(ObservationDefinition40_50.convertString(src.getConditionElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ObservationDefinition.ObservationRangeCategory> convertObservationRangeCategory(Enumeration<ObservationDefinition.ObservationRangeCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ObservationDefinition.ObservationRangeCategory> tgt = new org.hl7.fhir.r5.model.Enumeration<ObservationDefinition.ObservationRangeCategory>(new ObservationDefinition.ObservationRangeCategoryEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ObservationDefinition.ObservationRangeCategory)((Object)src.getValue())) {
            case REFERENCE: {
                tgt.setValue((Object)ObservationDefinition.ObservationRangeCategory.REFERENCE);
                break;
            }
            case CRITICAL: {
                tgt.setValue((Object)ObservationDefinition.ObservationRangeCategory.CRITICAL);
                break;
            }
            case ABSOLUTE: {
                tgt.setValue((Object)ObservationDefinition.ObservationRangeCategory.ABSOLUTE);
                break;
            }
            default: {
                tgt.setValue((Object)ObservationDefinition.ObservationRangeCategory.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ObservationDefinition.ObservationRangeCategory> convertObservationRangeCategory(org.hl7.fhir.r5.model.Enumeration<ObservationDefinition.ObservationRangeCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ObservationDefinition.ObservationRangeCategory> tgt = new Enumeration<ObservationDefinition.ObservationRangeCategory>(new ObservationDefinition.ObservationRangeCategoryEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ObservationDefinition.ObservationRangeCategory)((Object)src.getValue())) {
            case REFERENCE: {
                tgt.setValue((Object)ObservationDefinition.ObservationRangeCategory.REFERENCE);
                break;
            }
            case CRITICAL: {
                tgt.setValue((Object)ObservationDefinition.ObservationRangeCategory.CRITICAL);
                break;
            }
            case ABSOLUTE: {
                tgt.setValue((Object)ObservationDefinition.ObservationRangeCategory.ABSOLUTE);
                break;
            }
            default: {
                tgt.setValue((Object)ObservationDefinition.ObservationRangeCategory.NULL);
            }
        }
        return tgt;
    }
}

