/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.NamingSystem;

public class NamingSystem40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.NamingSystem convertNamingSystem(NamingSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.NamingSystem tgt = new org.hl7.fhir.r5.model.NamingSystem();
        NamingSystem40_50.copyDomainResource(src, tgt);
        if (src.hasName()) {
            tgt.setNameElement(NamingSystem40_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(NamingSystem40_50.convertNamingSystemType(src.getKindElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(NamingSystem40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(NamingSystem40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(NamingSystem40_50.convertContactDetail(contactDetail));
        }
        if (src.hasResponsible()) {
            tgt.setResponsibleElement(NamingSystem40_50.convertString(src.getResponsibleElement()));
        }
        if (src.hasType()) {
            tgt.setType(NamingSystem40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(NamingSystem40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(NamingSystem40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(NamingSystem40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(NamingSystem40_50.convertString(src.getUsageElement()));
        }
        for (NamingSystem.NamingSystemUniqueIdComponent namingSystemUniqueIdComponent : src.getUniqueId()) {
            tgt.addUniqueId(NamingSystem40_50.convertNamingSystemUniqueIdComponent(namingSystemUniqueIdComponent));
        }
        return tgt;
    }

    public static NamingSystem convertNamingSystem(org.hl7.fhir.r5.model.NamingSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NamingSystem tgt = new NamingSystem();
        NamingSystem40_50.copyDomainResource(src, tgt);
        if (src.hasName()) {
            tgt.setNameElement(NamingSystem40_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(NamingSystem40_50.convertNamingSystemType(src.getKindElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(NamingSystem40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(NamingSystem40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(NamingSystem40_50.convertContactDetail(contactDetail));
        }
        if (src.hasResponsible()) {
            tgt.setResponsibleElement(NamingSystem40_50.convertString(src.getResponsibleElement()));
        }
        if (src.hasType()) {
            tgt.setType(NamingSystem40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(NamingSystem40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(NamingSystem40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(NamingSystem40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(NamingSystem40_50.convertString(src.getUsageElement()));
        }
        for (NamingSystem.NamingSystemUniqueIdComponent namingSystemUniqueIdComponent : src.getUniqueId()) {
            tgt.addUniqueId(NamingSystem40_50.convertNamingSystemUniqueIdComponent(namingSystemUniqueIdComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemType> convertNamingSystemType(Enumeration<NamingSystem.NamingSystemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemType> tgt = new org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemType>(new NamingSystem.NamingSystemTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((NamingSystem.NamingSystemType)((Object)src.getValue())) {
            case CODESYSTEM: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.CODESYSTEM);
                break;
            }
            case IDENTIFIER: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.IDENTIFIER);
                break;
            }
            case ROOT: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.ROOT);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<NamingSystem.NamingSystemType> convertNamingSystemType(org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<NamingSystem.NamingSystemType> tgt = new Enumeration<NamingSystem.NamingSystemType>(new NamingSystem.NamingSystemTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((NamingSystem.NamingSystemType)((Object)src.getValue())) {
            case CODESYSTEM: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.CODESYSTEM);
                break;
            }
            case IDENTIFIER: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.IDENTIFIER);
                break;
            }
            case ROOT: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.ROOT);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.NULL);
            }
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        NamingSystem40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(NamingSystem40_50.convertNamingSystemIdentifierType(src.getTypeElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(NamingSystem40_50.convertString(src.getValueElement()));
        }
        if (src.hasPreferred()) {
            tgt.setPreferredElement(NamingSystem40_50.convertBoolean(src.getPreferredElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(NamingSystem40_50.convertString(src.getCommentElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(NamingSystem40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        NamingSystem40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(NamingSystem40_50.convertNamingSystemIdentifierType(src.getTypeElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(NamingSystem40_50.convertString(src.getValueElement()));
        }
        if (src.hasPreferred()) {
            tgt.setPreferredElement(NamingSystem40_50.convertBoolean(src.getPreferredElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(NamingSystem40_50.convertString(src.getCommentElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(NamingSystem40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemIdentifierType> convertNamingSystemIdentifierType(Enumeration<NamingSystem.NamingSystemIdentifierType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemIdentifierType> tgt = new org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemIdentifierType>(new NamingSystem.NamingSystemIdentifierTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((NamingSystem.NamingSystemIdentifierType)((Object)src.getValue())) {
            case OID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OID);
                break;
            }
            case UUID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.UUID);
                break;
            }
            case URI: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.URI);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<NamingSystem.NamingSystemIdentifierType> convertNamingSystemIdentifierType(org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemIdentifierType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<NamingSystem.NamingSystemIdentifierType> tgt = new Enumeration<NamingSystem.NamingSystemIdentifierType>(new NamingSystem.NamingSystemIdentifierTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((NamingSystem.NamingSystemIdentifierType)((Object)src.getValue())) {
            case OID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OID);
                break;
            }
            case UUID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.UUID);
                break;
            }
            case URI: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.URI);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.NULL);
            }
        }
        return tgt;
    }
}

