/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.MessageHeader;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.MessageHeader;

public class MessageHeader40_50
extends VersionConvertor_40_50 {
    public static MessageHeader convertMessageHeader(org.hl7.fhir.r4.model.MessageHeader src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader tgt = new MessageHeader();
        MessageHeader40_50.copyDomainResource(src, tgt);
        if (src.hasEvent()) {
            tgt.setEvent(MessageHeader40_50.convertType(src.getEvent()));
        }
        for (MessageHeader.MessageDestinationComponent messageDestinationComponent : src.getDestination()) {
            tgt.addDestination(MessageHeader40_50.convertMessageDestinationComponent(messageDestinationComponent));
        }
        if (src.hasSender()) {
            tgt.setSender(MessageHeader40_50.convertReference(src.getSender()));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(MessageHeader40_50.convertReference(src.getEnterer()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(MessageHeader40_50.convertReference(src.getAuthor()));
        }
        if (src.hasSource()) {
            tgt.setSource(MessageHeader40_50.convertMessageSourceComponent(src.getSource()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(MessageHeader40_50.convertReference(src.getResponsible()));
        }
        if (src.hasReason()) {
            tgt.setReason(MessageHeader40_50.convertCodeableConcept(src.getReason()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(MessageHeader40_50.convertMessageHeaderResponseComponent(src.getResponse()));
        }
        for (Reference reference : src.getFocus()) {
            tgt.addFocus(MessageHeader40_50.convertReference(reference));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(MessageHeader40_50.convertCanonical(src.getDefinitionElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MessageHeader convertMessageHeader(MessageHeader src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.MessageHeader tgt = new org.hl7.fhir.r4.model.MessageHeader();
        MessageHeader40_50.copyDomainResource(src, tgt);
        if (src.hasEvent()) {
            tgt.setEvent(MessageHeader40_50.convertType(src.getEvent()));
        }
        for (MessageHeader.MessageDestinationComponent messageDestinationComponent : src.getDestination()) {
            tgt.addDestination(MessageHeader40_50.convertMessageDestinationComponent(messageDestinationComponent));
        }
        if (src.hasSender()) {
            tgt.setSender(MessageHeader40_50.convertReference(src.getSender()));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(MessageHeader40_50.convertReference(src.getEnterer()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(MessageHeader40_50.convertReference(src.getAuthor()));
        }
        if (src.hasSource()) {
            tgt.setSource(MessageHeader40_50.convertMessageSourceComponent(src.getSource()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(MessageHeader40_50.convertReference(src.getResponsible()));
        }
        if (src.hasReason()) {
            tgt.setReason(MessageHeader40_50.convertCodeableConcept(src.getReason()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(MessageHeader40_50.convertMessageHeaderResponseComponent(src.getResponse()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getFocus()) {
            tgt.addFocus(MessageHeader40_50.convertReference(reference));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(MessageHeader40_50.convertCanonical(src.getDefinitionElement()));
        }
        return tgt;
    }

    public static MessageHeader.MessageDestinationComponent convertMessageDestinationComponent(MessageHeader.MessageDestinationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageDestinationComponent tgt = new MessageHeader.MessageDestinationComponent();
        MessageHeader40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(MessageHeader40_50.convertString(src.getNameElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(MessageHeader40_50.convertReference(src.getTarget()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpointElement(MessageHeader40_50.convertUrl(src.getEndpointElement()));
        }
        if (src.hasReceiver()) {
            tgt.setReceiver(MessageHeader40_50.convertReference(src.getReceiver()));
        }
        return tgt;
    }

    public static MessageHeader.MessageDestinationComponent convertMessageDestinationComponent(MessageHeader.MessageDestinationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageDestinationComponent tgt = new MessageHeader.MessageDestinationComponent();
        MessageHeader40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(MessageHeader40_50.convertString(src.getNameElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(MessageHeader40_50.convertReference(src.getTarget()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpointElement(MessageHeader40_50.convertUrl(src.getEndpointElement()));
        }
        if (src.hasReceiver()) {
            tgt.setReceiver(MessageHeader40_50.convertReference(src.getReceiver()));
        }
        return tgt;
    }

    public static MessageHeader.MessageSourceComponent convertMessageSourceComponent(MessageHeader.MessageSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageSourceComponent tgt = new MessageHeader.MessageSourceComponent();
        MessageHeader40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(MessageHeader40_50.convertString(src.getNameElement()));
        }
        if (src.hasSoftware()) {
            tgt.setSoftwareElement(MessageHeader40_50.convertString(src.getSoftwareElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(MessageHeader40_50.convertString(src.getVersionElement()));
        }
        if (src.hasContact()) {
            tgt.setContact(MessageHeader40_50.convertContactPoint(src.getContact()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpointElement(MessageHeader40_50.convertUrl(src.getEndpointElement()));
        }
        return tgt;
    }

    public static MessageHeader.MessageSourceComponent convertMessageSourceComponent(MessageHeader.MessageSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageSourceComponent tgt = new MessageHeader.MessageSourceComponent();
        MessageHeader40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(MessageHeader40_50.convertString(src.getNameElement()));
        }
        if (src.hasSoftware()) {
            tgt.setSoftwareElement(MessageHeader40_50.convertString(src.getSoftwareElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(MessageHeader40_50.convertString(src.getVersionElement()));
        }
        if (src.hasContact()) {
            tgt.setContact(MessageHeader40_50.convertContactPoint(src.getContact()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpointElement(MessageHeader40_50.convertUrl(src.getEndpointElement()));
        }
        return tgt;
    }

    public static MessageHeader.MessageHeaderResponseComponent convertMessageHeaderResponseComponent(MessageHeader.MessageHeaderResponseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageHeaderResponseComponent tgt = new MessageHeader.MessageHeaderResponseComponent();
        MessageHeader40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifierElement(MessageHeader40_50.convertId(src.getIdentifierElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(MessageHeader40_50.convertResponseType(src.getCodeElement()));
        }
        if (src.hasDetails()) {
            tgt.setDetails(MessageHeader40_50.convertReference(src.getDetails()));
        }
        return tgt;
    }

    public static MessageHeader.MessageHeaderResponseComponent convertMessageHeaderResponseComponent(MessageHeader.MessageHeaderResponseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageHeaderResponseComponent tgt = new MessageHeader.MessageHeaderResponseComponent();
        MessageHeader40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifierElement(MessageHeader40_50.convertId(src.getIdentifierElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(MessageHeader40_50.convertResponseType(src.getCodeElement()));
        }
        if (src.hasDetails()) {
            tgt.setDetails(MessageHeader40_50.convertReference(src.getDetails()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<MessageHeader.ResponseType> convertResponseType(Enumeration<MessageHeader.ResponseType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MessageHeader.ResponseType> tgt = new org.hl7.fhir.r5.model.Enumeration<MessageHeader.ResponseType>(new MessageHeader.ResponseTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MessageHeader.ResponseType)((Object)src.getValue())) {
            case OK: {
                tgt.setValue((Object)MessageHeader.ResponseType.OK);
                break;
            }
            case TRANSIENTERROR: {
                tgt.setValue((Object)MessageHeader.ResponseType.TRANSIENTERROR);
                break;
            }
            case FATALERROR: {
                tgt.setValue((Object)MessageHeader.ResponseType.FATALERROR);
                break;
            }
            default: {
                tgt.setValue((Object)MessageHeader.ResponseType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MessageHeader.ResponseType> convertResponseType(org.hl7.fhir.r5.model.Enumeration<MessageHeader.ResponseType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MessageHeader.ResponseType> tgt = new Enumeration<MessageHeader.ResponseType>(new MessageHeader.ResponseTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MessageHeader.ResponseType)((Object)src.getValue())) {
            case OK: {
                tgt.setValue((Object)MessageHeader.ResponseType.OK);
                break;
            }
            case TRANSIENTERROR: {
                tgt.setValue((Object)MessageHeader.ResponseType.TRANSIENTERROR);
                break;
            }
            case FATALERROR: {
                tgt.setValue((Object)MessageHeader.ResponseType.FATALERROR);
                break;
            }
            default: {
                tgt.setValue((Object)MessageHeader.ResponseType.NULL);
            }
        }
        return tgt;
    }
}

