/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MessageDefinition;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.MessageDefinition;

public class MessageDefinition40_50
extends VersionConvertor_40_50 {
    public static MessageDefinition convertMessageDefinition(org.hl7.fhir.r4.model.MessageDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageDefinition tgt = new MessageDefinition();
        MessageDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(MessageDefinition40_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MessageDefinition40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(MessageDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(MessageDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(MessageDefinition40_50.convertString(src.getTitleElement()));
        }
        for (CanonicalType canonicalType : src.getReplaces()) {
            tgt.getReplaces().add(MessageDefinition40_50.convertCanonical(canonicalType));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(MessageDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(MessageDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(MessageDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(MessageDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(MessageDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(MessageDefinition40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(MessageDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(MessageDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(MessageDefinition40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasBase()) {
            tgt.setBaseElement(MessageDefinition40_50.convertCanonical(src.getBaseElement()));
        }
        for (CanonicalType canonicalType : src.getParent()) {
            tgt.getParent().add(MessageDefinition40_50.convertCanonical(canonicalType));
        }
        if (src.hasEvent()) {
            tgt.setEvent(MessageDefinition40_50.convertType(src.getEvent()));
        }
        if (src.hasCategory()) {
            tgt.setCategoryElement(MessageDefinition40_50.convertMessageSignificanceCategory(src.getCategoryElement()));
        }
        for (MessageDefinition.MessageDefinitionFocusComponent messageDefinitionFocusComponent : src.getFocus()) {
            tgt.addFocus(MessageDefinition40_50.convertMessageDefinitionFocusComponent(messageDefinitionFocusComponent));
        }
        if (src.hasResponseRequired()) {
            tgt.setResponseRequiredElement(MessageDefinition40_50.convertMessageheaderResponseRequest(src.getResponseRequiredElement()));
        }
        for (MessageDefinition.MessageDefinitionAllowedResponseComponent messageDefinitionAllowedResponseComponent : src.getAllowedResponse()) {
            tgt.addAllowedResponse(MessageDefinition40_50.convertMessageDefinitionAllowedResponseComponent(messageDefinitionAllowedResponseComponent));
        }
        for (CanonicalType canonicalType : src.getGraph()) {
            tgt.getGraph().add(MessageDefinition40_50.convertCanonical(canonicalType));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MessageDefinition convertMessageDefinition(MessageDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.MessageDefinition tgt = new org.hl7.fhir.r4.model.MessageDefinition();
        MessageDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(MessageDefinition40_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MessageDefinition40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(MessageDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(MessageDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(MessageDefinition40_50.convertString(src.getTitleElement()));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getReplaces()) {
            tgt.getReplaces().add(MessageDefinition40_50.convertCanonical(canonicalType));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(MessageDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(MessageDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(MessageDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(MessageDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(MessageDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(MessageDefinition40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(MessageDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(MessageDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(MessageDefinition40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasBase()) {
            tgt.setBaseElement(MessageDefinition40_50.convertCanonical(src.getBaseElement()));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getParent()) {
            tgt.getParent().add(MessageDefinition40_50.convertCanonical(canonicalType));
        }
        if (src.hasEvent()) {
            tgt.setEvent(MessageDefinition40_50.convertType(src.getEvent()));
        }
        if (src.hasCategory()) {
            tgt.setCategoryElement(MessageDefinition40_50.convertMessageSignificanceCategory(src.getCategoryElement()));
        }
        for (MessageDefinition.MessageDefinitionFocusComponent messageDefinitionFocusComponent : src.getFocus()) {
            tgt.addFocus(MessageDefinition40_50.convertMessageDefinitionFocusComponent(messageDefinitionFocusComponent));
        }
        if (src.hasResponseRequired()) {
            tgt.setResponseRequiredElement(MessageDefinition40_50.convertMessageheaderResponseRequest(src.getResponseRequiredElement()));
        }
        for (MessageDefinition.MessageDefinitionAllowedResponseComponent messageDefinitionAllowedResponseComponent : src.getAllowedResponse()) {
            tgt.addAllowedResponse(MessageDefinition40_50.convertMessageDefinitionAllowedResponseComponent(messageDefinitionAllowedResponseComponent));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getGraph()) {
            tgt.getGraph().add(MessageDefinition40_50.convertCanonical(canonicalType));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<MessageDefinition.MessageSignificanceCategory> convertMessageSignificanceCategory(Enumeration<MessageDefinition.MessageSignificanceCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MessageDefinition.MessageSignificanceCategory> tgt = new org.hl7.fhir.r5.model.Enumeration<MessageDefinition.MessageSignificanceCategory>(new MessageDefinition.MessageSignificanceCategoryEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MessageDefinition.MessageSignificanceCategory)((Object)src.getValue())) {
            case CONSEQUENCE: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.CONSEQUENCE);
                break;
            }
            case CURRENCY: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.CURRENCY);
                break;
            }
            case NOTIFICATION: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.NOTIFICATION);
                break;
            }
            default: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MessageDefinition.MessageSignificanceCategory> convertMessageSignificanceCategory(org.hl7.fhir.r5.model.Enumeration<MessageDefinition.MessageSignificanceCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MessageDefinition.MessageSignificanceCategory> tgt = new Enumeration<MessageDefinition.MessageSignificanceCategory>(new MessageDefinition.MessageSignificanceCategoryEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MessageDefinition.MessageSignificanceCategory)((Object)src.getValue())) {
            case CONSEQUENCE: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.CONSEQUENCE);
                break;
            }
            case CURRENCY: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.CURRENCY);
                break;
            }
            case NOTIFICATION: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.NOTIFICATION);
                break;
            }
            default: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<MessageDefinition.MessageheaderResponseRequest> convertMessageheaderResponseRequest(Enumeration<MessageDefinition.MessageheaderResponseRequest> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MessageDefinition.MessageheaderResponseRequest> tgt = new org.hl7.fhir.r5.model.Enumeration<MessageDefinition.MessageheaderResponseRequest>(new MessageDefinition.MessageheaderResponseRequestEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MessageDefinition.MessageheaderResponseRequest)((Object)src.getValue())) {
            case ALWAYS: {
                tgt.setValue((Object)MessageDefinition.MessageheaderResponseRequest.ALWAYS);
                break;
            }
            case ONERROR: {
                tgt.setValue((Object)MessageDefinition.MessageheaderResponseRequest.ONERROR);
                break;
            }
            case NEVER: {
                tgt.setValue((Object)MessageDefinition.MessageheaderResponseRequest.NEVER);
                break;
            }
            case ONSUCCESS: {
                tgt.setValue((Object)MessageDefinition.MessageheaderResponseRequest.ONSUCCESS);
                break;
            }
            default: {
                tgt.setValue((Object)MessageDefinition.MessageheaderResponseRequest.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MessageDefinition.MessageheaderResponseRequest> convertMessageheaderResponseRequest(org.hl7.fhir.r5.model.Enumeration<MessageDefinition.MessageheaderResponseRequest> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MessageDefinition.MessageheaderResponseRequest> tgt = new Enumeration<MessageDefinition.MessageheaderResponseRequest>(new MessageDefinition.MessageheaderResponseRequestEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MessageDefinition.MessageheaderResponseRequest)((Object)src.getValue())) {
            case ALWAYS: {
                tgt.setValue((Object)MessageDefinition.MessageheaderResponseRequest.ALWAYS);
                break;
            }
            case ONERROR: {
                tgt.setValue((Object)MessageDefinition.MessageheaderResponseRequest.ONERROR);
                break;
            }
            case NEVER: {
                tgt.setValue((Object)MessageDefinition.MessageheaderResponseRequest.NEVER);
                break;
            }
            case ONSUCCESS: {
                tgt.setValue((Object)MessageDefinition.MessageheaderResponseRequest.ONSUCCESS);
                break;
            }
            default: {
                tgt.setValue((Object)MessageDefinition.MessageheaderResponseRequest.NULL);
            }
        }
        return tgt;
    }

    public static MessageDefinition.MessageDefinitionFocusComponent convertMessageDefinitionFocusComponent(MessageDefinition.MessageDefinitionFocusComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageDefinition.MessageDefinitionFocusComponent tgt = new MessageDefinition.MessageDefinitionFocusComponent();
        MessageDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(MessageDefinition40_50.convertResourceEnum(src.getCodeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(MessageDefinition40_50.convertCanonical(src.getProfileElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(MessageDefinition40_50.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(MessageDefinition40_50.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static MessageDefinition.MessageDefinitionFocusComponent convertMessageDefinitionFocusComponent(MessageDefinition.MessageDefinitionFocusComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageDefinition.MessageDefinitionFocusComponent tgt = new MessageDefinition.MessageDefinitionFocusComponent();
        MessageDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(MessageDefinition40_50.convertResourceEnum(src.getCodeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(MessageDefinition40_50.convertCanonical(src.getProfileElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(MessageDefinition40_50.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(MessageDefinition40_50.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static MessageDefinition.MessageDefinitionAllowedResponseComponent convertMessageDefinitionAllowedResponseComponent(MessageDefinition.MessageDefinitionAllowedResponseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageDefinition.MessageDefinitionAllowedResponseComponent tgt = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
        MessageDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMessage()) {
            tgt.setMessageElement(MessageDefinition40_50.convertCanonical(src.getMessageElement()));
        }
        if (src.hasSituation()) {
            tgt.setSituationElement(MessageDefinition40_50.convertMarkdown(src.getSituationElement()));
        }
        return tgt;
    }

    public static MessageDefinition.MessageDefinitionAllowedResponseComponent convertMessageDefinitionAllowedResponseComponent(MessageDefinition.MessageDefinitionAllowedResponseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageDefinition.MessageDefinitionAllowedResponseComponent tgt = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
        MessageDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMessage()) {
            tgt.setMessageElement(MessageDefinition40_50.convertCanonical(src.getMessageElement()));
        }
        if (src.hasSituation()) {
            tgt.setSituationElement(MessageDefinition40_50.convertMarkdown(src.getSituationElement()));
        }
        return tgt;
    }
}

