/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.Reference;

public class MedicationRequest40_50
extends VersionConvertor_40_50 {
    public static MedicationRequest convertMedicationRequest(org.hl7.fhir.r4.model.MedicationRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest tgt = new MedicationRequest();
        MedicationRequest40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MedicationRequest40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationRequest40_50.convertMedicationRequestStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(MedicationRequest40_50.convertCodeableConcept(src.getStatusReason()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(MedicationRequest40_50.convertMedicationRequestIntent(src.getIntentElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(MedicationRequest40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(MedicationRequest40_50.convertMedicationRequestPriority(src.getPriorityElement()));
        }
        if (src.hasDoNotPerform()) {
            tgt.setDoNotPerformElement(MedicationRequest40_50.convertBoolean(src.getDoNotPerformElement()));
        }
        if (src.hasReportedBooleanType()) {
            tgt.setReportedElement(MedicationRequest40_50.convertBoolean(src.getReportedBooleanType()));
        }
        if (src.hasReportedReference()) {
            tgt.setInformationSource(MedicationRequest40_50.convertReference(src.getReportedReference()));
        }
        if (src.hasMedicationCodeableConcept()) {
            tgt.getMedication().setConcept(MedicationRequest40_50.convertCodeableConcept(src.getMedicationCodeableConcept()));
        }
        if (src.hasMedicationReference()) {
            tgt.getMedication().setReference(MedicationRequest40_50.convertReference(src.getMedicationReference()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(MedicationRequest40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(MedicationRequest40_50.convertReference(src.getEncounter()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(MedicationRequest40_50.convertReference(reference));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(MedicationRequest40_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRequester()) {
            tgt.setRequester(MedicationRequest40_50.convertReference(src.getRequester()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(MedicationRequest40_50.convertReference(src.getPerformer()));
        }
        if (src.hasPerformerType()) {
            tgt.setPerformerType(MedicationRequest40_50.convertCodeableConcept(src.getPerformerType()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(MedicationRequest40_50.convertReference(src.getRecorder()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason().setConcept(MedicationRequest40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReason().setReference(MedicationRequest40_50.convertReference(reference));
        }
        for (CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(MedicationRequest40_50.convertCanonical(canonicalType));
        }
        for (UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(MedicationRequest40_50.convertUri(uriType));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(MedicationRequest40_50.convertReference(reference));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(MedicationRequest40_50.convertIdentifier(src.getGroupIdentifier()));
        }
        if (src.hasCourseOfTherapyType()) {
            tgt.setCourseOfTherapyType(MedicationRequest40_50.convertCodeableConcept(src.getCourseOfTherapyType()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getInsurance()) {
            tgt.addInsurance(MedicationRequest40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(MedicationRequest40_50.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.r4.model.Dosage dosage : src.getDosageInstruction()) {
            tgt.addDosageInstruction(MedicationRequest40_50.convertDosage(dosage));
        }
        if (src.hasDispenseRequest()) {
            tgt.setDispenseRequest(MedicationRequest40_50.convertMedicationRequestDispenseRequestComponent(src.getDispenseRequest()));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationRequest40_50.convertMedicationRequestSubstitutionComponent(src.getSubstitution()));
        }
        if (src.hasPriorPrescription()) {
            tgt.setPriorPrescription(MedicationRequest40_50.convertReference(src.getPriorPrescription()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getDetectedIssue()) {
            tgt.addDetectedIssue(MedicationRequest40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(MedicationRequest40_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MedicationRequest convertMedicationRequest(MedicationRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.MedicationRequest tgt = new org.hl7.fhir.r4.model.MedicationRequest();
        MedicationRequest40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MedicationRequest40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationRequest40_50.convertMedicationRequestStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(MedicationRequest40_50.convertCodeableConcept(src.getStatusReason()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(MedicationRequest40_50.convertMedicationRequestIntent(src.getIntentElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(MedicationRequest40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(MedicationRequest40_50.convertMedicationRequestPriority(src.getPriorityElement()));
        }
        if (src.hasDoNotPerform()) {
            tgt.setDoNotPerformElement(MedicationRequest40_50.convertBoolean(src.getDoNotPerformElement()));
        }
        if (src.hasReported()) {
            tgt.setReported(MedicationRequest40_50.convertBoolean(src.getReportedElement()));
        }
        if (src.hasInformationSource()) {
            tgt.setReported(MedicationRequest40_50.convertReference(src.getInformationSource()));
        }
        if (src.getMedication().hasReference()) {
            tgt.setMedication(MedicationRequest40_50.convertType(src.getMedication().getReference()));
        }
        if (src.getMedication().hasConcept()) {
            tgt.setMedication(MedicationRequest40_50.convertType(src.getMedication().getConcept()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(MedicationRequest40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(MedicationRequest40_50.convertReference(src.getEncounter()));
        }
        for (Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(MedicationRequest40_50.convertReference(reference));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(MedicationRequest40_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRequester()) {
            tgt.setRequester(MedicationRequest40_50.convertReference(src.getRequester()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(MedicationRequest40_50.convertReference(src.getPerformer()));
        }
        if (src.hasPerformerType()) {
            tgt.setPerformerType(MedicationRequest40_50.convertCodeableConcept(src.getPerformerType()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(MedicationRequest40_50.convertReference(src.getRecorder()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (codeableReference.hasConcept()) {
                tgt.addReasonCode(MedicationRequest40_50.convertCodeableConcept(codeableReference.getConcept()));
            }
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(MedicationRequest40_50.convertReference(codeableReference.getReference()));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(MedicationRequest40_50.convertCanonical(canonicalType));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(MedicationRequest40_50.convertUri(uriType));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(MedicationRequest40_50.convertReference(reference));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(MedicationRequest40_50.convertIdentifier(src.getGroupIdentifier()));
        }
        if (src.hasCourseOfTherapyType()) {
            tgt.setCourseOfTherapyType(MedicationRequest40_50.convertCodeableConcept(src.getCourseOfTherapyType()));
        }
        for (Reference reference : src.getInsurance()) {
            tgt.addInsurance(MedicationRequest40_50.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(MedicationRequest40_50.convertAnnotation(annotation));
        }
        for (Dosage dosage : src.getDosageInstruction()) {
            tgt.addDosageInstruction(MedicationRequest40_50.convertDosage(dosage));
        }
        if (src.hasDispenseRequest()) {
            tgt.setDispenseRequest(MedicationRequest40_50.convertMedicationRequestDispenseRequestComponent(src.getDispenseRequest()));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationRequest40_50.convertMedicationRequestSubstitutionComponent(src.getSubstitution()));
        }
        if (src.hasPriorPrescription()) {
            tgt.setPriorPrescription(MedicationRequest40_50.convertReference(src.getPriorPrescription()));
        }
        for (Reference reference : src.getDetectedIssue()) {
            tgt.addDetectedIssue(MedicationRequest40_50.convertReference(reference));
        }
        for (Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(MedicationRequest40_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<MedicationRequest.MedicationrequestStatus> convertMedicationRequestStatus(Enumeration<MedicationRequest.MedicationRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MedicationRequest.MedicationrequestStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<MedicationRequest.MedicationrequestStatus>(new MedicationRequest.MedicationrequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationRequestStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.ONHOLD);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.CANCELLED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.ENTEREDINERROR);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.STOPPED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.DRAFT);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MedicationRequest.MedicationRequestStatus> convertMedicationRequestStatus(org.hl7.fhir.r5.model.Enumeration<MedicationRequest.MedicationrequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MedicationRequest.MedicationRequestStatus> tgt = new Enumeration<MedicationRequest.MedicationRequestStatus>(new MedicationRequest.MedicationRequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationrequestStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.ONHOLD);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.CANCELLED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.ENTEREDINERROR);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.STOPPED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.DRAFT);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<MedicationRequest.MedicationRequestIntent> convertMedicationRequestIntent(Enumeration<MedicationRequest.MedicationRequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MedicationRequest.MedicationRequestIntent> tgt = new org.hl7.fhir.r5.model.Enumeration<MedicationRequest.MedicationRequestIntent>(new MedicationRequest.MedicationRequestIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationRequestIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.PLAN);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.ORIGINALORDER);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.REFLEXORDER);
                break;
            }
            case FILLERORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MedicationRequest.MedicationRequestIntent> convertMedicationRequestIntent(org.hl7.fhir.r5.model.Enumeration<MedicationRequest.MedicationRequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MedicationRequest.MedicationRequestIntent> tgt = new Enumeration<MedicationRequest.MedicationRequestIntent>(new MedicationRequest.MedicationRequestIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationRequestIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.PLAN);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.ORIGINALORDER);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.REFLEXORDER);
                break;
            }
            case FILLERORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> convertMedicationRequestPriority(Enumeration<MedicationRequest.MedicationRequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationRequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)Enumerations.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)Enumerations.RequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)Enumerations.RequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)Enumerations.RequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MedicationRequest.MedicationRequestPriority> convertMedicationRequestPriority(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MedicationRequest.MedicationRequestPriority> tgt = new Enumeration<MedicationRequest.MedicationRequestPriority>(new MedicationRequest.MedicationRequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestDispenseRequestComponent convertMedicationRequestDispenseRequestComponent(MedicationRequest.MedicationRequestDispenseRequestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestDispenseRequestComponent tgt = new MedicationRequest.MedicationRequestDispenseRequestComponent();
        MedicationRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasInitialFill()) {
            tgt.setInitialFill(MedicationRequest40_50.convertMedicationRequestDispenseRequestInitialFillComponent(src.getInitialFill()));
        }
        if (src.hasDispenseInterval()) {
            tgt.setDispenseInterval(MedicationRequest40_50.convertDuration(src.getDispenseInterval()));
        }
        if (src.hasValidityPeriod()) {
            tgt.setValidityPeriod(MedicationRequest40_50.convertPeriod(src.getValidityPeriod()));
        }
        if (src.hasNumberOfRepeatsAllowed()) {
            tgt.setNumberOfRepeatsAllowedElement(MedicationRequest40_50.convertUnsignedInt(src.getNumberOfRepeatsAllowedElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(MedicationRequest40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasExpectedSupplyDuration()) {
            tgt.setExpectedSupplyDuration(MedicationRequest40_50.convertDuration(src.getExpectedSupplyDuration()));
        }
        if (src.hasPerformer()) {
            tgt.setDispenser(MedicationRequest40_50.convertReference(src.getPerformer()));
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestDispenseRequestComponent convertMedicationRequestDispenseRequestComponent(MedicationRequest.MedicationRequestDispenseRequestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestDispenseRequestComponent tgt = new MedicationRequest.MedicationRequestDispenseRequestComponent();
        MedicationRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasInitialFill()) {
            tgt.setInitialFill(MedicationRequest40_50.convertMedicationRequestDispenseRequestInitialFillComponent(src.getInitialFill()));
        }
        if (src.hasDispenseInterval()) {
            tgt.setDispenseInterval(MedicationRequest40_50.convertDuration(src.getDispenseInterval()));
        }
        if (src.hasValidityPeriod()) {
            tgt.setValidityPeriod(MedicationRequest40_50.convertPeriod(src.getValidityPeriod()));
        }
        if (src.hasNumberOfRepeatsAllowed()) {
            tgt.setNumberOfRepeatsAllowedElement(MedicationRequest40_50.convertUnsignedInt(src.getNumberOfRepeatsAllowedElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(MedicationRequest40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasExpectedSupplyDuration()) {
            tgt.setExpectedSupplyDuration(MedicationRequest40_50.convertDuration(src.getExpectedSupplyDuration()));
        }
        if (src.hasDispenser()) {
            tgt.setPerformer(MedicationRequest40_50.convertReference(src.getDispenser()));
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent convertMedicationRequestDispenseRequestInitialFillComponent(MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent tgt = new MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent();
        MedicationRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasQuantity()) {
            tgt.setQuantity(MedicationRequest40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDuration()) {
            tgt.setDuration(MedicationRequest40_50.convertDuration(src.getDuration()));
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent convertMedicationRequestDispenseRequestInitialFillComponent(MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent tgt = new MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent();
        MedicationRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasQuantity()) {
            tgt.setQuantity(MedicationRequest40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDuration()) {
            tgt.setDuration(MedicationRequest40_50.convertDuration(src.getDuration()));
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestSubstitutionComponent convertMedicationRequestSubstitutionComponent(MedicationRequest.MedicationRequestSubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestSubstitutionComponent tgt = new MedicationRequest.MedicationRequestSubstitutionComponent();
        MedicationRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAllowed()) {
            tgt.setAllowed(MedicationRequest40_50.convertType(src.getAllowed()));
        }
        if (src.hasReason()) {
            tgt.setReason(MedicationRequest40_50.convertCodeableConcept(src.getReason()));
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestSubstitutionComponent convertMedicationRequestSubstitutionComponent(MedicationRequest.MedicationRequestSubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestSubstitutionComponent tgt = new MedicationRequest.MedicationRequestSubstitutionComponent();
        MedicationRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAllowed()) {
            tgt.setAllowed(MedicationRequest40_50.convertType(src.getAllowed()));
        }
        if (src.hasReason()) {
            tgt.setReason(MedicationRequest40_50.convertCodeableConcept(src.getReason()));
        }
        return tgt;
    }
}

