/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.StringType;

public class MedicationKnowledge40_50
extends VersionConvertor_40_50 {
    public static MedicationKnowledge convertMedicationKnowledge(org.hl7.fhir.r4.model.MedicationKnowledge src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge tgt = new MedicationKnowledge();
        MedicationKnowledge40_50.copyDomainResource(src, tgt);
        if (src.hasCode()) {
            tgt.setCode(MedicationKnowledge40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationKnowledge40_50.convertMedicationKnowledgeStatus(src.getStatusElement()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(MedicationKnowledge40_50.convertReference(src.getManufacturer()));
        }
        if (src.hasDoseForm()) {
            tgt.setDoseForm(MedicationKnowledge40_50.convertCodeableConcept(src.getDoseForm()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(MedicationKnowledge40_50.convertSimpleQuantity(src.getAmount()));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getSynonym()) {
            tgt.getSynonym().add(MedicationKnowledge40_50.convertString(stringType));
        }
        for (MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent medicationKnowledgeRelatedMedicationKnowledgeComponent : src.getRelatedMedicationKnowledge()) {
            tgt.addRelatedMedicationKnowledge(MedicationKnowledge40_50.convertMedicationKnowledgeRelatedMedicationKnowledgeComponent(medicationKnowledgeRelatedMedicationKnowledgeComponent));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getAssociatedMedication()) {
            tgt.addAssociatedMedication(MedicationKnowledge40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getProductType()) {
            tgt.addProductType(MedicationKnowledge40_50.convertCodeableConcept(codeableConcept));
        }
        for (MedicationKnowledge.MedicationKnowledgeMonographComponent medicationKnowledgeMonographComponent : src.getMonograph()) {
            tgt.addMonograph(MedicationKnowledge40_50.convertMedicationKnowledgeMonographComponent(medicationKnowledgeMonographComponent));
        }
        for (MedicationKnowledge.MedicationKnowledgeIngredientComponent medicationKnowledgeIngredientComponent : src.getIngredient()) {
            tgt.addIngredient(MedicationKnowledge40_50.convertMedicationKnowledgeIngredientComponent(medicationKnowledgeIngredientComponent));
        }
        if (src.hasPreparationInstruction()) {
            tgt.setPreparationInstructionElement(MedicationKnowledge40_50.convertMarkdown(src.getPreparationInstructionElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getIntendedRoute()) {
            tgt.addIntendedRoute(MedicationKnowledge40_50.convertCodeableConcept(codeableConcept));
        }
        for (MedicationKnowledge.MedicationKnowledgeCostComponent medicationKnowledgeCostComponent : src.getCost()) {
            tgt.addCost(MedicationKnowledge40_50.convertMedicationKnowledgeCostComponent(medicationKnowledgeCostComponent));
        }
        for (MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent medicationKnowledgeMonitoringProgramComponent : src.getMonitoringProgram()) {
            tgt.addMonitoringProgram(MedicationKnowledge40_50.convertMedicationKnowledgeMonitoringProgramComponent(medicationKnowledgeMonitoringProgramComponent));
        }
        for (MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent medicationKnowledgeMedicineClassificationComponent : src.getMedicineClassification()) {
            tgt.addMedicineClassification(MedicationKnowledge40_50.convertMedicationKnowledgeMedicineClassificationComponent(medicationKnowledgeMedicineClassificationComponent));
        }
        if (src.hasPackaging()) {
            tgt.setPackaging(MedicationKnowledge40_50.convertMedicationKnowledgePackagingComponent(src.getPackaging()));
        }
        for (MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent medicationKnowledgeDrugCharacteristicComponent : src.getDrugCharacteristic()) {
            tgt.addDrugCharacteristic(MedicationKnowledge40_50.convertMedicationKnowledgeDrugCharacteristicComponent(medicationKnowledgeDrugCharacteristicComponent));
        }
        for (MedicationKnowledge.MedicationKnowledgeRegulatoryComponent medicationKnowledgeRegulatoryComponent : src.getRegulatory()) {
            tgt.addRegulatory(MedicationKnowledge40_50.convertMedicationKnowledgeRegulatoryComponent(medicationKnowledgeRegulatoryComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MedicationKnowledge convertMedicationKnowledge(MedicationKnowledge src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.MedicationKnowledge tgt = new org.hl7.fhir.r4.model.MedicationKnowledge();
        MedicationKnowledge40_50.copyDomainResource(src, tgt);
        if (src.hasCode()) {
            tgt.setCode(MedicationKnowledge40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationKnowledge40_50.convertMedicationKnowledgeStatus(src.getStatusElement()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(MedicationKnowledge40_50.convertReference(src.getManufacturer()));
        }
        if (src.hasDoseForm()) {
            tgt.setDoseForm(MedicationKnowledge40_50.convertCodeableConcept(src.getDoseForm()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(MedicationKnowledge40_50.convertSimpleQuantity(src.getAmount()));
        }
        for (StringType stringType : src.getSynonym()) {
            tgt.getSynonym().add(MedicationKnowledge40_50.convertString(stringType));
        }
        for (MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent medicationKnowledgeRelatedMedicationKnowledgeComponent : src.getRelatedMedicationKnowledge()) {
            tgt.addRelatedMedicationKnowledge(MedicationKnowledge40_50.convertMedicationKnowledgeRelatedMedicationKnowledgeComponent(medicationKnowledgeRelatedMedicationKnowledgeComponent));
        }
        for (Reference reference : src.getAssociatedMedication()) {
            tgt.addAssociatedMedication(MedicationKnowledge40_50.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getProductType()) {
            tgt.addProductType(MedicationKnowledge40_50.convertCodeableConcept(codeableConcept));
        }
        for (MedicationKnowledge.MedicationKnowledgeMonographComponent medicationKnowledgeMonographComponent : src.getMonograph()) {
            tgt.addMonograph(MedicationKnowledge40_50.convertMedicationKnowledgeMonographComponent(medicationKnowledgeMonographComponent));
        }
        for (MedicationKnowledge.MedicationKnowledgeIngredientComponent medicationKnowledgeIngredientComponent : src.getIngredient()) {
            tgt.addIngredient(MedicationKnowledge40_50.convertMedicationKnowledgeIngredientComponent(medicationKnowledgeIngredientComponent));
        }
        if (src.hasPreparationInstruction()) {
            tgt.setPreparationInstructionElement(MedicationKnowledge40_50.convertMarkdown(src.getPreparationInstructionElement()));
        }
        for (CodeableConcept codeableConcept : src.getIntendedRoute()) {
            tgt.addIntendedRoute(MedicationKnowledge40_50.convertCodeableConcept(codeableConcept));
        }
        for (MedicationKnowledge.MedicationKnowledgeCostComponent medicationKnowledgeCostComponent : src.getCost()) {
            tgt.addCost(MedicationKnowledge40_50.convertMedicationKnowledgeCostComponent(medicationKnowledgeCostComponent));
        }
        for (MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent medicationKnowledgeMonitoringProgramComponent : src.getMonitoringProgram()) {
            tgt.addMonitoringProgram(MedicationKnowledge40_50.convertMedicationKnowledgeMonitoringProgramComponent(medicationKnowledgeMonitoringProgramComponent));
        }
        for (MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent medicationKnowledgeMedicineClassificationComponent : src.getMedicineClassification()) {
            tgt.addMedicineClassification(MedicationKnowledge40_50.convertMedicationKnowledgeMedicineClassificationComponent(medicationKnowledgeMedicineClassificationComponent));
        }
        if (src.hasPackaging()) {
            tgt.setPackaging(MedicationKnowledge40_50.convertMedicationKnowledgePackagingComponent(src.getPackaging()));
        }
        for (MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent medicationKnowledgeDrugCharacteristicComponent : src.getDrugCharacteristic()) {
            tgt.addDrugCharacteristic(MedicationKnowledge40_50.convertMedicationKnowledgeDrugCharacteristicComponent(medicationKnowledgeDrugCharacteristicComponent));
        }
        for (MedicationKnowledge.MedicationKnowledgeRegulatoryComponent medicationKnowledgeRegulatoryComponent : src.getRegulatory()) {
            tgt.addRegulatory(MedicationKnowledge40_50.convertMedicationKnowledgeRegulatoryComponent(medicationKnowledgeRegulatoryComponent));
        }
        return tgt;
    }

    private static Enumeration<MedicationKnowledge.MedicationKnowledgeStatus> convertMedicationKnowledgeStatus(org.hl7.fhir.r5.model.Enumeration<MedicationKnowledge.MedicationKnowledgeStatusCodes> src) {
        if (src == null) {
            return null;
        }
        Enumeration<MedicationKnowledge.MedicationKnowledgeStatus> tgt = new Enumeration<MedicationKnowledge.MedicationKnowledgeStatus>(new MedicationKnowledge.MedicationKnowledgeStatusEnumFactory());
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationKnowledge.MedicationKnowledgeStatusCodes)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationKnowledge.MedicationKnowledgeStatus.ACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationKnowledge.MedicationKnowledgeStatus.ENTEREDINERROR);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)MedicationKnowledge.MedicationKnowledgeStatus.INACTIVE);
                break;
            }
            case NULL: {
                tgt.setValue((Object)MedicationKnowledge.MedicationKnowledgeStatus.NULL);
            }
        }
        return tgt;
    }

    private static org.hl7.fhir.r5.model.Enumeration<MedicationKnowledge.MedicationKnowledgeStatusCodes> convertMedicationKnowledgeStatus(Enumeration<MedicationKnowledge.MedicationKnowledgeStatus> src) {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MedicationKnowledge.MedicationKnowledgeStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<MedicationKnowledge.MedicationKnowledgeStatusCodes>(new MedicationKnowledge.MedicationKnowledgeStatusCodesEnumFactory());
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationKnowledge.MedicationKnowledgeStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationKnowledge.MedicationKnowledgeStatusCodes.ACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationKnowledge.MedicationKnowledgeStatusCodes.ENTEREDINERROR);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)MedicationKnowledge.MedicationKnowledgeStatusCodes.INACTIVE);
                break;
            }
            case NULL: {
                tgt.setValue((Object)MedicationKnowledge.MedicationKnowledgeStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent convertMedicationKnowledgeRelatedMedicationKnowledgeComponent(MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent tgt = new MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getReference()) {
            tgt.addReference(MedicationKnowledge40_50.convertReference(t));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent convertMedicationKnowledgeRelatedMedicationKnowledgeComponent(MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent tgt = new MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        for (Reference t : src.getReference()) {
            tgt.addReference(MedicationKnowledge40_50.convertReference(t));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeMonographComponent convertMedicationKnowledgeMonographComponent(MedicationKnowledge.MedicationKnowledgeMonographComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeMonographComponent tgt = new MedicationKnowledge.MedicationKnowledgeMonographComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSource()) {
            tgt.setSource(MedicationKnowledge40_50.convertReference(src.getSource()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeMonographComponent convertMedicationKnowledgeMonographComponent(MedicationKnowledge.MedicationKnowledgeMonographComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeMonographComponent tgt = new MedicationKnowledge.MedicationKnowledgeMonographComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSource()) {
            tgt.setSource(MedicationKnowledge40_50.convertReference(src.getSource()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeIngredientComponent convertMedicationKnowledgeIngredientComponent(MedicationKnowledge.MedicationKnowledgeIngredientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeIngredientComponent tgt = new MedicationKnowledge.MedicationKnowledgeIngredientComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasItemCodeableConcept()) {
            tgt.getItem().setConcept(MedicationKnowledge40_50.convertCodeableConcept(src.getItemCodeableConcept()));
        }
        if (src.hasItemReference()) {
            tgt.getItem().setReference(MedicationKnowledge40_50.convertReference(src.getItemReference()));
        }
        if (src.hasIsActive()) {
            tgt.setIsActiveElement(MedicationKnowledge40_50.convertBoolean(src.getIsActiveElement()));
        }
        if (src.hasStrength()) {
            tgt.setStrength(MedicationKnowledge40_50.convertRatio(src.getStrength()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeIngredientComponent convertMedicationKnowledgeIngredientComponent(MedicationKnowledge.MedicationKnowledgeIngredientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeIngredientComponent tgt = new MedicationKnowledge.MedicationKnowledgeIngredientComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.getItem().hasConcept()) {
            tgt.setItem(MedicationKnowledge40_50.convertType(src.getItem().getConcept()));
        }
        if (src.getItem().hasReference()) {
            tgt.setItem(MedicationKnowledge40_50.convertType(src.getItem().getReference()));
        }
        if (src.hasIsActive()) {
            tgt.setIsActiveElement(MedicationKnowledge40_50.convertBoolean(src.getIsActiveElement()));
        }
        if (src.hasStrengthRatio()) {
            tgt.setStrength(MedicationKnowledge40_50.convertRatio(src.getStrengthRatio()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeCostComponent convertMedicationKnowledgeCostComponent(MedicationKnowledge.MedicationKnowledgeCostComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeCostComponent tgt = new MedicationKnowledge.MedicationKnowledgeCostComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSource()) {
            tgt.setSourceElement(MedicationKnowledge40_50.convertString(src.getSourceElement()));
        }
        if (src.hasCost()) {
            tgt.setCost(MedicationKnowledge40_50.convertMoney(src.getCost()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeCostComponent convertMedicationKnowledgeCostComponent(MedicationKnowledge.MedicationKnowledgeCostComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeCostComponent tgt = new MedicationKnowledge.MedicationKnowledgeCostComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSource()) {
            tgt.setSourceElement(MedicationKnowledge40_50.convertString(src.getSourceElement()));
        }
        if (src.hasCost()) {
            tgt.setCost(MedicationKnowledge40_50.convertMoney(src.getCost()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent convertMedicationKnowledgeMonitoringProgramComponent(MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent tgt = new MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasName()) {
            tgt.setNameElement(MedicationKnowledge40_50.convertString(src.getNameElement()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent convertMedicationKnowledgeMonitoringProgramComponent(MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent tgt = new MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasName()) {
            tgt.setNameElement(MedicationKnowledge40_50.convertString(src.getNameElement()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent convertMedicationKnowledgeMedicineClassificationComponent(MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent tgt = new MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getClassification()) {
            tgt.addClassification(MedicationKnowledge40_50.convertCodeableConcept(t));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent convertMedicationKnowledgeMedicineClassificationComponent(MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent tgt = new MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        for (CodeableConcept t : src.getClassification()) {
            tgt.addClassification(MedicationKnowledge40_50.convertCodeableConcept(t));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgePackagingComponent convertMedicationKnowledgePackagingComponent(MedicationKnowledge.MedicationKnowledgePackagingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgePackagingComponent tgt = new MedicationKnowledge.MedicationKnowledgePackagingComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(MedicationKnowledge40_50.convertSimpleQuantity(src.getQuantity()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgePackagingComponent convertMedicationKnowledgePackagingComponent(MedicationKnowledge.MedicationKnowledgePackagingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgePackagingComponent tgt = new MedicationKnowledge.MedicationKnowledgePackagingComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(MedicationKnowledge40_50.convertSimpleQuantity(src.getQuantity()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent convertMedicationKnowledgeDrugCharacteristicComponent(MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent tgt = new MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasValue()) {
            tgt.setValue(MedicationKnowledge40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent convertMedicationKnowledgeDrugCharacteristicComponent(MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent tgt = new MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasValue()) {
            tgt.setValue(MedicationKnowledge40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeRegulatoryComponent convertMedicationKnowledgeRegulatoryComponent(MedicationKnowledge.MedicationKnowledgeRegulatoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeRegulatoryComponent tgt = new MedicationKnowledge.MedicationKnowledgeRegulatoryComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasRegulatoryAuthority()) {
            tgt.setRegulatoryAuthority(MedicationKnowledge40_50.convertReference(src.getRegulatoryAuthority()));
        }
        for (MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent t : src.getSubstitution()) {
            tgt.addSubstitution(MedicationKnowledge40_50.convertMedicationKnowledgeRegulatorySubstitutionComponent(t));
        }
        if (src.hasMaxDispense()) {
            tgt.setMaxDispense(MedicationKnowledge40_50.convertMedicationKnowledgeRegulatoryMaxDispenseComponent(src.getMaxDispense()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeRegulatoryComponent convertMedicationKnowledgeRegulatoryComponent(MedicationKnowledge.MedicationKnowledgeRegulatoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeRegulatoryComponent tgt = new MedicationKnowledge.MedicationKnowledgeRegulatoryComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasRegulatoryAuthority()) {
            tgt.setRegulatoryAuthority(MedicationKnowledge40_50.convertReference(src.getRegulatoryAuthority()));
        }
        for (MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent t : src.getSubstitution()) {
            tgt.addSubstitution(MedicationKnowledge40_50.convertMedicationKnowledgeRegulatorySubstitutionComponent(t));
        }
        if (src.hasMaxDispense()) {
            tgt.setMaxDispense(MedicationKnowledge40_50.convertMedicationKnowledgeRegulatoryMaxDispenseComponent(src.getMaxDispense()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent convertMedicationKnowledgeRegulatorySubstitutionComponent(MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent tgt = new MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasAllowed()) {
            tgt.setAllowedElement(MedicationKnowledge40_50.convertBoolean(src.getAllowedElement()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent convertMedicationKnowledgeRegulatorySubstitutionComponent(MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent tgt = new MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(MedicationKnowledge40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasAllowed()) {
            tgt.setAllowedElement(MedicationKnowledge40_50.convertBoolean(src.getAllowedElement()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent convertMedicationKnowledgeRegulatoryMaxDispenseComponent(MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent tgt = new MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasQuantity()) {
            tgt.setQuantity(MedicationKnowledge40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(MedicationKnowledge40_50.convertDuration(src.getPeriod()));
        }
        return tgt;
    }

    public static MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent convertMedicationKnowledgeRegulatoryMaxDispenseComponent(MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent tgt = new MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent();
        MedicationKnowledge40_50.copyElement(src, tgt, new String[0]);
        if (src.hasQuantity()) {
            tgt.setQuantity(MedicationKnowledge40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(MedicationKnowledge40_50.convertDuration(src.getPeriod()));
        }
        return tgt;
    }
}

