/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MedicationAdministration;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.Reference;

public class MedicationAdministration40_50
extends VersionConvertor_40_50 {
    public static MedicationAdministration convertMedicationAdministration(org.hl7.fhir.r4.model.MedicationAdministration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration tgt = new MedicationAdministration();
        MedicationAdministration40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MedicationAdministration40_50.convertIdentifier(identifier));
        }
        for (UriType uriType : src.getInstantiates()) {
            tgt.getInstantiatesUri().add(MedicationAdministration40_50.convertUri(uriType));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(MedicationAdministration40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationAdministration40_50.convertMedicationAdministrationStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getStatusReason()) {
            tgt.addStatusReason(MedicationAdministration40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCategory()) {
            tgt.addCategory(MedicationAdministration40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedicationCodeableConcept()) {
            tgt.getMedication().setConcept(MedicationAdministration40_50.convertCodeableConcept(src.getMedicationCodeableConcept()));
        }
        if (src.hasMedicationReference()) {
            tgt.getMedication().setReference(MedicationAdministration40_50.convertReference(src.getMedicationReference()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(MedicationAdministration40_50.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(MedicationAdministration40_50.convertReference(src.getContext()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(MedicationAdministration40_50.convertReference(reference));
        }
        if (src.hasEffective()) {
            tgt.setOccurence(MedicationAdministration40_50.convertType(src.getEffective()));
        }
        for (MedicationAdministration.MedicationAdministrationPerformerComponent medicationAdministrationPerformerComponent : src.getPerformer()) {
            tgt.addPerformer(MedicationAdministration40_50.convertMedicationAdministrationPerformerComponent(medicationAdministrationPerformerComponent));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(MedicationAdministration40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReason(MedicationAdministration40_50.convertReferenceToCodeableReference(reference));
        }
        if (src.hasRequest()) {
            tgt.setRequest(MedicationAdministration40_50.convertReference(src.getRequest()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getDevice()) {
            tgt.addDevice(MedicationAdministration40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(MedicationAdministration40_50.convertAnnotation(annotation));
        }
        if (src.hasDosage()) {
            tgt.setDosage(MedicationAdministration40_50.convertMedicationAdministrationDosageComponent(src.getDosage()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(MedicationAdministration40_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MedicationAdministration convertMedicationAdministration(MedicationAdministration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.MedicationAdministration tgt = new org.hl7.fhir.r4.model.MedicationAdministration();
        MedicationAdministration40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MedicationAdministration40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiates().add(MedicationAdministration40_50.convertUri(uriType));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(MedicationAdministration40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationAdministration40_50.convertMedicationAdministrationStatus(src.getStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getStatusReason()) {
            tgt.addStatusReason(MedicationAdministration40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCategory()) {
            tgt.setCategory(MedicationAdministration40_50.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.getMedication().hasConcept()) {
            tgt.setMedication(MedicationAdministration40_50.convertType(src.getMedication().getConcept()));
        }
        if (src.getMedication().hasReference()) {
            tgt.setMedication(MedicationAdministration40_50.convertType(src.getMedication().getReference()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(MedicationAdministration40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(MedicationAdministration40_50.convertReference(src.getEncounter()));
        }
        for (Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(MedicationAdministration40_50.convertReference(reference));
        }
        if (src.hasOccurence()) {
            tgt.setEffective(MedicationAdministration40_50.convertType(src.getOccurence()));
        }
        for (MedicationAdministration.MedicationAdministrationPerformerComponent medicationAdministrationPerformerComponent : src.getPerformer()) {
            tgt.addPerformer(MedicationAdministration40_50.convertMedicationAdministrationPerformerComponent(medicationAdministrationPerformerComponent));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(MedicationAdministration40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(MedicationAdministration40_50.convertReference(codeableReference.getReference()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(MedicationAdministration40_50.convertReference(src.getRequest()));
        }
        for (Reference reference : src.getDevice()) {
            tgt.addDevice(MedicationAdministration40_50.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(MedicationAdministration40_50.convertAnnotation(annotation));
        }
        if (src.hasDosage()) {
            tgt.setDosage(MedicationAdministration40_50.convertMedicationAdministrationDosageComponent(src.getDosage()));
        }
        for (Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(MedicationAdministration40_50.convertReference(reference));
        }
        return tgt;
    }

    private static org.hl7.fhir.r5.model.Enumeration<MedicationAdministration.MedicationAdministrationStatusCodes> convertMedicationAdministrationStatus(Enumeration<MedicationAdministration.MedicationAdministrationStatus> src) {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MedicationAdministration.MedicationAdministrationStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<MedicationAdministration.MedicationAdministrationStatusCodes>(new MedicationAdministration.MedicationAdministrationStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationAdministration.MedicationAdministrationStatus)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatusCodes.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatusCodes.ENTEREDINERROR);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatusCodes.INPROGRESS);
                break;
            }
            case NOTDONE: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatusCodes.NOTDONE);
                break;
            }
            case NULL: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatusCodes.NULL);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatusCodes.ONHOLD);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatusCodes.STOPPED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatusCodes.UNKNOWN);
            }
        }
        return tgt;
    }

    private static Enumeration<MedicationAdministration.MedicationAdministrationStatus> convertMedicationAdministrationStatus(org.hl7.fhir.r5.model.Enumeration<MedicationAdministration.MedicationAdministrationStatusCodes> src) {
        if (src == null) {
            return null;
        }
        Enumeration<MedicationAdministration.MedicationAdministrationStatus> tgt = new Enumeration<MedicationAdministration.MedicationAdministrationStatus>(new MedicationAdministration.MedicationAdministrationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationAdministration.MedicationAdministrationStatusCodes)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.ENTEREDINERROR);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.INPROGRESS);
                break;
            }
            case NOTDONE: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.NOTDONE);
                break;
            }
            case NULL: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.NULL);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.ONHOLD);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.STOPPED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.UNKNOWN);
            }
        }
        return tgt;
    }

    public static MedicationAdministration.MedicationAdministrationPerformerComponent convertMedicationAdministrationPerformerComponent(MedicationAdministration.MedicationAdministrationPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationPerformerComponent tgt = new MedicationAdministration.MedicationAdministrationPerformerComponent();
        MedicationAdministration40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFunction()) {
            tgt.setFunction(MedicationAdministration40_50.convertCodeableConcept(src.getFunction()));
        }
        if (src.hasActor()) {
            tgt.setActor(MedicationAdministration40_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static MedicationAdministration.MedicationAdministrationPerformerComponent convertMedicationAdministrationPerformerComponent(MedicationAdministration.MedicationAdministrationPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationPerformerComponent tgt = new MedicationAdministration.MedicationAdministrationPerformerComponent();
        MedicationAdministration40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFunction()) {
            tgt.setFunction(MedicationAdministration40_50.convertCodeableConcept(src.getFunction()));
        }
        if (src.hasActor()) {
            tgt.setActor(MedicationAdministration40_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static MedicationAdministration.MedicationAdministrationDosageComponent convertMedicationAdministrationDosageComponent(MedicationAdministration.MedicationAdministrationDosageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationDosageComponent tgt = new MedicationAdministration.MedicationAdministrationDosageComponent();
        MedicationAdministration40_50.copyElement(src, tgt, new String[0]);
        if (src.hasText()) {
            tgt.setTextElement(MedicationAdministration40_50.convertString(src.getTextElement()));
        }
        if (src.hasSite()) {
            tgt.setSite(MedicationAdministration40_50.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(MedicationAdministration40_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(MedicationAdministration40_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose()) {
            tgt.setDose(MedicationAdministration40_50.convertSimpleQuantity(src.getDose()));
        }
        if (src.hasRate()) {
            tgt.setRate(MedicationAdministration40_50.convertType(src.getRate()));
        }
        return tgt;
    }

    public static MedicationAdministration.MedicationAdministrationDosageComponent convertMedicationAdministrationDosageComponent(MedicationAdministration.MedicationAdministrationDosageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationDosageComponent tgt = new MedicationAdministration.MedicationAdministrationDosageComponent();
        MedicationAdministration40_50.copyElement(src, tgt, new String[0]);
        if (src.hasText()) {
            tgt.setTextElement(MedicationAdministration40_50.convertString(src.getTextElement()));
        }
        if (src.hasSite()) {
            tgt.setSite(MedicationAdministration40_50.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(MedicationAdministration40_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(MedicationAdministration40_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose()) {
            tgt.setDose(MedicationAdministration40_50.convertSimpleQuantity(src.getDose()));
        }
        if (src.hasRate()) {
            tgt.setRate(MedicationAdministration40_50.convertType(src.getRate()));
        }
        return tgt;
    }
}

