/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ListResource;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ListResource;

public class ListResource40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.ListResource convertListResource(ListResource src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ListResource tgt = new org.hl7.fhir.r5.model.ListResource();
        ListResource40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ListResource40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ListResource40_50.convertListStatus(src.getStatusElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(ListResource40_50.convertListMode(src.getModeElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ListResource40_50.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(ListResource40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(ListResource40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(ListResource40_50.convertReference(src.getEncounter()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ListResource40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(ListResource40_50.convertReference(src.getSource()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(ListResource40_50.convertCodeableConcept(src.getOrderedBy()));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(ListResource40_50.convertAnnotation(annotation));
        }
        for (ListResource.ListEntryComponent listEntryComponent : src.getEntry()) {
            tgt.addEntry(ListResource40_50.convertListEntryComponent(listEntryComponent));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(ListResource40_50.convertCodeableConcept(src.getEmptyReason()));
        }
        return tgt;
    }

    public static ListResource convertListResource(org.hl7.fhir.r5.model.ListResource src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ListResource tgt = new ListResource();
        ListResource40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ListResource40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ListResource40_50.convertListStatus(src.getStatusElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(ListResource40_50.convertListMode(src.getModeElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ListResource40_50.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(ListResource40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(ListResource40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(ListResource40_50.convertReference(src.getEncounter()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ListResource40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(ListResource40_50.convertReference(src.getSource()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(ListResource40_50.convertCodeableConcept(src.getOrderedBy()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(ListResource40_50.convertAnnotation(annotation));
        }
        for (ListResource.ListResourceEntryComponent listResourceEntryComponent : src.getEntry()) {
            tgt.addEntry(ListResource40_50.convertListEntryComponent(listResourceEntryComponent));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(ListResource40_50.convertCodeableConcept(src.getEmptyReason()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ListResource.ListStatus> convertListStatus(Enumeration<ListResource.ListStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ListResource.ListStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<ListResource.ListStatus>(new ListResource.ListStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ListResource.ListStatus)((Object)src.getValue())) {
            case CURRENT: {
                tgt.setValue((Object)ListResource.ListStatus.CURRENT);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)ListResource.ListStatus.RETIRED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ListResource.ListStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ListResource.ListStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ListResource.ListStatus> convertListStatus(org.hl7.fhir.r5.model.Enumeration<ListResource.ListStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ListResource.ListStatus> tgt = new Enumeration<ListResource.ListStatus>(new ListResource.ListStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ListResource.ListStatus)((Object)src.getValue())) {
            case CURRENT: {
                tgt.setValue((Object)ListResource.ListStatus.CURRENT);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)ListResource.ListStatus.RETIRED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ListResource.ListStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ListResource.ListStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ListMode> convertListMode(Enumeration<ListResource.ListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ListMode> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ListMode>(new Enumerations.ListModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ListResource.ListMode)((Object)src.getValue())) {
            case WORKING: {
                tgt.setValue((Object)Enumerations.ListMode.WORKING);
                break;
            }
            case SNAPSHOT: {
                tgt.setValue((Object)Enumerations.ListMode.SNAPSHOT);
                break;
            }
            case CHANGES: {
                tgt.setValue((Object)Enumerations.ListMode.CHANGES);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ListMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ListResource.ListMode> convertListMode(org.hl7.fhir.r5.model.Enumeration<Enumerations.ListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ListResource.ListMode> tgt = new Enumeration<ListResource.ListMode>(new ListResource.ListModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ListMode)((Object)src.getValue())) {
            case WORKING: {
                tgt.setValue((Object)ListResource.ListMode.WORKING);
                break;
            }
            case SNAPSHOT: {
                tgt.setValue((Object)ListResource.ListMode.SNAPSHOT);
                break;
            }
            case CHANGES: {
                tgt.setValue((Object)ListResource.ListMode.CHANGES);
                break;
            }
            default: {
                tgt.setValue((Object)ListResource.ListMode.NULL);
            }
        }
        return tgt;
    }

    public static ListResource.ListResourceEntryComponent convertListEntryComponent(ListResource.ListEntryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ListResource.ListResourceEntryComponent tgt = new ListResource.ListResourceEntryComponent();
        ListResource40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFlag()) {
            tgt.setFlag(ListResource40_50.convertCodeableConcept(src.getFlag()));
        }
        if (src.hasDeleted()) {
            tgt.setDeletedElement(ListResource40_50.convertBoolean(src.getDeletedElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ListResource40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasItem()) {
            tgt.setItem(ListResource40_50.convertReference(src.getItem()));
        }
        return tgt;
    }

    public static ListResource.ListEntryComponent convertListEntryComponent(ListResource.ListResourceEntryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ListResource.ListEntryComponent tgt = new ListResource.ListEntryComponent();
        ListResource40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFlag()) {
            tgt.setFlag(ListResource40_50.convertCodeableConcept(src.getFlag()));
        }
        if (src.hasDeleted()) {
            tgt.setDeletedElement(ListResource40_50.convertBoolean(src.getDeletedElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ListResource40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasItem()) {
            tgt.setItem(ListResource40_50.convertReference(src.getItem()));
        }
        return tgt;
    }
}

