/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Immunization;

public class Immunization40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Immunization convertImmunization(Immunization src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Immunization tgt = new org.hl7.fhir.r5.model.Immunization();
        Immunization40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Immunization40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Immunization40_50.convertImmunizationStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(Immunization40_50.convertCodeableConcept(src.getStatusReason()));
        }
        if (src.hasVaccineCode()) {
            tgt.setVaccineCode(Immunization40_50.convertCodeableConcept(src.getVaccineCode()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(Immunization40_50.convertReference(src.getPatient()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Immunization40_50.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(Immunization40_50.convertType(src.getOccurrence()));
        }
        if (src.hasRecorded()) {
            tgt.setRecordedElement(Immunization40_50.convertDateTime(src.getRecordedElement()));
        }
        if (src.hasPrimarySource()) {
            tgt.setPrimarySourceElement(Immunization40_50.convertBoolean(src.getPrimarySourceElement()));
        }
        if (src.hasReportOrigin()) {
            tgt.setInformationSource(Immunization40_50.convertCodeableConcept(src.getReportOrigin()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Immunization40_50.convertReference(src.getLocation()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(Immunization40_50.convertReference(src.getManufacturer()));
        }
        if (src.hasLotNumber()) {
            tgt.setLotNumberElement(Immunization40_50.convertString(src.getLotNumberElement()));
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDateElement(Immunization40_50.convertDate(src.getExpirationDateElement()));
        }
        if (src.hasSite()) {
            tgt.setSite(Immunization40_50.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(Immunization40_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasDoseQuantity()) {
            tgt.setDoseQuantity(Immunization40_50.convertSimpleQuantity(src.getDoseQuantity()));
        }
        for (Immunization.ImmunizationPerformerComponent immunizationPerformerComponent : src.getPerformer()) {
            tgt.addPerformer(Immunization40_50.convertImmunizationPerformerComponent(immunizationPerformerComponent));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(Immunization40_50.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(Immunization40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReason(Immunization40_50.convertReferenceToCodeableReference(reference));
        }
        if (src.hasIsSubpotent()) {
            tgt.setIsSubpotentElement(Immunization40_50.convertBoolean(src.getIsSubpotentElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSubpotentReason()) {
            tgt.addSubpotentReason(Immunization40_50.convertCodeableConcept(codeableConcept));
        }
        for (Immunization.ImmunizationEducationComponent immunizationEducationComponent : src.getEducation()) {
            tgt.addEducation(Immunization40_50.convertImmunizationEducationComponent(immunizationEducationComponent));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getProgramEligibility()) {
            tgt.addProgramEligibility(Immunization40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasFundingSource()) {
            tgt.setFundingSource(Immunization40_50.convertCodeableConcept(src.getFundingSource()));
        }
        for (Immunization.ImmunizationReactionComponent immunizationReactionComponent : src.getReaction()) {
            tgt.addReaction(Immunization40_50.convertImmunizationReactionComponent(immunizationReactionComponent));
        }
        for (Immunization.ImmunizationProtocolAppliedComponent immunizationProtocolAppliedComponent : src.getProtocolApplied()) {
            tgt.addProtocolApplied(Immunization40_50.convertImmunizationProtocolAppliedComponent(immunizationProtocolAppliedComponent));
        }
        return tgt;
    }

    public static Immunization convertImmunization(org.hl7.fhir.r5.model.Immunization src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Immunization tgt = new Immunization();
        Immunization40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Immunization40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Immunization40_50.convertImmunizationStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(Immunization40_50.convertCodeableConcept(src.getStatusReason()));
        }
        if (src.hasVaccineCode()) {
            tgt.setVaccineCode(Immunization40_50.convertCodeableConcept(src.getVaccineCode()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(Immunization40_50.convertReference(src.getPatient()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Immunization40_50.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(Immunization40_50.convertType(src.getOccurrence()));
        }
        if (src.hasRecorded()) {
            tgt.setRecordedElement(Immunization40_50.convertDateTime(src.getRecordedElement()));
        }
        if (src.hasPrimarySource()) {
            tgt.setPrimarySourceElement(Immunization40_50.convertBoolean(src.getPrimarySourceElement()));
        }
        if (src.hasInformationSourceCodeableConcept()) {
            tgt.setReportOrigin(Immunization40_50.convertCodeableConcept(src.getInformationSourceCodeableConcept()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Immunization40_50.convertReference(src.getLocation()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(Immunization40_50.convertReference(src.getManufacturer()));
        }
        if (src.hasLotNumber()) {
            tgt.setLotNumberElement(Immunization40_50.convertString(src.getLotNumberElement()));
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDateElement(Immunization40_50.convertDate(src.getExpirationDateElement()));
        }
        if (src.hasSite()) {
            tgt.setSite(Immunization40_50.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(Immunization40_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasDoseQuantity()) {
            tgt.setDoseQuantity(Immunization40_50.convertSimpleQuantity(src.getDoseQuantity()));
        }
        for (Immunization.ImmunizationPerformerComponent immunizationPerformerComponent : src.getPerformer()) {
            tgt.addPerformer(Immunization40_50.convertImmunizationPerformerComponent(immunizationPerformerComponent));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(Immunization40_50.convertAnnotation(annotation));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(Immunization40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(Immunization40_50.convertReference(codeableReference.getReference()));
        }
        if (src.hasIsSubpotent()) {
            tgt.setIsSubpotentElement(Immunization40_50.convertBoolean(src.getIsSubpotentElement()));
        }
        for (CodeableConcept codeableConcept : src.getSubpotentReason()) {
            tgt.addSubpotentReason(Immunization40_50.convertCodeableConcept(codeableConcept));
        }
        for (Immunization.ImmunizationEducationComponent immunizationEducationComponent : src.getEducation()) {
            tgt.addEducation(Immunization40_50.convertImmunizationEducationComponent(immunizationEducationComponent));
        }
        for (CodeableConcept codeableConcept : src.getProgramEligibility()) {
            tgt.addProgramEligibility(Immunization40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasFundingSource()) {
            tgt.setFundingSource(Immunization40_50.convertCodeableConcept(src.getFundingSource()));
        }
        for (Immunization.ImmunizationReactionComponent immunizationReactionComponent : src.getReaction()) {
            tgt.addReaction(Immunization40_50.convertImmunizationReactionComponent(immunizationReactionComponent));
        }
        for (Immunization.ImmunizationProtocolAppliedComponent immunizationProtocolAppliedComponent : src.getProtocolApplied()) {
            tgt.addProtocolApplied(Immunization40_50.convertImmunizationProtocolAppliedComponent(immunizationProtocolAppliedComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Immunization.ImmunizationStatusCodes> convertImmunizationStatus(Enumeration<Immunization.ImmunizationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Immunization.ImmunizationStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Immunization.ImmunizationStatusCodes>(new Immunization.ImmunizationStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Immunization.ImmunizationStatus)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)Immunization.ImmunizationStatusCodes.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Immunization.ImmunizationStatusCodes.ENTEREDINERROR);
                break;
            }
            case NOTDONE: {
                tgt.setValue((Object)Immunization.ImmunizationStatusCodes.NOTDONE);
                break;
            }
            default: {
                tgt.setValue((Object)Immunization.ImmunizationStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Immunization.ImmunizationStatus> convertImmunizationStatus(org.hl7.fhir.r5.model.Enumeration<Immunization.ImmunizationStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Immunization.ImmunizationStatus> tgt = new Enumeration<Immunization.ImmunizationStatus>(new Immunization.ImmunizationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Immunization.ImmunizationStatusCodes)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)Immunization.ImmunizationStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Immunization.ImmunizationStatus.ENTEREDINERROR);
                break;
            }
            case NOTDONE: {
                tgt.setValue((Object)Immunization.ImmunizationStatus.NOTDONE);
                break;
            }
            default: {
                tgt.setValue((Object)Immunization.ImmunizationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Immunization.ImmunizationPerformerComponent convertImmunizationPerformerComponent(Immunization.ImmunizationPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Immunization.ImmunizationPerformerComponent tgt = new Immunization.ImmunizationPerformerComponent();
        Immunization40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFunction()) {
            tgt.setFunction(Immunization40_50.convertCodeableConcept(src.getFunction()));
        }
        if (src.hasActor()) {
            tgt.setActor(Immunization40_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static Immunization.ImmunizationPerformerComponent convertImmunizationPerformerComponent(Immunization.ImmunizationPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Immunization.ImmunizationPerformerComponent tgt = new Immunization.ImmunizationPerformerComponent();
        Immunization40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFunction()) {
            tgt.setFunction(Immunization40_50.convertCodeableConcept(src.getFunction()));
        }
        if (src.hasActor()) {
            tgt.setActor(Immunization40_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static Immunization.ImmunizationEducationComponent convertImmunizationEducationComponent(Immunization.ImmunizationEducationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Immunization.ImmunizationEducationComponent tgt = new Immunization.ImmunizationEducationComponent();
        Immunization40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDocumentType()) {
            tgt.setDocumentTypeElement(Immunization40_50.convertString(src.getDocumentTypeElement()));
        }
        if (src.hasReference()) {
            tgt.setReferenceElement(Immunization40_50.convertUri(src.getReferenceElement()));
        }
        if (src.hasPublicationDate()) {
            tgt.setPublicationDateElement(Immunization40_50.convertDateTime(src.getPublicationDateElement()));
        }
        if (src.hasPresentationDate()) {
            tgt.setPresentationDateElement(Immunization40_50.convertDateTime(src.getPresentationDateElement()));
        }
        return tgt;
    }

    public static Immunization.ImmunizationEducationComponent convertImmunizationEducationComponent(Immunization.ImmunizationEducationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Immunization.ImmunizationEducationComponent tgt = new Immunization.ImmunizationEducationComponent();
        Immunization40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDocumentType()) {
            tgt.setDocumentTypeElement(Immunization40_50.convertString(src.getDocumentTypeElement()));
        }
        if (src.hasReference()) {
            tgt.setReferenceElement(Immunization40_50.convertUri(src.getReferenceElement()));
        }
        if (src.hasPublicationDate()) {
            tgt.setPublicationDateElement(Immunization40_50.convertDateTime(src.getPublicationDateElement()));
        }
        if (src.hasPresentationDate()) {
            tgt.setPresentationDateElement(Immunization40_50.convertDateTime(src.getPresentationDateElement()));
        }
        return tgt;
    }

    public static Immunization.ImmunizationReactionComponent convertImmunizationReactionComponent(Immunization.ImmunizationReactionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Immunization.ImmunizationReactionComponent tgt = new Immunization.ImmunizationReactionComponent();
        Immunization40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDate()) {
            tgt.setDateElement(Immunization40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(Immunization40_50.convertReference(src.getDetail()));
        }
        if (src.hasReported()) {
            tgt.setReportedElement(Immunization40_50.convertBoolean(src.getReportedElement()));
        }
        return tgt;
    }

    public static Immunization.ImmunizationReactionComponent convertImmunizationReactionComponent(Immunization.ImmunizationReactionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Immunization.ImmunizationReactionComponent tgt = new Immunization.ImmunizationReactionComponent();
        Immunization40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDate()) {
            tgt.setDateElement(Immunization40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(Immunization40_50.convertReference(src.getDetail()));
        }
        if (src.hasReported()) {
            tgt.setReportedElement(Immunization40_50.convertBoolean(src.getReportedElement()));
        }
        return tgt;
    }

    public static Immunization.ImmunizationProtocolAppliedComponent convertImmunizationProtocolAppliedComponent(Immunization.ImmunizationProtocolAppliedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Immunization.ImmunizationProtocolAppliedComponent tgt = new Immunization.ImmunizationProtocolAppliedComponent();
        Immunization40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSeries()) {
            tgt.setSeriesElement(Immunization40_50.convertString(src.getSeriesElement()));
        }
        if (src.hasAuthority()) {
            tgt.setAuthority(Immunization40_50.convertReference(src.getAuthority()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getTargetDisease()) {
            tgt.addTargetDisease(Immunization40_50.convertCodeableConcept(t));
        }
        if (src.hasDoseNumber()) {
            tgt.setDoseNumber(src.getDoseNumber().primitiveValue());
        }
        if (src.hasSeriesDoses()) {
            tgt.setSeriesDoses(src.getSeriesDoses().primitiveValue());
        }
        return tgt;
    }

    public static Immunization.ImmunizationProtocolAppliedComponent convertImmunizationProtocolAppliedComponent(Immunization.ImmunizationProtocolAppliedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Immunization.ImmunizationProtocolAppliedComponent tgt = new Immunization.ImmunizationProtocolAppliedComponent();
        Immunization40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSeries()) {
            tgt.setSeriesElement(Immunization40_50.convertString(src.getSeriesElement()));
        }
        if (src.hasAuthority()) {
            tgt.setAuthority(Immunization40_50.convertReference(src.getAuthority()));
        }
        for (CodeableConcept t : src.getTargetDisease()) {
            tgt.addTargetDisease(Immunization40_50.convertCodeableConcept(t));
        }
        if (src.hasDoseNumber()) {
            tgt.setDoseNumber(Immunization40_50.convertType(src.getDoseNumberElement()));
        }
        if (src.hasSeriesDoses()) {
            tgt.setSeriesDoses(Immunization40_50.convertType(src.getSeriesDosesElement()));
        }
        return tgt;
    }
}

