/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ImagingStudy;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Reference;

public class ImagingStudy40_50
extends VersionConvertor_40_50 {
    public static ImagingStudy convertImagingStudy(org.hl7.fhir.r4.model.ImagingStudy src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImagingStudy tgt = new ImagingStudy();
        ImagingStudy40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ImagingStudy40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ImagingStudy40_50.convertImagingStudyStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.r4.model.Coding coding : src.getModality()) {
            tgt.addModality(ImagingStudy40_50.convertCoding(coding));
        }
        if (src.hasSubject()) {
            tgt.setSubject(ImagingStudy40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(ImagingStudy40_50.convertReference(src.getEncounter()));
        }
        if (src.hasStarted()) {
            tgt.setStartedElement(ImagingStudy40_50.convertDateTime(src.getStartedElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(ImagingStudy40_50.convertReference(reference));
        }
        if (src.hasReferrer()) {
            tgt.setReferrer(ImagingStudy40_50.convertReference(src.getReferrer()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getInterpreter()) {
            tgt.addInterpreter(ImagingStudy40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(ImagingStudy40_50.convertReference(reference));
        }
        if (src.hasNumberOfSeries()) {
            tgt.setNumberOfSeriesElement(ImagingStudy40_50.convertUnsignedInt(src.getNumberOfSeriesElement()));
        }
        if (src.hasNumberOfInstances()) {
            tgt.setNumberOfInstancesElement(ImagingStudy40_50.convertUnsignedInt(src.getNumberOfInstancesElement()));
        }
        if (src.hasProcedureReference()) {
            tgt.addProcedure().setValue(ImagingStudy40_50.convertReference(src.getProcedureReference()));
        }
        for (CodeableConcept codeableConcept : src.getProcedureCode()) {
            tgt.addProcedure().setValue(ImagingStudy40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasLocation()) {
            tgt.setLocation(ImagingStudy40_50.convertReference(src.getLocation()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(ImagingStudy40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReason(ImagingStudy40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(ImagingStudy40_50.convertAnnotation(annotation));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ImagingStudy40_50.convertString(src.getDescriptionElement()));
        }
        for (ImagingStudy.ImagingStudySeriesComponent imagingStudySeriesComponent : src.getSeries()) {
            tgt.addSeries(ImagingStudy40_50.convertImagingStudySeriesComponent(imagingStudySeriesComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ImagingStudy convertImagingStudy(ImagingStudy src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ImagingStudy tgt = new org.hl7.fhir.r4.model.ImagingStudy();
        ImagingStudy40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ImagingStudy40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ImagingStudy40_50.convertImagingStudyStatus(src.getStatusElement()));
        }
        for (Coding coding : src.getModality()) {
            tgt.addModality(ImagingStudy40_50.convertCoding(coding));
        }
        if (src.hasSubject()) {
            tgt.setSubject(ImagingStudy40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(ImagingStudy40_50.convertReference(src.getEncounter()));
        }
        if (src.hasStarted()) {
            tgt.setStartedElement(ImagingStudy40_50.convertDateTime(src.getStartedElement()));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(ImagingStudy40_50.convertReference(reference));
        }
        if (src.hasReferrer()) {
            tgt.setReferrer(ImagingStudy40_50.convertReference(src.getReferrer()));
        }
        for (Reference reference : src.getInterpreter()) {
            tgt.addInterpreter(ImagingStudy40_50.convertReference(reference));
        }
        for (Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(ImagingStudy40_50.convertReference(reference));
        }
        if (src.hasNumberOfSeries()) {
            tgt.setNumberOfSeriesElement(ImagingStudy40_50.convertUnsignedInt(src.getNumberOfSeriesElement()));
        }
        if (src.hasNumberOfInstances()) {
            tgt.setNumberOfInstancesElement(ImagingStudy40_50.convertUnsignedInt(src.getNumberOfInstancesElement()));
        }
        for (ImagingStudy.ImagingStudyProcedureComponent imagingStudyProcedureComponent : src.getProcedure()) {
            if (imagingStudyProcedureComponent.hasValueCodeableConcept()) {
                tgt.addProcedureCode(ImagingStudy40_50.convertCodeableConcept(imagingStudyProcedureComponent.getValueCodeableConcept()));
            }
            if (!imagingStudyProcedureComponent.hasValueReference()) continue;
            tgt.setProcedureReference(ImagingStudy40_50.convertReference(imagingStudyProcedureComponent.getValueReference()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(ImagingStudy40_50.convertReference(src.getLocation()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(ImagingStudy40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(ImagingStudy40_50.convertReference(codeableReference.getReference()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(ImagingStudy40_50.convertAnnotation(annotation));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ImagingStudy40_50.convertString(src.getDescriptionElement()));
        }
        for (ImagingStudy.ImagingStudySeriesComponent imagingStudySeriesComponent : src.getSeries()) {
            tgt.addSeries(ImagingStudy40_50.convertImagingStudySeriesComponent(imagingStudySeriesComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ImagingStudy.ImagingStudyStatus> convertImagingStudyStatus(Enumeration<ImagingStudy.ImagingStudyStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ImagingStudy.ImagingStudyStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<ImagingStudy.ImagingStudyStatus>(new ImagingStudy.ImagingStudyStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ImagingStudy.ImagingStudyStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)ImagingStudy.ImagingStudyStatus.REGISTERED);
                break;
            }
            case AVAILABLE: {
                tgt.setValue((Object)ImagingStudy.ImagingStudyStatus.AVAILABLE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)ImagingStudy.ImagingStudyStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ImagingStudy.ImagingStudyStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)ImagingStudy.ImagingStudyStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)ImagingStudy.ImagingStudyStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ImagingStudy.ImagingStudyStatus> convertImagingStudyStatus(org.hl7.fhir.r5.model.Enumeration<ImagingStudy.ImagingStudyStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ImagingStudy.ImagingStudyStatus> tgt = new Enumeration<ImagingStudy.ImagingStudyStatus>(new ImagingStudy.ImagingStudyStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ImagingStudy.ImagingStudyStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)ImagingStudy.ImagingStudyStatus.REGISTERED);
                break;
            }
            case AVAILABLE: {
                tgt.setValue((Object)ImagingStudy.ImagingStudyStatus.AVAILABLE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)ImagingStudy.ImagingStudyStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ImagingStudy.ImagingStudyStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)ImagingStudy.ImagingStudyStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)ImagingStudy.ImagingStudyStatus.NULL);
            }
        }
        return tgt;
    }

    public static ImagingStudy.ImagingStudySeriesComponent convertImagingStudySeriesComponent(ImagingStudy.ImagingStudySeriesComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImagingStudy.ImagingStudySeriesComponent tgt = new ImagingStudy.ImagingStudySeriesComponent();
        ImagingStudy40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUid()) {
            tgt.setUidElement(ImagingStudy40_50.convertId(src.getUidElement()));
        }
        if (src.hasNumber()) {
            tgt.setNumberElement(ImagingStudy40_50.convertUnsignedInt(src.getNumberElement()));
        }
        if (src.hasModality()) {
            tgt.setModality(ImagingStudy40_50.convertCoding(src.getModality()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ImagingStudy40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasNumberOfInstances()) {
            tgt.setNumberOfInstancesElement(ImagingStudy40_50.convertUnsignedInt(src.getNumberOfInstancesElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(ImagingStudy40_50.convertReference(reference));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(ImagingStudy40_50.convertCoding(src.getBodySite()));
        }
        if (src.hasLaterality()) {
            tgt.setLaterality(ImagingStudy40_50.convertCoding(src.getLaterality()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSpecimen()) {
            tgt.addSpecimen(ImagingStudy40_50.convertReference(reference));
        }
        if (src.hasStarted()) {
            tgt.setStartedElement(ImagingStudy40_50.convertDateTime(src.getStartedElement()));
        }
        for (ImagingStudy.ImagingStudySeriesPerformerComponent imagingStudySeriesPerformerComponent : src.getPerformer()) {
            tgt.addPerformer(ImagingStudy40_50.convertImagingStudySeriesPerformerComponent(imagingStudySeriesPerformerComponent));
        }
        for (ImagingStudy.ImagingStudySeriesInstanceComponent imagingStudySeriesInstanceComponent : src.getInstance()) {
            tgt.addInstance(ImagingStudy40_50.convertImagingStudySeriesInstanceComponent(imagingStudySeriesInstanceComponent));
        }
        return tgt;
    }

    public static ImagingStudy.ImagingStudySeriesComponent convertImagingStudySeriesComponent(ImagingStudy.ImagingStudySeriesComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImagingStudy.ImagingStudySeriesComponent tgt = new ImagingStudy.ImagingStudySeriesComponent();
        ImagingStudy40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUid()) {
            tgt.setUidElement(ImagingStudy40_50.convertId(src.getUidElement()));
        }
        if (src.hasNumber()) {
            tgt.setNumberElement(ImagingStudy40_50.convertUnsignedInt(src.getNumberElement()));
        }
        if (src.hasModality()) {
            tgt.setModality(ImagingStudy40_50.convertCoding(src.getModality()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ImagingStudy40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasNumberOfInstances()) {
            tgt.setNumberOfInstancesElement(ImagingStudy40_50.convertUnsignedInt(src.getNumberOfInstancesElement()));
        }
        for (Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(ImagingStudy40_50.convertReference(reference));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(ImagingStudy40_50.convertCoding(src.getBodySite()));
        }
        if (src.hasLaterality()) {
            tgt.setLaterality(ImagingStudy40_50.convertCoding(src.getLaterality()));
        }
        for (Reference reference : src.getSpecimen()) {
            tgt.addSpecimen(ImagingStudy40_50.convertReference(reference));
        }
        if (src.hasStarted()) {
            tgt.setStartedElement(ImagingStudy40_50.convertDateTime(src.getStartedElement()));
        }
        for (ImagingStudy.ImagingStudySeriesPerformerComponent imagingStudySeriesPerformerComponent : src.getPerformer()) {
            tgt.addPerformer(ImagingStudy40_50.convertImagingStudySeriesPerformerComponent(imagingStudySeriesPerformerComponent));
        }
        for (ImagingStudy.ImagingStudySeriesInstanceComponent imagingStudySeriesInstanceComponent : src.getInstance()) {
            tgt.addInstance(ImagingStudy40_50.convertImagingStudySeriesInstanceComponent(imagingStudySeriesInstanceComponent));
        }
        return tgt;
    }

    public static ImagingStudy.ImagingStudySeriesPerformerComponent convertImagingStudySeriesPerformerComponent(ImagingStudy.ImagingStudySeriesPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImagingStudy.ImagingStudySeriesPerformerComponent tgt = new ImagingStudy.ImagingStudySeriesPerformerComponent();
        ImagingStudy40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFunction()) {
            tgt.setFunction(ImagingStudy40_50.convertCodeableConcept(src.getFunction()));
        }
        if (src.hasActor()) {
            tgt.setActor(ImagingStudy40_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static ImagingStudy.ImagingStudySeriesPerformerComponent convertImagingStudySeriesPerformerComponent(ImagingStudy.ImagingStudySeriesPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImagingStudy.ImagingStudySeriesPerformerComponent tgt = new ImagingStudy.ImagingStudySeriesPerformerComponent();
        ImagingStudy40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFunction()) {
            tgt.setFunction(ImagingStudy40_50.convertCodeableConcept(src.getFunction()));
        }
        if (src.hasActor()) {
            tgt.setActor(ImagingStudy40_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static ImagingStudy.ImagingStudySeriesInstanceComponent convertImagingStudySeriesInstanceComponent(ImagingStudy.ImagingStudySeriesInstanceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImagingStudy.ImagingStudySeriesInstanceComponent tgt = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        ImagingStudy40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUid()) {
            tgt.setUidElement(ImagingStudy40_50.convertId(src.getUidElement()));
        }
        if (src.hasSopClass()) {
            tgt.setSopClass(ImagingStudy40_50.convertCoding(src.getSopClass()));
        }
        if (src.hasNumber()) {
            tgt.setNumberElement(ImagingStudy40_50.convertUnsignedInt(src.getNumberElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ImagingStudy40_50.convertString(src.getTitleElement()));
        }
        return tgt;
    }

    public static ImagingStudy.ImagingStudySeriesInstanceComponent convertImagingStudySeriesInstanceComponent(ImagingStudy.ImagingStudySeriesInstanceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImagingStudy.ImagingStudySeriesInstanceComponent tgt = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        ImagingStudy40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUid()) {
            tgt.setUidElement(ImagingStudy40_50.convertId(src.getUidElement()));
        }
        if (src.hasSopClass()) {
            tgt.setSopClass(ImagingStudy40_50.convertCoding(src.getSopClass()));
        }
        if (src.hasNumber()) {
            tgt.setNumberElement(ImagingStudy40_50.convertUnsignedInt(src.getNumberElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ImagingStudy40_50.convertString(src.getTitleElement()));
        }
        return tgt;
    }
}

