/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Reference;

public class HealthcareService40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.HealthcareService convertHealthcareService(HealthcareService src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.HealthcareService tgt = new org.hl7.fhir.r5.model.HealthcareService();
        HealthcareService40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(HealthcareService40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(HealthcareService40_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasProvidedBy()) {
            tgt.setProvidedBy(HealthcareService40_50.convertReference(src.getProvidedBy()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getLocation()) {
            tgt.addLocation(HealthcareService40_50.convertReference(reference));
        }
        if (src.hasName()) {
            tgt.setNameElement(HealthcareService40_50.convertString(src.getNameElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(HealthcareService40_50.convertString(src.getCommentElement()));
        }
        if (src.hasExtraDetails()) {
            tgt.setExtraDetailsElement(HealthcareService40_50.convertMarkdown(src.getExtraDetailsElement()));
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(HealthcareService40_50.convertAttachment(src.getPhoto()));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(HealthcareService40_50.convertContactPoint(contactPoint));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getCoverageArea()) {
            tgt.addCoverageArea(HealthcareService40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        for (HealthcareService.HealthcareServiceEligibilityComponent healthcareServiceEligibilityComponent : src.getEligibility()) {
            tgt.addEligibility(HealthcareService40_50.convertHealthcareServiceEligibilityComponent(healthcareServiceEligibilityComponent));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getProgram()) {
            tgt.addProgram(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCharacteristic()) {
            tgt.addCharacteristic(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCommunication()) {
            tgt.addCommunication(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReferralMethod()) {
            tgt.addReferralMethod(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentRequired()) {
            tgt.setAppointmentRequiredElement(HealthcareService40_50.convertBoolean(src.getAppointmentRequiredElement()));
        }
        for (HealthcareService.HealthcareServiceAvailableTimeComponent healthcareServiceAvailableTimeComponent : src.getAvailableTime()) {
            tgt.addAvailableTime(HealthcareService40_50.convertHealthcareServiceAvailableTimeComponent(healthcareServiceAvailableTimeComponent));
        }
        for (HealthcareService.HealthcareServiceNotAvailableComponent healthcareServiceNotAvailableComponent : src.getNotAvailable()) {
            tgt.addNotAvailable(HealthcareService40_50.convertHealthcareServiceNotAvailableComponent(healthcareServiceNotAvailableComponent));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptionsElement(HealthcareService40_50.convertString(src.getAvailabilityExceptionsElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(HealthcareService40_50.convertReference(reference));
        }
        return tgt;
    }

    public static HealthcareService convertHealthcareService(org.hl7.fhir.r5.model.HealthcareService src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService tgt = new HealthcareService();
        HealthcareService40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(HealthcareService40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(HealthcareService40_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasProvidedBy()) {
            tgt.setProvidedBy(HealthcareService40_50.convertReference(src.getProvidedBy()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getLocation()) {
            tgt.addLocation(HealthcareService40_50.convertReference(reference));
        }
        if (src.hasName()) {
            tgt.setNameElement(HealthcareService40_50.convertString(src.getNameElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(HealthcareService40_50.convertString(src.getCommentElement()));
        }
        if (src.hasExtraDetails()) {
            tgt.setExtraDetailsElement(HealthcareService40_50.convertMarkdown(src.getExtraDetailsElement()));
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(HealthcareService40_50.convertAttachment(src.getPhoto()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(HealthcareService40_50.convertContactPoint(contactPoint));
        }
        for (Reference reference : src.getCoverageArea()) {
            tgt.addCoverageArea(HealthcareService40_50.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        for (HealthcareService.HealthcareServiceEligibilityComponent healthcareServiceEligibilityComponent : src.getEligibility()) {
            tgt.addEligibility(HealthcareService40_50.convertHealthcareServiceEligibilityComponent(healthcareServiceEligibilityComponent));
        }
        for (CodeableConcept codeableConcept : src.getProgram()) {
            tgt.addProgram(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getCharacteristic()) {
            tgt.addCharacteristic(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getCommunication()) {
            tgt.addCommunication(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getReferralMethod()) {
            tgt.addReferralMethod(HealthcareService40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentRequired()) {
            tgt.setAppointmentRequiredElement(HealthcareService40_50.convertBoolean(src.getAppointmentRequiredElement()));
        }
        for (HealthcareService.HealthcareServiceAvailableTimeComponent healthcareServiceAvailableTimeComponent : src.getAvailableTime()) {
            tgt.addAvailableTime(HealthcareService40_50.convertHealthcareServiceAvailableTimeComponent(healthcareServiceAvailableTimeComponent));
        }
        for (HealthcareService.HealthcareServiceNotAvailableComponent healthcareServiceNotAvailableComponent : src.getNotAvailable()) {
            tgt.addNotAvailable(HealthcareService40_50.convertHealthcareServiceNotAvailableComponent(healthcareServiceNotAvailableComponent));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptionsElement(HealthcareService40_50.convertString(src.getAvailabilityExceptionsElement()));
        }
        for (Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(HealthcareService40_50.convertReference(reference));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceEligibilityComponent convertHealthcareServiceEligibilityComponent(HealthcareService.HealthcareServiceEligibilityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceEligibilityComponent tgt = new HealthcareService.HealthcareServiceEligibilityComponent();
        HealthcareService40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(HealthcareService40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(HealthcareService40_50.convertMarkdown(src.getCommentElement()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceEligibilityComponent convertHealthcareServiceEligibilityComponent(HealthcareService.HealthcareServiceEligibilityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceEligibilityComponent tgt = new HealthcareService.HealthcareServiceEligibilityComponent();
        HealthcareService40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(HealthcareService40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(HealthcareService40_50.convertMarkdown(src.getCommentElement()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        HealthcareService40_50.copyElement(src, tgt, new String[0]);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(HealthcareService40_50::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDay()) {
            tgt.setAllDayElement(HealthcareService40_50.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTime()) {
            tgt.setAvailableStartTimeElement(HealthcareService40_50.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTime()) {
            tgt.setAvailableEndTimeElement(HealthcareService40_50.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        HealthcareService40_50.copyElement(src, tgt, new String[0]);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(HealthcareService40_50::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDay()) {
            tgt.setAllDayElement(HealthcareService40_50.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTime()) {
            tgt.setAvailableStartTimeElement(HealthcareService40_50.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTime()) {
            tgt.setAvailableEndTimeElement(HealthcareService40_50.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> convertDaysOfWeek(Enumeration<HealthcareService.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((HealthcareService.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<HealthcareService.DaysOfWeek> convertDaysOfWeek(org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<HealthcareService.DaysOfWeek> tgt = new Enumeration<HealthcareService.DaysOfWeek>(new HealthcareService.DaysOfWeekEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        HealthcareService40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(HealthcareService40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(HealthcareService40_50.convertPeriod(src.getDuring()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        HealthcareService40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(HealthcareService40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(HealthcareService40_50.convertPeriod(src.getDuring()));
        }
        return tgt;
    }
}

