/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.GuidanceResponse;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.GuidanceResponse;

public class GuidanceResponse40_50
extends VersionConvertor_40_50 {
    public static GuidanceResponse convertGuidanceResponse(org.hl7.fhir.r4.model.GuidanceResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GuidanceResponse tgt = new GuidanceResponse();
        GuidanceResponse40_50.copyDomainResource(src, tgt);
        if (src.hasRequestIdentifier()) {
            tgt.setRequestIdentifier(GuidanceResponse40_50.convertIdentifier(src.getRequestIdentifier()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(GuidanceResponse40_50.convertIdentifier(identifier));
        }
        if (src.hasModule()) {
            tgt.setModule(GuidanceResponse40_50.convertType(src.getModule()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(GuidanceResponse40_50.convertGuidanceResponseStatus(src.getStatusElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(GuidanceResponse40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(GuidanceResponse40_50.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrenceDateTime()) {
            tgt.setOccurrenceDateTimeElement(GuidanceResponse40_50.convertDateTime(src.getOccurrenceDateTimeElement()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(GuidanceResponse40_50.convertReference(src.getPerformer()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(GuidanceResponse40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReason(GuidanceResponse40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(GuidanceResponse40_50.convertAnnotation(annotation));
        }
        for (Reference reference : src.getEvaluationMessage()) {
            tgt.addEvaluationMessage(GuidanceResponse40_50.convertReference(reference));
        }
        if (src.hasOutputParameters()) {
            tgt.setOutputParameters(GuidanceResponse40_50.convertReference(src.getOutputParameters()));
        }
        if (src.hasResult()) {
            tgt.setResult(GuidanceResponse40_50.convertReference(src.getResult()));
        }
        for (org.hl7.fhir.r4.model.DataRequirement dataRequirement : src.getDataRequirement()) {
            tgt.addDataRequirement(GuidanceResponse40_50.convertDataRequirement(dataRequirement));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.GuidanceResponse convertGuidanceResponse(GuidanceResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.GuidanceResponse tgt = new org.hl7.fhir.r4.model.GuidanceResponse();
        GuidanceResponse40_50.copyDomainResource(src, tgt);
        if (src.hasRequestIdentifier()) {
            tgt.setRequestIdentifier(GuidanceResponse40_50.convertIdentifier(src.getRequestIdentifier()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(GuidanceResponse40_50.convertIdentifier(identifier));
        }
        if (src.hasModule()) {
            tgt.setModule(GuidanceResponse40_50.convertType(src.getModule()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(GuidanceResponse40_50.convertGuidanceResponseStatus(src.getStatusElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(GuidanceResponse40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(GuidanceResponse40_50.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrenceDateTime()) {
            tgt.setOccurrenceDateTimeElement(GuidanceResponse40_50.convertDateTime(src.getOccurrenceDateTimeElement()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(GuidanceResponse40_50.convertReference(src.getPerformer()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(GuidanceResponse40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(GuidanceResponse40_50.convertReference(codeableReference.getReference()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(GuidanceResponse40_50.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getEvaluationMessage()) {
            tgt.addEvaluationMessage(GuidanceResponse40_50.convertReference(reference));
        }
        if (src.hasOutputParameters()) {
            tgt.setOutputParameters(GuidanceResponse40_50.convertReference(src.getOutputParameters()));
        }
        if (src.hasResult()) {
            tgt.setResult(GuidanceResponse40_50.convertReference(src.getResult()));
        }
        for (DataRequirement dataRequirement : src.getDataRequirement()) {
            tgt.addDataRequirement(GuidanceResponse40_50.convertDataRequirement(dataRequirement));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<GuidanceResponse.GuidanceResponseStatus> convertGuidanceResponseStatus(Enumeration<GuidanceResponse.GuidanceResponseStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<GuidanceResponse.GuidanceResponseStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<GuidanceResponse.GuidanceResponseStatus>(new GuidanceResponse.GuidanceResponseStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((GuidanceResponse.GuidanceResponseStatus)((Object)src.getValue())) {
            case SUCCESS: {
                tgt.setValue((Object)GuidanceResponse.GuidanceResponseStatus.SUCCESS);
                break;
            }
            case DATAREQUESTED: {
                tgt.setValue((Object)GuidanceResponse.GuidanceResponseStatus.DATAREQUESTED);
                break;
            }
            case DATAREQUIRED: {
                tgt.setValue((Object)GuidanceResponse.GuidanceResponseStatus.DATAREQUIRED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)GuidanceResponse.GuidanceResponseStatus.INPROGRESS);
                break;
            }
            case FAILURE: {
                tgt.setValue((Object)GuidanceResponse.GuidanceResponseStatus.FAILURE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)GuidanceResponse.GuidanceResponseStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)GuidanceResponse.GuidanceResponseStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<GuidanceResponse.GuidanceResponseStatus> convertGuidanceResponseStatus(org.hl7.fhir.r5.model.Enumeration<GuidanceResponse.GuidanceResponseStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<GuidanceResponse.GuidanceResponseStatus> tgt = new Enumeration<GuidanceResponse.GuidanceResponseStatus>(new GuidanceResponse.GuidanceResponseStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((GuidanceResponse.GuidanceResponseStatus)((Object)src.getValue())) {
            case SUCCESS: {
                tgt.setValue((Object)GuidanceResponse.GuidanceResponseStatus.SUCCESS);
                break;
            }
            case DATAREQUESTED: {
                tgt.setValue((Object)GuidanceResponse.GuidanceResponseStatus.DATAREQUESTED);
                break;
            }
            case DATAREQUIRED: {
                tgt.setValue((Object)GuidanceResponse.GuidanceResponseStatus.DATAREQUIRED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)GuidanceResponse.GuidanceResponseStatus.INPROGRESS);
                break;
            }
            case FAILURE: {
                tgt.setValue((Object)GuidanceResponse.GuidanceResponseStatus.FAILURE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)GuidanceResponse.GuidanceResponseStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)GuidanceResponse.GuidanceResponseStatus.NULL);
            }
        }
        return tgt;
    }
}

