/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.GraphDefinition;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.GraphDefinition;

public class GraphDefinition40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.GraphDefinition convertGraphDefinition(GraphDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.GraphDefinition tgt = new org.hl7.fhir.r5.model.GraphDefinition();
        GraphDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(GraphDefinition40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(GraphDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(GraphDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(GraphDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(GraphDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(GraphDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(GraphDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(GraphDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(GraphDefinition40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(GraphDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(GraphDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(GraphDefinition40_50.convertResourceEnum(src.getStartElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(GraphDefinition40_50.convertCanonical(src.getProfileElement()));
        }
        for (GraphDefinition.GraphDefinitionLinkComponent graphDefinitionLinkComponent : src.getLink()) {
            tgt.addLink(GraphDefinition40_50.convertGraphDefinitionLinkComponent(graphDefinitionLinkComponent));
        }
        return tgt;
    }

    public static GraphDefinition convertGraphDefinition(org.hl7.fhir.r5.model.GraphDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition tgt = new GraphDefinition();
        GraphDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(GraphDefinition40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(GraphDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(GraphDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(GraphDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(GraphDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(GraphDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(GraphDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(GraphDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(GraphDefinition40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(GraphDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(GraphDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(GraphDefinition40_50.convertResourceEnum(src.getStartElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(GraphDefinition40_50.convertCanonical(src.getProfileElement()));
        }
        for (GraphDefinition.GraphDefinitionLinkComponent graphDefinitionLinkComponent : src.getLink()) {
            tgt.addLink(GraphDefinition40_50.convertGraphDefinitionLinkComponent(graphDefinitionLinkComponent));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkComponent convertGraphDefinitionLinkComponent(GraphDefinition.GraphDefinitionLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkComponent tgt = new GraphDefinition.GraphDefinitionLinkComponent();
        GraphDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(GraphDefinition40_50.convertString(src.getPathElement()));
        }
        if (src.hasSliceName()) {
            tgt.setSliceNameElement(GraphDefinition40_50.convertString(src.getSliceNameElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(GraphDefinition40_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(GraphDefinition40_50.convertString(src.getMaxElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(GraphDefinition40_50.convertString(src.getDescriptionElement()));
        }
        for (GraphDefinition.GraphDefinitionLinkTargetComponent t : src.getTarget()) {
            tgt.addTarget(GraphDefinition40_50.convertGraphDefinitionLinkTargetComponent(t));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkComponent convertGraphDefinitionLinkComponent(GraphDefinition.GraphDefinitionLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkComponent tgt = new GraphDefinition.GraphDefinitionLinkComponent();
        GraphDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(GraphDefinition40_50.convertString(src.getPathElement()));
        }
        if (src.hasSliceName()) {
            tgt.setSliceNameElement(GraphDefinition40_50.convertString(src.getSliceNameElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(GraphDefinition40_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(GraphDefinition40_50.convertString(src.getMaxElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(GraphDefinition40_50.convertString(src.getDescriptionElement()));
        }
        for (GraphDefinition.GraphDefinitionLinkTargetComponent t : src.getTarget()) {
            tgt.addTarget(GraphDefinition40_50.convertGraphDefinitionLinkTargetComponent(t));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkTargetComponent convertGraphDefinitionLinkTargetComponent(GraphDefinition.GraphDefinitionLinkTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkTargetComponent tgt = new GraphDefinition.GraphDefinitionLinkTargetComponent();
        GraphDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(GraphDefinition40_50.convertResourceEnum(src.getTypeElement()));
        }
        if (src.hasParams()) {
            tgt.setParamsElement(GraphDefinition40_50.convertString(src.getParamsElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(GraphDefinition40_50.convertCanonical(src.getProfileElement()));
        }
        for (GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent graphDefinitionLinkTargetCompartmentComponent : src.getCompartment()) {
            tgt.addCompartment(GraphDefinition40_50.convertGraphDefinitionLinkTargetCompartmentComponent(graphDefinitionLinkTargetCompartmentComponent));
        }
        for (GraphDefinition.GraphDefinitionLinkComponent graphDefinitionLinkComponent : src.getLink()) {
            tgt.addLink(GraphDefinition40_50.convertGraphDefinitionLinkComponent(graphDefinitionLinkComponent));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkTargetComponent convertGraphDefinitionLinkTargetComponent(GraphDefinition.GraphDefinitionLinkTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkTargetComponent tgt = new GraphDefinition.GraphDefinitionLinkTargetComponent();
        GraphDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(GraphDefinition40_50.convertResourceEnum(src.getTypeElement()));
        }
        if (src.hasParams()) {
            tgt.setParamsElement(GraphDefinition40_50.convertString(src.getParamsElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(GraphDefinition40_50.convertCanonical(src.getProfileElement()));
        }
        for (GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent graphDefinitionLinkTargetCompartmentComponent : src.getCompartment()) {
            tgt.addCompartment(GraphDefinition40_50.convertGraphDefinitionLinkTargetCompartmentComponent(graphDefinitionLinkTargetCompartmentComponent));
        }
        for (GraphDefinition.GraphDefinitionLinkComponent graphDefinitionLinkComponent : src.getLink()) {
            tgt.addLink(GraphDefinition40_50.convertGraphDefinitionLinkComponent(graphDefinitionLinkComponent));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent convertGraphDefinitionLinkTargetCompartmentComponent(GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent tgt = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
        GraphDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(GraphDefinition40_50.convertGraphCompartmentUse(src.getUseElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(GraphDefinition40_50.convertCompartmentCode(src.getCodeElement()));
        }
        if (src.hasRule()) {
            tgt.setRuleElement(GraphDefinition40_50.convertGraphCompartmentRule(src.getRuleElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(GraphDefinition40_50.convertString(src.getExpressionElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(GraphDefinition40_50.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent convertGraphDefinitionLinkTargetCompartmentComponent(GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent tgt = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
        GraphDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(GraphDefinition40_50.convertGraphCompartmentUse(src.getUseElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(GraphDefinition40_50.convertCompartmentCode(src.getCodeElement()));
        }
        if (src.hasRule()) {
            tgt.setRuleElement(GraphDefinition40_50.convertGraphCompartmentRule(src.getRuleElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(GraphDefinition40_50.convertString(src.getExpressionElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(GraphDefinition40_50.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<GraphDefinition.GraphCompartmentUse> convertGraphCompartmentUse(Enumeration<GraphDefinition.GraphCompartmentUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<GraphDefinition.GraphCompartmentUse> tgt = new org.hl7.fhir.r5.model.Enumeration<GraphDefinition.GraphCompartmentUse>(new GraphDefinition.GraphCompartmentUseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((GraphDefinition.GraphCompartmentUse)((Object)src.getValue())) {
            case CONDITION: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentUse.CONDITION);
                break;
            }
            case REQUIREMENT: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentUse.REQUIREMENT);
                break;
            }
            default: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<GraphDefinition.GraphCompartmentUse> convertGraphCompartmentUse(org.hl7.fhir.r5.model.Enumeration<GraphDefinition.GraphCompartmentUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<GraphDefinition.GraphCompartmentUse> tgt = new Enumeration<GraphDefinition.GraphCompartmentUse>(new GraphDefinition.GraphCompartmentUseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((GraphDefinition.GraphCompartmentUse)((Object)src.getValue())) {
            case CONDITION: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentUse.CONDITION);
                break;
            }
            case REQUIREMENT: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentUse.REQUIREMENT);
                break;
            }
            default: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.CompartmentType> convertCompartmentCode(Enumeration<GraphDefinition.CompartmentCode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.CompartmentType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.CompartmentType>(new Enumerations.CompartmentTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((GraphDefinition.CompartmentCode)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)Enumerations.CompartmentType.PATIENT);
                break;
            }
            case ENCOUNTER: {
                tgt.setValue((Object)Enumerations.CompartmentType.ENCOUNTER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)Enumerations.CompartmentType.RELATEDPERSON);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)Enumerations.CompartmentType.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)Enumerations.CompartmentType.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.CompartmentType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<GraphDefinition.CompartmentCode> convertCompartmentCode(org.hl7.fhir.r5.model.Enumeration<Enumerations.CompartmentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<GraphDefinition.CompartmentCode> tgt = new Enumeration<GraphDefinition.CompartmentCode>(new GraphDefinition.CompartmentCodeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.CompartmentType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.PATIENT);
                break;
            }
            case ENCOUNTER: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.ENCOUNTER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.RELATEDPERSON);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<GraphDefinition.GraphCompartmentRule> convertGraphCompartmentRule(Enumeration<GraphDefinition.GraphCompartmentRule> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<GraphDefinition.GraphCompartmentRule> tgt = new org.hl7.fhir.r5.model.Enumeration<GraphDefinition.GraphCompartmentRule>(new GraphDefinition.GraphCompartmentRuleEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((GraphDefinition.GraphCompartmentRule)((Object)src.getValue())) {
            case IDENTICAL: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.IDENTICAL);
                break;
            }
            case MATCHING: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.MATCHING);
                break;
            }
            case DIFFERENT: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.DIFFERENT);
                break;
            }
            case CUSTOM: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.CUSTOM);
                break;
            }
            default: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<GraphDefinition.GraphCompartmentRule> convertGraphCompartmentRule(org.hl7.fhir.r5.model.Enumeration<GraphDefinition.GraphCompartmentRule> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<GraphDefinition.GraphCompartmentRule> tgt = new Enumeration<GraphDefinition.GraphCompartmentRule>(new GraphDefinition.GraphCompartmentRuleEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((GraphDefinition.GraphCompartmentRule)((Object)src.getValue())) {
            case IDENTICAL: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.IDENTICAL);
                break;
            }
            case MATCHING: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.MATCHING);
                break;
            }
            case DIFFERENT: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.DIFFERENT);
                break;
            }
            case CUSTOM: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.CUSTOM);
                break;
            }
            default: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.NULL);
            }
        }
        return tgt;
    }
}

