/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Flag;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r5.model.Flag;

public class Flag40_50
extends VersionConvertor_40_50 {
    public static Flag convertFlag(org.hl7.fhir.r4.model.Flag src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Flag tgt = new Flag();
        Flag40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Flag40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Flag40_50.convertFlagStatus(src.getStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Flag40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(Flag40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Flag40_50.convertReference(src.getSubject()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Flag40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Flag40_50.convertReference(src.getEncounter()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(Flag40_50.convertReference(src.getAuthor()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Flag convertFlag(Flag src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Flag tgt = new org.hl7.fhir.r4.model.Flag();
        Flag40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Flag40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Flag40_50.convertFlagStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Flag40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(Flag40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Flag40_50.convertReference(src.getSubject()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Flag40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Flag40_50.convertReference(src.getEncounter()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(Flag40_50.convertReference(src.getAuthor()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Flag.FlagStatus> convertFlagStatus(Enumeration<Flag.FlagStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Flag.FlagStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Flag.FlagStatus>(new Flag.FlagStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Flag.FlagStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Flag.FlagStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Flag.FlagStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Flag.FlagStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Flag.FlagStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Flag.FlagStatus> convertFlagStatus(org.hl7.fhir.r5.model.Enumeration<Flag.FlagStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Flag.FlagStatus> tgt = new Enumeration<Flag.FlagStatus>(new Flag.FlagStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Flag.FlagStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Flag.FlagStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Flag.FlagStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Flag.FlagStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Flag.FlagStatus.NULL);
            }
        }
        return tgt;
    }
}

