/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.EpisodeOfCare;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.EpisodeOfCare;

public class EpisodeOfCare40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.EpisodeOfCare convertEpisodeOfCare(EpisodeOfCare src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.EpisodeOfCare tgt = new org.hl7.fhir.r5.model.EpisodeOfCare();
        EpisodeOfCare40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(EpisodeOfCare40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(EpisodeOfCare40_50.convertEpisodeOfCareStatus(src.getStatusElement()));
        }
        for (EpisodeOfCare.EpisodeOfCareStatusHistoryComponent episodeOfCareStatusHistoryComponent : src.getStatusHistory()) {
            tgt.addStatusHistory(EpisodeOfCare40_50.convertEpisodeOfCareStatusHistoryComponent(episodeOfCareStatusHistoryComponent));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(EpisodeOfCare40_50.convertCodeableConcept(codeableConcept));
        }
        for (EpisodeOfCare.DiagnosisComponent diagnosisComponent : src.getDiagnosis()) {
            tgt.addDiagnosis(EpisodeOfCare40_50.convertDiagnosisComponent(diagnosisComponent));
        }
        if (src.hasPatient()) {
            tgt.setPatient(EpisodeOfCare40_50.convertReference(src.getPatient()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(EpisodeOfCare40_50.convertReference(src.getManagingOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(EpisodeOfCare40_50.convertPeriod(src.getPeriod()));
        }
        for (Reference reference : src.getReferralRequest()) {
            tgt.addReferralRequest(EpisodeOfCare40_50.convertReference(reference));
        }
        if (src.hasCareManager()) {
            tgt.setCareManager(EpisodeOfCare40_50.convertReference(src.getCareManager()));
        }
        for (Reference reference : src.getTeam()) {
            tgt.addTeam(EpisodeOfCare40_50.convertReference(reference));
        }
        for (Reference reference : src.getAccount()) {
            tgt.addAccount(EpisodeOfCare40_50.convertReference(reference));
        }
        return tgt;
    }

    public static EpisodeOfCare convertEpisodeOfCare(org.hl7.fhir.r5.model.EpisodeOfCare src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare tgt = new EpisodeOfCare();
        EpisodeOfCare40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(EpisodeOfCare40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(EpisodeOfCare40_50.convertEpisodeOfCareStatus(src.getStatusElement()));
        }
        for (EpisodeOfCare.EpisodeOfCareStatusHistoryComponent episodeOfCareStatusHistoryComponent : src.getStatusHistory()) {
            tgt.addStatusHistory(EpisodeOfCare40_50.convertEpisodeOfCareStatusHistoryComponent(episodeOfCareStatusHistoryComponent));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(EpisodeOfCare40_50.convertCodeableConcept(codeableConcept));
        }
        for (EpisodeOfCare.DiagnosisComponent diagnosisComponent : src.getDiagnosis()) {
            tgt.addDiagnosis(EpisodeOfCare40_50.convertDiagnosisComponent(diagnosisComponent));
        }
        if (src.hasPatient()) {
            tgt.setPatient(EpisodeOfCare40_50.convertReference(src.getPatient()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(EpisodeOfCare40_50.convertReference(src.getManagingOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(EpisodeOfCare40_50.convertPeriod(src.getPeriod()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getReferralRequest()) {
            tgt.addReferralRequest(EpisodeOfCare40_50.convertReference(reference));
        }
        if (src.hasCareManager()) {
            tgt.setCareManager(EpisodeOfCare40_50.convertReference(src.getCareManager()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getTeam()) {
            tgt.addTeam(EpisodeOfCare40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getAccount()) {
            tgt.addAccount(EpisodeOfCare40_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<EpisodeOfCare.EpisodeOfCareStatus> convertEpisodeOfCareStatus(Enumeration<EpisodeOfCare.EpisodeOfCareStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<EpisodeOfCare.EpisodeOfCareStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<EpisodeOfCare.EpisodeOfCareStatus>(new EpisodeOfCare.EpisodeOfCareStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((EpisodeOfCare.EpisodeOfCareStatus)((Object)src.getValue())) {
            case PLANNED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.PLANNED);
                break;
            }
            case WAITLIST: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.WAITLIST);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ONHOLD);
                break;
            }
            case FINISHED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.FINISHED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<EpisodeOfCare.EpisodeOfCareStatus> convertEpisodeOfCareStatus(org.hl7.fhir.r5.model.Enumeration<EpisodeOfCare.EpisodeOfCareStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<EpisodeOfCare.EpisodeOfCareStatus> tgt = new Enumeration<EpisodeOfCare.EpisodeOfCareStatus>(new EpisodeOfCare.EpisodeOfCareStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((EpisodeOfCare.EpisodeOfCareStatus)((Object)src.getValue())) {
            case PLANNED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.PLANNED);
                break;
            }
            case WAITLIST: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.WAITLIST);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ONHOLD);
                break;
            }
            case FINISHED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.FINISHED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.NULL);
            }
        }
        return tgt;
    }

    public static EpisodeOfCare.EpisodeOfCareStatusHistoryComponent convertEpisodeOfCareStatusHistoryComponent(EpisodeOfCare.EpisodeOfCareStatusHistoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent tgt = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        EpisodeOfCare40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(EpisodeOfCare40_50.convertEpisodeOfCareStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(EpisodeOfCare40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static EpisodeOfCare.EpisodeOfCareStatusHistoryComponent convertEpisodeOfCareStatusHistoryComponent(EpisodeOfCare.EpisodeOfCareStatusHistoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent tgt = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        EpisodeOfCare40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(EpisodeOfCare40_50.convertEpisodeOfCareStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(EpisodeOfCare40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static EpisodeOfCare.DiagnosisComponent convertDiagnosisComponent(EpisodeOfCare.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare.DiagnosisComponent tgt = new EpisodeOfCare.DiagnosisComponent();
        EpisodeOfCare40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCondition()) {
            tgt.setCondition(EpisodeOfCare40_50.convertReference(src.getCondition()));
        }
        if (src.hasRole()) {
            tgt.setRole(EpisodeOfCare40_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(EpisodeOfCare40_50.convertPositiveInt(src.getRankElement()));
        }
        return tgt;
    }

    public static EpisodeOfCare.DiagnosisComponent convertDiagnosisComponent(EpisodeOfCare.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare.DiagnosisComponent tgt = new EpisodeOfCare.DiagnosisComponent();
        EpisodeOfCare40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCondition()) {
            tgt.setCondition(EpisodeOfCare40_50.convertReference(src.getCondition()));
        }
        if (src.hasRole()) {
            tgt.setRole(EpisodeOfCare40_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(EpisodeOfCare40_50.convertPositiveInt(src.getRankElement()));
        }
        return tgt;
    }
}

