/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.EnrollmentRequest;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.Enumerations;

public class EnrollmentRequest40_50
extends VersionConvertor_40_50 {
    public static EnrollmentRequest convertEnrollmentRequest(org.hl7.fhir.r4.model.EnrollmentRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EnrollmentRequest tgt = new EnrollmentRequest();
        EnrollmentRequest40_50.copyDomainResource(src, tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(EnrollmentRequest40_50.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(EnrollmentRequest40_50.convertEnrollmentRequestStatus(src.getStatusElement()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(EnrollmentRequest40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasInsurer()) {
            tgt.setInsurer(EnrollmentRequest40_50.convertReference(src.getInsurer()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(EnrollmentRequest40_50.convertReference(src.getProvider()));
        }
        if (src.hasCandidate()) {
            tgt.setCandidate(EnrollmentRequest40_50.convertReference(src.getCandidate()));
        }
        if (src.hasCoverage()) {
            tgt.setCoverage(EnrollmentRequest40_50.convertReference(src.getCoverage()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.EnrollmentRequest convertEnrollmentRequest(EnrollmentRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.EnrollmentRequest tgt = new org.hl7.fhir.r4.model.EnrollmentRequest();
        EnrollmentRequest40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(EnrollmentRequest40_50.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(EnrollmentRequest40_50.convertEnrollmentRequestStatus(src.getStatusElement()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(EnrollmentRequest40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasInsurer()) {
            tgt.setInsurer(EnrollmentRequest40_50.convertReference(src.getInsurer()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(EnrollmentRequest40_50.convertReference(src.getProvider()));
        }
        if (src.hasCandidate()) {
            tgt.setCandidate(EnrollmentRequest40_50.convertReference(src.getCandidate()));
        }
        if (src.hasCoverage()) {
            tgt.setCoverage(EnrollmentRequest40_50.convertReference(src.getCoverage()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> convertEnrollmentRequestStatus(Enumeration<EnrollmentRequest.EnrollmentRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((EnrollmentRequest.EnrollmentRequestStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<EnrollmentRequest.EnrollmentRequestStatus> convertEnrollmentRequestStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<EnrollmentRequest.EnrollmentRequestStatus> tgt = new Enumeration<EnrollmentRequest.EnrollmentRequestStatus>(new EnrollmentRequest.EnrollmentRequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.FinancialResourceStatusCodes)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)EnrollmentRequest.EnrollmentRequestStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)EnrollmentRequest.EnrollmentRequestStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)EnrollmentRequest.EnrollmentRequestStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)EnrollmentRequest.EnrollmentRequestStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)EnrollmentRequest.EnrollmentRequestStatus.NULL);
            }
        }
        return tgt;
    }
}

