/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.DeviceUseStatement;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.DeviceUseStatement;

public class DeviceUseStatement40_50
extends VersionConvertor_40_50 {
    public static DeviceUseStatement convertDeviceUseStatement(org.hl7.fhir.r4.model.DeviceUseStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceUseStatement tgt = new DeviceUseStatement();
        DeviceUseStatement40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(DeviceUseStatement40_50.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(DeviceUseStatement40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DeviceUseStatement40_50.convertDeviceUseStatementStatus(src.getStatusElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(DeviceUseStatement40_50.convertReference(src.getSubject()));
        }
        for (Reference reference : src.getDerivedFrom()) {
            tgt.addDerivedFrom(DeviceUseStatement40_50.convertReference(reference));
        }
        if (src.hasTiming()) {
            tgt.setTiming(DeviceUseStatement40_50.convertType(src.getTiming()));
        }
        if (src.hasRecordedOn()) {
            tgt.setDateAssertedElement(DeviceUseStatement40_50.convertDateTime(src.getRecordedOnElement()));
        }
        if (src.hasSource()) {
            tgt.setInformationSource(DeviceUseStatement40_50.convertReference(src.getSource()));
        }
        if (src.hasDevice()) {
            tgt.getDevice().setReference(DeviceUseStatement40_50.convertReference(src.getDevice()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(DeviceUseStatement40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReason(DeviceUseStatement40_50.convertReferenceToCodeableReference(reference));
        }
        if (src.hasBodySite()) {
            tgt.getBodySite().setConcept(DeviceUseStatement40_50.convertCodeableConcept(src.getBodySite()));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(DeviceUseStatement40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.DeviceUseStatement convertDeviceUseStatement(DeviceUseStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.DeviceUseStatement tgt = new org.hl7.fhir.r4.model.DeviceUseStatement();
        DeviceUseStatement40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(DeviceUseStatement40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(DeviceUseStatement40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DeviceUseStatement40_50.convertDeviceUseStatementStatus(src.getStatusElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(DeviceUseStatement40_50.convertReference(src.getSubject()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getDerivedFrom()) {
            tgt.addDerivedFrom(DeviceUseStatement40_50.convertReference(reference));
        }
        if (src.hasTiming()) {
            tgt.setTiming(DeviceUseStatement40_50.convertType(src.getTiming()));
        }
        if (src.hasDateAsserted()) {
            tgt.setRecordedOnElement(DeviceUseStatement40_50.convertDateTime(src.getDateAssertedElement()));
        }
        if (src.hasInformationSource()) {
            tgt.setSource(DeviceUseStatement40_50.convertReference(src.getInformationSource()));
        }
        if (src.getDevice().hasReference()) {
            tgt.setDevice(DeviceUseStatement40_50.convertReference(src.getDevice().getReference()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(DeviceUseStatement40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(DeviceUseStatement40_50.convertReference(codeableReference.getReference()));
        }
        if (src.getBodySite().hasConcept()) {
            tgt.setBodySite(DeviceUseStatement40_50.convertCodeableConcept(src.getBodySite().getConcept()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(DeviceUseStatement40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<DeviceUseStatement.DeviceUseStatementStatus> convertDeviceUseStatementStatus(Enumeration<DeviceUseStatement.DeviceUseStatementStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<DeviceUseStatement.DeviceUseStatementStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<DeviceUseStatement.DeviceUseStatementStatus>(new DeviceUseStatement.DeviceUseStatementStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceUseStatement.DeviceUseStatementStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.ENTEREDINERROR);
                break;
            }
            case INTENDED: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.INTENDED);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.STOPPED);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.ONHOLD);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DeviceUseStatement.DeviceUseStatementStatus> convertDeviceUseStatementStatus(org.hl7.fhir.r5.model.Enumeration<DeviceUseStatement.DeviceUseStatementStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DeviceUseStatement.DeviceUseStatementStatus> tgt = new Enumeration<DeviceUseStatement.DeviceUseStatementStatus>(new DeviceUseStatement.DeviceUseStatementStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceUseStatement.DeviceUseStatementStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.ENTEREDINERROR);
                break;
            }
            case INTENDED: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.INTENDED);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.STOPPED);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.ONHOLD);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.NULL);
            }
        }
        return tgt;
    }
}

