/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class DetectedIssue40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.DetectedIssue convertDetectedIssue(DetectedIssue src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.DetectedIssue tgt = new org.hl7.fhir.r5.model.DetectedIssue();
        DetectedIssue40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(DetectedIssue40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DetectedIssue40_50.convertDetectedIssueStatus(src.getStatusElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(DetectedIssue40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(DetectedIssue40_50.convertDetectedIssueSeverity(src.getSeverityElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(DetectedIssue40_50.convertReference(src.getPatient()));
        }
        if (src.hasIdentified()) {
            tgt.setIdentified(DetectedIssue40_50.convertType(src.getIdentified()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(DetectedIssue40_50.convertReference(src.getAuthor()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getImplicated()) {
            tgt.addImplicated(DetectedIssue40_50.convertReference(reference));
        }
        for (DetectedIssue.DetectedIssueEvidenceComponent detectedIssueEvidenceComponent : src.getEvidence()) {
            tgt.addEvidence(DetectedIssue40_50.convertDetectedIssueEvidenceComponent(detectedIssueEvidenceComponent));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(DetectedIssue40_50.convertString(src.getDetailElement()));
        }
        if (src.hasReference()) {
            tgt.setReferenceElement(DetectedIssue40_50.convertUri(src.getReferenceElement()));
        }
        for (DetectedIssue.DetectedIssueMitigationComponent detectedIssueMitigationComponent : src.getMitigation()) {
            tgt.addMitigation(DetectedIssue40_50.convertDetectedIssueMitigationComponent(detectedIssueMitigationComponent));
        }
        return tgt;
    }

    public static DetectedIssue convertDetectedIssue(org.hl7.fhir.r5.model.DetectedIssue src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DetectedIssue tgt = new DetectedIssue();
        DetectedIssue40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(DetectedIssue40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DetectedIssue40_50.convertDetectedIssueStatus(src.getStatusElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(DetectedIssue40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(DetectedIssue40_50.convertDetectedIssueSeverity(src.getSeverityElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(DetectedIssue40_50.convertReference(src.getPatient()));
        }
        if (src.hasIdentified()) {
            tgt.setIdentified(DetectedIssue40_50.convertType(src.getIdentified()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(DetectedIssue40_50.convertReference(src.getAuthor()));
        }
        for (Reference reference : src.getImplicated()) {
            tgt.addImplicated(DetectedIssue40_50.convertReference(reference));
        }
        for (DetectedIssue.DetectedIssueEvidenceComponent detectedIssueEvidenceComponent : src.getEvidence()) {
            tgt.addEvidence(DetectedIssue40_50.convertDetectedIssueEvidenceComponent(detectedIssueEvidenceComponent));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(DetectedIssue40_50.convertString(src.getDetailElement()));
        }
        if (src.hasReference()) {
            tgt.setReferenceElement(DetectedIssue40_50.convertUri(src.getReferenceElement()));
        }
        for (DetectedIssue.DetectedIssueMitigationComponent detectedIssueMitigationComponent : src.getMitigation()) {
            tgt.addMitigation(DetectedIssue40_50.convertDetectedIssueMitigationComponent(detectedIssueMitigationComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus> convertDetectedIssueStatus(Enumeration<DetectedIssue.DetectedIssueStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus>(new Enumerations.ObservationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DetectedIssue.DetectedIssueStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)Enumerations.ObservationStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Enumerations.ObservationStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.CORRECTED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.ObservationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.ObservationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ObservationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DetectedIssue.DetectedIssueStatus> convertDetectedIssueStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DetectedIssue.DetectedIssueStatus> tgt = new Enumeration<DetectedIssue.DetectedIssueStatus>(new DetectedIssue.DetectedIssueStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ObservationStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.CORRECTED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<DetectedIssue.DetectedIssueSeverity> convertDetectedIssueSeverity(Enumeration<DetectedIssue.DetectedIssueSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<DetectedIssue.DetectedIssueSeverity> tgt = new org.hl7.fhir.r5.model.Enumeration<DetectedIssue.DetectedIssueSeverity>(new DetectedIssue.DetectedIssueSeverityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DetectedIssue.DetectedIssueSeverity)((Object)src.getValue())) {
            case HIGH: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.HIGH);
                break;
            }
            case MODERATE: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.MODERATE);
                break;
            }
            case LOW: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.LOW);
                break;
            }
            default: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DetectedIssue.DetectedIssueSeverity> convertDetectedIssueSeverity(org.hl7.fhir.r5.model.Enumeration<DetectedIssue.DetectedIssueSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DetectedIssue.DetectedIssueSeverity> tgt = new Enumeration<DetectedIssue.DetectedIssueSeverity>(new DetectedIssue.DetectedIssueSeverityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DetectedIssue.DetectedIssueSeverity)((Object)src.getValue())) {
            case HIGH: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.HIGH);
                break;
            }
            case MODERATE: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.MODERATE);
                break;
            }
            case LOW: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.LOW);
                break;
            }
            default: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.NULL);
            }
        }
        return tgt;
    }

    public static DetectedIssue.DetectedIssueEvidenceComponent convertDetectedIssueEvidenceComponent(DetectedIssue.DetectedIssueEvidenceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DetectedIssue.DetectedIssueEvidenceComponent tgt = new DetectedIssue.DetectedIssueEvidenceComponent();
        DetectedIssue40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(DetectedIssue40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getDetail()) {
            tgt.addDetail(DetectedIssue40_50.convertReference(reference));
        }
        return tgt;
    }

    public static DetectedIssue.DetectedIssueEvidenceComponent convertDetectedIssueEvidenceComponent(DetectedIssue.DetectedIssueEvidenceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DetectedIssue.DetectedIssueEvidenceComponent tgt = new DetectedIssue.DetectedIssueEvidenceComponent();
        DetectedIssue40_50.copyElement(src, tgt, new String[0]);
        for (CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(DetectedIssue40_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getDetail()) {
            tgt.addDetail(DetectedIssue40_50.convertReference(reference));
        }
        return tgt;
    }

    public static DetectedIssue.DetectedIssueMitigationComponent convertDetectedIssueMitigationComponent(DetectedIssue.DetectedIssueMitigationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DetectedIssue.DetectedIssueMitigationComponent tgt = new DetectedIssue.DetectedIssueMitigationComponent();
        DetectedIssue40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAction()) {
            tgt.setAction(DetectedIssue40_50.convertCodeableConcept(src.getAction()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(DetectedIssue40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(DetectedIssue40_50.convertReference(src.getAuthor()));
        }
        return tgt;
    }

    public static DetectedIssue.DetectedIssueMitigationComponent convertDetectedIssueMitigationComponent(DetectedIssue.DetectedIssueMitigationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DetectedIssue.DetectedIssueMitigationComponent tgt = new DetectedIssue.DetectedIssueMitigationComponent();
        DetectedIssue40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAction()) {
            tgt.setAction(DetectedIssue40_50.convertCodeableConcept(src.getAction()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(DetectedIssue40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(DetectedIssue40_50.convertReference(src.getAuthor()));
        }
        return tgt;
    }
}

