/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CoverageEligibilityResponse;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.Enumerations;

public class CoverageEligibilityResponse40_50
extends VersionConvertor_40_50 {
    public static CoverageEligibilityResponse convertCoverageEligibilityResponse(org.hl7.fhir.r4.model.CoverageEligibilityResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityResponse tgt = new CoverageEligibilityResponse();
        CoverageEligibilityResponse40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(CoverageEligibilityResponse40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CoverageEligibilityResponse40_50.convertEligibilityResponseStatus(src.getStatusElement()));
        }
        tgt.setPurpose(src.getPurpose().stream().map(CoverageEligibilityResponse40_50::convertEligibilityResponsePurpose).collect(Collectors.toList()));
        if (src.hasPatient()) {
            tgt.setPatient(CoverageEligibilityResponse40_50.convertReference(src.getPatient()));
        }
        if (src.hasServiced()) {
            tgt.setServiced(CoverageEligibilityResponse40_50.convertType(src.getServiced()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(CoverageEligibilityResponse40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasRequestor()) {
            tgt.setRequestor(CoverageEligibilityResponse40_50.convertReference(src.getRequestor()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(CoverageEligibilityResponse40_50.convertReference(src.getRequest()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcomeElement(CoverageEligibilityResponse40_50.convertRemittanceOutcome(src.getOutcomeElement()));
        }
        if (src.hasDisposition()) {
            tgt.setDispositionElement(CoverageEligibilityResponse40_50.convertString(src.getDispositionElement()));
        }
        if (src.hasInsurer()) {
            tgt.setInsurer(CoverageEligibilityResponse40_50.convertReference(src.getInsurer()));
        }
        for (CoverageEligibilityResponse.InsuranceComponent insuranceComponent : src.getInsurance()) {
            tgt.addInsurance(CoverageEligibilityResponse40_50.convertInsuranceComponent(insuranceComponent));
        }
        if (src.hasPreAuthRef()) {
            tgt.setPreAuthRefElement(CoverageEligibilityResponse40_50.convertString(src.getPreAuthRefElement()));
        }
        if (src.hasForm()) {
            tgt.setForm(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getForm()));
        }
        for (CoverageEligibilityResponse.ErrorsComponent errorsComponent : src.getError()) {
            tgt.addError(CoverageEligibilityResponse40_50.convertErrorsComponent(errorsComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CoverageEligibilityResponse convertCoverageEligibilityResponse(CoverageEligibilityResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CoverageEligibilityResponse tgt = new org.hl7.fhir.r4.model.CoverageEligibilityResponse();
        CoverageEligibilityResponse40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(CoverageEligibilityResponse40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CoverageEligibilityResponse40_50.convertEligibilityResponseStatus(src.getStatusElement()));
        }
        tgt.setPurpose(src.getPurpose().stream().map(CoverageEligibilityResponse40_50::convertEligibilityResponsePurpose).collect(Collectors.toList()));
        if (src.hasPatient()) {
            tgt.setPatient(CoverageEligibilityResponse40_50.convertReference(src.getPatient()));
        }
        if (src.hasServiced()) {
            tgt.setServiced(CoverageEligibilityResponse40_50.convertType(src.getServiced()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(CoverageEligibilityResponse40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasRequestor()) {
            tgt.setRequestor(CoverageEligibilityResponse40_50.convertReference(src.getRequestor()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(CoverageEligibilityResponse40_50.convertReference(src.getRequest()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcomeElement(CoverageEligibilityResponse40_50.convertRemittanceOutcome(src.getOutcomeElement()));
        }
        if (src.hasDisposition()) {
            tgt.setDispositionElement(CoverageEligibilityResponse40_50.convertString(src.getDispositionElement()));
        }
        if (src.hasInsurer()) {
            tgt.setInsurer(CoverageEligibilityResponse40_50.convertReference(src.getInsurer()));
        }
        for (CoverageEligibilityResponse.InsuranceComponent insuranceComponent : src.getInsurance()) {
            tgt.addInsurance(CoverageEligibilityResponse40_50.convertInsuranceComponent(insuranceComponent));
        }
        if (src.hasPreAuthRef()) {
            tgt.setPreAuthRefElement(CoverageEligibilityResponse40_50.convertString(src.getPreAuthRefElement()));
        }
        if (src.hasForm()) {
            tgt.setForm(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getForm()));
        }
        for (CoverageEligibilityResponse.ErrorsComponent errorsComponent : src.getError()) {
            tgt.addError(CoverageEligibilityResponse40_50.convertErrorsComponent(errorsComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> convertEligibilityResponseStatus(Enumeration<CoverageEligibilityResponse.EligibilityResponseStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CoverageEligibilityResponse.EligibilityResponseStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CoverageEligibilityResponse.EligibilityResponseStatus> convertEligibilityResponseStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CoverageEligibilityResponse.EligibilityResponseStatus> tgt = new Enumeration<CoverageEligibilityResponse.EligibilityResponseStatus>(new CoverageEligibilityResponse.EligibilityResponseStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.FinancialResourceStatusCodes)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)CoverageEligibilityResponse.EligibilityResponseStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)CoverageEligibilityResponse.EligibilityResponseStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)CoverageEligibilityResponse.EligibilityResponseStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)CoverageEligibilityResponse.EligibilityResponseStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)CoverageEligibilityResponse.EligibilityResponseStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CoverageEligibilityResponse.EligibilityResponsePurpose> convertEligibilityResponsePurpose(Enumeration<CoverageEligibilityResponse.EligibilityResponsePurpose> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CoverageEligibilityResponse.EligibilityResponsePurpose> tgt = new org.hl7.fhir.r5.model.Enumeration<CoverageEligibilityResponse.EligibilityResponsePurpose>(new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CoverageEligibilityResponse.EligibilityResponsePurpose)((Object)src.getValue())) {
            case AUTHREQUIREMENTS: {
                tgt.setValue((Object)CoverageEligibilityResponse.EligibilityResponsePurpose.AUTHREQUIREMENTS);
                break;
            }
            case BENEFITS: {
                tgt.setValue((Object)CoverageEligibilityResponse.EligibilityResponsePurpose.BENEFITS);
                break;
            }
            case DISCOVERY: {
                tgt.setValue((Object)CoverageEligibilityResponse.EligibilityResponsePurpose.DISCOVERY);
                break;
            }
            case VALIDATION: {
                tgt.setValue((Object)CoverageEligibilityResponse.EligibilityResponsePurpose.VALIDATION);
                break;
            }
            default: {
                tgt.setValue((Object)CoverageEligibilityResponse.EligibilityResponsePurpose.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CoverageEligibilityResponse.EligibilityResponsePurpose> convertEligibilityResponsePurpose(org.hl7.fhir.r5.model.Enumeration<CoverageEligibilityResponse.EligibilityResponsePurpose> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CoverageEligibilityResponse.EligibilityResponsePurpose> tgt = new Enumeration<CoverageEligibilityResponse.EligibilityResponsePurpose>(new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CoverageEligibilityResponse.EligibilityResponsePurpose)((Object)src.getValue())) {
            case AUTHREQUIREMENTS: {
                tgt.setValue((Object)CoverageEligibilityResponse.EligibilityResponsePurpose.AUTHREQUIREMENTS);
                break;
            }
            case BENEFITS: {
                tgt.setValue((Object)CoverageEligibilityResponse.EligibilityResponsePurpose.BENEFITS);
                break;
            }
            case DISCOVERY: {
                tgt.setValue((Object)CoverageEligibilityResponse.EligibilityResponsePurpose.DISCOVERY);
                break;
            }
            case VALIDATION: {
                tgt.setValue((Object)CoverageEligibilityResponse.EligibilityResponsePurpose.VALIDATION);
                break;
            }
            default: {
                tgt.setValue((Object)CoverageEligibilityResponse.EligibilityResponsePurpose.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes> convertRemittanceOutcome(Enumeration<Enumerations.RemittanceOutcome> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes>(new Enumerations.ClaimProcessingCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RemittanceOutcome)((Object)src.getValue())) {
            case QUEUED: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.QUEUED);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.COMPLETE);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.ERROR);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.PARTIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.RemittanceOutcome> convertRemittanceOutcome(org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.RemittanceOutcome> tgt = new Enumeration<Enumerations.RemittanceOutcome>(new Enumerations.RemittanceOutcomeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ClaimProcessingCodes)((Object)src.getValue())) {
            case QUEUED: {
                tgt.setValue((Object)Enumerations.RemittanceOutcome.QUEUED);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)Enumerations.RemittanceOutcome.COMPLETE);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Enumerations.RemittanceOutcome.ERROR);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)Enumerations.RemittanceOutcome.PARTIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RemittanceOutcome.NULL);
            }
        }
        return tgt;
    }

    public static CoverageEligibilityResponse.InsuranceComponent convertInsuranceComponent(CoverageEligibilityResponse.InsuranceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityResponse.InsuranceComponent tgt = new CoverageEligibilityResponse.InsuranceComponent();
        CoverageEligibilityResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCoverage()) {
            tgt.setCoverage(CoverageEligibilityResponse40_50.convertReference(src.getCoverage()));
        }
        if (src.hasInforce()) {
            tgt.setInforceElement(CoverageEligibilityResponse40_50.convertBoolean(src.getInforceElement()));
        }
        if (src.hasBenefitPeriod()) {
            tgt.setBenefitPeriod(CoverageEligibilityResponse40_50.convertPeriod(src.getBenefitPeriod()));
        }
        for (CoverageEligibilityResponse.ItemsComponent t : src.getItem()) {
            tgt.addItem(CoverageEligibilityResponse40_50.convertItemsComponent(t));
        }
        return tgt;
    }

    public static CoverageEligibilityResponse.InsuranceComponent convertInsuranceComponent(CoverageEligibilityResponse.InsuranceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityResponse.InsuranceComponent tgt = new CoverageEligibilityResponse.InsuranceComponent();
        CoverageEligibilityResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCoverage()) {
            tgt.setCoverage(CoverageEligibilityResponse40_50.convertReference(src.getCoverage()));
        }
        if (src.hasInforce()) {
            tgt.setInforceElement(CoverageEligibilityResponse40_50.convertBoolean(src.getInforceElement()));
        }
        if (src.hasBenefitPeriod()) {
            tgt.setBenefitPeriod(CoverageEligibilityResponse40_50.convertPeriod(src.getBenefitPeriod()));
        }
        for (CoverageEligibilityResponse.ItemsComponent t : src.getItem()) {
            tgt.addItem(CoverageEligibilityResponse40_50.convertItemsComponent(t));
        }
        return tgt;
    }

    public static CoverageEligibilityResponse.ItemsComponent convertItemsComponent(CoverageEligibilityResponse.ItemsComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityResponse.ItemsComponent tgt = new CoverageEligibilityResponse.ItemsComponent();
        CoverageEligibilityResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(CoverageEligibilityResponse40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasProvider()) {
            tgt.setProvider(CoverageEligibilityResponse40_50.convertReference(src.getProvider()));
        }
        if (src.hasExcluded()) {
            tgt.setExcludedElement(CoverageEligibilityResponse40_50.convertBoolean(src.getExcludedElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(CoverageEligibilityResponse40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CoverageEligibilityResponse40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasNetwork()) {
            tgt.setNetwork(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getNetwork()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getUnit()));
        }
        if (src.hasTerm()) {
            tgt.setTerm(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getTerm()));
        }
        for (CoverageEligibilityResponse.BenefitComponent benefitComponent : src.getBenefit()) {
            tgt.addBenefit(CoverageEligibilityResponse40_50.convertBenefitComponent(benefitComponent));
        }
        if (src.hasAuthorizationRequired()) {
            tgt.setAuthorizationRequiredElement(CoverageEligibilityResponse40_50.convertBoolean(src.getAuthorizationRequiredElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getAuthorizationSupporting()) {
            tgt.addAuthorizationSupporting(CoverageEligibilityResponse40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAuthorizationUrl()) {
            tgt.setAuthorizationUrlElement(CoverageEligibilityResponse40_50.convertUri(src.getAuthorizationUrlElement()));
        }
        return tgt;
    }

    public static CoverageEligibilityResponse.ItemsComponent convertItemsComponent(CoverageEligibilityResponse.ItemsComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityResponse.ItemsComponent tgt = new CoverageEligibilityResponse.ItemsComponent();
        CoverageEligibilityResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(CoverageEligibilityResponse40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasProvider()) {
            tgt.setProvider(CoverageEligibilityResponse40_50.convertReference(src.getProvider()));
        }
        if (src.hasExcluded()) {
            tgt.setExcludedElement(CoverageEligibilityResponse40_50.convertBoolean(src.getExcludedElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(CoverageEligibilityResponse40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CoverageEligibilityResponse40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasNetwork()) {
            tgt.setNetwork(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getNetwork()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getUnit()));
        }
        if (src.hasTerm()) {
            tgt.setTerm(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getTerm()));
        }
        for (CoverageEligibilityResponse.BenefitComponent benefitComponent : src.getBenefit()) {
            tgt.addBenefit(CoverageEligibilityResponse40_50.convertBenefitComponent(benefitComponent));
        }
        if (src.hasAuthorizationRequired()) {
            tgt.setAuthorizationRequiredElement(CoverageEligibilityResponse40_50.convertBoolean(src.getAuthorizationRequiredElement()));
        }
        for (CodeableConcept codeableConcept : src.getAuthorizationSupporting()) {
            tgt.addAuthorizationSupporting(CoverageEligibilityResponse40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAuthorizationUrl()) {
            tgt.setAuthorizationUrlElement(CoverageEligibilityResponse40_50.convertUri(src.getAuthorizationUrlElement()));
        }
        return tgt;
    }

    public static CoverageEligibilityResponse.BenefitComponent convertBenefitComponent(CoverageEligibilityResponse.BenefitComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityResponse.BenefitComponent tgt = new CoverageEligibilityResponse.BenefitComponent();
        CoverageEligibilityResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasAllowed()) {
            tgt.setAllowed(CoverageEligibilityResponse40_50.convertType(src.getAllowed()));
        }
        if (src.hasUsed()) {
            tgt.setUsed(CoverageEligibilityResponse40_50.convertType(src.getUsed()));
        }
        return tgt;
    }

    public static CoverageEligibilityResponse.BenefitComponent convertBenefitComponent(CoverageEligibilityResponse.BenefitComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityResponse.BenefitComponent tgt = new CoverageEligibilityResponse.BenefitComponent();
        CoverageEligibilityResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasAllowed()) {
            tgt.setAllowed(CoverageEligibilityResponse40_50.convertType(src.getAllowed()));
        }
        if (src.hasUsed()) {
            tgt.setUsed(CoverageEligibilityResponse40_50.convertType(src.getUsed()));
        }
        return tgt;
    }

    public static CoverageEligibilityResponse.ErrorsComponent convertErrorsComponent(CoverageEligibilityResponse.ErrorsComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityResponse.ErrorsComponent tgt = new CoverageEligibilityResponse.ErrorsComponent();
        CoverageEligibilityResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static CoverageEligibilityResponse.ErrorsComponent convertErrorsComponent(CoverageEligibilityResponse.ErrorsComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityResponse.ErrorsComponent tgt = new CoverageEligibilityResponse.ErrorsComponent();
        CoverageEligibilityResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(CoverageEligibilityResponse40_50.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }
}

