/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class Composition40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Composition convertComposition(Composition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Composition tgt = new org.hl7.fhir.r5.model.Composition();
        Composition40_50.copyDomainResource(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(Composition40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Composition40_50.convertCompositionStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Composition40_50.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Composition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Composition40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Composition40_50.convertReference(src.getEncounter()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(Composition40_50.convertDateTime(src.getDateElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getAuthor()) {
            tgt.addAuthor(Composition40_50.convertReference(reference));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(Composition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasConfidentiality()) {
            tgt.setConfidentialityElement(Composition40_50.convertDocumentConfidentiality(src.getConfidentialityElement()));
        }
        for (Composition.CompositionAttesterComponent compositionAttesterComponent : src.getAttester()) {
            tgt.addAttester(Composition40_50.convertCompositionAttesterComponent(compositionAttesterComponent));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(Composition40_50.convertReference(src.getCustodian()));
        }
        for (Composition.CompositionRelatesToComponent compositionRelatesToComponent : src.getRelatesTo()) {
            tgt.addRelatesTo(Composition40_50.convertCompositionRelatesToComponent(compositionRelatesToComponent));
        }
        for (Composition.CompositionEventComponent compositionEventComponent : src.getEvent()) {
            tgt.addEvent(Composition40_50.convertCompositionEventComponent(compositionEventComponent));
        }
        for (Composition.SectionComponent sectionComponent : src.getSection()) {
            tgt.addSection(Composition40_50.convertSectionComponent(sectionComponent));
        }
        return tgt;
    }

    public static Composition convertComposition(org.hl7.fhir.r5.model.Composition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition tgt = new Composition();
        Composition40_50.copyDomainResource(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(Composition40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Composition40_50.convertCompositionStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Composition40_50.convertCodeableConcept(src.getType()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Composition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Composition40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Composition40_50.convertReference(src.getEncounter()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(Composition40_50.convertDateTime(src.getDateElement()));
        }
        for (Reference reference : src.getAuthor()) {
            tgt.addAuthor(Composition40_50.convertReference(reference));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(Composition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasConfidentiality()) {
            tgt.setConfidentialityElement(Composition40_50.convertDocumentConfidentiality(src.getConfidentialityElement()));
        }
        for (Composition.CompositionAttesterComponent compositionAttesterComponent : src.getAttester()) {
            tgt.addAttester(Composition40_50.convertCompositionAttesterComponent(compositionAttesterComponent));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(Composition40_50.convertReference(src.getCustodian()));
        }
        for (Composition.CompositionRelatesToComponent compositionRelatesToComponent : src.getRelatesTo()) {
            tgt.addRelatesTo(Composition40_50.convertCompositionRelatesToComponent(compositionRelatesToComponent));
        }
        for (Composition.CompositionEventComponent compositionEventComponent : src.getEvent()) {
            tgt.addEvent(Composition40_50.convertCompositionEventComponent(compositionEventComponent));
        }
        for (Composition.SectionComponent sectionComponent : src.getSection()) {
            tgt.addSection(Composition40_50.convertSectionComponent(sectionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.CompositionStatus> convertCompositionStatus(Enumeration<Composition.CompositionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.CompositionStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.CompositionStatus>(new Enumerations.CompositionStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Composition.CompositionStatus)((Object)src.getValue())) {
            case PRELIMINARY: {
                tgt.setValue((Object)Enumerations.CompositionStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Enumerations.CompositionStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Enumerations.CompositionStatus.AMENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.CompositionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.CompositionStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Composition.CompositionStatus> convertCompositionStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.CompositionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Composition.CompositionStatus> tgt = new Enumeration<Composition.CompositionStatus>(new Composition.CompositionStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.CompositionStatus)((Object)src.getValue())) {
            case PRELIMINARY: {
                tgt.setValue((Object)Composition.CompositionStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Composition.CompositionStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Composition.CompositionStatus.AMENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Composition.CompositionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.CompositionStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Composition.V3ConfidentialityClassification> convertDocumentConfidentiality(Enumeration<Composition.DocumentConfidentiality> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Composition.V3ConfidentialityClassification> tgt = new org.hl7.fhir.r5.model.Enumeration<Composition.V3ConfidentialityClassification>(new Composition.V3ConfidentialityClassificationEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Composition.DocumentConfidentiality)((Object)src.getValue())) {
            case U: {
                tgt.setValue((Object)Composition.V3ConfidentialityClassification.U);
                break;
            }
            case L: {
                tgt.setValue((Object)Composition.V3ConfidentialityClassification.L);
                break;
            }
            case M: {
                tgt.setValue((Object)Composition.V3ConfidentialityClassification.M);
                break;
            }
            case N: {
                tgt.setValue((Object)Composition.V3ConfidentialityClassification.N);
                break;
            }
            case R: {
                tgt.setValue((Object)Composition.V3ConfidentialityClassification.R);
                break;
            }
            case V: {
                tgt.setValue((Object)Composition.V3ConfidentialityClassification.V);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.V3ConfidentialityClassification.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Composition.DocumentConfidentiality> convertDocumentConfidentiality(org.hl7.fhir.r5.model.Enumeration<Composition.V3ConfidentialityClassification> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Composition.DocumentConfidentiality> tgt = new Enumeration<Composition.DocumentConfidentiality>(new Composition.DocumentConfidentialityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Composition.V3ConfidentialityClassification)((Object)src.getValue())) {
            case U: {
                tgt.setValue((Object)Composition.DocumentConfidentiality.U);
                break;
            }
            case L: {
                tgt.setValue((Object)Composition.DocumentConfidentiality.L);
                break;
            }
            case M: {
                tgt.setValue((Object)Composition.DocumentConfidentiality.M);
                break;
            }
            case N: {
                tgt.setValue((Object)Composition.DocumentConfidentiality.N);
                break;
            }
            case R: {
                tgt.setValue((Object)Composition.DocumentConfidentiality.R);
                break;
            }
            case V: {
                tgt.setValue((Object)Composition.DocumentConfidentiality.V);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.DocumentConfidentiality.NULL);
            }
        }
        return tgt;
    }

    public static Composition.CompositionAttesterComponent convertCompositionAttesterComponent(Composition.CompositionAttesterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionAttesterComponent tgt = new Composition.CompositionAttesterComponent();
        Composition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(Composition40_50.convertCompositionAttestationMode(src.getModeElement()));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(Composition40_50.convertDateTime(src.getTimeElement()));
        }
        if (src.hasParty()) {
            tgt.setParty(Composition40_50.convertReference(src.getParty()));
        }
        return tgt;
    }

    public static Composition.CompositionAttesterComponent convertCompositionAttesterComponent(Composition.CompositionAttesterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionAttesterComponent tgt = new Composition.CompositionAttesterComponent();
        Composition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(Composition40_50.convertCompositionAttestationMode(src.getModeElement()));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(Composition40_50.convertDateTime(src.getTimeElement()));
        }
        if (src.hasParty()) {
            tgt.setParty(Composition40_50.convertReference(src.getParty()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Composition.CompositionAttestationMode> convertCompositionAttestationMode(Enumeration<Composition.CompositionAttestationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Composition.CompositionAttestationMode> tgt = new org.hl7.fhir.r5.model.Enumeration<Composition.CompositionAttestationMode>(new Composition.CompositionAttestationModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Composition.CompositionAttestationMode)((Object)src.getValue())) {
            case PERSONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PERSONAL);
                break;
            }
            case PROFESSIONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PROFESSIONAL);
                break;
            }
            case LEGAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.LEGAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.OFFICIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Composition.CompositionAttestationMode> convertCompositionAttestationMode(org.hl7.fhir.r5.model.Enumeration<Composition.CompositionAttestationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Composition.CompositionAttestationMode> tgt = new Enumeration<Composition.CompositionAttestationMode>(new Composition.CompositionAttestationModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Composition.CompositionAttestationMode)((Object)src.getValue())) {
            case PERSONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PERSONAL);
                break;
            }
            case PROFESSIONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PROFESSIONAL);
                break;
            }
            case LEGAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.LEGAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.OFFICIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.NULL);
            }
        }
        return tgt;
    }

    public static Composition.CompositionRelatesToComponent convertCompositionRelatesToComponent(Composition.CompositionRelatesToComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionRelatesToComponent tgt = new Composition.CompositionRelatesToComponent();
        Composition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(Composition40_50.convertDocumentRelationshipType(src.getCodeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(Composition40_50.convertType(src.getTarget()));
        }
        return tgt;
    }

    public static Composition.CompositionRelatesToComponent convertCompositionRelatesToComponent(Composition.CompositionRelatesToComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionRelatesToComponent tgt = new Composition.CompositionRelatesToComponent();
        Composition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(Composition40_50.convertDocumentRelationshipType(src.getCodeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(Composition40_50.convertType(src.getTarget()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentRelationshipType> convertDocumentRelationshipType(Enumeration<Composition.DocumentRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentRelationshipType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentRelationshipType>(new Enumerations.DocumentRelationshipTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Composition.DocumentRelationshipType)((Object)src.getValue())) {
            case REPLACES: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.REPLACES);
                break;
            }
            case TRANSFORMS: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.TRANSFORMS);
                break;
            }
            case SIGNS: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.SIGNS);
                break;
            }
            case APPENDS: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.APPENDS);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Composition.DocumentRelationshipType> convertDocumentRelationshipType(org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Composition.DocumentRelationshipType> tgt = new Enumeration<Composition.DocumentRelationshipType>(new Composition.DocumentRelationshipTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.DocumentRelationshipType)((Object)src.getValue())) {
            case REPLACES: {
                tgt.setValue((Object)Composition.DocumentRelationshipType.REPLACES);
                break;
            }
            case TRANSFORMS: {
                tgt.setValue((Object)Composition.DocumentRelationshipType.TRANSFORMS);
                break;
            }
            case SIGNS: {
                tgt.setValue((Object)Composition.DocumentRelationshipType.SIGNS);
                break;
            }
            case APPENDS: {
                tgt.setValue((Object)Composition.DocumentRelationshipType.APPENDS);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.DocumentRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static Composition.CompositionEventComponent convertCompositionEventComponent(Composition.CompositionEventComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionEventComponent tgt = new Composition.CompositionEventComponent();
        Composition40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(Composition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Composition40_50.convertPeriod(src.getPeriod()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getDetail()) {
            tgt.addDetail(Composition40_50.convertReference(reference));
        }
        return tgt;
    }

    public static Composition.CompositionEventComponent convertCompositionEventComponent(Composition.CompositionEventComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionEventComponent tgt = new Composition.CompositionEventComponent();
        Composition40_50.copyElement(src, tgt, new String[0]);
        for (CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(Composition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Composition40_50.convertPeriod(src.getPeriod()));
        }
        for (Reference reference : src.getDetail()) {
            tgt.addDetail(Composition40_50.convertReference(reference));
        }
        return tgt;
    }

    public static Composition.SectionComponent convertSectionComponent(Composition.SectionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.SectionComponent tgt = new Composition.SectionComponent();
        Composition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasTitle()) {
            tgt.setTitleElement(Composition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(Composition40_50.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getAuthor()) {
            tgt.addAuthor(Composition40_50.convertReference(reference));
        }
        if (src.hasFocus()) {
            tgt.setFocus(Composition40_50.convertReference(src.getFocus()));
        }
        if (src.hasText()) {
            tgt.setText(Composition40_50.convertNarrative(src.getText()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(Composition40_50.convertSectionMode(src.getModeElement()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(Composition40_50.convertCodeableConcept(src.getOrderedBy()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEntry()) {
            tgt.addEntry(Composition40_50.convertReference(reference));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(Composition40_50.convertCodeableConcept(src.getEmptyReason()));
        }
        for (Composition.SectionComponent sectionComponent : src.getSection()) {
            tgt.addSection(Composition40_50.convertSectionComponent(sectionComponent));
        }
        return tgt;
    }

    public static Composition.SectionComponent convertSectionComponent(Composition.SectionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.SectionComponent tgt = new Composition.SectionComponent();
        Composition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasTitle()) {
            tgt.setTitleElement(Composition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(Composition40_50.convertCodeableConcept(src.getCode()));
        }
        for (Reference reference : src.getAuthor()) {
            tgt.addAuthor(Composition40_50.convertReference(reference));
        }
        if (src.hasFocus()) {
            tgt.setFocus(Composition40_50.convertReference(src.getFocus()));
        }
        if (src.hasText()) {
            tgt.setText(Composition40_50.convertNarrative(src.getText()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(Composition40_50.convertSectionMode(src.getModeElement()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(Composition40_50.convertCodeableConcept(src.getOrderedBy()));
        }
        for (Reference reference : src.getEntry()) {
            tgt.addEntry(Composition40_50.convertReference(reference));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(Composition40_50.convertCodeableConcept(src.getEmptyReason()));
        }
        for (Composition.SectionComponent sectionComponent : src.getSection()) {
            tgt.addSection(Composition40_50.convertSectionComponent(sectionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ListMode> convertSectionMode(Enumeration<Composition.SectionMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ListMode> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ListMode>(new Enumerations.ListModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Composition.SectionMode)((Object)src.getValue())) {
            case WORKING: {
                tgt.setValue((Object)Enumerations.ListMode.WORKING);
                break;
            }
            case SNAPSHOT: {
                tgt.setValue((Object)Enumerations.ListMode.SNAPSHOT);
                break;
            }
            case CHANGES: {
                tgt.setValue((Object)Enumerations.ListMode.CHANGES);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ListMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Composition.SectionMode> convertSectionMode(org.hl7.fhir.r5.model.Enumeration<Enumerations.ListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Composition.SectionMode> tgt = new Enumeration<Composition.SectionMode>(new Composition.SectionModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ListMode)((Object)src.getValue())) {
            case WORKING: {
                tgt.setValue((Object)Composition.SectionMode.WORKING);
                break;
            }
            case SNAPSHOT: {
                tgt.setValue((Object)Composition.SectionMode.SNAPSHOT);
                break;
            }
            case CHANGES: {
                tgt.setValue((Object)Composition.SectionMode.CHANGES);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.SectionMode.NULL);
            }
        }
        return tgt;
    }
}

