/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CommunicationRequest;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.utils.ToolingExtensions;

public class CommunicationRequest40_50
extends VersionConvertor_40_50 {
    public static final String EXT_PAYLOAD_CONTENT = "http://hl7.org/fhir/4.0/StructureDefinition/extension-CommunicationRequest.payload.content";

    public static org.hl7.fhir.r5.model.CommunicationRequest convertCommunicationRequest(CommunicationRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.CommunicationRequest tgt = new org.hl7.fhir.r5.model.CommunicationRequest();
        CommunicationRequest40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(CommunicationRequest40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(CommunicationRequest40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReplaces()) {
            tgt.addReplaces(CommunicationRequest40_50.convertReference(reference));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(CommunicationRequest40_50.convertIdentifier(src.getGroupIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CommunicationRequest40_50.convertCommunicationRequestStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(CommunicationRequest40_50.convertCodeableConcept(src.getStatusReason()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(CommunicationRequest40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(CommunicationRequest40_50.convertCommunicationPriority(src.getPriorityElement()));
        }
        if (src.hasDoNotPerform()) {
            tgt.setDoNotPerformElement(CommunicationRequest40_50.convertBoolean(src.getDoNotPerformElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getMedium()) {
            tgt.addMedium(CommunicationRequest40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(CommunicationRequest40_50.convertReference(src.getSubject()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getAbout()) {
            tgt.addAbout(CommunicationRequest40_50.convertReference(reference));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(CommunicationRequest40_50.convertReference(src.getEncounter()));
        }
        for (CommunicationRequest.CommunicationRequestPayloadComponent communicationRequestPayloadComponent : src.getPayload()) {
            tgt.addPayload(CommunicationRequest40_50.convertCommunicationRequestPayloadComponent(communicationRequestPayloadComponent));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(CommunicationRequest40_50.convertType(src.getOccurrence()));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(CommunicationRequest40_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRequester()) {
            tgt.setRequester(CommunicationRequest40_50.convertReference(src.getRequester()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getRecipient()) {
            tgt.addRecipient(CommunicationRequest40_50.convertReference(reference));
        }
        if (src.hasSender()) {
            tgt.addInformationProvider(CommunicationRequest40_50.convertReference(src.getSender()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(CommunicationRequest40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReason(CommunicationRequest40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(CommunicationRequest40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static CommunicationRequest convertCommunicationRequest(org.hl7.fhir.r5.model.CommunicationRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CommunicationRequest tgt = new CommunicationRequest();
        CommunicationRequest40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(CommunicationRequest40_50.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(CommunicationRequest40_50.convertReference(reference));
        }
        for (Reference reference : src.getReplaces()) {
            tgt.addReplaces(CommunicationRequest40_50.convertReference(reference));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(CommunicationRequest40_50.convertIdentifier(src.getGroupIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CommunicationRequest40_50.convertCommunicationRequestStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(CommunicationRequest40_50.convertCodeableConcept(src.getStatusReason()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(CommunicationRequest40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(CommunicationRequest40_50.convertCommunicationPriority(src.getPriorityElement()));
        }
        if (src.hasDoNotPerform()) {
            tgt.setDoNotPerformElement(CommunicationRequest40_50.convertBoolean(src.getDoNotPerformElement()));
        }
        for (CodeableConcept codeableConcept : src.getMedium()) {
            tgt.addMedium(CommunicationRequest40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(CommunicationRequest40_50.convertReference(src.getSubject()));
        }
        for (Reference reference : src.getAbout()) {
            tgt.addAbout(CommunicationRequest40_50.convertReference(reference));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(CommunicationRequest40_50.convertReference(src.getEncounter()));
        }
        for (CommunicationRequest.CommunicationRequestPayloadComponent communicationRequestPayloadComponent : src.getPayload()) {
            tgt.addPayload(CommunicationRequest40_50.convertCommunicationRequestPayloadComponent(communicationRequestPayloadComponent));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(CommunicationRequest40_50.convertType(src.getOccurrence()));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(CommunicationRequest40_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRequester()) {
            tgt.setRequester(CommunicationRequest40_50.convertReference(src.getRequester()));
        }
        for (Reference reference : src.getRecipient()) {
            tgt.addRecipient(CommunicationRequest40_50.convertReference(reference));
        }
        if (src.hasInformationProvider()) {
            tgt.setSender(CommunicationRequest40_50.convertReference(src.getInformationProviderFirstRep()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(CommunicationRequest40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(CommunicationRequest40_50.convertReference(codeableReference.getReference()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(CommunicationRequest40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> convertCommunicationRequestStatus(Enumeration<CommunicationRequest.CommunicationRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CommunicationRequest.CommunicationRequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.RequestStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.RequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Enumerations.RequestStatus.ONHOLD);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)Enumerations.RequestStatus.REVOKED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Enumerations.RequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.RequestStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.RequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CommunicationRequest.CommunicationRequestStatus> convertCommunicationRequestStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CommunicationRequest.CommunicationRequestStatus> tgt = new Enumeration<CommunicationRequest.CommunicationRequestStatus>(new CommunicationRequest.CommunicationRequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.ONHOLD);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.REVOKED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> convertCommunicationPriority(Enumeration<CommunicationRequest.CommunicationPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CommunicationRequest.CommunicationPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)Enumerations.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)Enumerations.RequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)Enumerations.RequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)Enumerations.RequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CommunicationRequest.CommunicationPriority> convertCommunicationPriority(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CommunicationRequest.CommunicationPriority> tgt = new Enumeration<CommunicationRequest.CommunicationPriority>(new CommunicationRequest.CommunicationPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)CommunicationRequest.CommunicationPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)CommunicationRequest.CommunicationPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)CommunicationRequest.CommunicationPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)CommunicationRequest.CommunicationPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)CommunicationRequest.CommunicationPriority.NULL);
            }
        }
        return tgt;
    }

    public static CommunicationRequest.CommunicationRequestPayloadComponent convertCommunicationRequestPayloadComponent(CommunicationRequest.CommunicationRequestPayloadComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CommunicationRequest.CommunicationRequestPayloadComponent tgt = new CommunicationRequest.CommunicationRequestPayloadComponent();
        CommunicationRequest40_50.copyElement(src, tgt, new String[0]);
        if (org.hl7.fhir.r4.utils.ToolingExtensions.hasExtension(src, EXT_PAYLOAD_CONTENT)) {
            Extension e = org.hl7.fhir.r4.utils.ToolingExtensions.getExtension(src, EXT_PAYLOAD_CONTENT);
            tgt.setContent(CommunicationRequest40_50.convertType(e.getValue()));
            ToolingExtensions.removeExtension(tgt, EXT_PAYLOAD_CONTENT);
        } else if (src.hasContent()) {
            Type content = src.getContent();
            if (content instanceof org.hl7.fhir.r4.model.StringType) {
                org.hl7.fhir.r4.model.StringType string = (org.hl7.fhir.r4.model.StringType)content;
                CodeableConcept code = new CodeableConcept();
                code.setTextElement((StringType)CommunicationRequest40_50.convertType(string));
                tgt.setContent(code);
            } else {
                tgt.setContent(CommunicationRequest40_50.convertType(content));
            }
        }
        return tgt;
    }

    public static CommunicationRequest.CommunicationRequestPayloadComponent convertCommunicationRequestPayloadComponent(CommunicationRequest.CommunicationRequestPayloadComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CommunicationRequest.CommunicationRequestPayloadComponent tgt = new CommunicationRequest.CommunicationRequestPayloadComponent();
        CommunicationRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasContent()) {
            DataType content = src.getContent();
            if (content instanceof CodeableConcept) {
                CodeableConcept code = (CodeableConcept)content;
                if (code.hasText()) {
                    tgt.setContent(new org.hl7.fhir.r4.model.StringType(code.getText()));
                }
                if (code.hasCoding() || code.hasExtension()) {
                    Extension e = new Extension(EXT_PAYLOAD_CONTENT);
                    e.setValue(CommunicationRequest40_50.convertType(code));
                    tgt.addExtension(e);
                }
            } else {
                tgt.setContent(CommunicationRequest40_50.convertType(content));
            }
        }
        return tgt;
    }
}

