/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Communication;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class Communication40_50
extends VersionConvertor_40_50 {
    public static Communication convertCommunication(org.hl7.fhir.r4.model.Communication src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Communication tgt = new Communication();
        Communication40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Communication40_50.convertIdentifier(identifier));
        }
        for (CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(Communication40_50.convertCanonical(canonicalType));
        }
        for (UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(Communication40_50.convertUri(uriType));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(Communication40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(Communication40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getInResponseTo()) {
            tgt.addInResponseTo(Communication40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Communication40_50.convertCommunicationStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(Communication40_50.convertCodeableConcept(src.getStatusReason()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Communication40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(Communication40_50.convertCommunicationPriority(src.getPriorityElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getMedium()) {
            tgt.addMedium(Communication40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Communication40_50.convertReference(src.getSubject()));
        }
        if (src.hasTopic()) {
            tgt.setTopic(Communication40_50.convertCodeableConcept(src.getTopic()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getAbout()) {
            tgt.addAbout(Communication40_50.convertReference(reference));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Communication40_50.convertReference(src.getEncounter()));
        }
        if (src.hasSent()) {
            tgt.setSentElement(Communication40_50.convertDateTime(src.getSentElement()));
        }
        if (src.hasReceived()) {
            tgt.setReceivedElement(Communication40_50.convertDateTime(src.getReceivedElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getRecipient()) {
            tgt.addRecipient(Communication40_50.convertReference(reference));
        }
        if (src.hasSender()) {
            tgt.setSender(Communication40_50.convertReference(src.getSender()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(Communication40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReason(Communication40_50.convertReferenceToCodeableReference(reference));
        }
        for (Communication.CommunicationPayloadComponent communicationPayloadComponent : src.getPayload()) {
            tgt.addPayload(Communication40_50.convertCommunicationPayloadComponent(communicationPayloadComponent));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(Communication40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Communication convertCommunication(Communication src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Communication tgt = new org.hl7.fhir.r4.model.Communication();
        Communication40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Communication40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(Communication40_50.convertCanonical(canonicalType));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(Communication40_50.convertUri(uriType));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(Communication40_50.convertReference(reference));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(Communication40_50.convertReference(reference));
        }
        for (Reference reference : src.getInResponseTo()) {
            tgt.addInResponseTo(Communication40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Communication40_50.convertCommunicationStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(Communication40_50.convertCodeableConcept(src.getStatusReason()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Communication40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(Communication40_50.convertCommunicationPriority(src.getPriorityElement()));
        }
        for (CodeableConcept codeableConcept : src.getMedium()) {
            tgt.addMedium(Communication40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Communication40_50.convertReference(src.getSubject()));
        }
        if (src.hasTopic()) {
            tgt.setTopic(Communication40_50.convertCodeableConcept(src.getTopic()));
        }
        for (Reference reference : src.getAbout()) {
            tgt.addAbout(Communication40_50.convertReference(reference));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Communication40_50.convertReference(src.getEncounter()));
        }
        if (src.hasSent()) {
            tgt.setSentElement(Communication40_50.convertDateTime(src.getSentElement()));
        }
        if (src.hasReceived()) {
            tgt.setReceivedElement(Communication40_50.convertDateTime(src.getReceivedElement()));
        }
        for (Reference reference : src.getRecipient()) {
            tgt.addRecipient(Communication40_50.convertReference(reference));
        }
        if (src.hasSender()) {
            tgt.setSender(Communication40_50.convertReference(src.getSender()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(Communication40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(Communication40_50.convertReference(codeableReference.getReference()));
        }
        for (Communication.CommunicationPayloadComponent communicationPayloadComponent : src.getPayload()) {
            tgt.addPayload(Communication40_50.convertCommunicationPayloadComponent(communicationPayloadComponent));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(Communication40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus> convertCommunicationStatus(Enumeration<Communication.CommunicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus>(new Enumerations.EventStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Communication.CommunicationStatus)((Object)src.getValue())) {
            case PREPARATION: {
                tgt.setValue((Object)Enumerations.EventStatus.PREPARATION);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Enumerations.EventStatus.INPROGRESS);
                break;
            }
            case NOTDONE: {
                tgt.setValue((Object)Enumerations.EventStatus.NOTDONE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Enumerations.EventStatus.ONHOLD);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)Enumerations.EventStatus.STOPPED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Enumerations.EventStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.EventStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.EventStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.EventStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Communication.CommunicationStatus> convertCommunicationStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Communication.CommunicationStatus> tgt = new Enumeration<Communication.CommunicationStatus>(new Communication.CommunicationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.EventStatus)((Object)src.getValue())) {
            case PREPARATION: {
                tgt.setValue((Object)Communication.CommunicationStatus.PREPARATION);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Communication.CommunicationStatus.INPROGRESS);
                break;
            }
            case NOTDONE: {
                tgt.setValue((Object)Communication.CommunicationStatus.NOTDONE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Communication.CommunicationStatus.ONHOLD);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)Communication.CommunicationStatus.STOPPED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Communication.CommunicationStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Communication.CommunicationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Communication.CommunicationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Communication.CommunicationStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> convertCommunicationPriority(Enumeration<Communication.CommunicationPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Communication.CommunicationPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)Enumerations.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)Enumerations.RequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)Enumerations.RequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)Enumerations.RequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Communication.CommunicationPriority> convertCommunicationPriority(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Communication.CommunicationPriority> tgt = new Enumeration<Communication.CommunicationPriority>(new Communication.CommunicationPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)Communication.CommunicationPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)Communication.CommunicationPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)Communication.CommunicationPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)Communication.CommunicationPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)Communication.CommunicationPriority.NULL);
            }
        }
        return tgt;
    }

    public static Communication.CommunicationPayloadComponent convertCommunicationPayloadComponent(Communication.CommunicationPayloadComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Communication.CommunicationPayloadComponent tgt = new Communication.CommunicationPayloadComponent();
        Communication40_50.copyElement(src, tgt, new String[0]);
        if (src.hasContent()) {
            if (src.getContent() instanceof StringType) {
                CodeableConcept tgtc = new CodeableConcept();
                Communication40_50.copyElement(src.getContent(), tgtc, new String[0]);
                tgtc.setText((String)src.getContentStringType().getValue());
                tgt.setContent(tgtc);
            } else if (src.hasContent()) {
                tgt.setContent(Communication40_50.convertType(src.getContent()));
            }
        }
        return tgt;
    }

    public static Communication.CommunicationPayloadComponent convertCommunicationPayloadComponent(Communication.CommunicationPayloadComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Communication.CommunicationPayloadComponent tgt = new Communication.CommunicationPayloadComponent();
        Communication40_50.copyElement(src, tgt, new String[0]);
        if (src.hasContent()) {
            if (src.hasContentCodeableConcept()) {
                StringType tgts = new StringType();
                Communication40_50.copyElement(src.getContent(), tgts, new String[0]);
                tgts.setValue(src.getContentCodeableConcept().getText());
                tgt.setContent(tgts);
            } else if (src.hasContent()) {
                tgt.setContent(Communication40_50.convertType(src.getContent()));
            }
        }
        return tgt;
    }
}

