/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumerations;

public class CodeSystem40_50
extends VersionConvertor_40_50 {
    public static CodeSystem convertCodeSystem(org.hl7.fhir.r4.model.CodeSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem tgt = new CodeSystem();
        CodeSystem40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(CodeSystem40_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(CodeSystem40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(CodeSystem40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(CodeSystem40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(CodeSystem40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(CodeSystem40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(CodeSystem40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(CodeSystem40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(CodeSystem40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CodeSystem40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(CodeSystem40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(CodeSystem40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(CodeSystem40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(CodeSystem40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasCaseSensitive()) {
            tgt.setCaseSensitiveElement(CodeSystem40_50.convertBoolean(src.getCaseSensitiveElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSetElement(CodeSystem40_50.convertCanonical(src.getValueSetElement()));
        }
        if (src.hasHierarchyMeaning()) {
            tgt.setHierarchyMeaningElement(CodeSystem40_50.convertCodeSystemHierarchyMeaning(src.getHierarchyMeaningElement()));
        }
        if (src.hasCompositional()) {
            tgt.setCompositionalElement(CodeSystem40_50.convertBoolean(src.getCompositionalElement()));
        }
        if (src.hasVersionNeeded()) {
            tgt.setVersionNeededElement(CodeSystem40_50.convertBoolean(src.getVersionNeededElement()));
        }
        if (src.hasContent()) {
            tgt.setContentElement(CodeSystem40_50.convertCodeSystemContentMode(src.getContentElement()));
        }
        if (src.hasSupplements()) {
            tgt.setSupplementsElement(CodeSystem40_50.convertCanonical(src.getSupplementsElement()));
        }
        if (src.hasCount()) {
            tgt.setCountElement(CodeSystem40_50.convertUnsignedInt(src.getCountElement()));
        }
        for (CodeSystem.CodeSystemFilterComponent codeSystemFilterComponent : src.getFilter()) {
            tgt.addFilter(CodeSystem40_50.convertCodeSystemFilterComponent(codeSystemFilterComponent));
        }
        for (CodeSystem.PropertyComponent propertyComponent : src.getProperty()) {
            tgt.addProperty(CodeSystem40_50.convertPropertyComponent(propertyComponent));
        }
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : src.getConcept()) {
            tgt.addConcept(CodeSystem40_50.convertConceptDefinitionComponent(conceptDefinitionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CodeSystem convertCodeSystem(CodeSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CodeSystem tgt = new org.hl7.fhir.r4.model.CodeSystem();
        CodeSystem40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(CodeSystem40_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(CodeSystem40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(CodeSystem40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(CodeSystem40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(CodeSystem40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(CodeSystem40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(CodeSystem40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(CodeSystem40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(CodeSystem40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CodeSystem40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(CodeSystem40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(CodeSystem40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(CodeSystem40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(CodeSystem40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasCaseSensitive()) {
            tgt.setCaseSensitiveElement(CodeSystem40_50.convertBoolean(src.getCaseSensitiveElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSetElement(CodeSystem40_50.convertCanonical(src.getValueSetElement()));
        }
        if (src.hasHierarchyMeaning()) {
            tgt.setHierarchyMeaningElement(CodeSystem40_50.convertCodeSystemHierarchyMeaning(src.getHierarchyMeaningElement()));
        }
        if (src.hasCompositional()) {
            tgt.setCompositionalElement(CodeSystem40_50.convertBoolean(src.getCompositionalElement()));
        }
        if (src.hasVersionNeeded()) {
            tgt.setVersionNeededElement(CodeSystem40_50.convertBoolean(src.getVersionNeededElement()));
        }
        if (src.hasContent()) {
            tgt.setContentElement(CodeSystem40_50.convertCodeSystemContentMode(src.getContentElement()));
        }
        if (src.hasSupplements()) {
            tgt.setSupplementsElement(CodeSystem40_50.convertCanonical(src.getSupplementsElement()));
        }
        if (src.hasCount()) {
            tgt.setCountElement(CodeSystem40_50.convertUnsignedInt(src.getCountElement()));
        }
        for (CodeSystem.CodeSystemFilterComponent codeSystemFilterComponent : src.getFilter()) {
            tgt.addFilter(CodeSystem40_50.convertCodeSystemFilterComponent(codeSystemFilterComponent));
        }
        for (CodeSystem.PropertyComponent propertyComponent : src.getProperty()) {
            tgt.addProperty(CodeSystem40_50.convertPropertyComponent(propertyComponent));
        }
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : src.getConcept()) {
            tgt.addConcept(CodeSystem40_50.convertConceptDefinitionComponent(conceptDefinitionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CodeSystem.CodeSystemHierarchyMeaning> convertCodeSystemHierarchyMeaning(Enumeration<CodeSystem.CodeSystemHierarchyMeaning> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CodeSystem.CodeSystemHierarchyMeaning> tgt = new org.hl7.fhir.r5.model.Enumeration<CodeSystem.CodeSystemHierarchyMeaning>(new CodeSystem.CodeSystemHierarchyMeaningEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.CodeSystemHierarchyMeaning)((Object)src.getValue())) {
            case GROUPEDBY: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.GROUPEDBY);
                break;
            }
            case ISA: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.ISA);
                break;
            }
            case PARTOF: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.PARTOF);
                break;
            }
            case CLASSIFIEDWITH: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.CLASSIFIEDWITH);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CodeSystem.CodeSystemHierarchyMeaning> convertCodeSystemHierarchyMeaning(org.hl7.fhir.r5.model.Enumeration<CodeSystem.CodeSystemHierarchyMeaning> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CodeSystem.CodeSystemHierarchyMeaning> tgt = new Enumeration<CodeSystem.CodeSystemHierarchyMeaning>(new CodeSystem.CodeSystemHierarchyMeaningEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.CodeSystemHierarchyMeaning)((Object)src.getValue())) {
            case GROUPEDBY: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.GROUPEDBY);
                break;
            }
            case ISA: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.ISA);
                break;
            }
            case PARTOF: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.PARTOF);
                break;
            }
            case CLASSIFIEDWITH: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.CLASSIFIEDWITH);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CodeSystem.CodeSystemContentMode> convertCodeSystemContentMode(Enumeration<CodeSystem.CodeSystemContentMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CodeSystem.CodeSystemContentMode> tgt = new org.hl7.fhir.r5.model.Enumeration<CodeSystem.CodeSystemContentMode>(new CodeSystem.CodeSystemContentModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.CodeSystemContentMode)((Object)src.getValue())) {
            case NOTPRESENT: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.NOTPRESENT);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.EXAMPLE);
                break;
            }
            case FRAGMENT: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.FRAGMENT);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.COMPLETE);
                break;
            }
            case SUPPLEMENT: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.SUPPLEMENT);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CodeSystem.CodeSystemContentMode> convertCodeSystemContentMode(org.hl7.fhir.r5.model.Enumeration<CodeSystem.CodeSystemContentMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CodeSystem.CodeSystemContentMode> tgt = new Enumeration<CodeSystem.CodeSystemContentMode>(new CodeSystem.CodeSystemContentModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.CodeSystemContentMode)((Object)src.getValue())) {
            case NOTPRESENT: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.NOTPRESENT);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.EXAMPLE);
                break;
            }
            case FRAGMENT: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.FRAGMENT);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.COMPLETE);
                break;
            }
            case SUPPLEMENT: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.SUPPLEMENT);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.NULL);
            }
        }
        return tgt;
    }

    public static CodeSystem.CodeSystemFilterComponent convertCodeSystemFilterComponent(CodeSystem.CodeSystemFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.CodeSystemFilterComponent tgt = new CodeSystem.CodeSystemFilterComponent();
        CodeSystem40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CodeSystem40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CodeSystem40_50.convertString(src.getDescriptionElement()));
        }
        tgt.setOperator(src.getOperator().stream().map(CodeSystem40_50::convertFilterOperator).collect(Collectors.toList()));
        if (src.hasValue()) {
            tgt.setValueElement(CodeSystem40_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static CodeSystem.CodeSystemFilterComponent convertCodeSystemFilterComponent(CodeSystem.CodeSystemFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.CodeSystemFilterComponent tgt = new CodeSystem.CodeSystemFilterComponent();
        CodeSystem40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CodeSystem40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CodeSystem40_50.convertString(src.getDescriptionElement()));
        }
        tgt.setOperator(src.getOperator().stream().map(CodeSystem40_50::convertFilterOperator).collect(Collectors.toList()));
        if (src.hasValue()) {
            tgt.setValueElement(CodeSystem40_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.FilterOperator> convertFilterOperator(Enumeration<CodeSystem.FilterOperator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.FilterOperator> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.FilterOperator>(new Enumerations.FilterOperatorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.FilterOperator)((Object)src.getValue())) {
            case EQUAL: {
                tgt.setValue((Object)Enumerations.FilterOperator.EQUAL);
                break;
            }
            case ISA: {
                tgt.setValue((Object)Enumerations.FilterOperator.ISA);
                break;
            }
            case DESCENDENTOF: {
                tgt.setValue((Object)Enumerations.FilterOperator.DESCENDENTOF);
                break;
            }
            case ISNOTA: {
                tgt.setValue((Object)Enumerations.FilterOperator.ISNOTA);
                break;
            }
            case REGEX: {
                tgt.setValue((Object)Enumerations.FilterOperator.REGEX);
                break;
            }
            case IN: {
                tgt.setValue((Object)Enumerations.FilterOperator.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)Enumerations.FilterOperator.NOTIN);
                break;
            }
            case GENERALIZES: {
                tgt.setValue((Object)Enumerations.FilterOperator.GENERALIZES);
                break;
            }
            case EXISTS: {
                tgt.setValue((Object)Enumerations.FilterOperator.EXISTS);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.FilterOperator.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CodeSystem.FilterOperator> convertFilterOperator(org.hl7.fhir.r5.model.Enumeration<Enumerations.FilterOperator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CodeSystem.FilterOperator> tgt = new Enumeration<CodeSystem.FilterOperator>(new CodeSystem.FilterOperatorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.FilterOperator)((Object)src.getValue())) {
            case EQUAL: {
                tgt.setValue((Object)CodeSystem.FilterOperator.EQUAL);
                break;
            }
            case ISA: {
                tgt.setValue((Object)CodeSystem.FilterOperator.ISA);
                break;
            }
            case DESCENDENTOF: {
                tgt.setValue((Object)CodeSystem.FilterOperator.DESCENDENTOF);
                break;
            }
            case ISNOTA: {
                tgt.setValue((Object)CodeSystem.FilterOperator.ISNOTA);
                break;
            }
            case REGEX: {
                tgt.setValue((Object)CodeSystem.FilterOperator.REGEX);
                break;
            }
            case IN: {
                tgt.setValue((Object)CodeSystem.FilterOperator.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)CodeSystem.FilterOperator.NOTIN);
                break;
            }
            case GENERALIZES: {
                tgt.setValue((Object)CodeSystem.FilterOperator.GENERALIZES);
                break;
            }
            case EXISTS: {
                tgt.setValue((Object)CodeSystem.FilterOperator.EXISTS);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.FilterOperator.NULL);
            }
        }
        return tgt;
    }

    public static CodeSystem.PropertyComponent convertPropertyComponent(CodeSystem.PropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.PropertyComponent tgt = new CodeSystem.PropertyComponent();
        CodeSystem40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CodeSystem40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(CodeSystem40_50.convertUri(src.getUriElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CodeSystem40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(CodeSystem40_50.convertPropertyType(src.getTypeElement()));
        }
        return tgt;
    }

    public static CodeSystem.PropertyComponent convertPropertyComponent(CodeSystem.PropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.PropertyComponent tgt = new CodeSystem.PropertyComponent();
        CodeSystem40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CodeSystem40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(CodeSystem40_50.convertUri(src.getUriElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CodeSystem40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(CodeSystem40_50.convertPropertyType(src.getTypeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CodeSystem.PropertyType> convertPropertyType(Enumeration<CodeSystem.PropertyType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CodeSystem.PropertyType> tgt = new org.hl7.fhir.r5.model.Enumeration<CodeSystem.PropertyType>(new CodeSystem.PropertyTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.PropertyType)((Object)src.getValue())) {
            case CODE: {
                tgt.setValue((Object)CodeSystem.PropertyType.CODE);
                break;
            }
            case CODING: {
                tgt.setValue((Object)CodeSystem.PropertyType.CODING);
                break;
            }
            case STRING: {
                tgt.setValue((Object)CodeSystem.PropertyType.STRING);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)CodeSystem.PropertyType.INTEGER);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)CodeSystem.PropertyType.BOOLEAN);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)CodeSystem.PropertyType.DATETIME);
                break;
            }
            case DECIMAL: {
                tgt.setValue((Object)CodeSystem.PropertyType.DECIMAL);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.PropertyType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CodeSystem.PropertyType> convertPropertyType(org.hl7.fhir.r5.model.Enumeration<CodeSystem.PropertyType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CodeSystem.PropertyType> tgt = new Enumeration<CodeSystem.PropertyType>(new CodeSystem.PropertyTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.PropertyType)((Object)src.getValue())) {
            case CODE: {
                tgt.setValue((Object)CodeSystem.PropertyType.CODE);
                break;
            }
            case CODING: {
                tgt.setValue((Object)CodeSystem.PropertyType.CODING);
                break;
            }
            case STRING: {
                tgt.setValue((Object)CodeSystem.PropertyType.STRING);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)CodeSystem.PropertyType.INTEGER);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)CodeSystem.PropertyType.BOOLEAN);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)CodeSystem.PropertyType.DATETIME);
                break;
            }
            case DECIMAL: {
                tgt.setValue((Object)CodeSystem.PropertyType.DECIMAL);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.PropertyType.NULL);
            }
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionComponent convertConceptDefinitionComponent(CodeSystem.ConceptDefinitionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionComponent tgt = new CodeSystem.ConceptDefinitionComponent();
        CodeSystem40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CodeSystem40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(CodeSystem40_50.convertString(src.getDisplayElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(CodeSystem40_50.convertString(src.getDefinitionElement()));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : src.getDesignation()) {
            tgt.addDesignation(CodeSystem40_50.convertConceptDefinitionDesignationComponent(conceptDefinitionDesignationComponent));
        }
        for (CodeSystem.ConceptPropertyComponent conceptPropertyComponent : src.getProperty()) {
            tgt.addProperty(CodeSystem40_50.convertConceptPropertyComponent(conceptPropertyComponent));
        }
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : src.getConcept()) {
            tgt.addConcept(CodeSystem40_50.convertConceptDefinitionComponent(conceptDefinitionComponent));
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionComponent convertConceptDefinitionComponent(CodeSystem.ConceptDefinitionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionComponent tgt = new CodeSystem.ConceptDefinitionComponent();
        CodeSystem40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CodeSystem40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(CodeSystem40_50.convertString(src.getDisplayElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(CodeSystem40_50.convertString(src.getDefinitionElement()));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : src.getDesignation()) {
            tgt.addDesignation(CodeSystem40_50.convertConceptDefinitionDesignationComponent(conceptDefinitionDesignationComponent));
        }
        for (CodeSystem.ConceptPropertyComponent conceptPropertyComponent : src.getProperty()) {
            tgt.addProperty(CodeSystem40_50.convertConceptPropertyComponent(conceptPropertyComponent));
        }
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : src.getConcept()) {
            tgt.addConcept(CodeSystem40_50.convertConceptDefinitionComponent(conceptDefinitionComponent));
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionDesignationComponent convertConceptDefinitionDesignationComponent(CodeSystem.ConceptDefinitionDesignationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionDesignationComponent tgt = new CodeSystem.ConceptDefinitionDesignationComponent();
        CodeSystem40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguageElement(CodeSystem40_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasUse()) {
            tgt.setUse(CodeSystem40_50.convertCoding(src.getUse()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(CodeSystem40_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionDesignationComponent convertConceptDefinitionDesignationComponent(CodeSystem.ConceptDefinitionDesignationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionDesignationComponent tgt = new CodeSystem.ConceptDefinitionDesignationComponent();
        CodeSystem40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguageElement(CodeSystem40_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasUse()) {
            tgt.setUse(CodeSystem40_50.convertCoding(src.getUse()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(CodeSystem40_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static CodeSystem.ConceptPropertyComponent convertConceptPropertyComponent(CodeSystem.ConceptPropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptPropertyComponent tgt = new CodeSystem.ConceptPropertyComponent();
        CodeSystem40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CodeSystem40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(CodeSystem40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static CodeSystem.ConceptPropertyComponent convertConceptPropertyComponent(CodeSystem.ConceptPropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptPropertyComponent tgt = new CodeSystem.ConceptPropertyComponent();
        CodeSystem40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CodeSystem40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(CodeSystem40_50.convertType(src.getValue()));
        }
        return tgt;
    }
}

