/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ClaimResponse;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Reference;

public class ClaimResponse40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.ClaimResponse convertClaimResponse(ClaimResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ClaimResponse tgt = new org.hl7.fhir.r5.model.ClaimResponse();
        ClaimResponse40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ClaimResponse40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ClaimResponse40_50.convertClaimResponseStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(ClaimResponse40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubType()) {
            tgt.setSubType(ClaimResponse40_50.convertCodeableConcept(src.getSubType()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(ClaimResponse40_50.convertUse(src.getUseElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(ClaimResponse40_50.convertReference(src.getPatient()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(ClaimResponse40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasInsurer()) {
            tgt.setInsurer(ClaimResponse40_50.convertReference(src.getInsurer()));
        }
        if (src.hasRequestor()) {
            tgt.setRequestor(ClaimResponse40_50.convertReference(src.getRequestor()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(ClaimResponse40_50.convertReference(src.getRequest()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcomeElement(ClaimResponse40_50.convertRemittanceOutcome(src.getOutcomeElement()));
        }
        if (src.hasDisposition()) {
            tgt.setDispositionElement(ClaimResponse40_50.convertString(src.getDispositionElement()));
        }
        if (src.hasPreAuthRef()) {
            tgt.setPreAuthRefElement(ClaimResponse40_50.convertString(src.getPreAuthRefElement()));
        }
        if (src.hasPreAuthPeriod()) {
            tgt.setPreAuthPeriod(ClaimResponse40_50.convertPeriod(src.getPreAuthPeriod()));
        }
        if (src.hasPayeeType()) {
            tgt.setPayeeType(ClaimResponse40_50.convertCodeableConcept(src.getPayeeType()));
        }
        for (ClaimResponse.ItemComponent itemComponent : src.getItem()) {
            tgt.addItem(ClaimResponse40_50.convertItemComponent(itemComponent));
        }
        for (ClaimResponse.AddedItemComponent addedItemComponent : src.getAddItem()) {
            tgt.addAddItem(ClaimResponse40_50.convertAddedItemComponent(addedItemComponent));
        }
        for (ClaimResponse.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ClaimResponse40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ClaimResponse.TotalComponent totalComponent : src.getTotal()) {
            tgt.addTotal(ClaimResponse40_50.convertTotalComponent(totalComponent));
        }
        if (src.hasPayment()) {
            tgt.setPayment(ClaimResponse40_50.convertPaymentComponent(src.getPayment()));
        }
        if (src.hasFundsReserve()) {
            tgt.setFundsReserve(ClaimResponse40_50.convertCodeableConcept(src.getFundsReserve()));
        }
        if (src.hasFormCode()) {
            tgt.setFormCode(ClaimResponse40_50.convertCodeableConcept(src.getFormCode()));
        }
        if (src.hasForm()) {
            tgt.setForm(ClaimResponse40_50.convertAttachment(src.getForm()));
        }
        for (ClaimResponse.NoteComponent noteComponent : src.getProcessNote()) {
            tgt.addProcessNote(ClaimResponse40_50.convertNoteComponent(noteComponent));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getCommunicationRequest()) {
            tgt.addCommunicationRequest(ClaimResponse40_50.convertReference(reference));
        }
        for (ClaimResponse.InsuranceComponent insuranceComponent : src.getInsurance()) {
            tgt.addInsurance(ClaimResponse40_50.convertInsuranceComponent(insuranceComponent));
        }
        for (ClaimResponse.ErrorComponent errorComponent : src.getError()) {
            tgt.addError(ClaimResponse40_50.convertErrorComponent(errorComponent));
        }
        return tgt;
    }

    public static ClaimResponse convertClaimResponse(org.hl7.fhir.r5.model.ClaimResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse tgt = new ClaimResponse();
        ClaimResponse40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ClaimResponse40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ClaimResponse40_50.convertClaimResponseStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(ClaimResponse40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubType()) {
            tgt.setSubType(ClaimResponse40_50.convertCodeableConcept(src.getSubType()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(ClaimResponse40_50.convertUse(src.getUseElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(ClaimResponse40_50.convertReference(src.getPatient()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(ClaimResponse40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasInsurer()) {
            tgt.setInsurer(ClaimResponse40_50.convertReference(src.getInsurer()));
        }
        if (src.hasRequestor()) {
            tgt.setRequestor(ClaimResponse40_50.convertReference(src.getRequestor()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(ClaimResponse40_50.convertReference(src.getRequest()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcomeElement(ClaimResponse40_50.convertRemittanceOutcome(src.getOutcomeElement()));
        }
        if (src.hasDisposition()) {
            tgt.setDispositionElement(ClaimResponse40_50.convertString(src.getDispositionElement()));
        }
        if (src.hasPreAuthRef()) {
            tgt.setPreAuthRefElement(ClaimResponse40_50.convertString(src.getPreAuthRefElement()));
        }
        if (src.hasPreAuthPeriod()) {
            tgt.setPreAuthPeriod(ClaimResponse40_50.convertPeriod(src.getPreAuthPeriod()));
        }
        if (src.hasPayeeType()) {
            tgt.setPayeeType(ClaimResponse40_50.convertCodeableConcept(src.getPayeeType()));
        }
        for (ClaimResponse.ItemComponent itemComponent : src.getItem()) {
            tgt.addItem(ClaimResponse40_50.convertItemComponent(itemComponent));
        }
        for (ClaimResponse.AddedItemComponent addedItemComponent : src.getAddItem()) {
            tgt.addAddItem(ClaimResponse40_50.convertAddedItemComponent(addedItemComponent));
        }
        for (ClaimResponse.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ClaimResponse40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ClaimResponse.TotalComponent totalComponent : src.getTotal()) {
            tgt.addTotal(ClaimResponse40_50.convertTotalComponent(totalComponent));
        }
        if (src.hasPayment()) {
            tgt.setPayment(ClaimResponse40_50.convertPaymentComponent(src.getPayment()));
        }
        if (src.hasFundsReserve()) {
            tgt.setFundsReserve(ClaimResponse40_50.convertCodeableConcept(src.getFundsReserve()));
        }
        if (src.hasFormCode()) {
            tgt.setFormCode(ClaimResponse40_50.convertCodeableConcept(src.getFormCode()));
        }
        if (src.hasForm()) {
            tgt.setForm(ClaimResponse40_50.convertAttachment(src.getForm()));
        }
        for (ClaimResponse.NoteComponent noteComponent : src.getProcessNote()) {
            tgt.addProcessNote(ClaimResponse40_50.convertNoteComponent(noteComponent));
        }
        for (Reference reference : src.getCommunicationRequest()) {
            tgt.addCommunicationRequest(ClaimResponse40_50.convertReference(reference));
        }
        for (ClaimResponse.InsuranceComponent insuranceComponent : src.getInsurance()) {
            tgt.addInsurance(ClaimResponse40_50.convertInsuranceComponent(insuranceComponent));
        }
        for (ClaimResponse.ErrorComponent errorComponent : src.getError()) {
            tgt.addError(ClaimResponse40_50.convertErrorComponent(errorComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> convertClaimResponseStatus(Enumeration<ClaimResponse.ClaimResponseStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ClaimResponse.ClaimResponseStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ClaimResponse.ClaimResponseStatus> convertClaimResponseStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ClaimResponse.ClaimResponseStatus> tgt = new Enumeration<ClaimResponse.ClaimResponseStatus>(new ClaimResponse.ClaimResponseStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.FinancialResourceStatusCodes)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)ClaimResponse.ClaimResponseStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)ClaimResponse.ClaimResponseStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)ClaimResponse.ClaimResponseStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ClaimResponse.ClaimResponseStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ClaimResponse.ClaimResponseStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.Use> convertUse(Enumeration<ClaimResponse.Use> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.Use> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.Use>(new Enumerations.UseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ClaimResponse.Use)((Object)src.getValue())) {
            case CLAIM: {
                tgt.setValue((Object)Enumerations.Use.CLAIM);
                break;
            }
            case PREAUTHORIZATION: {
                tgt.setValue((Object)Enumerations.Use.PREAUTHORIZATION);
                break;
            }
            case PREDETERMINATION: {
                tgt.setValue((Object)Enumerations.Use.PREDETERMINATION);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.Use.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ClaimResponse.Use> convertUse(org.hl7.fhir.r5.model.Enumeration<Enumerations.Use> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ClaimResponse.Use> tgt = new Enumeration<ClaimResponse.Use>(new ClaimResponse.UseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.Use)((Object)src.getValue())) {
            case CLAIM: {
                tgt.setValue((Object)ClaimResponse.Use.CLAIM);
                break;
            }
            case PREAUTHORIZATION: {
                tgt.setValue((Object)ClaimResponse.Use.PREAUTHORIZATION);
                break;
            }
            case PREDETERMINATION: {
                tgt.setValue((Object)ClaimResponse.Use.PREDETERMINATION);
                break;
            }
            default: {
                tgt.setValue((Object)ClaimResponse.Use.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes> convertRemittanceOutcome(Enumeration<ClaimResponse.RemittanceOutcome> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes>(new Enumerations.ClaimProcessingCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ClaimResponse.RemittanceOutcome)((Object)src.getValue())) {
            case QUEUED: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.QUEUED);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.COMPLETE);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.ERROR);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.PARTIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ClaimResponse.RemittanceOutcome> convertRemittanceOutcome(org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ClaimResponse.RemittanceOutcome> tgt = new Enumeration<ClaimResponse.RemittanceOutcome>(new ClaimResponse.RemittanceOutcomeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ClaimProcessingCodes)((Object)src.getValue())) {
            case QUEUED: {
                tgt.setValue((Object)ClaimResponse.RemittanceOutcome.QUEUED);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)ClaimResponse.RemittanceOutcome.COMPLETE);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)ClaimResponse.RemittanceOutcome.ERROR);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)ClaimResponse.RemittanceOutcome.PARTIAL);
                break;
            }
            default: {
                tgt.setValue((Object)ClaimResponse.RemittanceOutcome.NULL);
            }
        }
        return tgt;
    }

    public static ClaimResponse.ItemComponent convertItemComponent(ClaimResponse.ItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.ItemComponent tgt = new ClaimResponse.ItemComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasItemSequence()) {
            tgt.setItemSequenceElement(ClaimResponse40_50.convertPositiveInt(src.getItemSequenceElement()));
        }
        for (PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (ClaimResponse.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ClaimResponse40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ClaimResponse.ItemDetailComponent itemDetailComponent : src.getDetail()) {
            tgt.addDetail(ClaimResponse40_50.convertItemDetailComponent(itemDetailComponent));
        }
        return tgt;
    }

    public static ClaimResponse.ItemComponent convertItemComponent(ClaimResponse.ItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.ItemComponent tgt = new ClaimResponse.ItemComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasItemSequence()) {
            tgt.setItemSequenceElement(ClaimResponse40_50.convertPositiveInt(src.getItemSequenceElement()));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (ClaimResponse.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ClaimResponse40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ClaimResponse.ItemDetailComponent itemDetailComponent : src.getDetail()) {
            tgt.addDetail(ClaimResponse40_50.convertItemDetailComponent(itemDetailComponent));
        }
        return tgt;
    }

    public static ClaimResponse.AdjudicationComponent convertAdjudicationComponent(ClaimResponse.AdjudicationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.AdjudicationComponent tgt = new ClaimResponse.AdjudicationComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(ClaimResponse40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasReason()) {
            tgt.setReason(ClaimResponse40_50.convertCodeableConcept(src.getReason()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(ClaimResponse40_50.convertMoney(src.getAmount()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(ClaimResponse40_50.convertDecimal(src.getValueElement()));
        }
        return tgt;
    }

    public static ClaimResponse.AdjudicationComponent convertAdjudicationComponent(ClaimResponse.AdjudicationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.AdjudicationComponent tgt = new ClaimResponse.AdjudicationComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(ClaimResponse40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasReason()) {
            tgt.setReason(ClaimResponse40_50.convertCodeableConcept(src.getReason()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(ClaimResponse40_50.convertMoney(src.getAmount()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(ClaimResponse40_50.convertDecimal(src.getValueElement()));
        }
        return tgt;
    }

    public static ClaimResponse.ItemDetailComponent convertItemDetailComponent(ClaimResponse.ItemDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.ItemDetailComponent tgt = new ClaimResponse.ItemDetailComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDetailSequence()) {
            tgt.setDetailSequenceElement(ClaimResponse40_50.convertPositiveInt(src.getDetailSequenceElement()));
        }
        for (PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (ClaimResponse.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ClaimResponse40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ClaimResponse.SubDetailComponent subDetailComponent : src.getSubDetail()) {
            tgt.addSubDetail(ClaimResponse40_50.convertSubDetailComponent(subDetailComponent));
        }
        return tgt;
    }

    public static ClaimResponse.ItemDetailComponent convertItemDetailComponent(ClaimResponse.ItemDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.ItemDetailComponent tgt = new ClaimResponse.ItemDetailComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDetailSequence()) {
            tgt.setDetailSequenceElement(ClaimResponse40_50.convertPositiveInt(src.getDetailSequenceElement()));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (ClaimResponse.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ClaimResponse40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ClaimResponse.SubDetailComponent subDetailComponent : src.getSubDetail()) {
            tgt.addSubDetail(ClaimResponse40_50.convertSubDetailComponent(subDetailComponent));
        }
        return tgt;
    }

    public static ClaimResponse.SubDetailComponent convertSubDetailComponent(ClaimResponse.SubDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.SubDetailComponent tgt = new ClaimResponse.SubDetailComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSubDetailSequence()) {
            tgt.setSubDetailSequenceElement(ClaimResponse40_50.convertPositiveInt(src.getSubDetailSequenceElement()));
        }
        for (PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (ClaimResponse.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ClaimResponse40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        return tgt;
    }

    public static ClaimResponse.SubDetailComponent convertSubDetailComponent(ClaimResponse.SubDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.SubDetailComponent tgt = new ClaimResponse.SubDetailComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSubDetailSequence()) {
            tgt.setSubDetailSequenceElement(ClaimResponse40_50.convertPositiveInt(src.getSubDetailSequenceElement()));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (ClaimResponse.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ClaimResponse40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        return tgt;
    }

    public static ClaimResponse.AddedItemComponent convertAddedItemComponent(ClaimResponse.AddedItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.AddedItemComponent tgt = new ClaimResponse.AddedItemComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        for (PositiveIntType positiveIntType : src.getItemSequence()) {
            tgt.getItemSequence().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (PositiveIntType positiveIntType : src.getDetailSequence()) {
            tgt.getDetailSequence().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (PositiveIntType positiveIntType : src.getSubdetailSequence()) {
            tgt.getSubdetailSequence().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getProvider()) {
            tgt.addProvider(ClaimResponse40_50.convertReference(reference));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ClaimResponse40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ClaimResponse40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(ClaimResponse40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasServiced()) {
            tgt.setServiced(ClaimResponse40_50.convertType(src.getServiced()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(ClaimResponse40_50.convertType(src.getLocation()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ClaimResponse40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ClaimResponse40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ClaimResponse40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ClaimResponse40_50.convertMoney(src.getNet()));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(ClaimResponse40_50.convertCodeableConcept(src.getBodySite()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSubSite()) {
            tgt.addSubSite(ClaimResponse40_50.convertCodeableConcept(codeableConcept));
        }
        for (PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (ClaimResponse.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ClaimResponse40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ClaimResponse.AddedItemDetailComponent addedItemDetailComponent : src.getDetail()) {
            tgt.addDetail(ClaimResponse40_50.convertAddedItemDetailComponent(addedItemDetailComponent));
        }
        return tgt;
    }

    public static ClaimResponse.AddedItemComponent convertAddedItemComponent(ClaimResponse.AddedItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.AddedItemComponent tgt = new ClaimResponse.AddedItemComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getItemSequence()) {
            tgt.getItemSequence().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getDetailSequence()) {
            tgt.getDetailSequence().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getSubdetailSequence()) {
            tgt.getSubdetailSequence().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (Reference reference : src.getProvider()) {
            tgt.addProvider(ClaimResponse40_50.convertReference(reference));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ClaimResponse40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ClaimResponse40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(ClaimResponse40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasServiced()) {
            tgt.setServiced(ClaimResponse40_50.convertType(src.getServiced()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(ClaimResponse40_50.convertType(src.getLocation()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ClaimResponse40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ClaimResponse40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ClaimResponse40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ClaimResponse40_50.convertMoney(src.getNet()));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(ClaimResponse40_50.convertCodeableConcept(src.getBodySite()));
        }
        for (CodeableConcept codeableConcept : src.getSubSite()) {
            tgt.addSubSite(ClaimResponse40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (ClaimResponse.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ClaimResponse40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ClaimResponse.AddedItemDetailComponent addedItemDetailComponent : src.getDetail()) {
            tgt.addDetail(ClaimResponse40_50.convertAddedItemDetailComponent(addedItemDetailComponent));
        }
        return tgt;
    }

    public static ClaimResponse.AddedItemDetailComponent convertAddedItemDetailComponent(ClaimResponse.AddedItemDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.AddedItemDetailComponent tgt = new ClaimResponse.AddedItemDetailComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ClaimResponse40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ClaimResponse40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ClaimResponse40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ClaimResponse40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ClaimResponse40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ClaimResponse40_50.convertMoney(src.getNet()));
        }
        for (PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (ClaimResponse.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ClaimResponse40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ClaimResponse.AddedItemSubDetailComponent addedItemSubDetailComponent : src.getSubDetail()) {
            tgt.addSubDetail(ClaimResponse40_50.convertAddedItemSubDetailComponent(addedItemSubDetailComponent));
        }
        return tgt;
    }

    public static ClaimResponse.AddedItemDetailComponent convertAddedItemDetailComponent(ClaimResponse.AddedItemDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.AddedItemDetailComponent tgt = new ClaimResponse.AddedItemDetailComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ClaimResponse40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ClaimResponse40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ClaimResponse40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ClaimResponse40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ClaimResponse40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ClaimResponse40_50.convertMoney(src.getNet()));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (ClaimResponse.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ClaimResponse40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ClaimResponse.AddedItemSubDetailComponent addedItemSubDetailComponent : src.getSubDetail()) {
            tgt.addSubDetail(ClaimResponse40_50.convertAddedItemSubDetailComponent(addedItemSubDetailComponent));
        }
        return tgt;
    }

    public static ClaimResponse.AddedItemSubDetailComponent convertAddedItemSubDetailComponent(ClaimResponse.AddedItemSubDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.AddedItemSubDetailComponent tgt = new ClaimResponse.AddedItemSubDetailComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ClaimResponse40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ClaimResponse40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ClaimResponse40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ClaimResponse40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ClaimResponse40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ClaimResponse40_50.convertMoney(src.getNet()));
        }
        for (PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (ClaimResponse.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ClaimResponse40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        return tgt;
    }

    public static ClaimResponse.AddedItemSubDetailComponent convertAddedItemSubDetailComponent(ClaimResponse.AddedItemSubDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.AddedItemSubDetailComponent tgt = new ClaimResponse.AddedItemSubDetailComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ClaimResponse40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ClaimResponse40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ClaimResponse40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ClaimResponse40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ClaimResponse40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ClaimResponse40_50.convertMoney(src.getNet()));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ClaimResponse40_50.convertPositiveInt(positiveIntType));
        }
        for (ClaimResponse.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ClaimResponse40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        return tgt;
    }

    public static ClaimResponse.TotalComponent convertTotalComponent(ClaimResponse.TotalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.TotalComponent tgt = new ClaimResponse.TotalComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(ClaimResponse40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(ClaimResponse40_50.convertMoney(src.getAmount()));
        }
        return tgt;
    }

    public static ClaimResponse.TotalComponent convertTotalComponent(ClaimResponse.TotalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.TotalComponent tgt = new ClaimResponse.TotalComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(ClaimResponse40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(ClaimResponse40_50.convertMoney(src.getAmount()));
        }
        return tgt;
    }

    public static ClaimResponse.PaymentComponent convertPaymentComponent(ClaimResponse.PaymentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.PaymentComponent tgt = new ClaimResponse.PaymentComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(ClaimResponse40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasAdjustment()) {
            tgt.setAdjustment(ClaimResponse40_50.convertMoney(src.getAdjustment()));
        }
        if (src.hasAdjustmentReason()) {
            tgt.setAdjustmentReason(ClaimResponse40_50.convertCodeableConcept(src.getAdjustmentReason()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ClaimResponse40_50.convertDate(src.getDateElement()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(ClaimResponse40_50.convertMoney(src.getAmount()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(ClaimResponse40_50.convertIdentifier(src.getIdentifier()));
        }
        return tgt;
    }

    public static ClaimResponse.PaymentComponent convertPaymentComponent(ClaimResponse.PaymentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.PaymentComponent tgt = new ClaimResponse.PaymentComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(ClaimResponse40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasAdjustment()) {
            tgt.setAdjustment(ClaimResponse40_50.convertMoney(src.getAdjustment()));
        }
        if (src.hasAdjustmentReason()) {
            tgt.setAdjustmentReason(ClaimResponse40_50.convertCodeableConcept(src.getAdjustmentReason()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ClaimResponse40_50.convertDate(src.getDateElement()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(ClaimResponse40_50.convertMoney(src.getAmount()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(ClaimResponse40_50.convertIdentifier(src.getIdentifier()));
        }
        return tgt;
    }

    public static ClaimResponse.NoteComponent convertNoteComponent(ClaimResponse.NoteComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.NoteComponent tgt = new ClaimResponse.NoteComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasNumber()) {
            tgt.setNumberElement(ClaimResponse40_50.convertPositiveInt(src.getNumberElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Enumerations40_50.convertNoteType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(ClaimResponse40_50.convertString(src.getTextElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(ClaimResponse40_50.convertCodeableConcept(src.getLanguage()));
        }
        return tgt;
    }

    public static ClaimResponse.NoteComponent convertNoteComponent(ClaimResponse.NoteComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.NoteComponent tgt = new ClaimResponse.NoteComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasNumber()) {
            tgt.setNumberElement(ClaimResponse40_50.convertPositiveInt(src.getNumberElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Enumerations40_50.convertNoteType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(ClaimResponse40_50.convertString(src.getTextElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(ClaimResponse40_50.convertCodeableConcept(src.getLanguage()));
        }
        return tgt;
    }

    public static ClaimResponse.InsuranceComponent convertInsuranceComponent(ClaimResponse.InsuranceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.InsuranceComponent tgt = new ClaimResponse.InsuranceComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ClaimResponse40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasFocal()) {
            tgt.setFocalElement(ClaimResponse40_50.convertBoolean(src.getFocalElement()));
        }
        if (src.hasCoverage()) {
            tgt.setCoverage(ClaimResponse40_50.convertReference(src.getCoverage()));
        }
        if (src.hasBusinessArrangement()) {
            tgt.setBusinessArrangementElement(ClaimResponse40_50.convertString(src.getBusinessArrangementElement()));
        }
        if (src.hasClaimResponse()) {
            tgt.setClaimResponse(ClaimResponse40_50.convertReference(src.getClaimResponse()));
        }
        return tgt;
    }

    public static ClaimResponse.InsuranceComponent convertInsuranceComponent(ClaimResponse.InsuranceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.InsuranceComponent tgt = new ClaimResponse.InsuranceComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ClaimResponse40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasFocal()) {
            tgt.setFocalElement(ClaimResponse40_50.convertBoolean(src.getFocalElement()));
        }
        if (src.hasCoverage()) {
            tgt.setCoverage(ClaimResponse40_50.convertReference(src.getCoverage()));
        }
        if (src.hasBusinessArrangement()) {
            tgt.setBusinessArrangementElement(ClaimResponse40_50.convertString(src.getBusinessArrangementElement()));
        }
        if (src.hasClaimResponse()) {
            tgt.setClaimResponse(ClaimResponse40_50.convertReference(src.getClaimResponse()));
        }
        return tgt;
    }

    public static ClaimResponse.ErrorComponent convertErrorComponent(ClaimResponse.ErrorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.ErrorComponent tgt = new ClaimResponse.ErrorComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasItemSequence()) {
            tgt.setItemSequenceElement(ClaimResponse40_50.convertPositiveInt(src.getItemSequenceElement()));
        }
        if (src.hasDetailSequence()) {
            tgt.setDetailSequenceElement(ClaimResponse40_50.convertPositiveInt(src.getDetailSequenceElement()));
        }
        if (src.hasSubDetailSequence()) {
            tgt.setSubDetailSequenceElement(ClaimResponse40_50.convertPositiveInt(src.getSubDetailSequenceElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(ClaimResponse40_50.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static ClaimResponse.ErrorComponent convertErrorComponent(ClaimResponse.ErrorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClaimResponse.ErrorComponent tgt = new ClaimResponse.ErrorComponent();
        ClaimResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasItemSequence()) {
            tgt.setItemSequenceElement(ClaimResponse40_50.convertPositiveInt(src.getItemSequenceElement()));
        }
        if (src.hasDetailSequence()) {
            tgt.setDetailSequenceElement(ClaimResponse40_50.convertPositiveInt(src.getDetailSequenceElement()));
        }
        if (src.hasSubDetailSequence()) {
            tgt.setSubDetailSequenceElement(ClaimResponse40_50.convertPositiveInt(src.getSubDetailSequenceElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(ClaimResponse40_50.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }
}

