/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.ChargeItem;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Reference;

public class ChargeItem40_50
extends VersionConvertor_40_50 {
    public static ChargeItem convertChargeItem(org.hl7.fhir.r4.model.ChargeItem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ChargeItem tgt = new ChargeItem();
        ChargeItem40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ChargeItem40_50.convertIdentifier(identifier));
        }
        for (UriType uriType : src.getDefinitionUri()) {
            tgt.getDefinitionUri().add(ChargeItem40_50.convertUri(uriType));
        }
        for (CanonicalType canonicalType : src.getDefinitionCanonical()) {
            tgt.getDefinitionCanonical().add(ChargeItem40_50.convertCanonical(canonicalType));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ChargeItem40_50.convertChargeItemStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(ChargeItem40_50.convertReference(reference));
        }
        if (src.hasCode()) {
            tgt.setCode(ChargeItem40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(ChargeItem40_50.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setContext(ChargeItem40_50.convertReference(src.getContext()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(ChargeItem40_50.convertType(src.getOccurrence()));
        }
        for (ChargeItem.ChargeItemPerformerComponent chargeItemPerformerComponent : src.getPerformer()) {
            tgt.addPerformer(ChargeItem40_50.convertChargeItemPerformerComponent(chargeItemPerformerComponent));
        }
        if (src.hasPerformingOrganization()) {
            tgt.setPerformingOrganization(ChargeItem40_50.convertReference(src.getPerformingOrganization()));
        }
        if (src.hasRequestingOrganization()) {
            tgt.setRequestingOrganization(ChargeItem40_50.convertReference(src.getRequestingOrganization()));
        }
        if (src.hasCostCenter()) {
            tgt.setCostCenter(ChargeItem40_50.convertReference(src.getCostCenter()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ChargeItem40_50.convertQuantity(src.getQuantity()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getBodysite()) {
            tgt.addBodysite(ChargeItem40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasFactorOverride()) {
            tgt.setFactorOverrideElement(ChargeItem40_50.convertDecimal(src.getFactorOverrideElement()));
        }
        if (src.hasPriceOverride()) {
            tgt.setPriceOverride(ChargeItem40_50.convertMoney(src.getPriceOverride()));
        }
        if (src.hasOverrideReason()) {
            tgt.setOverrideReasonElement(ChargeItem40_50.convertString(src.getOverrideReasonElement()));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(ChargeItem40_50.convertReference(src.getEnterer()));
        }
        if (src.hasEnteredDate()) {
            tgt.setEnteredDateElement(ChargeItem40_50.convertDateTime(src.getEnteredDateElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReason(ChargeItem40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getService()) {
            tgt.addService(ChargeItem40_50.convertReference(reference));
        }
        if (src.hasProduct()) {
            tgt.setProduct(ChargeItem40_50.convertType(src.getProduct()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getAccount()) {
            tgt.addAccount(ChargeItem40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(ChargeItem40_50.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(ChargeItem40_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ChargeItem convertChargeItem(ChargeItem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ChargeItem tgt = new org.hl7.fhir.r4.model.ChargeItem();
        ChargeItem40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ChargeItem40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getDefinitionUri()) {
            tgt.getDefinitionUri().add(ChargeItem40_50.convertUri(uriType));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getDefinitionCanonical()) {
            tgt.getDefinitionCanonical().add(ChargeItem40_50.convertCanonical(canonicalType));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ChargeItem40_50.convertChargeItemStatus(src.getStatusElement()));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(ChargeItem40_50.convertReference(reference));
        }
        if (src.hasCode()) {
            tgt.setCode(ChargeItem40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(ChargeItem40_50.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setContext(ChargeItem40_50.convertReference(src.getContext()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(ChargeItem40_50.convertType(src.getOccurrence()));
        }
        for (ChargeItem.ChargeItemPerformerComponent chargeItemPerformerComponent : src.getPerformer()) {
            tgt.addPerformer(ChargeItem40_50.convertChargeItemPerformerComponent(chargeItemPerformerComponent));
        }
        if (src.hasPerformingOrganization()) {
            tgt.setPerformingOrganization(ChargeItem40_50.convertReference(src.getPerformingOrganization()));
        }
        if (src.hasRequestingOrganization()) {
            tgt.setRequestingOrganization(ChargeItem40_50.convertReference(src.getRequestingOrganization()));
        }
        if (src.hasCostCenter()) {
            tgt.setCostCenter(ChargeItem40_50.convertReference(src.getCostCenter()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ChargeItem40_50.convertQuantity(src.getQuantity()));
        }
        for (CodeableConcept codeableConcept : src.getBodysite()) {
            tgt.addBodysite(ChargeItem40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasFactorOverride()) {
            tgt.setFactorOverrideElement(ChargeItem40_50.convertDecimal(src.getFactorOverrideElement()));
        }
        if (src.hasPriceOverride()) {
            tgt.setPriceOverride(ChargeItem40_50.convertMoney(src.getPriceOverride()));
        }
        if (src.hasOverrideReason()) {
            tgt.setOverrideReasonElement(ChargeItem40_50.convertString(src.getOverrideReasonElement()));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(ChargeItem40_50.convertReference(src.getEnterer()));
        }
        if (src.hasEnteredDate()) {
            tgt.setEnteredDateElement(ChargeItem40_50.convertDateTime(src.getEnteredDateElement()));
        }
        for (CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReason(ChargeItem40_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getService()) {
            tgt.addService(ChargeItem40_50.convertReference(reference));
        }
        if (src.hasProduct()) {
            tgt.setProduct(ChargeItem40_50.convertType(src.getProduct()));
        }
        for (Reference reference : src.getAccount()) {
            tgt.addAccount(ChargeItem40_50.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(ChargeItem40_50.convertAnnotation(annotation));
        }
        for (Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(ChargeItem40_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ChargeItem.ChargeItemStatus> convertChargeItemStatus(Enumeration<ChargeItem.ChargeItemStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ChargeItem.ChargeItemStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<ChargeItem.ChargeItemStatus>(new ChargeItem.ChargeItemStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ChargeItem.ChargeItemStatus)((Object)src.getValue())) {
            case PLANNED: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.PLANNED);
                break;
            }
            case BILLABLE: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.BILLABLE);
                break;
            }
            case NOTBILLABLE: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.NOTBILLABLE);
                break;
            }
            case ABORTED: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.ABORTED);
                break;
            }
            case BILLED: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.BILLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ChargeItem.ChargeItemStatus> convertChargeItemStatus(org.hl7.fhir.r5.model.Enumeration<ChargeItem.ChargeItemStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ChargeItem.ChargeItemStatus> tgt = new Enumeration<ChargeItem.ChargeItemStatus>(new ChargeItem.ChargeItemStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ChargeItem.ChargeItemStatus)((Object)src.getValue())) {
            case PLANNED: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.PLANNED);
                break;
            }
            case BILLABLE: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.BILLABLE);
                break;
            }
            case NOTBILLABLE: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.NOTBILLABLE);
                break;
            }
            case ABORTED: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.ABORTED);
                break;
            }
            case BILLED: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.BILLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)ChargeItem.ChargeItemStatus.NULL);
            }
        }
        return tgt;
    }

    public static ChargeItem.ChargeItemPerformerComponent convertChargeItemPerformerComponent(ChargeItem.ChargeItemPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ChargeItem.ChargeItemPerformerComponent tgt = new ChargeItem.ChargeItemPerformerComponent();
        ChargeItem40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFunction()) {
            tgt.setFunction(ChargeItem40_50.convertCodeableConcept(src.getFunction()));
        }
        if (src.hasActor()) {
            tgt.setActor(ChargeItem40_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static ChargeItem.ChargeItemPerformerComponent convertChargeItemPerformerComponent(ChargeItem.ChargeItemPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ChargeItem.ChargeItemPerformerComponent tgt = new ChargeItem.ChargeItemPerformerComponent();
        ChargeItem40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFunction()) {
            tgt.setFunction(ChargeItem40_50.convertCodeableConcept(src.getFunction()));
        }
        if (src.hasActor()) {
            tgt.setActor(ChargeItem40_50.convertReference(src.getActor()));
        }
        return tgt;
    }
}

