/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CareTeam;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Reference;

public class CareTeam40_50
extends VersionConvertor_40_50 {
    public static CareTeam convertCareTeam(org.hl7.fhir.r4.model.CareTeam src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CareTeam tgt = new CareTeam();
        CareTeam40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(CareTeam40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CareTeam40_50.convertCareTeamStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(CareTeam40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setNameElement(CareTeam40_50.convertString(src.getNameElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(CareTeam40_50.convertReference(src.getSubject()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(CareTeam40_50.convertPeriod(src.getPeriod()));
        }
        for (CareTeam.CareTeamParticipantComponent careTeamParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(CareTeam40_50.convertCareTeamParticipantComponent(careTeamParticipantComponent));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(CareTeam40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReason(CareTeam40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getManagingOrganization()) {
            tgt.addManagingOrganization(CareTeam40_50.convertReference(reference));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(CareTeam40_50.convertContactPoint(contactPoint));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(CareTeam40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CareTeam convertCareTeam(CareTeam src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CareTeam tgt = new org.hl7.fhir.r4.model.CareTeam();
        CareTeam40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(CareTeam40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CareTeam40_50.convertCareTeamStatus(src.getStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(CareTeam40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setNameElement(CareTeam40_50.convertString(src.getNameElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(CareTeam40_50.convertReference(src.getSubject()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(CareTeam40_50.convertPeriod(src.getPeriod()));
        }
        for (CareTeam.CareTeamParticipantComponent careTeamParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(CareTeam40_50.convertCareTeamParticipantComponent(careTeamParticipantComponent));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(CareTeam40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(CareTeam40_50.convertReference(codeableReference.getReference()));
        }
        for (Reference reference : src.getManagingOrganization()) {
            tgt.addManagingOrganization(CareTeam40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(CareTeam40_50.convertContactPoint(contactPoint));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(CareTeam40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CareTeam.CareTeamStatus> convertCareTeamStatus(Enumeration<CareTeam.CareTeamStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CareTeam.CareTeamStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<CareTeam.CareTeamStatus>(new CareTeam.CareTeamStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CareTeam.CareTeamStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.PROPOSED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.ACTIVE);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.SUSPENDED);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CareTeam.CareTeamStatus> convertCareTeamStatus(org.hl7.fhir.r5.model.Enumeration<CareTeam.CareTeamStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CareTeam.CareTeamStatus> tgt = new Enumeration<CareTeam.CareTeamStatus>(new CareTeam.CareTeamStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CareTeam.CareTeamStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.PROPOSED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.ACTIVE);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.SUSPENDED);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.NULL);
            }
        }
        return tgt;
    }

    public static CareTeam.CareTeamParticipantComponent convertCareTeamParticipantComponent(CareTeam.CareTeamParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CareTeam.CareTeamParticipantComponent tgt = new CareTeam.CareTeamParticipantComponent();
        CareTeam40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getRole()) {
            tgt.setRole(CareTeam40_50.convertCodeableConcept(t));
        }
        if (src.hasMember()) {
            tgt.setMember(CareTeam40_50.convertReference(src.getMember()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(CareTeam40_50.convertReference(src.getOnBehalfOf()));
        }
        if (src.hasPeriod()) {
            tgt.setCoverage(CareTeam40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static CareTeam.CareTeamParticipantComponent convertCareTeamParticipantComponent(CareTeam.CareTeamParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CareTeam.CareTeamParticipantComponent tgt = new CareTeam.CareTeamParticipantComponent();
        CareTeam40_50.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.addRole(CareTeam40_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasMember()) {
            tgt.setMember(CareTeam40_50.convertReference(src.getMember()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(CareTeam40_50.convertReference(src.getOnBehalfOf()));
        }
        if (src.hasCoveragePeriod()) {
            tgt.setPeriod(CareTeam40_50.convertPeriod(src.getCoveragePeriod()));
        }
        return tgt;
    }
}

