/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.BodyStructure;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Identifier;

public class BodyStructure40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.BodyStructure convertBodyStructure(BodyStructure src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.BodyStructure tgt = new org.hl7.fhir.r5.model.BodyStructure();
        BodyStructure40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(BodyStructure40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(BodyStructure40_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasMorphology()) {
            tgt.setMorphology(BodyStructure40_50.convertCodeableConcept(src.getMorphology()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(BodyStructure40_50.convertCodeableConcept(src.getLocation()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getLocationQualifier()) {
            tgt.addLocationQualifier(BodyStructure40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(BodyStructure40_50.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r4.model.Attachment attachment : src.getImage()) {
            tgt.addImage(BodyStructure40_50.convertAttachment(attachment));
        }
        if (src.hasPatient()) {
            tgt.setPatient(BodyStructure40_50.convertReference(src.getPatient()));
        }
        return tgt;
    }

    public static BodyStructure convertBodyStructure(org.hl7.fhir.r5.model.BodyStructure src) throws FHIRException {
        if (src == null) {
            return null;
        }
        BodyStructure tgt = new BodyStructure();
        BodyStructure40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(BodyStructure40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(BodyStructure40_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasMorphology()) {
            tgt.setMorphology(BodyStructure40_50.convertCodeableConcept(src.getMorphology()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(BodyStructure40_50.convertCodeableConcept(src.getLocation()));
        }
        for (CodeableConcept codeableConcept : src.getLocationQualifier()) {
            tgt.addLocationQualifier(BodyStructure40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(BodyStructure40_50.convertString(src.getDescriptionElement()));
        }
        for (Attachment attachment : src.getImage()) {
            tgt.addImage(BodyStructure40_50.convertAttachment(attachment));
        }
        if (src.hasPatient()) {
            tgt.setPatient(BodyStructure40_50.convertReference(src.getPatient()));
        }
        return tgt;
    }
}

