/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Appointment;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class Appointment40_50
extends VersionConvertor_40_50 {
    public static Appointment convertAppointment(org.hl7.fhir.r4.model.Appointment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Appointment tgt = new Appointment();
        Appointment40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Appointment40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Appointment40_50.convertAppointmentStatus(src.getStatusElement()));
        }
        if (src.hasCancelationReason()) {
            tgt.setCancelationReason(Appointment40_50.convertCodeableConcept(src.getCancelationReason()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getServiceCategory()) {
            tgt.addServiceCategory(Appointment40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.addServiceType(Appointment40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(Appointment40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentType()) {
            tgt.setAppointmentType(Appointment40_50.convertCodeableConcept(src.getAppointmentType()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(Appointment40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReason(Appointment40_50.convertReferenceToCodeableReference(reference));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(Appointment40_50.convertUnsignedInt(src.getPriorityElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Appointment40_50.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(Appointment40_50.convertReference(reference));
        }
        if (src.hasStart()) {
            tgt.setStartElement(Appointment40_50.convertInstant(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(Appointment40_50.convertInstant(src.getEndElement()));
        }
        if (src.hasMinutesDuration()) {
            tgt.setMinutesDurationElement(Appointment40_50.convertPositiveInt(src.getMinutesDurationElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSlot()) {
            tgt.addSlot(Appointment40_50.convertReference(reference));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(Appointment40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(Appointment40_50.convertString(src.getCommentElement()));
        }
        if (src.hasPatientInstruction()) {
            tgt.setPatientInstructionElement(Appointment40_50.convertString(src.getPatientInstructionElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(Appointment40_50.convertReference(reference));
        }
        for (Appointment.AppointmentParticipantComponent appointmentParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(Appointment40_50.convertAppointmentParticipantComponent(appointmentParticipantComponent));
        }
        for (Period period : src.getRequestedPeriod()) {
            tgt.addRequestedPeriod(Appointment40_50.convertPeriod(period));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Appointment convertAppointment(Appointment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Appointment tgt = new org.hl7.fhir.r4.model.Appointment();
        Appointment40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Appointment40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Appointment40_50.convertAppointmentStatus(src.getStatusElement()));
        }
        if (src.hasCancelationReason()) {
            tgt.setCancelationReason(Appointment40_50.convertCodeableConcept(src.getCancelationReason()));
        }
        for (CodeableConcept codeableConcept : src.getServiceCategory()) {
            tgt.addServiceCategory(Appointment40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.addServiceType(Appointment40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(Appointment40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentType()) {
            tgt.setAppointmentType(Appointment40_50.convertCodeableConcept(src.getAppointmentType()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(Appointment40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(Appointment40_50.convertReference(codeableReference.getReference()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(Appointment40_50.convertUnsignedInt(src.getPriorityElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Appointment40_50.convertString(src.getDescriptionElement()));
        }
        for (Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(Appointment40_50.convertReference(reference));
        }
        if (src.hasStart()) {
            tgt.setStartElement(Appointment40_50.convertInstant(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(Appointment40_50.convertInstant(src.getEndElement()));
        }
        if (src.hasMinutesDuration()) {
            tgt.setMinutesDurationElement(Appointment40_50.convertPositiveInt(src.getMinutesDurationElement()));
        }
        for (Reference reference : src.getSlot()) {
            tgt.addSlot(Appointment40_50.convertReference(reference));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(Appointment40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(Appointment40_50.convertString(src.getCommentElement()));
        }
        if (src.hasPatientInstruction()) {
            tgt.setPatientInstructionElement(Appointment40_50.convertString(src.getPatientInstructionElement()));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(Appointment40_50.convertReference(reference));
        }
        for (Appointment.AppointmentParticipantComponent appointmentParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(Appointment40_50.convertAppointmentParticipantComponent(appointmentParticipantComponent));
        }
        for (org.hl7.fhir.r5.model.Period period : src.getRequestedPeriod()) {
            tgt.addRequestedPeriod(Appointment40_50.convertPeriod(period));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Appointment.AppointmentStatus> convertAppointmentStatus(Enumeration<Appointment.AppointmentStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Appointment.AppointmentStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Appointment.AppointmentStatus>(new Appointment.AppointmentStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Appointment.AppointmentStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.PROPOSED);
                break;
            }
            case PENDING: {
                tgt.setValue((Object)Appointment.AppointmentStatus.PENDING);
                break;
            }
            case BOOKED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.BOOKED);
                break;
            }
            case ARRIVED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.ARRIVED);
                break;
            }
            case FULFILLED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.FULFILLED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.CANCELLED);
                break;
            }
            case NOSHOW: {
                tgt.setValue((Object)Appointment.AppointmentStatus.NOSHOW);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Appointment.AppointmentStatus.ENTEREDINERROR);
                break;
            }
            case CHECKEDIN: {
                tgt.setValue((Object)Appointment.AppointmentStatus.CHECKEDIN);
                break;
            }
            case WAITLIST: {
                tgt.setValue((Object)Appointment.AppointmentStatus.WAITLIST);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.AppointmentStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Appointment.AppointmentStatus> convertAppointmentStatus(org.hl7.fhir.r5.model.Enumeration<Appointment.AppointmentStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Appointment.AppointmentStatus> tgt = new Enumeration<Appointment.AppointmentStatus>(new Appointment.AppointmentStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Appointment.AppointmentStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.PROPOSED);
                break;
            }
            case PENDING: {
                tgt.setValue((Object)Appointment.AppointmentStatus.PENDING);
                break;
            }
            case BOOKED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.BOOKED);
                break;
            }
            case ARRIVED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.ARRIVED);
                break;
            }
            case FULFILLED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.FULFILLED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.CANCELLED);
                break;
            }
            case NOSHOW: {
                tgt.setValue((Object)Appointment.AppointmentStatus.NOSHOW);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Appointment.AppointmentStatus.ENTEREDINERROR);
                break;
            }
            case CHECKEDIN: {
                tgt.setValue((Object)Appointment.AppointmentStatus.CHECKEDIN);
                break;
            }
            case WAITLIST: {
                tgt.setValue((Object)Appointment.AppointmentStatus.WAITLIST);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.AppointmentStatus.NULL);
            }
        }
        return tgt;
    }

    public static Appointment.AppointmentParticipantComponent convertAppointmentParticipantComponent(Appointment.AppointmentParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Appointment.AppointmentParticipantComponent tgt = new Appointment.AppointmentParticipantComponent();
        Appointment40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getType()) {
            tgt.addType(Appointment40_50.convertCodeableConcept(t));
        }
        if (src.hasActor()) {
            tgt.setActor(Appointment40_50.convertReference(src.getActor()));
        }
        if (src.hasRequired()) {
            tgt.setRequiredElement(Appointment40_50.convertParticipantRequired(src.getRequiredElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Appointment40_50.convertParticipationStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Appointment40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Appointment.AppointmentParticipantComponent convertAppointmentParticipantComponent(Appointment.AppointmentParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Appointment.AppointmentParticipantComponent tgt = new Appointment.AppointmentParticipantComponent();
        Appointment40_50.copyElement(src, tgt, new String[0]);
        for (CodeableConcept t : src.getType()) {
            tgt.addType(Appointment40_50.convertCodeableConcept(t));
        }
        if (src.hasActor()) {
            tgt.setActor(Appointment40_50.convertReference(src.getActor()));
        }
        if (src.hasRequired()) {
            tgt.setRequiredElement(Appointment40_50.convertParticipantRequired(src.getRequiredElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Appointment40_50.convertParticipationStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Appointment40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Appointment.ParticipantRequired> convertParticipantRequired(Enumeration<Appointment.ParticipantRequired> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Appointment.ParticipantRequired> tgt = new org.hl7.fhir.r5.model.Enumeration<Appointment.ParticipantRequired>(new Appointment.ParticipantRequiredEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Appointment.ParticipantRequired)((Object)src.getValue())) {
            case REQUIRED: {
                tgt.setValue((Object)Appointment.ParticipantRequired.REQUIRED);
                break;
            }
            case OPTIONAL: {
                tgt.setValue((Object)Appointment.ParticipantRequired.OPTIONAL);
                break;
            }
            case INFORMATIONONLY: {
                tgt.setValue((Object)Appointment.ParticipantRequired.INFORMATIONONLY);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.ParticipantRequired.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Appointment.ParticipantRequired> convertParticipantRequired(org.hl7.fhir.r5.model.Enumeration<Appointment.ParticipantRequired> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Appointment.ParticipantRequired> tgt = new Enumeration<Appointment.ParticipantRequired>(new Appointment.ParticipantRequiredEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Appointment.ParticipantRequired)((Object)src.getValue())) {
            case REQUIRED: {
                tgt.setValue((Object)Appointment.ParticipantRequired.REQUIRED);
                break;
            }
            case OPTIONAL: {
                tgt.setValue((Object)Appointment.ParticipantRequired.OPTIONAL);
                break;
            }
            case INFORMATIONONLY: {
                tgt.setValue((Object)Appointment.ParticipantRequired.INFORMATIONONLY);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.ParticipantRequired.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus> convertParticipationStatus(Enumeration<Appointment.ParticipationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus>(new Enumerations.ParticipationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Appointment.ParticipationStatus)((Object)src.getValue())) {
            case ACCEPTED: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.ACCEPTED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.DECLINED);
                break;
            }
            case TENTATIVE: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.TENTATIVE);
                break;
            }
            case NEEDSACTION: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.NEEDSACTION);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Appointment.ParticipationStatus> convertParticipationStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Appointment.ParticipationStatus> tgt = new Enumeration<Appointment.ParticipationStatus>(new Appointment.ParticipationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ParticipationStatus)((Object)src.getValue())) {
            case ACCEPTED: {
                tgt.setValue((Object)Appointment.ParticipationStatus.ACCEPTED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)Appointment.ParticipationStatus.DECLINED);
                break;
            }
            case TENTATIVE: {
                tgt.setValue((Object)Appointment.ParticipationStatus.TENTATIVE);
                break;
            }
            case NEEDSACTION: {
                tgt.setValue((Object)Appointment.ParticipationStatus.NEEDSACTION);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.ParticipationStatus.NULL);
            }
        }
        return tgt;
    }
}

