/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;

public class ActivityDefinition40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.ActivityDefinition convertActivityDefinition(ActivityDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ActivityDefinition tgt = new org.hl7.fhir.r5.model.ActivityDefinition();
        ActivityDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(ActivityDefinition40_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ActivityDefinition40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ActivityDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ActivityDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ActivityDefinition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasSubtitle()) {
            tgt.setSubtitleElement(ActivityDefinition40_50.convertString(src.getSubtitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(ActivityDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(ActivityDefinition40_50.convertType(src.getSubject()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ActivityDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(ActivityDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ActivityDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ActivityDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(ActivityDefinition40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(ActivityDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(ActivityDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(ActivityDefinition40_50.convertString(src.getUsageElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(ActivityDefinition40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(ActivityDefinition40_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(ActivityDefinition40_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(ActivityDefinition40_50.convertPeriod(src.getEffectivePeriod()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getTopic()) {
            tgt.addTopic(ActivityDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getAuthor()) {
            tgt.addAuthor(ActivityDefinition40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getEditor()) {
            tgt.addEditor(ActivityDefinition40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getReviewer()) {
            tgt.addReviewer(ActivityDefinition40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getEndorser()) {
            tgt.addEndorser(ActivityDefinition40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(ActivityDefinition40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (CanonicalType canonicalType : src.getLibrary()) {
            tgt.getLibrary().add(ActivityDefinition40_50.convertCanonical(canonicalType));
        }
        if (src.hasKind()) {
            tgt.setKindElement(ActivityDefinition40_50.convertActivityDefinitionKind(src.getKindElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(ActivityDefinition40_50.convertCanonical(src.getProfileElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(ActivityDefinition40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(ActivityDefinition40_50.convertRequestIntent(src.getIntentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(ActivityDefinition40_50.convertRequestPriority(src.getPriorityElement()));
        }
        if (src.hasDoNotPerform()) {
            tgt.setDoNotPerformElement(ActivityDefinition40_50.convertBoolean(src.getDoNotPerformElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(ActivityDefinition40_50.convertType(src.getTiming()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(ActivityDefinition40_50.convertReference(src.getLocation()));
        }
        for (ActivityDefinition.ActivityDefinitionParticipantComponent activityDefinitionParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(ActivityDefinition40_50.convertActivityDefinitionParticipantComponent(activityDefinitionParticipantComponent));
        }
        if (src.hasProduct()) {
            tgt.setProduct(ActivityDefinition40_50.convertType(src.getProduct()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ActivityDefinition40_50.convertSimpleQuantity(src.getQuantity()));
        }
        for (org.hl7.fhir.r4.model.Dosage dosage : src.getDosage()) {
            tgt.addDosage(ActivityDefinition40_50.convertDosage(dosage));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(ActivityDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSpecimenRequirement()) {
            tgt.addSpecimenRequirement(ActivityDefinition40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getObservationRequirement()) {
            tgt.addObservationRequirement(ActivityDefinition40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getObservationResultRequirement()) {
            tgt.addObservationResultRequirement(ActivityDefinition40_50.convertReference(reference));
        }
        if (src.hasTransform()) {
            tgt.setTransformElement(ActivityDefinition40_50.convertCanonical(src.getTransformElement()));
        }
        for (ActivityDefinition.ActivityDefinitionDynamicValueComponent activityDefinitionDynamicValueComponent : src.getDynamicValue()) {
            tgt.addDynamicValue(ActivityDefinition40_50.convertActivityDefinitionDynamicValueComponent(activityDefinitionDynamicValueComponent));
        }
        return tgt;
    }

    public static ActivityDefinition convertActivityDefinition(org.hl7.fhir.r5.model.ActivityDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ActivityDefinition tgt = new ActivityDefinition();
        ActivityDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(ActivityDefinition40_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ActivityDefinition40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ActivityDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ActivityDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ActivityDefinition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasSubtitle()) {
            tgt.setSubtitleElement(ActivityDefinition40_50.convertString(src.getSubtitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(ActivityDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(ActivityDefinition40_50.convertType(src.getSubject()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ActivityDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(ActivityDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ActivityDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ActivityDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(ActivityDefinition40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(ActivityDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(ActivityDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(ActivityDefinition40_50.convertString(src.getUsageElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(ActivityDefinition40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(ActivityDefinition40_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(ActivityDefinition40_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(ActivityDefinition40_50.convertPeriod(src.getEffectivePeriod()));
        }
        for (CodeableConcept codeableConcept : src.getTopic()) {
            tgt.addTopic(ActivityDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (ContactDetail contactDetail : src.getAuthor()) {
            tgt.addAuthor(ActivityDefinition40_50.convertContactDetail(contactDetail));
        }
        for (ContactDetail contactDetail : src.getEditor()) {
            tgt.addEditor(ActivityDefinition40_50.convertContactDetail(contactDetail));
        }
        for (ContactDetail contactDetail : src.getReviewer()) {
            tgt.addReviewer(ActivityDefinition40_50.convertContactDetail(contactDetail));
        }
        for (ContactDetail contactDetail : src.getEndorser()) {
            tgt.addEndorser(ActivityDefinition40_50.convertContactDetail(contactDetail));
        }
        for (RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(ActivityDefinition40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getLibrary()) {
            tgt.getLibrary().add(ActivityDefinition40_50.convertCanonical(canonicalType));
        }
        if (src.hasKind()) {
            tgt.setKindElement(ActivityDefinition40_50.convertActivityDefinitionKind(src.getKindElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(ActivityDefinition40_50.convertCanonical(src.getProfileElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(ActivityDefinition40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(ActivityDefinition40_50.convertRequestIntent(src.getIntentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(ActivityDefinition40_50.convertRequestPriority(src.getPriorityElement()));
        }
        if (src.hasDoNotPerform()) {
            tgt.setDoNotPerformElement(ActivityDefinition40_50.convertBoolean(src.getDoNotPerformElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(ActivityDefinition40_50.convertType(src.getTiming()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(ActivityDefinition40_50.convertReference(src.getLocation()));
        }
        for (ActivityDefinition.ActivityDefinitionParticipantComponent activityDefinitionParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(ActivityDefinition40_50.convertActivityDefinitionParticipantComponent(activityDefinitionParticipantComponent));
        }
        if (src.hasProduct()) {
            tgt.setProduct(ActivityDefinition40_50.convertType(src.getProduct()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ActivityDefinition40_50.convertSimpleQuantity(src.getQuantity()));
        }
        for (Dosage dosage : src.getDosage()) {
            tgt.addDosage(ActivityDefinition40_50.convertDosage(dosage));
        }
        for (CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(ActivityDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getSpecimenRequirement()) {
            tgt.addSpecimenRequirement(ActivityDefinition40_50.convertReference(reference));
        }
        for (Reference reference : src.getObservationRequirement()) {
            tgt.addObservationRequirement(ActivityDefinition40_50.convertReference(reference));
        }
        for (Reference reference : src.getObservationResultRequirement()) {
            tgt.addObservationResultRequirement(ActivityDefinition40_50.convertReference(reference));
        }
        if (src.hasTransform()) {
            tgt.setTransformElement(ActivityDefinition40_50.convertCanonical(src.getTransformElement()));
        }
        for (ActivityDefinition.ActivityDefinitionDynamicValueComponent activityDefinitionDynamicValueComponent : src.getDynamicValue()) {
            tgt.addDynamicValue(ActivityDefinition40_50.convertActivityDefinitionDynamicValueComponent(activityDefinitionDynamicValueComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ActivityDefinition.RequestResourceType> convertActivityDefinitionKind(Enumeration<ActivityDefinition.ActivityDefinitionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ActivityDefinition.RequestResourceType> tgt = new org.hl7.fhir.r5.model.Enumeration<ActivityDefinition.RequestResourceType>(new ActivityDefinition.RequestResourceTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ActivityDefinition.ActivityDefinitionKind)((Object)src.getValue())) {
            case APPOINTMENT: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.APPOINTMENT);
                break;
            }
            case APPOINTMENTRESPONSE: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.APPOINTMENTRESPONSE);
                break;
            }
            case CAREPLAN: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.CAREPLAN);
                break;
            }
            case CLAIM: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.CLAIM);
                break;
            }
            case COMMUNICATIONREQUEST: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.COMMUNICATIONREQUEST);
                break;
            }
            case CONTRACT: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.CONTRACT);
                break;
            }
            case DEVICEREQUEST: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.DEVICEREQUEST);
                break;
            }
            case ENROLLMENTREQUEST: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.ENROLLMENTREQUEST);
                break;
            }
            case IMMUNIZATIONRECOMMENDATION: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.IMMUNIZATIONRECOMMENDATION);
                break;
            }
            case MEDICATIONREQUEST: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.MEDICATIONREQUEST);
                break;
            }
            case NUTRITIONORDER: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.NUTRITIONORDER);
                break;
            }
            case SERVICEREQUEST: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.SERVICEREQUEST);
                break;
            }
            case SUPPLYREQUEST: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.SUPPLYREQUEST);
                break;
            }
            case TASK: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.TASK);
                break;
            }
            case VISIONPRESCRIPTION: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.VISIONPRESCRIPTION);
                break;
            }
            default: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ActivityDefinition.ActivityDefinitionKind> convertActivityDefinitionKind(org.hl7.fhir.r5.model.Enumeration<ActivityDefinition.RequestResourceType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ActivityDefinition.ActivityDefinitionKind> tgt = new Enumeration<ActivityDefinition.ActivityDefinitionKind>(new ActivityDefinition.ActivityDefinitionKindEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ActivityDefinition.RequestResourceType)((Object)src.getValue())) {
            case APPOINTMENT: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.APPOINTMENT);
                break;
            }
            case APPOINTMENTRESPONSE: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.APPOINTMENTRESPONSE);
                break;
            }
            case CAREPLAN: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.CAREPLAN);
                break;
            }
            case CLAIM: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.CLAIM);
                break;
            }
            case COMMUNICATIONREQUEST: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.COMMUNICATIONREQUEST);
                break;
            }
            case CONTRACT: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.CONTRACT);
                break;
            }
            case DEVICEREQUEST: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.DEVICEREQUEST);
                break;
            }
            case ENROLLMENTREQUEST: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.ENROLLMENTREQUEST);
                break;
            }
            case IMMUNIZATIONRECOMMENDATION: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.IMMUNIZATIONRECOMMENDATION);
                break;
            }
            case MEDICATIONREQUEST: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.MEDICATIONREQUEST);
                break;
            }
            case NUTRITIONORDER: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.NUTRITIONORDER);
                break;
            }
            case SERVICEREQUEST: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.SERVICEREQUEST);
                break;
            }
            case SUPPLYREQUEST: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.SUPPLYREQUEST);
                break;
            }
            case TASK: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.TASK);
                break;
            }
            case VISIONPRESCRIPTION: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.VISIONPRESCRIPTION);
                break;
            }
            default: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent> convertRequestIntent(Enumeration<ActivityDefinition.RequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent>(new Enumerations.RequestIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ActivityDefinition.RequestIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)Enumerations.RequestIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)Enumerations.RequestIntent.PLAN);
                break;
            }
            case DIRECTIVE: {
                tgt.setValue((Object)Enumerations.RequestIntent.DIRECTIVE);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.ORIGINALORDER);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.REFLEXORDER);
                break;
            }
            case FILLERORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)Enumerations.RequestIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ActivityDefinition.RequestIntent> convertRequestIntent(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ActivityDefinition.RequestIntent> tgt = new Enumeration<ActivityDefinition.RequestIntent>(new ActivityDefinition.RequestIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)ActivityDefinition.RequestIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)ActivityDefinition.RequestIntent.PLAN);
                break;
            }
            case DIRECTIVE: {
                tgt.setValue((Object)ActivityDefinition.RequestIntent.DIRECTIVE);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)ActivityDefinition.RequestIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)ActivityDefinition.RequestIntent.ORIGINALORDER);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)ActivityDefinition.RequestIntent.REFLEXORDER);
                break;
            }
            case FILLERORDER: {
                tgt.setValue((Object)ActivityDefinition.RequestIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)ActivityDefinition.RequestIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)ActivityDefinition.RequestIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)ActivityDefinition.RequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> convertRequestPriority(Enumeration<ActivityDefinition.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ActivityDefinition.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)Enumerations.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)Enumerations.RequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)Enumerations.RequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)Enumerations.RequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ActivityDefinition.RequestPriority> convertRequestPriority(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ActivityDefinition.RequestPriority> tgt = new Enumeration<ActivityDefinition.RequestPriority>(new ActivityDefinition.RequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)ActivityDefinition.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)ActivityDefinition.RequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)ActivityDefinition.RequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)ActivityDefinition.RequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)ActivityDefinition.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static ActivityDefinition.ActivityDefinitionParticipantComponent convertActivityDefinitionParticipantComponent(ActivityDefinition.ActivityDefinitionParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ActivityDefinition.ActivityDefinitionParticipantComponent tgt = new ActivityDefinition.ActivityDefinitionParticipantComponent();
        ActivityDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(ActivityDefinition40_50.convertActivityParticipantType(src.getTypeElement()));
        }
        if (src.hasRole()) {
            tgt.setRole(ActivityDefinition40_50.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static ActivityDefinition.ActivityDefinitionParticipantComponent convertActivityDefinitionParticipantComponent(ActivityDefinition.ActivityDefinitionParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ActivityDefinition.ActivityDefinitionParticipantComponent tgt = new ActivityDefinition.ActivityDefinitionParticipantComponent();
        ActivityDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(ActivityDefinition40_50.convertActivityParticipantType(src.getTypeElement()));
        }
        if (src.hasRole()) {
            tgt.setRole(ActivityDefinition40_50.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionParticipantType> convertActivityParticipantType(Enumeration<ActivityDefinition.ActivityParticipantType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionParticipantType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionParticipantType>(new Enumerations.ActionParticipantTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ActivityDefinition.ActivityParticipantType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)Enumerations.ActionParticipantType.PATIENT);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)Enumerations.ActionParticipantType.PRACTITIONER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)Enumerations.ActionParticipantType.RELATEDPERSON);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)Enumerations.ActionParticipantType.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionParticipantType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ActivityDefinition.ActivityParticipantType> convertActivityParticipantType(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionParticipantType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ActivityDefinition.ActivityParticipantType> tgt = new Enumeration<ActivityDefinition.ActivityParticipantType>(new ActivityDefinition.ActivityParticipantTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionParticipantType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)ActivityDefinition.ActivityParticipantType.PATIENT);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)ActivityDefinition.ActivityParticipantType.PRACTITIONER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)ActivityDefinition.ActivityParticipantType.RELATEDPERSON);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)ActivityDefinition.ActivityParticipantType.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)ActivityDefinition.ActivityParticipantType.NULL);
            }
        }
        return tgt;
    }

    public static ActivityDefinition.ActivityDefinitionDynamicValueComponent convertActivityDefinitionDynamicValueComponent(ActivityDefinition.ActivityDefinitionDynamicValueComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ActivityDefinition.ActivityDefinitionDynamicValueComponent tgt = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
        ActivityDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(ActivityDefinition40_50.convertString(src.getPathElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpression(ActivityDefinition40_50.convertExpression(src.getExpression()));
        }
        return tgt;
    }

    public static ActivityDefinition.ActivityDefinitionDynamicValueComponent convertActivityDefinitionDynamicValueComponent(ActivityDefinition.ActivityDefinitionDynamicValueComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ActivityDefinition.ActivityDefinitionDynamicValueComponent tgt = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
        ActivityDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(ActivityDefinition40_50.convertString(src.getPathElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpression(ActivityDefinition40_50.convertExpression(src.getExpression()));
        }
        return tgt;
    }
}

