/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.StructureMap;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureMap;

public class StructureMap30_50 {
    public static org.hl7.fhir.r5.model.StructureMap convertStructureMap(StructureMap src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.StructureMap tgt = new org.hl7.fhir.r5.model.StructureMap();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        for (StructureMap.StructureMapStructureComponent structureMapStructureComponent : src.getStructure()) {
            tgt.addStructure(StructureMap30_50.convertStructureMapStructureComponent(structureMapStructureComponent));
        }
        for (UriType uriType : src.getImport()) {
            tgt.addImport((String)uriType.getValue());
        }
        for (StructureMap.StructureMapGroupComponent structureMapGroupComponent : src.getGroup()) {
            tgt.addGroup(StructureMap30_50.convertStructureMapGroupComponent(structureMapGroupComponent));
        }
        return tgt;
    }

    public static StructureMap convertStructureMap(org.hl7.fhir.r5.model.StructureMap src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap tgt = new StructureMap();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        for (StructureMap.StructureMapStructureComponent structureMapStructureComponent : src.getStructure()) {
            tgt.addStructure(StructureMap30_50.convertStructureMapStructureComponent(structureMapStructureComponent));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getImport()) {
            tgt.addImport((String)uriType.getValue());
        }
        for (StructureMap.StructureMapGroupComponent structureMapGroupComponent : src.getGroup()) {
            tgt.addGroup(StructureMap30_50.convertStructureMapGroupComponent(structureMapGroupComponent));
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapContextType> convertStructureMapContextType(org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapContextType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapContextType> tgt = new Enumeration<StructureMap.StructureMapContextType>(new StructureMap.StructureMapContextTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapContextType)((Object)src.getValue())) {
            case TYPE: {
                tgt.setValue((Object)StructureMap.StructureMapContextType.TYPE);
                break;
            }
            case VARIABLE: {
                tgt.setValue((Object)StructureMap.StructureMapContextType.VARIABLE);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapContextType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapContextType> convertStructureMapContextType(Enumeration<StructureMap.StructureMapContextType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapContextType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapContextType>(new StructureMap.StructureMapContextTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapContextType)((Object)src.getValue())) {
            case TYPE: {
                tgt.setValue((Object)StructureMap.StructureMapContextType.TYPE);
                break;
            }
            case VARIABLE: {
                tgt.setValue((Object)StructureMap.StructureMapContextType.VARIABLE);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapContextType.NULL);
            }
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupComponent convertStructureMapGroupComponent(StructureMap.StructureMapGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupComponent tgt = new StructureMap.StructureMapGroupComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertId(src.getNameElement()));
        }
        if (src.hasExtends()) {
            tgt.setExtendsElement(VersionConvertor_30_50.convertId(src.getExtendsElement()));
        }
        if (src.hasTypeMode()) {
            tgt.setTypeModeElement(StructureMap30_50.convertStructureMapGroupTypeMode(src.getTypeModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertString(src.getDocumentationElement()));
        }
        for (StructureMap.StructureMapGroupInputComponent structureMapGroupInputComponent : src.getInput()) {
            tgt.addInput(StructureMap30_50.convertStructureMapGroupInputComponent(structureMapGroupInputComponent));
        }
        for (StructureMap.StructureMapGroupRuleComponent structureMapGroupRuleComponent : src.getRule()) {
            tgt.addRule(StructureMap30_50.convertStructureMapGroupRuleComponent(structureMapGroupRuleComponent));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupComponent convertStructureMapGroupComponent(StructureMap.StructureMapGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupComponent tgt = new StructureMap.StructureMapGroupComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertId(src.getNameElement()));
        }
        if (src.hasExtends()) {
            tgt.setExtendsElement(VersionConvertor_30_50.convertId(src.getExtendsElement()));
        }
        if (src.hasTypeMode()) {
            tgt.setTypeModeElement(StructureMap30_50.convertStructureMapGroupTypeMode(src.getTypeModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertString(src.getDocumentationElement()));
        }
        for (StructureMap.StructureMapGroupInputComponent structureMapGroupInputComponent : src.getInput()) {
            tgt.addInput(StructureMap30_50.convertStructureMapGroupInputComponent(structureMapGroupInputComponent));
        }
        for (StructureMap.StructureMapGroupRuleComponent structureMapGroupRuleComponent : src.getRule()) {
            tgt.addRule(StructureMap30_50.convertStructureMapGroupRuleComponent(structureMapGroupRuleComponent));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupInputComponent convertStructureMapGroupInputComponent(StructureMap.StructureMapGroupInputComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupInputComponent tgt = new StructureMap.StructureMapGroupInputComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertId(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertString(src.getTypeElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(StructureMap30_50.convertStructureMapInputMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupInputComponent convertStructureMapGroupInputComponent(StructureMap.StructureMapGroupInputComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupInputComponent tgt = new StructureMap.StructureMapGroupInputComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertId(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertString(src.getTypeElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(StructureMap30_50.convertStructureMapInputMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleComponent convertStructureMapGroupRuleComponent(StructureMap.StructureMapGroupRuleComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleComponent tgt = new StructureMap.StructureMapGroupRuleComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertId(src.getNameElement()));
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent structureMapGroupRuleSourceComponent : src.getSource()) {
            tgt.addSource(StructureMap30_50.convertStructureMapGroupRuleSourceComponent(structureMapGroupRuleSourceComponent));
        }
        for (StructureMap.StructureMapGroupRuleTargetComponent structureMapGroupRuleTargetComponent : src.getTarget()) {
            tgt.addTarget(StructureMap30_50.convertStructureMapGroupRuleTargetComponent(structureMapGroupRuleTargetComponent));
        }
        for (StructureMap.StructureMapGroupRuleComponent structureMapGroupRuleComponent : src.getRule()) {
            tgt.addRule(StructureMap30_50.convertStructureMapGroupRuleComponent(structureMapGroupRuleComponent));
        }
        for (StructureMap.StructureMapGroupRuleDependentComponent structureMapGroupRuleDependentComponent : src.getDependent()) {
            tgt.addDependent(StructureMap30_50.convertStructureMapGroupRuleDependentComponent(structureMapGroupRuleDependentComponent));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleComponent convertStructureMapGroupRuleComponent(StructureMap.StructureMapGroupRuleComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleComponent tgt = new StructureMap.StructureMapGroupRuleComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertId(src.getNameElement()));
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent structureMapGroupRuleSourceComponent : src.getSource()) {
            tgt.addSource(StructureMap30_50.convertStructureMapGroupRuleSourceComponent(structureMapGroupRuleSourceComponent));
        }
        for (StructureMap.StructureMapGroupRuleTargetComponent structureMapGroupRuleTargetComponent : src.getTarget()) {
            tgt.addTarget(StructureMap30_50.convertStructureMapGroupRuleTargetComponent(structureMapGroupRuleTargetComponent));
        }
        for (StructureMap.StructureMapGroupRuleComponent structureMapGroupRuleComponent : src.getRule()) {
            tgt.addRule(StructureMap30_50.convertStructureMapGroupRuleComponent(structureMapGroupRuleComponent));
        }
        for (StructureMap.StructureMapGroupRuleDependentComponent structureMapGroupRuleDependentComponent : src.getDependent()) {
            tgt.addDependent(StructureMap30_50.convertStructureMapGroupRuleDependentComponent(structureMapGroupRuleDependentComponent));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleDependentComponent convertStructureMapGroupRuleDependentComponent(StructureMap.StructureMapGroupRuleDependentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleDependentComponent tgt = new StructureMap.StructureMapGroupRuleDependentComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertId(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu3.model.StringType t : src.getVariable()) {
            tgt.addVariable((String)t.getValue());
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleDependentComponent convertStructureMapGroupRuleDependentComponent(StructureMap.StructureMapGroupRuleDependentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleDependentComponent tgt = new StructureMap.StructureMapGroupRuleDependentComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertId(src.getNameElement()));
        }
        for (StringType t : src.getVariable()) {
            tgt.addVariable((String)t.getValue());
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleSourceComponent convertStructureMapGroupRuleSourceComponent(StructureMap.StructureMapGroupRuleSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleSourceComponent tgt = new StructureMap.StructureMapGroupRuleSourceComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasContext()) {
            tgt.setContextElement(VersionConvertor_30_50.convertId(src.getContextElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_50.convertString(src.getMaxElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertString(src.getTypeElement()));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_30_50.convertType(src.getDefaultValue()));
        }
        if (src.hasElement()) {
            tgt.setElementElement(VersionConvertor_30_50.convertString(src.getElementElement()));
        }
        if (src.hasListMode()) {
            tgt.setListModeElement(StructureMap30_50.convertStructureMapSourceListMode(src.getListModeElement()));
        }
        if (src.hasVariable()) {
            tgt.setVariableElement(VersionConvertor_30_50.convertId(src.getVariableElement()));
        }
        if (src.hasCondition()) {
            tgt.setConditionElement(VersionConvertor_30_50.convertString(src.getConditionElement()));
        }
        if (src.hasCheck()) {
            tgt.setCheckElement(VersionConvertor_30_50.convertString(src.getCheckElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleSourceComponent convertStructureMapGroupRuleSourceComponent(StructureMap.StructureMapGroupRuleSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleSourceComponent tgt = new StructureMap.StructureMapGroupRuleSourceComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasContext()) {
            tgt.setContextElement(VersionConvertor_30_50.convertId(src.getContextElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_50.convertString(src.getMaxElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertString(src.getTypeElement()));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_30_50.convertType(src.getDefaultValue()));
        }
        if (src.hasElement()) {
            tgt.setElementElement(VersionConvertor_30_50.convertString(src.getElementElement()));
        }
        if (src.hasListMode()) {
            tgt.setListModeElement(StructureMap30_50.convertStructureMapSourceListMode(src.getListModeElement()));
        }
        if (src.hasVariable()) {
            tgt.setVariableElement(VersionConvertor_30_50.convertId(src.getVariableElement()));
        }
        if (src.hasCondition()) {
            tgt.setConditionElement(VersionConvertor_30_50.convertString(src.getConditionElement()));
        }
        if (src.hasCheck()) {
            tgt.setCheckElement(VersionConvertor_30_50.convertString(src.getCheckElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleTargetComponent convertStructureMapGroupRuleTargetComponent(StructureMap.StructureMapGroupRuleTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetComponent tgt = new StructureMap.StructureMapGroupRuleTargetComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasContext()) {
            tgt.setContextElement(VersionConvertor_30_50.convertId(src.getContextElement()));
        }
        if (src.hasContextType()) {
            tgt.setContextTypeElement(StructureMap30_50.convertStructureMapContextType(src.getContextTypeElement()));
        }
        if (src.hasElement()) {
            tgt.setElementElement(VersionConvertor_30_50.convertString(src.getElementElement()));
        }
        if (src.hasVariable()) {
            tgt.setVariableElement(VersionConvertor_30_50.convertId(src.getVariableElement()));
        }
        tgt.setListMode(src.getListMode().stream().map(StructureMap30_50::convertStructureMapTargetListMode).collect(Collectors.toList()));
        if (src.hasListRuleId()) {
            tgt.setListRuleIdElement(VersionConvertor_30_50.convertId(src.getListRuleIdElement()));
        }
        if (src.hasTransform()) {
            tgt.setTransformElement(StructureMap30_50.convertStructureMapTransform(src.getTransformElement()));
        }
        for (StructureMap.StructureMapGroupRuleTargetParameterComponent t : src.getParameter()) {
            tgt.addParameter(StructureMap30_50.convertStructureMapGroupRuleTargetParameterComponent(t));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleTargetComponent convertStructureMapGroupRuleTargetComponent(StructureMap.StructureMapGroupRuleTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetComponent tgt = new StructureMap.StructureMapGroupRuleTargetComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasContext()) {
            tgt.setContextElement(VersionConvertor_30_50.convertId(src.getContextElement()));
        }
        if (src.hasContextType()) {
            tgt.setContextTypeElement(StructureMap30_50.convertStructureMapContextType(src.getContextTypeElement()));
        }
        if (src.hasElement()) {
            tgt.setElementElement(VersionConvertor_30_50.convertString(src.getElementElement()));
        }
        if (src.hasVariable()) {
            tgt.setVariableElement(VersionConvertor_30_50.convertId(src.getVariableElement()));
        }
        tgt.setListMode(src.getListMode().stream().map(StructureMap30_50::convertStructureMapTargetListMode).collect(Collectors.toList()));
        if (src.hasListRuleId()) {
            tgt.setListRuleIdElement(VersionConvertor_30_50.convertId(src.getListRuleIdElement()));
        }
        if (src.hasTransform()) {
            tgt.setTransformElement(StructureMap30_50.convertStructureMapTransform(src.getTransformElement()));
        }
        for (StructureMap.StructureMapGroupRuleTargetParameterComponent t : src.getParameter()) {
            tgt.addParameter(StructureMap30_50.convertStructureMapGroupRuleTargetParameterComponent(t));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleTargetParameterComponent convertStructureMapGroupRuleTargetParameterComponent(StructureMap.StructureMapGroupRuleTargetParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetParameterComponent tgt = new StructureMap.StructureMapGroupRuleTargetParameterComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleTargetParameterComponent convertStructureMapGroupRuleTargetParameterComponent(StructureMap.StructureMapGroupRuleTargetParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetParameterComponent tgt = new StructureMap.StructureMapGroupRuleTargetParameterComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapGroupTypeMode> convertStructureMapGroupTypeMode(org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapGroupTypeMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapGroupTypeMode> tgt = new Enumeration<StructureMap.StructureMapGroupTypeMode>(new StructureMap.StructureMapGroupTypeModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapGroupTypeMode)((Object)src.getValue())) {
            case NONE: {
                tgt.setValue((Object)StructureMap.StructureMapGroupTypeMode.NONE);
                break;
            }
            case TYPES: {
                tgt.setValue((Object)StructureMap.StructureMapGroupTypeMode.TYPES);
                break;
            }
            case TYPEANDTYPES: {
                tgt.setValue((Object)StructureMap.StructureMapGroupTypeMode.TYPEANDTYPES);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapGroupTypeMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapGroupTypeMode> convertStructureMapGroupTypeMode(Enumeration<StructureMap.StructureMapGroupTypeMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapGroupTypeMode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapGroupTypeMode>(new StructureMap.StructureMapGroupTypeModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapGroupTypeMode)((Object)src.getValue())) {
            case NONE: {
                tgt.setValue((Object)StructureMap.StructureMapGroupTypeMode.NONE);
                break;
            }
            case TYPES: {
                tgt.setValue((Object)StructureMap.StructureMapGroupTypeMode.TYPES);
                break;
            }
            case TYPEANDTYPES: {
                tgt.setValue((Object)StructureMap.StructureMapGroupTypeMode.TYPEANDTYPES);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapGroupTypeMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapInputMode> convertStructureMapInputMode(org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapInputMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapInputMode> tgt = new Enumeration<StructureMap.StructureMapInputMode>(new StructureMap.StructureMapInputModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapInputMode)((Object)src.getValue())) {
            case SOURCE: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.SOURCE);
                break;
            }
            case TARGET: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.TARGET);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapInputMode> convertStructureMapInputMode(Enumeration<StructureMap.StructureMapInputMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapInputMode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapInputMode>(new StructureMap.StructureMapInputModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapInputMode)((Object)src.getValue())) {
            case SOURCE: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.SOURCE);
                break;
            }
            case TARGET: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.TARGET);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapModelMode> convertStructureMapModelMode(org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapModelMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapModelMode> tgt = new Enumeration<StructureMap.StructureMapModelMode>(new StructureMap.StructureMapModelModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapModelMode)((Object)src.getValue())) {
            case SOURCE: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.SOURCE);
                break;
            }
            case QUERIED: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.QUERIED);
                break;
            }
            case TARGET: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.TARGET);
                break;
            }
            case PRODUCED: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.PRODUCED);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapModelMode> convertStructureMapModelMode(Enumeration<StructureMap.StructureMapModelMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapModelMode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapModelMode>(new StructureMap.StructureMapModelModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapModelMode)((Object)src.getValue())) {
            case SOURCE: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.SOURCE);
                break;
            }
            case QUERIED: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.QUERIED);
                break;
            }
            case TARGET: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.TARGET);
                break;
            }
            case PRODUCED: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.PRODUCED);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapSourceListMode> convertStructureMapSourceListMode(Enumeration<StructureMap.StructureMapSourceListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapSourceListMode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapSourceListMode>(new StructureMap.StructureMapSourceListModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapSourceListMode)((Object)src.getValue())) {
            case FIRST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.FIRST);
                break;
            }
            case NOTFIRST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.NOTFIRST);
                break;
            }
            case LAST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.LAST);
                break;
            }
            case NOTLAST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.NOTLAST);
                break;
            }
            case ONLYONE: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.ONLYONE);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapSourceListMode> convertStructureMapSourceListMode(org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapSourceListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapSourceListMode> tgt = new Enumeration<StructureMap.StructureMapSourceListMode>(new StructureMap.StructureMapSourceListModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapSourceListMode)((Object)src.getValue())) {
            case FIRST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.FIRST);
                break;
            }
            case NOTFIRST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.NOTFIRST);
                break;
            }
            case LAST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.LAST);
                break;
            }
            case NOTLAST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.NOTLAST);
                break;
            }
            case ONLYONE: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.ONLYONE);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.NULL);
            }
        }
        return tgt;
    }

    public static StructureMap.StructureMapStructureComponent convertStructureMapStructureComponent(StructureMap.StructureMapStructureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapStructureComponent tgt = new StructureMap.StructureMapStructureComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasMode()) {
            tgt.setModeElement(StructureMap30_50.convertStructureMapModelMode(src.getModeElement()));
        }
        if (src.hasAlias()) {
            tgt.setAliasElement(VersionConvertor_30_50.convertString(src.getAliasElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapStructureComponent convertStructureMapStructureComponent(StructureMap.StructureMapStructureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapStructureComponent tgt = new StructureMap.StructureMapStructureComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasMode()) {
            tgt.setModeElement(StructureMap30_50.convertStructureMapModelMode(src.getModeElement()));
        }
        if (src.hasAlias()) {
            tgt.setAliasElement(VersionConvertor_30_50.convertString(src.getAliasElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapTargetListMode> convertStructureMapTargetListMode(org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapTargetListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapTargetListMode> tgt = new Enumeration<StructureMap.StructureMapTargetListMode>(new StructureMap.StructureMapTargetListModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapTargetListMode)((Object)src.getValue())) {
            case FIRST: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.FIRST);
                break;
            }
            case SHARE: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.SHARE);
                break;
            }
            case LAST: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.LAST);
                break;
            }
            case COLLATE: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.COLLATE);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapTargetListMode> convertStructureMapTargetListMode(Enumeration<StructureMap.StructureMapTargetListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapTargetListMode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapTargetListMode>(new StructureMap.StructureMapTargetListModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapTargetListMode)((Object)src.getValue())) {
            case FIRST: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.FIRST);
                break;
            }
            case SHARE: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.SHARE);
                break;
            }
            case LAST: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.LAST);
                break;
            }
            case COLLATE: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.COLLATE);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapTransform> convertStructureMapTransform(Enumeration<StructureMap.StructureMapTransform> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapTransform> tgt = new org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapTransform>(new StructureMap.StructureMapTransformEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapTransform)((Object)src.getValue())) {
            case CREATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CREATE);
                break;
            }
            case COPY: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.COPY);
                break;
            }
            case TRUNCATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.TRUNCATE);
                break;
            }
            case ESCAPE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.ESCAPE);
                break;
            }
            case CAST: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CAST);
                break;
            }
            case APPEND: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.APPEND);
                break;
            }
            case TRANSLATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.TRANSLATE);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.REFERENCE);
                break;
            }
            case DATEOP: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.DATEOP);
                break;
            }
            case UUID: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.UUID);
                break;
            }
            case POINTER: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.POINTER);
                break;
            }
            case EVALUATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.EVALUATE);
                break;
            }
            case CC: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CC);
                break;
            }
            case C: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.C);
                break;
            }
            case QTY: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.QTY);
                break;
            }
            case ID: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.ID);
                break;
            }
            case CP: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CP);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapTransform> convertStructureMapTransform(org.hl7.fhir.dstu3.model.Enumeration<StructureMap.StructureMapTransform> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapTransform> tgt = new Enumeration<StructureMap.StructureMapTransform>(new StructureMap.StructureMapTransformEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapTransform)((Object)src.getValue())) {
            case CREATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CREATE);
                break;
            }
            case COPY: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.COPY);
                break;
            }
            case TRUNCATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.TRUNCATE);
                break;
            }
            case ESCAPE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.ESCAPE);
                break;
            }
            case CAST: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CAST);
                break;
            }
            case APPEND: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.APPEND);
                break;
            }
            case TRANSLATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.TRANSLATE);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.REFERENCE);
                break;
            }
            case DATEOP: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.DATEOP);
                break;
            }
            case UUID: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.UUID);
                break;
            }
            case POINTER: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.POINTER);
                break;
            }
            case EVALUATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.EVALUATE);
                break;
            }
            case CC: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CC);
                break;
            }
            case C: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.C);
                break;
            }
            case QTY: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.QTY);
                break;
            }
            case ID: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.ID);
                break;
            }
            case CP: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CP);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.NULL);
            }
        }
        return tgt;
    }
}

