/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RiskAssessment;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.RiskAssessment;

public class RiskAssessment30_50 {
    public static RiskAssessment convertRiskAssessment(org.hl7.fhir.dstu3.model.RiskAssessment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RiskAssessment tgt = new RiskAssessment();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasBasedOn()) {
            tgt.setBasedOn(VersionConvertor_30_50.convertReference(src.getBasedOn()));
        }
        if (src.hasParent()) {
            tgt.setParent(VersionConvertor_30_50.convertReference(src.getParent()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(RiskAssessment30_50.convertRiskAssessmentStatus(src.getStatusElement()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_50.convertReference(src.getContext()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(VersionConvertor_30_50.convertType(src.getOccurrence()));
        }
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_50.convertReference(src.getCondition()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_30_50.convertReference(src.getPerformer()));
        }
        if (src.hasReason()) {
            if (src.getReason() instanceof CodeableConcept) {
                tgt.addReason(VersionConvertor_30_50.convertCodeableConceptToCodableReference((CodeableConcept)src.getReason()));
            } else if (src.getReason() instanceof Reference) {
                tgt.addReason(VersionConvertor_30_50.convertReferenceToCodableReference((Reference)src.getReason()));
            }
        }
        for (Reference reference : src.getBasis()) {
            tgt.addBasis(VersionConvertor_30_50.convertReference(reference));
        }
        for (RiskAssessment.RiskAssessmentPredictionComponent riskAssessmentPredictionComponent : src.getPrediction()) {
            tgt.addPrediction(RiskAssessment30_50.convertRiskAssessmentPredictionComponent(riskAssessmentPredictionComponent));
        }
        if (src.hasMitigation()) {
            tgt.setMitigationElement(VersionConvertor_30_50.convertString(src.getMitigationElement()));
        }
        if (src.hasComment()) {
            tgt.addNote().setText(src.getComment());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.RiskAssessment convertRiskAssessment(RiskAssessment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.RiskAssessment tgt = new org.hl7.fhir.dstu3.model.RiskAssessment();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasBasedOn()) {
            tgt.setBasedOn(VersionConvertor_30_50.convertReference(src.getBasedOn()));
        }
        if (src.hasParent()) {
            tgt.setParent(VersionConvertor_30_50.convertReference(src.getParent()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(RiskAssessment30_50.convertRiskAssessmentStatus(src.getStatusElement()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_50.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(VersionConvertor_30_50.convertType(src.getOccurrence()));
        }
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_50.convertReference(src.getCondition()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_30_50.convertReference(src.getPerformer()));
        }
        if (src.hasReason() && src.getReasonFirstRep().hasConcept()) {
            tgt.setReason(VersionConvertor_30_50.convertType(src.getReasonFirstRep().getConcept()));
        }
        if (src.hasReason() && src.getReasonFirstRep().hasReference()) {
            tgt.setReason(VersionConvertor_30_50.convertType(src.getReasonFirstRep().getReference()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getBasis()) {
            tgt.addBasis(VersionConvertor_30_50.convertReference(reference));
        }
        for (RiskAssessment.RiskAssessmentPredictionComponent riskAssessmentPredictionComponent : src.getPrediction()) {
            tgt.addPrediction(RiskAssessment30_50.convertRiskAssessmentPredictionComponent(riskAssessmentPredictionComponent));
        }
        if (src.hasMitigation()) {
            tgt.setMitigationElement(VersionConvertor_30_50.convertString(src.getMitigationElement()));
        }
        if (src.hasNote()) {
            tgt.setComment(src.getNoteFirstRep().getText());
        }
        return tgt;
    }

    public static RiskAssessment.RiskAssessmentPredictionComponent convertRiskAssessmentPredictionComponent(RiskAssessment.RiskAssessmentPredictionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RiskAssessment.RiskAssessmentPredictionComponent tgt = new RiskAssessment.RiskAssessmentPredictionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_50.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasProbability()) {
            tgt.setProbability(VersionConvertor_30_50.convertType(src.getProbability()));
        }
        if (src.hasQualitativeRisk()) {
            tgt.setQualitativeRisk(VersionConvertor_30_50.convertCodeableConcept(src.getQualitativeRisk()));
        }
        if (src.hasRelativeRisk()) {
            tgt.setRelativeRiskElement(VersionConvertor_30_50.convertDecimal(src.getRelativeRiskElement()));
        }
        if (src.hasWhen()) {
            tgt.setWhen(VersionConvertor_30_50.convertType(src.getWhen()));
        }
        if (src.hasRationale()) {
            tgt.setRationaleElement(VersionConvertor_30_50.convertString(src.getRationaleElement()));
        }
        return tgt;
    }

    public static RiskAssessment.RiskAssessmentPredictionComponent convertRiskAssessmentPredictionComponent(RiskAssessment.RiskAssessmentPredictionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RiskAssessment.RiskAssessmentPredictionComponent tgt = new RiskAssessment.RiskAssessmentPredictionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_50.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasProbability()) {
            tgt.setProbability(VersionConvertor_30_50.convertType(src.getProbability()));
        }
        if (src.hasQualitativeRisk()) {
            tgt.setQualitativeRisk(VersionConvertor_30_50.convertCodeableConcept(src.getQualitativeRisk()));
        }
        if (src.hasRelativeRisk()) {
            tgt.setRelativeRiskElement(VersionConvertor_30_50.convertDecimal(src.getRelativeRiskElement()));
        }
        if (src.hasWhen()) {
            tgt.setWhen(VersionConvertor_30_50.convertType(src.getWhen()));
        }
        if (src.hasRationale()) {
            tgt.setRationaleElement(VersionConvertor_30_50.convertString(src.getRationaleElement()));
        }
        return tgt;
    }

    public static Enumeration<Enumerations.ObservationStatus> convertRiskAssessmentStatus(org.hl7.fhir.dstu3.model.Enumeration<RiskAssessment.RiskAssessmentStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.ObservationStatus> tgt = new Enumeration<Enumerations.ObservationStatus>(new Enumerations.ObservationStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((RiskAssessment.RiskAssessmentStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)Enumerations.ObservationStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Enumerations.ObservationStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.CORRECTED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.ObservationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.ObservationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ObservationStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<RiskAssessment.RiskAssessmentStatus> convertRiskAssessmentStatus(Enumeration<Enumerations.ObservationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<RiskAssessment.RiskAssessmentStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<RiskAssessment.RiskAssessmentStatus>(new RiskAssessment.RiskAssessmentStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ObservationStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.CORRECTED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.NULL);
            }
        }
        return tgt;
    }
}

