/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import java.util.List;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.HumanName;

public class RelatedPerson30_50 {
    public static RelatedPerson convertRelatedPerson(org.hl7.fhir.r5.model.RelatedPerson src) throws FHIRException {
        List<CodeableConcept> relationships;
        if (src == null) {
            return null;
        }
        RelatedPerson tgt = new RelatedPerson();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(t));
        }
        if (src.hasActive() && src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasPatient() && src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_50.convertReference(src.getPatient()));
        }
        if ((relationships = src.getRelationship()).size() > 0) {
            tgt.setRelationship(VersionConvertor_30_50.convertCodeableConcept(relationships.get(0)));
            if (relationships.size() > 1) {
                // empty if block
            }
        }
        for (HumanName humanName : src.getName()) {
            tgt.addName(VersionConvertor_30_50.convertHumanName(humanName));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_30_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDate(tgt.getBirthDate());
        }
        for (org.hl7.fhir.r5.model.Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_50.convertAddress(address));
        }
        for (Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_30_50.convertAttachment(attachment));
        }
        if (src.hasPeriod() && src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.RelatedPerson convertRelatedPerson(RelatedPerson src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.RelatedPerson tgt = new org.hl7.fhir.r5.model.RelatedPerson();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasActive() && src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasPatient() && src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_50.convertReference(src.getPatient()));
        }
        if (src.hasRelationship() && src.hasRelationship()) {
            tgt.addRelationship(VersionConvertor_30_50.convertCodeableConcept(src.getRelationship()));
        }
        for (org.hl7.fhir.dstu3.model.HumanName humanName : src.getName()) {
            tgt.addName(VersionConvertor_30_50.convertHumanName(humanName));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_30_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDate(tgt.getBirthDate());
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_50.convertAddress(address));
        }
        for (org.hl7.fhir.dstu3.model.Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_30_50.convertAttachment(attachment));
        }
        if (src.hasPeriod() && src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }
}

