/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Provenance;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Signature;

public class Provenance30_50
extends VersionConvertor_30_50 {
    public static Provenance convertProvenance(org.hl7.fhir.dstu3.model.Provenance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance tgt = new Provenance();
        Provenance30_50.copyDomainResource(src, tgt, new String[0]);
        for (Reference reference : src.getTarget()) {
            tgt.addTarget(Provenance30_50.convertReference(reference));
        }
        if (src.hasPeriod()) {
            tgt.setOccurred(Provenance30_50.convertType(src.getPeriod()));
        }
        if (src.hasRecorded()) {
            tgt.setRecordedElement(Provenance30_50.convertInstant(src.getRecordedElement()));
        }
        for (UriType uriType : src.getPolicy()) {
            tgt.getPolicy().add(Provenance30_50.convertUri(uriType));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Provenance30_50.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.dstu3.model.Coding coding : src.getReason()) {
            tgt.addReason().addCoding(Provenance30_50.convertCoding(coding));
        }
        if (src.hasActivity()) {
            tgt.getActivity().addCoding(Provenance30_50.convertCoding(src.getActivity()));
        }
        for (Provenance.ProvenanceAgentComponent provenanceAgentComponent : src.getAgent()) {
            tgt.addAgent(Provenance30_50.convertProvenanceAgentComponent(provenanceAgentComponent));
        }
        for (Provenance.ProvenanceEntityComponent provenanceEntityComponent : src.getEntity()) {
            tgt.addEntity(Provenance30_50.convertProvenanceEntityComponent(provenanceEntityComponent));
        }
        for (org.hl7.fhir.dstu3.model.Signature signature : src.getSignature()) {
            tgt.addSignature(Provenance30_50.convertSignature(signature));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Provenance convertProvenance(Provenance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Provenance tgt = new org.hl7.fhir.dstu3.model.Provenance();
        Provenance30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Reference reference : src.getTarget()) {
            tgt.addTarget(Provenance30_50.convertReference(reference));
        }
        if (src.hasOccurredPeriod()) {
            tgt.setPeriod(Provenance30_50.convertPeriod(src.getOccurredPeriod()));
        }
        if (src.hasRecorded()) {
            tgt.setRecordedElement(Provenance30_50.convertInstant(src.getRecordedElement()));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getPolicy()) {
            tgt.getPolicy().add(Provenance30_50.convertUri(uriType));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Provenance30_50.convertReference(src.getLocation()));
        }
        for (CodeableConcept codeableConcept : src.getReason()) {
            for (Coding t2 : codeableConcept.getCoding()) {
                tgt.addReason(Provenance30_50.convertCoding(t2));
            }
        }
        if (src.hasActivity()) {
            tgt.setActivity(Provenance30_50.convertCoding(src.getActivity().getCodingFirstRep()));
        }
        for (Provenance.ProvenanceAgentComponent provenanceAgentComponent : src.getAgent()) {
            tgt.addAgent(Provenance30_50.convertProvenanceAgentComponent(provenanceAgentComponent));
        }
        for (Provenance.ProvenanceEntityComponent provenanceEntityComponent : src.getEntity()) {
            tgt.addEntity(Provenance30_50.convertProvenanceEntityComponent(provenanceEntityComponent));
        }
        for (Signature signature : src.getSignature()) {
            tgt.addSignature(Provenance30_50.convertSignature(signature));
        }
        return tgt;
    }

    public static Provenance.ProvenanceAgentComponent convertProvenanceAgentComponent(Provenance.ProvenanceAgentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceAgentComponent tgt = new Provenance.ProvenanceAgentComponent();
        Provenance30_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.CodeableConcept t : src.getRole()) {
            tgt.addRole(Provenance30_50.convertCodeableConcept(t));
        }
        if (src.hasWhoReference()) {
            tgt.setWho(Provenance30_50.convertReference(src.getWhoReference()));
        }
        if (src.hasOnBehalfOfReference()) {
            tgt.setOnBehalfOf(Provenance30_50.convertReference(src.getOnBehalfOfReference()));
        }
        return tgt;
    }

    public static Provenance.ProvenanceAgentComponent convertProvenanceAgentComponent(Provenance.ProvenanceAgentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceAgentComponent tgt = new Provenance.ProvenanceAgentComponent();
        Provenance30_50.copyElement(src, tgt, new String[0]);
        for (CodeableConcept t : src.getRole()) {
            tgt.addRole(Provenance30_50.convertCodeableConcept(t));
        }
        if (src.hasWho()) {
            tgt.setWho(Provenance30_50.convertReference(src.getWho()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(Provenance30_50.convertReference(src.getOnBehalfOf()));
        }
        return tgt;
    }

    public static Provenance.ProvenanceEntityComponent convertProvenanceEntityComponent(Provenance.ProvenanceEntityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceEntityComponent tgt = new Provenance.ProvenanceEntityComponent();
        Provenance30_50.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRoleElement(Provenance30_50.convertProvenanceEntityRole(src.getRoleElement()));
        }
        if (src.hasWhatReference()) {
            tgt.setWhat(Provenance30_50.convertReference(src.getWhatReference()));
        }
        for (Provenance.ProvenanceAgentComponent t : src.getAgent()) {
            tgt.addAgent(Provenance30_50.convertProvenanceAgentComponent(t));
        }
        return tgt;
    }

    public static Provenance.ProvenanceEntityComponent convertProvenanceEntityComponent(Provenance.ProvenanceEntityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceEntityComponent tgt = new Provenance.ProvenanceEntityComponent();
        Provenance30_50.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRoleElement(Provenance30_50.convertProvenanceEntityRole(src.getRoleElement()));
        }
        if (src.hasWhat()) {
            tgt.setWhat(Provenance30_50.convertReference(src.getWhat()));
        }
        for (Provenance.ProvenanceAgentComponent t : src.getAgent()) {
            tgt.addAgent(Provenance30_50.convertProvenanceAgentComponent(t));
        }
        return tgt;
    }

    public static Enumeration<Provenance.ProvenanceEntityRole> convertProvenanceEntityRole(org.hl7.fhir.dstu3.model.Enumeration<Provenance.ProvenanceEntityRole> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Provenance.ProvenanceEntityRole> tgt = new Enumeration<Provenance.ProvenanceEntityRole>(new Provenance.ProvenanceEntityRoleEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Provenance.ProvenanceEntityRole)((Object)src.getValue())) {
            case DERIVATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.DERIVATION);
                break;
            }
            case REVISION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.REVISION);
                break;
            }
            case QUOTATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.QUOTATION);
                break;
            }
            case SOURCE: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.SOURCE);
                break;
            }
            case REMOVAL: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.REMOVAL);
                break;
            }
            default: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Provenance.ProvenanceEntityRole> convertProvenanceEntityRole(Enumeration<Provenance.ProvenanceEntityRole> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Provenance.ProvenanceEntityRole> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Provenance.ProvenanceEntityRole>(new Provenance.ProvenanceEntityRoleEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Provenance.ProvenanceEntityRole)((Object)src.getValue())) {
            case DERIVATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.DERIVATION);
                break;
            }
            case REVISION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.REVISION);
                break;
            }
            case QUOTATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.QUOTATION);
                break;
            }
            case SOURCE: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.SOURCE);
                break;
            }
            case REMOVAL: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.REMOVAL);
                break;
            }
            default: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.NULL);
            }
        }
        return tgt;
    }
}

