/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.Practitioner;

public class Practitioner30_50 {
    public static org.hl7.fhir.r5.model.Practitioner convertPractitioner(Practitioner src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Practitioner tgt = new org.hl7.fhir.r5.model.Practitioner();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        for (org.hl7.fhir.dstu3.model.HumanName humanName : src.getName()) {
            tgt.addName(VersionConvertor_30_50.convertHumanName(humanName));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(contactPoint));
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_50.convertAddress(address));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_30_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDateElement(VersionConvertor_30_50.convertDate(src.getBirthDateElement()));
        }
        for (org.hl7.fhir.dstu3.model.Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_30_50.convertAttachment(attachment));
        }
        for (Practitioner.PractitionerQualificationComponent practitionerQualificationComponent : src.getQualification()) {
            tgt.addQualification(Practitioner30_50.convertPractitionerQualificationComponent(practitionerQualificationComponent));
        }
        for (CodeableConcept codeableConcept : src.getCommunication()) {
            tgt.addCommunication(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static Practitioner convertPractitioner(org.hl7.fhir.r5.model.Practitioner src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Practitioner tgt = new Practitioner();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        for (HumanName humanName : src.getName()) {
            tgt.addName(VersionConvertor_30_50.convertHumanName(humanName));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(contactPoint));
        }
        for (org.hl7.fhir.r5.model.Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_50.convertAddress(address));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_30_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDateElement(VersionConvertor_30_50.convertDate(src.getBirthDateElement()));
        }
        for (Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_30_50.convertAttachment(attachment));
        }
        for (Practitioner.PractitionerQualificationComponent practitionerQualificationComponent : src.getQualification()) {
            tgt.addQualification(Practitioner30_50.convertPractitionerQualificationComponent(practitionerQualificationComponent));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getCommunication()) {
            tgt.addCommunication(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static Practitioner.PractitionerQualificationComponent convertPractitionerQualificationComponent(Practitioner.PractitionerQualificationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Practitioner.PractitionerQualificationComponent tgt = new Practitioner.PractitionerQualificationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasIssuer()) {
            tgt.setIssuer(VersionConvertor_30_50.convertReference(src.getIssuer()));
        }
        return tgt;
    }

    public static Practitioner.PractitionerQualificationComponent convertPractitionerQualificationComponent(Practitioner.PractitionerQualificationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Practitioner.PractitionerQualificationComponent tgt = new Practitioner.PractitionerQualificationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasIssuer()) {
            tgt.setIssuer(VersionConvertor_30_50.convertReference(src.getIssuer()));
        }
        return tgt;
    }
}

