/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Person;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.Person;

public class Person30_50 {
    public static org.hl7.fhir.dstu3.model.Enumeration<Person.IdentityAssuranceLevel> convertIdentityAssuranceLevel(Enumeration<Person.IdentityAssuranceLevel> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Person.IdentityAssuranceLevel> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Person.IdentityAssuranceLevel>(new Person.IdentityAssuranceLevelEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Person.IdentityAssuranceLevel)((Object)src.getValue())) {
            case LEVEL1: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL1);
                break;
            }
            case LEVEL2: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL2);
                break;
            }
            case LEVEL3: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL3);
                break;
            }
            case LEVEL4: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL4);
                break;
            }
            default: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Person.IdentityAssuranceLevel> convertIdentityAssuranceLevel(org.hl7.fhir.dstu3.model.Enumeration<Person.IdentityAssuranceLevel> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Person.IdentityAssuranceLevel> tgt = new Enumeration<Person.IdentityAssuranceLevel>(new Person.IdentityAssuranceLevelEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Person.IdentityAssuranceLevel)((Object)src.getValue())) {
            case LEVEL1: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL1);
                break;
            }
            case LEVEL2: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL2);
                break;
            }
            case LEVEL3: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL3);
                break;
            }
            case LEVEL4: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL4);
                break;
            }
            default: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Person convertPerson(Person src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Person tgt = new org.hl7.fhir.dstu3.model.Person();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        for (HumanName humanName : src.getName()) {
            tgt.addName(VersionConvertor_30_50.convertHumanName(humanName));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_30_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDateElement(VersionConvertor_30_50.convertDate(src.getBirthDateElement()));
        }
        for (org.hl7.fhir.r5.model.Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_50.convertAddress(address));
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_30_50.convertAttachment(src.getPhoto()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_50.convertReference(src.getManagingOrganization()));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        for (Person.PersonLinkComponent personLinkComponent : src.getLink()) {
            tgt.addLink(Person30_50.convertPersonLinkComponent(personLinkComponent));
        }
        return tgt;
    }

    public static Person convertPerson(org.hl7.fhir.dstu3.model.Person src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Person tgt = new Person();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.dstu3.model.HumanName humanName : src.getName()) {
            tgt.addName(VersionConvertor_30_50.convertHumanName(humanName));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_30_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDateElement(VersionConvertor_30_50.convertDate(src.getBirthDateElement()));
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_50.convertAddress(address));
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_30_50.convertAttachment(src.getPhoto()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_50.convertReference(src.getManagingOrganization()));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        for (Person.PersonLinkComponent personLinkComponent : src.getLink()) {
            tgt.addLink(Person30_50.convertPersonLinkComponent(personLinkComponent));
        }
        return tgt;
    }

    public static Person.PersonLinkComponent convertPersonLinkComponent(Person.PersonLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Person.PersonLinkComponent tgt = new Person.PersonLinkComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_50.convertReference(src.getTarget()));
        }
        if (src.hasAssurance()) {
            tgt.setAssuranceElement(Person30_50.convertIdentityAssuranceLevel(src.getAssuranceElement()));
        }
        return tgt;
    }

    public static Person.PersonLinkComponent convertPersonLinkComponent(Person.PersonLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Person.PersonLinkComponent tgt = new Person.PersonLinkComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_50.convertReference(src.getTarget()));
        }
        if (src.hasAssurance()) {
            tgt.setAssuranceElement(Person30_50.convertIdentityAssuranceLevel(src.getAssuranceElement()));
        }
        return tgt;
    }
}

