/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.Patient;

public class Patient30_50 {
    public static Patient.AnimalComponent convertAnimalComponent(Extension src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.AnimalComponent tgt = new Patient.AnimalComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasExtension("species")) {
            tgt.setSpecies(VersionConvertor_30_50.convertCodeableConcept((CodeableConcept)src.getExtensionByUrl("species").getValue()));
        }
        if (src.hasExtension("breed")) {
            tgt.setBreed(VersionConvertor_30_50.convertCodeableConcept((CodeableConcept)src.getExtensionByUrl("breed").getValue()));
        }
        if (src.hasExtension("genderStatus")) {
            tgt.setGenderStatus(VersionConvertor_30_50.convertCodeableConcept((CodeableConcept)src.getExtensionByUrl("genderStatus").getValue()));
        }
        return tgt;
    }

    public static Extension convertAnimalComponent(Patient.AnimalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Extension tgt = new Extension();
        tgt.setUrl("http://hl7.org/fhir/StructureDefinition/patient-animal");
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSpecies()) {
            tgt.addExtension("species", VersionConvertor_30_50.convertCodeableConcept(src.getSpecies()));
        }
        if (src.hasBreed()) {
            tgt.addExtension("breed", VersionConvertor_30_50.convertCodeableConcept(src.getBreed()));
        }
        if (src.hasGenderStatus()) {
            tgt.addExtension("genderStatus", VersionConvertor_30_50.convertCodeableConcept(src.getGenderStatus()));
        }
        return tgt;
    }

    public static Patient.ContactComponent convertContactComponent(Patient.ContactComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.ContactComponent tgt = new Patient.ContactComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getRelationship()) {
            tgt.addRelationship(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setName(VersionConvertor_30_50.convertHumanName(src.getName()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(contactPoint));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_30_50.convertAddress(src.getAddress()));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_30_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(VersionConvertor_30_50.convertReference(src.getOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Patient.ContactComponent convertContactComponent(Patient.ContactComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.ContactComponent tgt = new Patient.ContactComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (CodeableConcept codeableConcept : src.getRelationship()) {
            tgt.addRelationship(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setName(VersionConvertor_30_50.convertHumanName(src.getName()));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(contactPoint));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_30_50.convertAddress(src.getAddress()));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_30_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(VersionConvertor_30_50.convertReference(src.getOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Patient.LinkType> convertLinkType(Enumeration<Patient.LinkType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Patient.LinkType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Patient.LinkType>(new Patient.LinkTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Patient.LinkType)((Object)src.getValue())) {
            case REPLACEDBY: {
                tgt.setValue((Object)Patient.LinkType.REPLACEDBY);
                break;
            }
            case REPLACES: {
                tgt.setValue((Object)Patient.LinkType.REPLACES);
                break;
            }
            case REFER: {
                tgt.setValue((Object)Patient.LinkType.REFER);
                break;
            }
            case SEEALSO: {
                tgt.setValue((Object)Patient.LinkType.SEEALSO);
                break;
            }
            default: {
                tgt.setValue((Object)Patient.LinkType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Patient.LinkType> convertLinkType(org.hl7.fhir.dstu3.model.Enumeration<Patient.LinkType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Patient.LinkType> tgt = new Enumeration<Patient.LinkType>(new Patient.LinkTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Patient.LinkType)((Object)src.getValue())) {
            case REPLACEDBY: {
                tgt.setValue((Object)Patient.LinkType.REPLACEDBY);
                break;
            }
            case REPLACES: {
                tgt.setValue((Object)Patient.LinkType.REPLACES);
                break;
            }
            case REFER: {
                tgt.setValue((Object)Patient.LinkType.REFER);
                break;
            }
            case SEEALSO: {
                tgt.setValue((Object)Patient.LinkType.SEEALSO);
                break;
            }
            default: {
                tgt.setValue((Object)Patient.LinkType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Patient convertPatient(Patient src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Patient tgt = new org.hl7.fhir.r5.model.Patient();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        for (org.hl7.fhir.dstu3.model.HumanName humanName : src.getName()) {
            tgt.addName(VersionConvertor_30_50.convertHumanName(humanName));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_30_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDateElement(VersionConvertor_30_50.convertDate(src.getBirthDateElement()));
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(VersionConvertor_30_50.convertType(src.getDeceased()));
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_50.convertAddress(address));
        }
        if (src.hasMaritalStatus()) {
            tgt.setMaritalStatus(VersionConvertor_30_50.convertCodeableConcept(src.getMaritalStatus()));
        }
        if (src.hasMultipleBirth()) {
            tgt.setMultipleBirth(VersionConvertor_30_50.convertType(src.getMultipleBirth()));
        }
        for (org.hl7.fhir.dstu3.model.Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_30_50.convertAttachment(attachment));
        }
        for (Patient.ContactComponent contactComponent : src.getContact()) {
            tgt.addContact(Patient30_50.convertContactComponent(contactComponent));
        }
        if (src.hasAnimal()) {
            tgt.addExtension(Patient30_50.convertAnimalComponent(src.getAnimal()));
        }
        for (Patient.PatientCommunicationComponent patientCommunicationComponent : src.getCommunication()) {
            tgt.addCommunication(Patient30_50.convertPatientCommunicationComponent(patientCommunicationComponent));
        }
        for (Reference reference : src.getGeneralPractitioner()) {
            tgt.addGeneralPractitioner(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_50.convertReference(src.getManagingOrganization()));
        }
        for (Patient.PatientLinkComponent patientLinkComponent : src.getLink()) {
            tgt.addLink(Patient30_50.convertPatientLinkComponent(patientLinkComponent));
        }
        return tgt;
    }

    public static Patient convertPatient(org.hl7.fhir.r5.model.Patient src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient tgt = new Patient();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        for (HumanName humanName : src.getName()) {
            tgt.addName(VersionConvertor_30_50.convertHumanName(humanName));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_30_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDateElement(VersionConvertor_30_50.convertDate(src.getBirthDateElement()));
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(VersionConvertor_30_50.convertType(src.getDeceased()));
        }
        for (org.hl7.fhir.r5.model.Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_50.convertAddress(address));
        }
        if (src.hasMaritalStatus()) {
            tgt.setMaritalStatus(VersionConvertor_30_50.convertCodeableConcept(src.getMaritalStatus()));
        }
        if (src.hasMultipleBirth()) {
            tgt.setMultipleBirth(VersionConvertor_30_50.convertType(src.getMultipleBirth()));
        }
        for (Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_30_50.convertAttachment(attachment));
        }
        for (Patient.ContactComponent contactComponent : src.getContact()) {
            tgt.addContact(Patient30_50.convertContactComponent(contactComponent));
        }
        if (src.hasExtension("http://hl7.org/fhir/StructureDefinition/patient-animal")) {
            tgt.setAnimal(Patient30_50.convertAnimalComponent(src.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/patient-animal")));
        }
        for (Patient.PatientCommunicationComponent patientCommunicationComponent : src.getCommunication()) {
            tgt.addCommunication(Patient30_50.convertPatientCommunicationComponent(patientCommunicationComponent));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getGeneralPractitioner()) {
            tgt.addGeneralPractitioner(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_50.convertReference(src.getManagingOrganization()));
        }
        for (Patient.PatientLinkComponent patientLinkComponent : src.getLink()) {
            tgt.addLink(Patient30_50.convertPatientLinkComponent(patientLinkComponent));
        }
        return tgt;
    }

    public static Patient.PatientCommunicationComponent convertPatientCommunicationComponent(Patient.PatientCommunicationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.PatientCommunicationComponent tgt = new Patient.PatientCommunicationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguage(VersionConvertor_30_50.convertCodeableConcept(src.getLanguage()));
        }
        if (src.hasPreferred()) {
            tgt.setPreferredElement(VersionConvertor_30_50.convertBoolean(src.getPreferredElement()));
        }
        return tgt;
    }

    public static Patient.PatientCommunicationComponent convertPatientCommunicationComponent(Patient.PatientCommunicationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.PatientCommunicationComponent tgt = new Patient.PatientCommunicationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguage(VersionConvertor_30_50.convertCodeableConcept(src.getLanguage()));
        }
        if (src.hasPreferred()) {
            tgt.setPreferredElement(VersionConvertor_30_50.convertBoolean(src.getPreferredElement()));
        }
        return tgt;
    }

    public static Patient.PatientLinkComponent convertPatientLinkComponent(Patient.PatientLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.PatientLinkComponent tgt = new Patient.PatientLinkComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOther()) {
            tgt.setOther(VersionConvertor_30_50.convertReference(src.getOther()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Patient30_50.convertLinkType(src.getTypeElement()));
        }
        return tgt;
    }

    public static Patient.PatientLinkComponent convertPatientLinkComponent(Patient.PatientLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.PatientLinkComponent tgt = new Patient.PatientLinkComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOther()) {
            tgt.setOther(VersionConvertor_30_50.convertReference(src.getOther()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Patient30_50.convertLinkType(src.getTypeElement()));
        }
        return tgt;
    }
}

