/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.StringType;

public class Organization30_50 {
    public static org.hl7.fhir.r5.model.Organization convertOrganization(Organization src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Organization tgt = new org.hl7.fhir.r5.model.Organization();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu3.model.StringType stringType : src.getAlias()) {
            tgt.addAlias((String)stringType.getValue());
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(contactPoint));
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_50.convertAddress(address));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_30_50.convertReference(src.getPartOf()));
        }
        for (Organization.OrganizationContactComponent organizationContactComponent : src.getContact()) {
            tgt.addContact(Organization30_50.convertOrganizationContactComponent(organizationContactComponent));
        }
        for (Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static Organization convertOrganization(org.hl7.fhir.r5.model.Organization src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Organization tgt = new Organization();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        for (StringType stringType : src.getAlias()) {
            tgt.addAlias((String)stringType.getValue());
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(contactPoint));
        }
        for (org.hl7.fhir.r5.model.Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_50.convertAddress(address));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_30_50.convertReference(src.getPartOf()));
        }
        for (Organization.OrganizationContactComponent organizationContactComponent : src.getContact()) {
            tgt.addContact(Organization30_50.convertOrganizationContactComponent(organizationContactComponent));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static Organization.OrganizationContactComponent convertOrganizationContactComponent(Organization.OrganizationContactComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Organization.OrganizationContactComponent tgt = new Organization.OrganizationContactComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasPurpose()) {
            tgt.setPurpose(VersionConvertor_30_50.convertCodeableConcept(src.getPurpose()));
        }
        if (src.hasName()) {
            tgt.setName(VersionConvertor_30_50.convertHumanName(src.getName()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_30_50.convertAddress(src.getAddress()));
        }
        return tgt;
    }

    public static Organization.OrganizationContactComponent convertOrganizationContactComponent(Organization.OrganizationContactComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Organization.OrganizationContactComponent tgt = new Organization.OrganizationContactComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasPurpose()) {
            tgt.setPurpose(VersionConvertor_30_50.convertCodeableConcept(src.getPurpose()));
        }
        if (src.hasName()) {
            tgt.setName(VersionConvertor_30_50.convertHumanName(src.getName()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_30_50.convertAddress(src.getAddress()));
        }
        return tgt;
    }
}

