/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.NamingSystem;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.NamingSystem;

public class NamingSystem30_50 {
    public static NamingSystem convertNamingSystem(org.hl7.fhir.r5.model.NamingSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NamingSystem tgt = new NamingSystem();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(NamingSystem30_50.convertNamingSystemType(src.getKindElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasResponsible()) {
            tgt.setResponsibleElement(VersionConvertor_30_50.convertString(src.getResponsibleElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(VersionConvertor_30_50.convertString(src.getUsageElement()));
        }
        for (NamingSystem.NamingSystemUniqueIdComponent namingSystemUniqueIdComponent : src.getUniqueId()) {
            tgt.addUniqueId(NamingSystem30_50.convertNamingSystemUniqueIdComponent(namingSystemUniqueIdComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.NamingSystem convertNamingSystem(NamingSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.NamingSystem tgt = new org.hl7.fhir.r5.model.NamingSystem();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(NamingSystem30_50.convertNamingSystemType(src.getKindElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasResponsible()) {
            tgt.setResponsibleElement(VersionConvertor_30_50.convertString(src.getResponsibleElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(VersionConvertor_30_50.convertString(src.getUsageElement()));
        }
        for (NamingSystem.NamingSystemUniqueIdComponent namingSystemUniqueIdComponent : src.getUniqueId()) {
            tgt.addUniqueId(NamingSystem30_50.convertNamingSystemUniqueIdComponent(namingSystemUniqueIdComponent));
        }
        return tgt;
    }

    public static Enumeration<NamingSystem.NamingSystemIdentifierType> convertNamingSystemIdentifierType(org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemIdentifierType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<NamingSystem.NamingSystemIdentifierType> tgt = new Enumeration<NamingSystem.NamingSystemIdentifierType>(new NamingSystem.NamingSystemIdentifierTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((NamingSystem.NamingSystemIdentifierType)((Object)src.getValue())) {
            case OID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OID);
                break;
            }
            case UUID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.UUID);
                break;
            }
            case URI: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.URI);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemIdentifierType> convertNamingSystemIdentifierType(Enumeration<NamingSystem.NamingSystemIdentifierType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemIdentifierType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemIdentifierType>(new NamingSystem.NamingSystemIdentifierTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((NamingSystem.NamingSystemIdentifierType)((Object)src.getValue())) {
            case OID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OID);
                break;
            }
            case UUID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.UUID);
                break;
            }
            case URI: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.URI);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<NamingSystem.NamingSystemType> convertNamingSystemType(org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<NamingSystem.NamingSystemType> tgt = new Enumeration<NamingSystem.NamingSystemType>(new NamingSystem.NamingSystemTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((NamingSystem.NamingSystemType)((Object)src.getValue())) {
            case CODESYSTEM: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.CODESYSTEM);
                break;
            }
            case IDENTIFIER: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.IDENTIFIER);
                break;
            }
            case ROOT: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.ROOT);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemType> convertNamingSystemType(Enumeration<NamingSystem.NamingSystemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemType>(new NamingSystem.NamingSystemTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((NamingSystem.NamingSystemType)((Object)src.getValue())) {
            case CODESYSTEM: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.CODESYSTEM);
                break;
            }
            case IDENTIFIER: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.IDENTIFIER);
                break;
            }
            case ROOT: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.ROOT);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.NULL);
            }
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(NamingSystem30_50.convertNamingSystemIdentifierType(src.getTypeElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertString(src.getValueElement()));
        }
        if (src.hasPreferred()) {
            tgt.setPreferredElement(VersionConvertor_30_50.convertBoolean(src.getPreferredElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(NamingSystem30_50.convertNamingSystemIdentifierType(src.getTypeElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertString(src.getValueElement()));
        }
        if (src.hasPreferred()) {
            tgt.setPreferredElement(VersionConvertor_30_50.convertBoolean(src.getPreferredElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }
}

