/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.MessageDefinition;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.MessageDefinition;

public class MessageDefinition30_50 {
    public static MessageDefinition convertMessageDefinition(org.hl7.fhir.r5.model.MessageDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageDefinition tgt = new MessageDefinition();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_30_50.convertCanonicalToReference(src.getBaseElement()));
        }
        for (CanonicalType canonicalType : src.getParent()) {
            tgt.addParent(VersionConvertor_30_50.convertCanonicalToReference(canonicalType));
        }
        for (CanonicalType canonicalType : src.getReplaces()) {
            tgt.addReplaces(VersionConvertor_30_50.convertCanonicalToReference(canonicalType));
        }
        if (src.hasEventCoding()) {
            tgt.setEvent(VersionConvertor_30_50.convertCoding(src.getEventCoding()));
        }
        if (src.hasCategory()) {
            tgt.setCategoryElement(MessageDefinition30_50.convertMessageSignificanceCategory(src.getCategoryElement()));
        }
        for (MessageDefinition.MessageDefinitionFocusComponent messageDefinitionFocusComponent : src.getFocus()) {
            tgt.addFocus(MessageDefinition30_50.convertMessageDefinitionFocusComponent(messageDefinitionFocusComponent));
        }
        if (src.hasResponseRequired()) {
            tgt.setResponseRequired(src.getResponseRequired() != MessageDefinition.MessageheaderResponseRequest.NEVER);
        }
        for (MessageDefinition.MessageDefinitionAllowedResponseComponent messageDefinitionAllowedResponseComponent : src.getAllowedResponse()) {
            tgt.addAllowedResponse(MessageDefinition30_50.convertMessageDefinitionAllowedResponseComponent(messageDefinitionAllowedResponseComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.MessageDefinition convertMessageDefinition(MessageDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.MessageDefinition tgt = new org.hl7.fhir.r5.model.MessageDefinition();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasBase()) {
            tgt.setBaseElement(VersionConvertor_30_50.convertReferenceToCanonical(src.getBase()));
        }
        for (Reference reference : src.getParent()) {
            tgt.getParent().add(VersionConvertor_30_50.convertReferenceToCanonical(reference));
        }
        for (Reference reference : src.getReplaces()) {
            tgt.getReplaces().add(VersionConvertor_30_50.convertReferenceToCanonical(reference));
        }
        if (src.hasEvent()) {
            tgt.setEvent(VersionConvertor_30_50.convertCoding(src.getEvent()));
        }
        if (src.hasCategory()) {
            tgt.setCategoryElement(MessageDefinition30_50.convertMessageSignificanceCategory(src.getCategoryElement()));
        }
        for (MessageDefinition.MessageDefinitionFocusComponent messageDefinitionFocusComponent : src.getFocus()) {
            tgt.addFocus(MessageDefinition30_50.convertMessageDefinitionFocusComponent(messageDefinitionFocusComponent));
        }
        if (src.hasResponseRequired()) {
            tgt.setResponseRequired(src.getResponseRequired() ? MessageDefinition.MessageheaderResponseRequest.ALWAYS : MessageDefinition.MessageheaderResponseRequest.NEVER);
        }
        for (MessageDefinition.MessageDefinitionAllowedResponseComponent messageDefinitionAllowedResponseComponent : src.getAllowedResponse()) {
            tgt.addAllowedResponse(MessageDefinition30_50.convertMessageDefinitionAllowedResponseComponent(messageDefinitionAllowedResponseComponent));
        }
        return tgt;
    }

    public static MessageDefinition.MessageDefinitionAllowedResponseComponent convertMessageDefinitionAllowedResponseComponent(MessageDefinition.MessageDefinitionAllowedResponseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageDefinition.MessageDefinitionAllowedResponseComponent tgt = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasMessage()) {
            tgt.setMessage(VersionConvertor_30_50.convertCanonicalToReference(src.getMessageElement()));
        }
        if (src.hasSituation()) {
            tgt.setSituationElement(VersionConvertor_30_50.convertMarkdown(src.getSituationElement()));
        }
        return tgt;
    }

    public static MessageDefinition.MessageDefinitionAllowedResponseComponent convertMessageDefinitionAllowedResponseComponent(MessageDefinition.MessageDefinitionAllowedResponseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageDefinition.MessageDefinitionAllowedResponseComponent tgt = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasMessage()) {
            tgt.setMessageElement(VersionConvertor_30_50.convertReferenceToCanonical(src.getMessage()));
        }
        if (src.hasSituation()) {
            tgt.setSituationElement(VersionConvertor_30_50.convertMarkdown(src.getSituationElement()));
        }
        return tgt;
    }

    public static MessageDefinition.MessageDefinitionFocusComponent convertMessageDefinitionFocusComponent(MessageDefinition.MessageDefinitionFocusComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageDefinition.MessageDefinitionFocusComponent tgt = new MessageDefinition.MessageDefinitionFocusComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_30_50.convertCanonicalToReference(src.getProfileElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_50.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_50.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static MessageDefinition.MessageDefinitionFocusComponent convertMessageDefinitionFocusComponent(MessageDefinition.MessageDefinitionFocusComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageDefinition.MessageDefinitionFocusComponent tgt = new MessageDefinition.MessageDefinitionFocusComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(VersionConvertor_30_50.convertReferenceToCanonical(src.getProfile()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_50.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_50.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<MessageDefinition.MessageSignificanceCategory> convertMessageSignificanceCategory(Enumeration<MessageDefinition.MessageSignificanceCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MessageDefinition.MessageSignificanceCategory> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MessageDefinition.MessageSignificanceCategory>(new MessageDefinition.MessageSignificanceCategoryEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((MessageDefinition.MessageSignificanceCategory)((Object)src.getValue())) {
            case CONSEQUENCE: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.CONSEQUENCE);
                break;
            }
            case CURRENCY: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.CURRENCY);
                break;
            }
            case NOTIFICATION: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.NOTIFICATION);
                break;
            }
            default: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MessageDefinition.MessageSignificanceCategory> convertMessageSignificanceCategory(org.hl7.fhir.dstu3.model.Enumeration<MessageDefinition.MessageSignificanceCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MessageDefinition.MessageSignificanceCategory> tgt = new Enumeration<MessageDefinition.MessageSignificanceCategory>(new MessageDefinition.MessageSignificanceCategoryEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((MessageDefinition.MessageSignificanceCategory)((Object)src.getValue())) {
            case CONSEQUENCE: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.CONSEQUENCE);
                break;
            }
            case CURRENCY: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.CURRENCY);
                break;
            }
            case NOTIFICATION: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.NOTIFICATION);
                break;
            }
            default: {
                tgt.setValue((Object)MessageDefinition.MessageSignificanceCategory.NULL);
            }
        }
        return tgt;
    }
}

