/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Contributor;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.Measure;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Measure;

public class Measure30_50 {
    public static Measure convertMeasure(org.hl7.fhir.dstu3.model.Measure src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Measure tgt = new Measure();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasType()) {
            for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getType()) {
                tgt.addType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
            }
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(VersionConvertor_30_50.convertString(src.getUsageElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(VersionConvertor_30_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(VersionConvertor_30_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(VersionConvertor_30_50.convertPeriod(src.getEffectivePeriod()));
        }
        for (Contributor contributor : src.getContributor()) {
            if (contributor.getType() == Contributor.ContributorType.AUTHOR) {
                if (contributor.hasContact()) {
                    for (org.hl7.fhir.dstu3.model.ContactDetail c : contributor.getContact()) {
                        tgt.addAuthor(VersionConvertor_30_50.convertContactDetail(c));
                    }
                } else {
                    tgt.addAuthor(new ContactDetail().setName(contributor.getName()));
                }
            }
            if (contributor.getType() == Contributor.ContributorType.EDITOR) {
                if (contributor.hasContact()) {
                    for (org.hl7.fhir.dstu3.model.ContactDetail c : contributor.getContact()) {
                        tgt.addEditor(VersionConvertor_30_50.convertContactDetail(c).setName(contributor.hasName() ? contributor.getName() : null));
                    }
                } else {
                    tgt.addAuthor(new ContactDetail().setName(contributor.getName()));
                }
            }
            if (contributor.getType() == Contributor.ContributorType.REVIEWER) {
                if (contributor.hasContact()) {
                    for (org.hl7.fhir.dstu3.model.ContactDetail c : contributor.getContact()) {
                        tgt.addReviewer(VersionConvertor_30_50.convertContactDetail(c).setName(contributor.hasName() ? contributor.getName() : null));
                    }
                } else {
                    tgt.addAuthor(new ContactDetail().setName(contributor.getName()));
                }
            }
            if (contributor.getType() != Contributor.ContributorType.ENDORSER) continue;
            if (contributor.hasContact()) {
                for (org.hl7.fhir.dstu3.model.ContactDetail c : contributor.getContact()) {
                    tgt.addEndorser(VersionConvertor_30_50.convertContactDetail(c).setName(contributor.hasName() ? contributor.getName() : null));
                }
                continue;
            }
            tgt.addAuthor(new ContactDetail().setName(contributor.getName()));
        }
        for (RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(VersionConvertor_30_50.convertRelatedArtifact(relatedArtifact));
        }
        for (Reference reference : src.getLibrary()) {
            tgt.addLibrary(reference.getReference());
        }
        if (src.hasDisclaimer()) {
            tgt.setDisclaimerElement(VersionConvertor_30_50.convertMarkdown(src.getDisclaimerElement()));
        }
        if (src.hasScoring()) {
            tgt.setScoring(VersionConvertor_30_50.convertCodeableConcept(src.getScoring()));
        }
        if (src.hasCompositeScoring()) {
            tgt.setCompositeScoring(VersionConvertor_30_50.convertCodeableConcept(src.getCompositeScoring()));
        }
        if (src.hasRiskAdjustment()) {
            tgt.setRiskAdjustmentElement(VersionConvertor_30_50.convertString(src.getRiskAdjustmentElement()));
        }
        if (src.hasRateAggregation()) {
            tgt.setRateAggregationElement(VersionConvertor_30_50.convertString(src.getRateAggregationElement()));
        }
        if (src.hasRationale()) {
            tgt.setRationaleElement(VersionConvertor_30_50.convertMarkdown(src.getRationaleElement()));
        }
        if (src.hasClinicalRecommendationStatement()) {
            tgt.setClinicalRecommendationStatementElement(VersionConvertor_30_50.convertMarkdown(src.getClinicalRecommendationStatementElement()));
        }
        if (src.hasImprovementNotation()) {
            if (src.getImprovementNotation().toLowerCase().contains("increase") || src.getImprovementNotation().toLowerCase().contains("higher")) {
                tgt.setImprovementNotation(new CodeableConcept().addCoding(new Coding().setCode("increase").setSystem("http://terminology.hl7.org/CodeSystem/measure-improvement-notation")).setText(src.getImprovementNotation()));
            } else if (src.getImprovementNotation().toLowerCase().contains("decrease") || src.getImprovementNotation().toLowerCase().contains("lower")) {
                tgt.setImprovementNotation(new CodeableConcept().addCoding(new Coding().setCode("decrease").setSystem("http://terminology.hl7.org/CodeSystem/measure-improvement-notation")).setText(src.getImprovementNotation()));
            } else {
                tgt.setImprovementNotation(new CodeableConcept().setText(src.getImprovementNotation()));
            }
        }
        for (MarkdownType markdownType : src.getDefinition()) {
            tgt.addDefinition((String)markdownType.getValue());
        }
        if (src.hasGuidance()) {
            tgt.setGuidanceElement(VersionConvertor_30_50.convertMarkdown(src.getGuidanceElement()));
        }
        for (Measure.MeasureGroupComponent measureGroupComponent : src.getGroup()) {
            tgt.addGroup(Measure30_50.convertMeasureGroup(measureGroupComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Measure convertMeasure(Measure src) throws FHIRException {
        org.hl7.fhir.dstu3.model.ContactDetail cd2;
        Contributor con;
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Measure tgt = new org.hl7.fhir.dstu3.model.Measure();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasType()) {
            for (CodeableConcept codeableConcept : src.getType()) {
                tgt.addType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
            }
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(VersionConvertor_30_50.convertString(src.getUsageElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(VersionConvertor_30_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(VersionConvertor_30_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(VersionConvertor_30_50.convertPeriod(src.getEffectivePeriod()));
        }
        if (src.hasAuthor()) {
            for (ContactDetail contactDetail : src.getAuthor()) {
                org.hl7.fhir.dstu3.model.ContactDetail cd22 = VersionConvertor_30_50.convertContactDetail(contactDetail);
                con = new Contributor().setType(Contributor.ContributorType.AUTHOR);
                if (cd22.hasName()) {
                    con.setName(cd22.getName());
                }
                tgt.addContributor(con);
            }
        }
        if (src.hasEditor()) {
            for (ContactDetail contactDetail : src.getAuthor()) {
                cd2 = VersionConvertor_30_50.convertContactDetail(contactDetail);
                con = new Contributor().setType(Contributor.ContributorType.EDITOR);
                if (cd2.hasName()) {
                    con.setName(cd2.getName());
                }
                tgt.addContributor(con);
            }
        }
        if (src.hasReviewer()) {
            for (ContactDetail contactDetail : src.getAuthor()) {
                cd2 = VersionConvertor_30_50.convertContactDetail(contactDetail);
                con = new Contributor().setType(Contributor.ContributorType.REVIEWER);
                if (cd2.hasName()) {
                    con.setName(cd2.getName());
                }
                tgt.addContributor(con);
            }
        }
        if (src.hasEndorser()) {
            for (ContactDetail contactDetail : src.getAuthor()) {
                cd2 = VersionConvertor_30_50.convertContactDetail(contactDetail);
                con = new Contributor().setType(Contributor.ContributorType.ENDORSER);
                if (cd2.hasName()) {
                    con.setName(cd2.getName());
                }
                tgt.addContributor(con);
            }
        }
        for (org.hl7.fhir.r5.model.RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(VersionConvertor_30_50.convertRelatedArtifact(relatedArtifact));
        }
        for (CanonicalType canonicalType : src.getLibrary()) {
            tgt.addLibrary(VersionConvertor_30_50.convertCanonicalToReference(canonicalType));
        }
        if (src.hasDisclaimer()) {
            tgt.setDisclaimerElement(VersionConvertor_30_50.convertMarkdown(src.getDisclaimerElement()));
        }
        if (src.hasScoring()) {
            tgt.setScoring(VersionConvertor_30_50.convertCodeableConcept(src.getScoring()));
        }
        if (src.hasCompositeScoring()) {
            tgt.setCompositeScoring(VersionConvertor_30_50.convertCodeableConcept(src.getCompositeScoring()));
        }
        if (src.hasRiskAdjustment()) {
            tgt.setRiskAdjustmentElement(VersionConvertor_30_50.convertString(src.getRiskAdjustmentElement()));
        }
        if (src.hasRateAggregation()) {
            tgt.setRateAggregationElement(VersionConvertor_30_50.convertString(src.getRateAggregationElement()));
        }
        if (src.hasRationale()) {
            tgt.setRationaleElement(VersionConvertor_30_50.convertMarkdown(src.getRationaleElement()));
        }
        if (src.hasClinicalRecommendationStatement()) {
            tgt.setClinicalRecommendationStatementElement(VersionConvertor_30_50.convertMarkdown(src.getClinicalRecommendationStatementElement()));
        }
        if (src.hasImprovementNotation()) {
            for (Coding coding : src.getImprovementNotation().getCoding()) {
                if (coding.hasCode() && coding.getCode().equals("increase")) {
                    tgt.setImprovementNotation(coding.getCode());
                    continue;
                }
                if (!coding.hasCode() || !coding.getCode().equals("decrease")) continue;
                tgt.setImprovementNotation(coding.getCode());
            }
        }
        for (org.hl7.fhir.r5.model.MarkdownType markdownType : src.getDefinition()) {
            tgt.addDefinition((String)markdownType.getValue());
        }
        if (src.hasGuidance()) {
            tgt.setGuidanceElement(VersionConvertor_30_50.convertMarkdown(src.getGuidanceElement()));
        }
        for (Measure.MeasureGroupComponent measureGroupComponent : src.getGroup()) {
            tgt.addGroup(Measure30_50.convertMeasureGroup(measureGroupComponent));
        }
        return tgt;
    }

    public static Measure.MeasureGroupComponent convertMeasureGroup(Measure.MeasureGroupComponent src) {
        if (src == null) {
            return null;
        }
        Measure.MeasureGroupComponent tgt = new Measure.MeasureGroupComponent();
        if (src.hasCode() && src.getCode().hasCoding()) {
            tgt.setIdentifier(new Identifier().setValue(src.getCode().getCodingFirstRep().getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        for (Measure.MeasureGroupPopulationComponent p : src.getPopulation()) {
            tgt.addPopulation(Measure30_50.convertMeasureGroupPopulation(p));
        }
        for (Measure.MeasureGroupStratifierComponent s2 : src.getStratifier()) {
            tgt.addStratifier(Measure30_50.convertMeasureGroupStratifier(s2));
        }
        return tgt;
    }

    public static Measure.MeasureGroupComponent convertMeasureGroup(Measure.MeasureGroupComponent src) {
        if (src == null) {
            return null;
        }
        Measure.MeasureGroupComponent tgt = new Measure.MeasureGroupComponent();
        if (src.hasIdentifier()) {
            tgt.setCode(new CodeableConcept().addCoding(new Coding().setCode(src.getIdentifier().getValue())));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        for (Measure.MeasureGroupPopulationComponent p : src.getPopulation()) {
            tgt.addPopulation(Measure30_50.convertMeasureGroupPopulation(p));
        }
        for (Measure.MeasureGroupStratifierComponent s2 : src.getStratifier()) {
            tgt.addStratifier(Measure30_50.convertMeasureGroupStratifier(s2));
        }
        return tgt;
    }

    public static Measure.MeasureGroupPopulationComponent convertMeasureGroupPopulation(Measure.MeasureGroupPopulationComponent src) {
        if (src == null) {
            return null;
        }
        Measure.MeasureGroupPopulationComponent tgt = new Measure.MeasureGroupPopulationComponent();
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasCriteria() && src.getCriteria().hasExpression()) {
            tgt.setCriteria(src.getCriteria().getExpression());
        }
        if (src.hasCriteria() && src.getCriteria().hasName()) {
            tgt.setName(src.getCriteria().getName());
        }
        return tgt;
    }

    public static Measure.MeasureGroupPopulationComponent convertMeasureGroupPopulation(Measure.MeasureGroupPopulationComponent src) {
        if (src == null) {
            return null;
        }
        Measure.MeasureGroupPopulationComponent tgt = new Measure.MeasureGroupPopulationComponent();
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasCriteria()) {
            tgt.setCriteria(new Expression().setExpression(src.getCriteria()));
        }
        if (src.hasName()) {
            if (tgt.hasCriteria()) {
                tgt.getCriteria().setName(src.getName());
            } else {
                tgt.setCriteria(new Expression().setName(src.getName()));
            }
        }
        return tgt;
    }

    public static Measure.MeasureGroupStratifierComponent convertMeasureGroupStratifier(Measure.MeasureGroupStratifierComponent src) {
        if (src == null) {
            return null;
        }
        Measure.MeasureGroupStratifierComponent tgt = new Measure.MeasureGroupStratifierComponent();
        if (src.hasIdentifier()) {
            tgt.setCode(new CodeableConcept().addCoding(new Coding().setCode(src.getIdentifier().getValue())));
        }
        if (src.hasCriteria()) {
            tgt.setCriteria(new Expression().setExpression(src.getCriteria()));
        }
        return tgt;
    }

    public static Measure.MeasureGroupStratifierComponent convertMeasureGroupStratifier(Measure.MeasureGroupStratifierComponent src) {
        if (src == null) {
            return null;
        }
        Measure.MeasureGroupStratifierComponent tgt = new Measure.MeasureGroupStratifierComponent();
        if (src.hasCode() && src.getCode().hasCoding()) {
            tgt.setIdentifier(new Identifier().setValue(src.getCode().getCodingFirstRep().getCode()));
        }
        if (src.hasCriteria() && src.getCriteria().hasExpression()) {
            tgt.setCriteria(src.getCriteria().getExpression());
        }
        return tgt;
    }
}

