/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.ListResource;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ListResource;

public class List30_50 {
    public static ListResource convertList(org.hl7.fhir.dstu3.model.ListResource src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ListResource tgt = new ListResource();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(List30_50.convertListStatus(src.getStatusElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(List30_50.convertListMode(src.getModeElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_50.convertReference(src.getEncounter()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_50.convertReference(src.getSource()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_30_50.convertCodeableConcept(src.getOrderedBy()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        for (ListResource.ListEntryComponent listEntryComponent : src.getEntry()) {
            tgt.addEntry(List30_50.convertListEntryComponent(listEntryComponent));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(VersionConvertor_30_50.convertCodeableConcept(src.getEmptyReason()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ListResource convertList(ListResource src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ListResource tgt = new org.hl7.fhir.dstu3.model.ListResource();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(List30_50.convertListStatus(src.getStatusElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(List30_50.convertListMode(src.getModeElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_50.convertReference(src.getEncounter()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_50.convertReference(src.getSource()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_30_50.convertCodeableConcept(src.getOrderedBy()));
        }
        for (org.hl7.fhir.r5.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        for (ListResource.ListResourceEntryComponent listResourceEntryComponent : src.getEntry()) {
            tgt.addEntry(List30_50.convertListEntryComponent(listResourceEntryComponent));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(VersionConvertor_30_50.convertCodeableConcept(src.getEmptyReason()));
        }
        return tgt;
    }

    public static ListResource.ListResourceEntryComponent convertListEntryComponent(ListResource.ListEntryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ListResource.ListResourceEntryComponent tgt = new ListResource.ListResourceEntryComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasFlag()) {
            tgt.setFlag(VersionConvertor_30_50.convertCodeableConcept(src.getFlag()));
        }
        if (src.hasDeleted()) {
            tgt.setDeletedElement(VersionConvertor_30_50.convertBoolean(src.getDeletedElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_30_50.convertReference(src.getItem()));
        }
        return tgt;
    }

    public static ListResource.ListEntryComponent convertListEntryComponent(ListResource.ListResourceEntryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ListResource.ListEntryComponent tgt = new ListResource.ListEntryComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasFlag()) {
            tgt.setFlag(VersionConvertor_30_50.convertCodeableConcept(src.getFlag()));
        }
        if (src.hasDeleted()) {
            tgt.setDeletedElement(VersionConvertor_30_50.convertBoolean(src.getDeletedElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_30_50.convertReference(src.getItem()));
        }
        return tgt;
    }

    public static Enumeration<Enumerations.ListMode> convertListMode(org.hl7.fhir.dstu3.model.Enumeration<ListResource.ListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.ListMode> tgt = new Enumeration<Enumerations.ListMode>(new Enumerations.ListModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((ListResource.ListMode)((Object)src.getValue())) {
            case WORKING: {
                tgt.setValue((Object)Enumerations.ListMode.WORKING);
                break;
            }
            case SNAPSHOT: {
                tgt.setValue((Object)Enumerations.ListMode.SNAPSHOT);
                break;
            }
            case CHANGES: {
                tgt.setValue((Object)Enumerations.ListMode.CHANGES);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ListMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ListResource.ListMode> convertListMode(Enumeration<Enumerations.ListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ListResource.ListMode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ListResource.ListMode>(new ListResource.ListModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ListMode)((Object)src.getValue())) {
            case WORKING: {
                tgt.setValue((Object)ListResource.ListMode.WORKING);
                break;
            }
            case SNAPSHOT: {
                tgt.setValue((Object)ListResource.ListMode.SNAPSHOT);
                break;
            }
            case CHANGES: {
                tgt.setValue((Object)ListResource.ListMode.CHANGES);
                break;
            }
            default: {
                tgt.setValue((Object)ListResource.ListMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ListResource.ListStatus> convertListStatus(org.hl7.fhir.dstu3.model.Enumeration<ListResource.ListStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ListResource.ListStatus> tgt = new Enumeration<ListResource.ListStatus>(new ListResource.ListStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((ListResource.ListStatus)((Object)src.getValue())) {
            case CURRENT: {
                tgt.setValue((Object)ListResource.ListStatus.CURRENT);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)ListResource.ListStatus.RETIRED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ListResource.ListStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ListResource.ListStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ListResource.ListStatus> convertListStatus(Enumeration<ListResource.ListStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ListResource.ListStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ListResource.ListStatus>(new ListResource.ListStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((ListResource.ListStatus)((Object)src.getValue())) {
            case CURRENT: {
                tgt.setValue((Object)ListResource.ListStatus.CURRENT);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)ListResource.ListStatus.RETIRED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ListResource.ListStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ListResource.ListStatus.NULL);
            }
        }
        return tgt;
    }
}

