/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import java.util.List;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.ImagingStudy;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.ImagingStudy;

public class ImagingStudy30_50 {
    private static final String URN_DICOM_UID = "urn:dicom:uid";
    private static final String URN_IETF_RFC_3986 = "urn:ietf:rfc:3986";

    public static org.hl7.fhir.dstu3.model.ImagingStudy convertImagingStudy(ImagingStudy src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ImagingStudy tgt = new org.hl7.fhir.dstu3.model.ImagingStudy();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            if (URN_DICOM_UID.equals(identifier.getSystem())) {
                tgt.setUid(identifier.getValue());
                continue;
            }
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            ImagingStudy.ImagingStudyStatus s2 = src.getStatus();
            switch (s2) {
                case REGISTERED: {
                    tgt.setAvailability(ImagingStudy.InstanceAvailability.OFFLINE);
                    break;
                }
                case AVAILABLE: {
                    tgt.setAvailability(ImagingStudy.InstanceAvailability.ONLINE);
                    break;
                }
                case CANCELLED: {
                    tgt.setAvailability(ImagingStudy.InstanceAvailability.UNAVAILABLE);
                    break;
                }
            }
        }
        for (org.hl7.fhir.r5.model.Coding coding : src.getModality()) {
            tgt.addModalityList(VersionConvertor_30_50.convertCoding(coding));
        }
        if (src.hasSubject() && src.hasSubject()) {
            tgt.setPatient(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter() && src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_50.convertReference(src.getEncounter()));
        }
        if (src.hasStarted() && src.hasStartedElement()) {
            tgt.setStartedElement(VersionConvertor_30_50.convertDateTime(src.getStartedElement()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasReferrer() && src.hasReferrer()) {
            tgt.setReferrer(VersionConvertor_30_50.convertReference(src.getReferrer()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getInterpreter()) {
            tgt.addInterpreter(VersionConvertor_30_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasNumberOfSeries() && src.hasNumberOfSeriesElement()) {
            tgt.setNumberOfSeriesElement(VersionConvertor_30_50.convertUnsignedInt(src.getNumberOfSeriesElement()));
        }
        if (src.hasNumberOfInstances() && src.hasNumberOfInstancesElement()) {
            tgt.setNumberOfInstancesElement(VersionConvertor_30_50.convertUnsignedInt(src.getNumberOfInstancesElement()));
        }
        for (ImagingStudy.ImagingStudyProcedureComponent imagingStudyProcedureComponent : src.getProcedure()) {
            if (imagingStudyProcedureComponent.hasValueReference()) {
                tgt.addProcedureReference(VersionConvertor_30_50.convertReference(imagingStudyProcedureComponent.getValueReference()));
                continue;
            }
            tgt.addProcedureCode(VersionConvertor_30_50.convertCodeableConcept(imagingStudyProcedureComponent.getValueCodeableConcept()));
        }
        List<CodeableReference> reasonCodes = src.getReason();
        if (reasonCodes.size() > 0) {
            tgt.setReason(VersionConvertor_30_50.convertCodeableConcept(reasonCodes.get(0).getConcept()));
            if (reasonCodes.size() > 1) {
                // empty if block
            }
        }
        if (src.hasDescription() && src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        for (ImagingStudy.ImagingStudySeriesComponent t : src.getSeries()) {
            tgt.addSeries(ImagingStudy30_50.convertImagingStudySeriesComponent(t));
        }
        return tgt;
    }

    public static ImagingStudy convertImagingStudy(org.hl7.fhir.dstu3.model.ImagingStudy src) throws FHIRException {
        List<Reference> procedureReferences;
        if (src == null) {
            return null;
        }
        ImagingStudy tgt = new ImagingStudy();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUid()) {
            org.hl7.fhir.r5.model.Identifier i = new org.hl7.fhir.r5.model.Identifier();
            i.setSystem(URN_DICOM_UID);
            i.setValue(src.getUid());
            tgt.addIdentifier(i);
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasAccession()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(src.getAccession()));
        }
        if (src.hasAvailability()) {
            ImagingStudy.InstanceAvailability availability = src.getAvailability();
            switch (availability) {
                case OFFLINE: {
                    tgt.setStatus(ImagingStudy.ImagingStudyStatus.REGISTERED);
                    break;
                }
                case UNAVAILABLE: {
                    tgt.setStatus(ImagingStudy.ImagingStudyStatus.CANCELLED);
                    break;
                }
                case ONLINE: 
                case NEARLINE: {
                    tgt.setStatus(ImagingStudy.ImagingStudyStatus.AVAILABLE);
                    break;
                }
            }
        } else {
            tgt.setStatus(ImagingStudy.ImagingStudyStatus.UNKNOWN);
        }
        for (Coding coding : src.getModalityList()) {
            tgt.addModality(VersionConvertor_30_50.convertCoding(coding));
        }
        if (src.hasPatient()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getPatient()));
        }
        if (src.hasContext() && src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_50.convertReference(src.getContext()));
        }
        if (src.hasStarted() && src.hasStartedElement()) {
            tgt.setStartedElement(VersionConvertor_30_50.convertDateTime(src.getStartedElement()));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasReferrer() && src.hasReferrer()) {
            tgt.setReferrer(VersionConvertor_30_50.convertReference(src.getReferrer()));
        }
        for (Reference reference : src.getInterpreter()) {
            tgt.addInterpreter(VersionConvertor_30_50.convertReference(reference));
        }
        for (Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasNumberOfSeries() && src.hasNumberOfSeriesElement()) {
            tgt.setNumberOfSeriesElement(VersionConvertor_30_50.convertUnsignedInt(src.getNumberOfSeriesElement()));
        }
        if (src.hasNumberOfInstances() && src.hasNumberOfInstancesElement()) {
            tgt.setNumberOfInstancesElement(VersionConvertor_30_50.convertUnsignedInt(src.getNumberOfInstancesElement()));
        }
        if ((procedureReferences = src.getProcedureReference()).size() > 0) {
            tgt.addProcedure().setValue(VersionConvertor_30_50.convertReference(procedureReferences.get(0)));
        }
        for (CodeableConcept codeableConcept : src.getProcedureCode()) {
            tgt.addProcedure().setValue(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasReason() && src.hasReason()) {
            tgt.addReason(VersionConvertor_30_50.convertCodeableConceptToCodableReference(src.getReason()));
        }
        if (src.hasDescription() && src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        for (ImagingStudy.ImagingStudySeriesComponent imagingStudySeriesComponent : src.getSeries()) {
            tgt.addSeries(ImagingStudy30_50.convertImagingStudySeriesComponent(imagingStudySeriesComponent));
        }
        return tgt;
    }

    public static ImagingStudy.ImagingStudySeriesComponent convertImagingStudySeriesComponent(ImagingStudy.ImagingStudySeriesComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImagingStudy.ImagingStudySeriesComponent tgt = new ImagingStudy.ImagingStudySeriesComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasUid() && src.hasUid()) {
            tgt.setUid(src.getUid());
        }
        if (src.hasNumber() && src.hasNumberElement()) {
            tgt.setNumberElement(VersionConvertor_30_50.convertUnsignedInt(src.getNumberElement()));
        }
        if (src.hasModality() && src.hasModality()) {
            tgt.setModality(VersionConvertor_30_50.convertCoding(src.getModality()));
        }
        if (src.hasDescription() && src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasNumberOfInstances() && src.hasNumberOfInstancesElement()) {
            tgt.setNumberOfInstancesElement(VersionConvertor_30_50.convertUnsignedInt(src.getNumberOfInstancesElement()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasBodySite() && src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_30_50.convertCoding(src.getBodySite()));
        }
        if (src.hasLaterality() && src.hasLaterality()) {
            tgt.setLaterality(VersionConvertor_30_50.convertCoding(src.getLaterality()));
        }
        if (src.hasStarted() && src.hasStartedElement()) {
            tgt.setStartedElement(VersionConvertor_30_50.convertDateTime(src.getStartedElement()));
        }
        for (ImagingStudy.ImagingStudySeriesInstanceComponent imagingStudySeriesInstanceComponent : src.getInstance()) {
            tgt.addInstance(ImagingStudy30_50.convertImagingStudySeriesInstanceComponent(imagingStudySeriesInstanceComponent));
        }
        return tgt;
    }

    public static ImagingStudy.ImagingStudySeriesComponent convertImagingStudySeriesComponent(ImagingStudy.ImagingStudySeriesComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImagingStudy.ImagingStudySeriesComponent tgt = new ImagingStudy.ImagingStudySeriesComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasUid() && src.hasUid()) {
            tgt.setUid(src.getUid());
        }
        if (src.hasNumber() && src.hasNumberElement()) {
            tgt.setNumberElement(VersionConvertor_30_50.convertUnsignedInt(src.getNumberElement()));
        }
        if (src.hasModality() && src.hasModality()) {
            tgt.setModality(VersionConvertor_30_50.convertCoding(src.getModality()));
        }
        if (src.hasDescription() && src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasNumberOfInstances() && src.hasNumberOfInstancesElement()) {
            tgt.setNumberOfInstancesElement(VersionConvertor_30_50.convertUnsignedInt(src.getNumberOfInstancesElement()));
        }
        for (Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasBodySite() && src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_30_50.convertCoding(src.getBodySite()));
        }
        if (src.hasLaterality() && src.hasLaterality()) {
            tgt.setLaterality(VersionConvertor_30_50.convertCoding(src.getLaterality()));
        }
        if (src.hasStarted() && src.hasStartedElement()) {
            tgt.setStartedElement(VersionConvertor_30_50.convertDateTime(src.getStartedElement()));
        }
        for (ImagingStudy.ImagingStudySeriesInstanceComponent imagingStudySeriesInstanceComponent : src.getInstance()) {
            tgt.addInstance(ImagingStudy30_50.convertImagingStudySeriesInstanceComponent(imagingStudySeriesInstanceComponent));
        }
        return tgt;
    }

    public static ImagingStudy.ImagingStudySeriesInstanceComponent convertImagingStudySeriesInstanceComponent(ImagingStudy.ImagingStudySeriesInstanceComponent src) throws FHIRException {
        org.hl7.fhir.r5.model.Coding sop;
        if (src == null) {
            return null;
        }
        ImagingStudy.ImagingStudySeriesInstanceComponent tgt = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasUid() && src.hasUid()) {
            tgt.setUid(src.getUid());
        }
        if (URN_IETF_RFC_3986.equals((sop = src.getSopClass()).getSystem())) {
            tgt.setSopClass(sop.getCode());
        }
        if (src.hasNumber() && src.hasNumberElement()) {
            tgt.setNumberElement(VersionConvertor_30_50.convertUnsignedInt(src.getNumberElement()));
        }
        if (src.hasTitle() && src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        return tgt;
    }

    public static ImagingStudy.ImagingStudySeriesInstanceComponent convertImagingStudySeriesInstanceComponent(ImagingStudy.ImagingStudySeriesInstanceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImagingStudy.ImagingStudySeriesInstanceComponent tgt = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasUid() && src.hasUid()) {
            tgt.setUid(src.getUid());
        }
        if (src.hasSopClass()) {
            org.hl7.fhir.r5.model.Coding c = new org.hl7.fhir.r5.model.Coding();
            c.setSystem(URN_IETF_RFC_3986);
            c.setCode(src.getSopClass());
            tgt.setSopClass(c);
        }
        if (src.hasNumber() && src.hasNumberElement()) {
            tgt.setNumberElement(VersionConvertor_30_50.convertUnsignedInt(src.getNumberElement()));
        }
        if (src.hasTitle() && src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        return tgt;
    }
}

