/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;

public class Group30_50 {
    public static org.hl7.fhir.r5.model.Group convertGroup(Group src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Group tgt = new org.hl7.fhir.r5.model.Group();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Group30_50.convertGroupType(src.getTypeElement()));
        }
        if (src.hasActual()) {
            tgt.setActualElement(VersionConvertor_30_50.convertBoolean(src.getActualElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantityElement(VersionConvertor_30_50.convertUnsignedInt(src.getQuantityElement()));
        }
        for (Group.GroupCharacteristicComponent groupCharacteristicComponent : src.getCharacteristic()) {
            tgt.addCharacteristic(Group30_50.convertGroupCharacteristicComponent(groupCharacteristicComponent));
        }
        for (Group.GroupMemberComponent groupMemberComponent : src.getMember()) {
            tgt.addMember(Group30_50.convertGroupMemberComponent(groupMemberComponent));
        }
        return tgt;
    }

    public static Group convertGroup(org.hl7.fhir.r5.model.Group src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Group tgt = new Group();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Group30_50.convertGroupType(src.getTypeElement()));
        }
        if (src.hasActual()) {
            tgt.setActualElement(VersionConvertor_30_50.convertBoolean(src.getActualElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantityElement(VersionConvertor_30_50.convertUnsignedInt(src.getQuantityElement()));
        }
        for (Group.GroupCharacteristicComponent groupCharacteristicComponent : src.getCharacteristic()) {
            tgt.addCharacteristic(Group30_50.convertGroupCharacteristicComponent(groupCharacteristicComponent));
        }
        for (Group.GroupMemberComponent groupMemberComponent : src.getMember()) {
            tgt.addMember(Group30_50.convertGroupMemberComponent(groupMemberComponent));
        }
        return tgt;
    }

    public static Group.GroupCharacteristicComponent convertGroupCharacteristicComponent(Group.GroupCharacteristicComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Group.GroupCharacteristicComponent tgt = new Group.GroupCharacteristicComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_50.convertType(src.getValue()));
        }
        if (src.hasExclude()) {
            tgt.setExcludeElement(VersionConvertor_30_50.convertBoolean(src.getExcludeElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Group.GroupCharacteristicComponent convertGroupCharacteristicComponent(Group.GroupCharacteristicComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Group.GroupCharacteristicComponent tgt = new Group.GroupCharacteristicComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_50.convertType(src.getValue()));
        }
        if (src.hasExclude()) {
            tgt.setExcludeElement(VersionConvertor_30_50.convertBoolean(src.getExcludeElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Group.GroupMemberComponent convertGroupMemberComponent(Group.GroupMemberComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Group.GroupMemberComponent tgt = new Group.GroupMemberComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasEntity()) {
            tgt.setEntity(VersionConvertor_30_50.convertReference(src.getEntity()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasInactive()) {
            tgt.setInactiveElement(VersionConvertor_30_50.convertBoolean(src.getInactiveElement()));
        }
        return tgt;
    }

    public static Group.GroupMemberComponent convertGroupMemberComponent(Group.GroupMemberComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Group.GroupMemberComponent tgt = new Group.GroupMemberComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasEntity()) {
            tgt.setEntity(VersionConvertor_30_50.convertReference(src.getEntity()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasInactive()) {
            tgt.setInactiveElement(VersionConvertor_30_50.convertBoolean(src.getInactiveElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Group.GroupType> convertGroupType(Enumeration<Group.GroupType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Group.GroupType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Group.GroupType>(new Group.GroupTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Group.GroupType)((Object)src.getValue())) {
            case PERSON: {
                tgt.setValue((Object)Group.GroupType.PERSON);
                break;
            }
            case ANIMAL: {
                tgt.setValue((Object)Group.GroupType.ANIMAL);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)Group.GroupType.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)Group.GroupType.DEVICE);
                break;
            }
            case MEDICATION: {
                tgt.setValue((Object)Group.GroupType.MEDICATION);
                break;
            }
            case SUBSTANCE: {
                tgt.setValue((Object)Group.GroupType.SUBSTANCE);
                break;
            }
            default: {
                tgt.setValue((Object)Group.GroupType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Group.GroupType> convertGroupType(org.hl7.fhir.dstu3.model.Enumeration<Group.GroupType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Group.GroupType> tgt = new Enumeration<Group.GroupType>(new Group.GroupTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Group.GroupType)((Object)src.getValue())) {
            case PERSON: {
                tgt.setValue((Object)Group.GroupType.PERSON);
                break;
            }
            case ANIMAL: {
                tgt.setValue((Object)Group.GroupType.ANIMAL);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)Group.GroupType.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)Group.GroupType.DEVICE);
                break;
            }
            case MEDICATION: {
                tgt.setValue((Object)Group.GroupType.MEDICATION);
                break;
            }
            case SUBSTANCE: {
                tgt.setValue((Object)Group.GroupType.SUBSTANCE);
                break;
            }
            default: {
                tgt.setValue((Object)Group.GroupType.NULL);
            }
        }
        return tgt;
    }
}

