/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.DeviceUseStatement;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.DeviceUseStatement;
import org.hl7.fhir.r5.model.Enumeration;

public class DeviceUseStatement30_50 {
    public static DeviceUseStatement convertDeviceUseStatement(org.hl7.fhir.r5.model.DeviceUseStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceUseStatement tgt = new DeviceUseStatement();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DeviceUseStatement30_50.convertDeviceUseStatementStatus(src.getStatusElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_50.convertType(src.getTiming()));
        }
        if (src.hasDateAsserted()) {
            tgt.setRecordedOnElement(VersionConvertor_30_50.convertDateTime(src.getDateAssertedElement()));
        }
        if (src.hasInformationSource()) {
            tgt.setSource(VersionConvertor_30_50.convertReference(src.getInformationSource()));
        }
        if (src.getDevice().hasReference()) {
            tgt.setDevice(VersionConvertor_30_50.convertReference(src.getDevice().getReference()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addIndication(VersionConvertor_30_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        if (src.getBodySite().hasConcept()) {
            tgt.setBodySite(VersionConvertor_30_50.convertCodeableConcept(src.getBodySite().getConcept()));
        }
        for (org.hl7.fhir.r5.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.DeviceUseStatement convertDeviceUseStatement(DeviceUseStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.DeviceUseStatement tgt = new org.hl7.fhir.r5.model.DeviceUseStatement();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DeviceUseStatement30_50.convertDeviceUseStatementStatus(src.getStatusElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_50.convertType(src.getTiming()));
        }
        if (src.hasRecordedOn()) {
            tgt.setDateAssertedElement(VersionConvertor_30_50.convertDateTime(src.getRecordedOnElement()));
        }
        if (src.hasSource()) {
            tgt.setInformationSource(VersionConvertor_30_50.convertReference(src.getSource()));
        }
        if (src.hasDevice()) {
            tgt.getDevice().setReference(VersionConvertor_30_50.convertReference(src.getDevice()));
        }
        for (CodeableConcept codeableConcept : src.getIndication()) {
            tgt.addReason(VersionConvertor_30_50.convertCodeableConceptToCodableReference(codeableConcept));
        }
        if (src.hasBodySite()) {
            tgt.getBodySite().setConcept(VersionConvertor_30_50.convertCodeableConcept(src.getBodySite()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<DeviceUseStatement.DeviceUseStatementStatus> convertDeviceUseStatementStatus(Enumeration<DeviceUseStatement.DeviceUseStatementStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<DeviceUseStatement.DeviceUseStatementStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<DeviceUseStatement.DeviceUseStatementStatus>(new DeviceUseStatement.DeviceUseStatementStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceUseStatement.DeviceUseStatementStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.ENTEREDINERROR);
                break;
            }
            case INTENDED: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.INTENDED);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.STOPPED);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.ONHOLD);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DeviceUseStatement.DeviceUseStatementStatus> convertDeviceUseStatementStatus(org.hl7.fhir.dstu3.model.Enumeration<DeviceUseStatement.DeviceUseStatementStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DeviceUseStatement.DeviceUseStatementStatus> tgt = new Enumeration<DeviceUseStatement.DeviceUseStatementStatus>(new DeviceUseStatement.DeviceUseStatementStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceUseStatement.DeviceUseStatementStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.ENTEREDINERROR);
                break;
            }
            case INTENDED: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.INTENDED);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.STOPPED);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.ONHOLD);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceUseStatement.DeviceUseStatementStatus.NULL);
            }
        }
        return tgt;
    }
}

