/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.CompartmentDefinition;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.StringType;

public class CompartmentDefinition30_50 {
    public static org.hl7.fhir.r5.model.CompartmentDefinition convertCompartmentDefinition(CompartmentDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.CompartmentDefinition tgt = new org.hl7.fhir.r5.model.CompartmentDefinition();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(CompartmentDefinition30_50.convertCompartmentType(src.getCodeElement()));
        }
        if (src.hasSearch()) {
            tgt.setSearchElement(VersionConvertor_30_50.convertBoolean(src.getSearchElement()));
        }
        for (CompartmentDefinition.CompartmentDefinitionResourceComponent compartmentDefinitionResourceComponent : src.getResource()) {
            tgt.addResource(CompartmentDefinition30_50.convertCompartmentDefinitionResourceComponent(compartmentDefinitionResourceComponent));
        }
        return tgt;
    }

    public static CompartmentDefinition convertCompartmentDefinition(org.hl7.fhir.r5.model.CompartmentDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CompartmentDefinition tgt = new CompartmentDefinition();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r5.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(CompartmentDefinition30_50.convertCompartmentType(src.getCodeElement()));
        }
        if (src.hasSearch()) {
            tgt.setSearchElement(VersionConvertor_30_50.convertBoolean(src.getSearchElement()));
        }
        for (CompartmentDefinition.CompartmentDefinitionResourceComponent compartmentDefinitionResourceComponent : src.getResource()) {
            tgt.addResource(CompartmentDefinition30_50.convertCompartmentDefinitionResourceComponent(compartmentDefinitionResourceComponent));
        }
        return tgt;
    }

    public static CompartmentDefinition.CompartmentDefinitionResourceComponent convertCompartmentDefinitionResourceComponent(CompartmentDefinition.CompartmentDefinitionResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CompartmentDefinition.CompartmentDefinitionResourceComponent tgt = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        for (org.hl7.fhir.dstu3.model.StringType t : src.getParam()) {
            tgt.addParam((String)t.getValue());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static CompartmentDefinition.CompartmentDefinitionResourceComponent convertCompartmentDefinitionResourceComponent(CompartmentDefinition.CompartmentDefinitionResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CompartmentDefinition.CompartmentDefinitionResourceComponent tgt = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        for (StringType t : src.getParam()) {
            tgt.addParam((String)t.getValue());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CompartmentDefinition.CompartmentType> convertCompartmentType(Enumeration<Enumerations.CompartmentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CompartmentDefinition.CompartmentType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CompartmentDefinition.CompartmentType>(new CompartmentDefinition.CompartmentTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.CompartmentType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.PATIENT);
                break;
            }
            case ENCOUNTER: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.ENCOUNTER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.RELATEDPERSON);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.CompartmentType> convertCompartmentType(org.hl7.fhir.dstu3.model.Enumeration<CompartmentDefinition.CompartmentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.CompartmentType> tgt = new Enumeration<Enumerations.CompartmentType>(new Enumerations.CompartmentTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CompartmentDefinition.CompartmentType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)Enumerations.CompartmentType.PATIENT);
                break;
            }
            case ENCOUNTER: {
                tgt.setValue((Object)Enumerations.CompartmentType.ENCOUNTER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)Enumerations.CompartmentType.RELATEDPERSON);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)Enumerations.CompartmentType.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)Enumerations.CompartmentType.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.CompartmentType.NULL);
            }
        }
        return tgt;
    }
}

