/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.AppointmentResponse;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;

public class AppointmentResponse30_50 {
    public static org.hl7.fhir.r5.model.AppointmentResponse convertAppointmentResponse(AppointmentResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.AppointmentResponse tgt = new org.hl7.fhir.r5.model.AppointmentResponse();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasAppointment()) {
            tgt.setAppointment(VersionConvertor_30_50.convertReference(src.getAppointment()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_50.convertInstant(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_50.convertInstant(src.getEndElement()));
        }
        for (CodeableConcept codeableConcept : src.getParticipantType()) {
            tgt.addParticipantType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_50.convertReference(src.getActor()));
        }
        if (src.hasParticipantStatus()) {
            tgt.setParticipantStatusElement(AppointmentResponse30_50.convertParticipantStatus(src.getParticipantStatusElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static AppointmentResponse convertAppointmentResponse(org.hl7.fhir.r5.model.AppointmentResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AppointmentResponse tgt = new AppointmentResponse();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasAppointment()) {
            tgt.setAppointment(VersionConvertor_30_50.convertReference(src.getAppointment()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_50.convertInstant(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_50.convertInstant(src.getEndElement()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getParticipantType()) {
            tgt.addParticipantType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_50.convertReference(src.getActor()));
        }
        if (src.hasParticipantStatus()) {
            tgt.setParticipantStatusElement(AppointmentResponse30_50.convertParticipantStatus(src.getParticipantStatusElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<AppointmentResponse.ParticipantStatus> convertParticipantStatus(Enumeration<Enumerations.ParticipationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<AppointmentResponse.ParticipantStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<AppointmentResponse.ParticipantStatus>(new AppointmentResponse.ParticipantStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ParticipationStatus)((Object)src.getValue())) {
            case ACCEPTED: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.ACCEPTED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.DECLINED);
                break;
            }
            case TENTATIVE: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.TENTATIVE);
                break;
            }
            case NEEDSACTION: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.NEEDSACTION);
                break;
            }
            default: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.ParticipationStatus> convertParticipantStatus(org.hl7.fhir.dstu3.model.Enumeration<AppointmentResponse.ParticipantStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.ParticipationStatus> tgt = new Enumeration<Enumerations.ParticipationStatus>(new Enumerations.ParticipationStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((AppointmentResponse.ParticipantStatus)((Object)src.getValue())) {
            case ACCEPTED: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.ACCEPTED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.DECLINED);
                break;
            }
            case TENTATIVE: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.TENTATIVE);
                break;
            }
            case NEEDSACTION: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.NEEDSACTION);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.NULL);
            }
        }
        return tgt;
    }
}

