/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Subscription;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Subscription;

public class Subscription30_40 {
    public static Subscription convertSubscription(org.hl7.fhir.dstu3.model.Subscription src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Subscription tgt = new Subscription();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(Subscription30_40.convertSubscriptionStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactPoint(t));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_40.convertInstant(src.getEndElement()));
        }
        if (src.hasReason()) {
            tgt.setReasonElement(VersionConvertor_30_40.convertString(src.getReasonElement()));
        }
        if (src.hasCriteria()) {
            tgt.setCriteriaElement(VersionConvertor_30_40.convertString(src.getCriteriaElement()));
        }
        if (src.hasError()) {
            tgt.setErrorElement(VersionConvertor_30_40.convertString(src.getErrorElement()));
        }
        if (src.hasChannel()) {
            tgt.setChannel(Subscription30_40.convertSubscriptionChannelComponent(src.getChannel()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Subscription convertSubscription(Subscription src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Subscription tgt = new org.hl7.fhir.dstu3.model.Subscription();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(Subscription30_40.convertSubscriptionStatus(src.getStatusElement()));
        }
        for (ContactPoint t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactPoint(t));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_40.convertInstant(src.getEndElement()));
        }
        if (src.hasReason()) {
            tgt.setReasonElement(VersionConvertor_30_40.convertString(src.getReasonElement()));
        }
        if (src.hasCriteria()) {
            tgt.setCriteriaElement(VersionConvertor_30_40.convertString(src.getCriteriaElement()));
        }
        if (src.hasError()) {
            tgt.setErrorElement(VersionConvertor_30_40.convertString(src.getErrorElement()));
        }
        if (src.hasChannel()) {
            tgt.setChannel(Subscription30_40.convertSubscriptionChannelComponent(src.getChannel()));
        }
        return tgt;
    }

    public static Subscription.SubscriptionChannelComponent convertSubscriptionChannelComponent(Subscription.SubscriptionChannelComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Subscription.SubscriptionChannelComponent tgt = new Subscription.SubscriptionChannelComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(Subscription30_40.convertSubscriptionChannelType(src.getTypeElement()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpoint(src.getEndpoint());
        }
        if (src.hasPayload()) {
            tgt.setPayload(src.getPayload());
        }
        for (StringType t : src.getHeader()) {
            tgt.addHeader((String)t.getValue());
        }
        return tgt;
    }

    public static Subscription.SubscriptionChannelComponent convertSubscriptionChannelComponent(Subscription.SubscriptionChannelComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Subscription.SubscriptionChannelComponent tgt = new Subscription.SubscriptionChannelComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(Subscription30_40.convertSubscriptionChannelType(src.getTypeElement()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpoint(src.getEndpoint());
        }
        if (src.hasPayload()) {
            tgt.setPayload(src.getPayload());
        }
        for (org.hl7.fhir.dstu3.model.StringType t : src.getHeader()) {
            tgt.addHeader((String)t.getValue());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionChannelType> convertSubscriptionChannelType(Enumeration<Subscription.SubscriptionChannelType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionChannelType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionChannelType>(new Subscription.SubscriptionChannelTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Subscription.SubscriptionChannelType)((Object)src.getValue())) {
            case RESTHOOK: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.RESTHOOK);
                break;
            }
            case WEBSOCKET: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.WEBSOCKET);
                break;
            }
            case EMAIL: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.EMAIL);
                break;
            }
            case SMS: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.SMS);
                break;
            }
            case MESSAGE: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.MESSAGE);
                break;
            }
            default: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Subscription.SubscriptionChannelType> convertSubscriptionChannelType(org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionChannelType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Subscription.SubscriptionChannelType> tgt = new Enumeration<Subscription.SubscriptionChannelType>(new Subscription.SubscriptionChannelTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Subscription.SubscriptionChannelType)((Object)src.getValue())) {
            case RESTHOOK: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.RESTHOOK);
                break;
            }
            case WEBSOCKET: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.WEBSOCKET);
                break;
            }
            case EMAIL: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.EMAIL);
                break;
            }
            case SMS: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.SMS);
                break;
            }
            case MESSAGE: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.MESSAGE);
                break;
            }
            default: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Subscription.SubscriptionStatus> convertSubscriptionStatus(org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Subscription.SubscriptionStatus> tgt = new Enumeration<Subscription.SubscriptionStatus>(new Subscription.SubscriptionStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Subscription.SubscriptionStatus)((Object)src.getValue())) {
            case REQUESTED: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.REQUESTED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.ACTIVE);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.ERROR);
                break;
            }
            case OFF: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.OFF);
                break;
            }
            default: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionStatus> convertSubscriptionStatus(Enumeration<Subscription.SubscriptionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionStatus>(new Subscription.SubscriptionStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Subscription.SubscriptionStatus)((Object)src.getValue())) {
            case REQUESTED: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.REQUESTED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.ACTIVE);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.ERROR);
                break;
            }
            case OFF: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.OFF);
                break;
            }
            default: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.NULL);
            }
        }
        return tgt;
    }
}

