/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Sequence;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.MolecularSequence;

public class Sequence30_40 {
    public static org.hl7.fhir.dstu3.model.Enumeration<Sequence.QualityType> convertQualityType(Enumeration<MolecularSequence.QualityType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Sequence.QualityType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Sequence.QualityType>(new Sequence.QualityTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((MolecularSequence.QualityType)((Object)src.getValue())) {
            case INDEL: {
                tgt.setValue((Object)Sequence.QualityType.INDEL);
                break;
            }
            case SNP: {
                tgt.setValue((Object)Sequence.QualityType.SNP);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Sequence.QualityType.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Sequence.QualityType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MolecularSequence.QualityType> convertQualityType(org.hl7.fhir.dstu3.model.Enumeration<Sequence.QualityType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MolecularSequence.QualityType> tgt = new Enumeration<MolecularSequence.QualityType>(new MolecularSequence.QualityTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Sequence.QualityType)((Object)src.getValue())) {
            case INDEL: {
                tgt.setValue((Object)MolecularSequence.QualityType.INDEL);
                break;
            }
            case SNP: {
                tgt.setValue((Object)MolecularSequence.QualityType.SNP);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MolecularSequence.QualityType.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)MolecularSequence.QualityType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Sequence.RepositoryType> convertRepositoryType(Enumeration<MolecularSequence.RepositoryType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Sequence.RepositoryType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Sequence.RepositoryType>(new Sequence.RepositoryTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((MolecularSequence.RepositoryType)((Object)src.getValue())) {
            case DIRECTLINK: {
                tgt.setValue((Object)Sequence.RepositoryType.DIRECTLINK);
                break;
            }
            case OPENAPI: {
                tgt.setValue((Object)Sequence.RepositoryType.OPENAPI);
                break;
            }
            case LOGIN: {
                tgt.setValue((Object)Sequence.RepositoryType.LOGIN);
                break;
            }
            case OAUTH: {
                tgt.setValue((Object)Sequence.RepositoryType.OAUTH);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)Sequence.RepositoryType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)Sequence.RepositoryType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MolecularSequence.RepositoryType> convertRepositoryType(org.hl7.fhir.dstu3.model.Enumeration<Sequence.RepositoryType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MolecularSequence.RepositoryType> tgt = new Enumeration<MolecularSequence.RepositoryType>(new MolecularSequence.RepositoryTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Sequence.RepositoryType)((Object)src.getValue())) {
            case DIRECTLINK: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.DIRECTLINK);
                break;
            }
            case OPENAPI: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.OPENAPI);
                break;
            }
            case LOGIN: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.LOGIN);
                break;
            }
            case OAUTH: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.OAUTH);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.NULL);
            }
        }
        return tgt;
    }

    public static Sequence convertSequence(MolecularSequence src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Sequence tgt = new Sequence();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Sequence30_40.convertSequenceType(src.getTypeElement()));
        }
        if (src.hasCoordinateSystem()) {
            tgt.setCoordinateSystemElement(VersionConvertor_30_40.convertInteger(src.getCoordinateSystemElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(VersionConvertor_30_40.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_30_40.convertReference(src.getDevice()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_30_40.convertReference(src.getPerformer()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertQuantity(src.getQuantity()));
        }
        if (src.hasReferenceSeq()) {
            tgt.setReferenceSeq(Sequence30_40.convertSequenceReferenceSeqComponent(src.getReferenceSeq()));
        }
        for (MolecularSequence.MolecularSequenceVariantComponent molecularSequenceVariantComponent : src.getVariant()) {
            tgt.addVariant(Sequence30_40.convertSequenceVariantComponent(molecularSequenceVariantComponent));
        }
        if (src.hasObservedSeq()) {
            tgt.setObservedSeqElement(VersionConvertor_30_40.convertString(src.getObservedSeqElement()));
        }
        for (MolecularSequence.MolecularSequenceQualityComponent molecularSequenceQualityComponent : src.getQuality()) {
            tgt.addQuality(Sequence30_40.convertSequenceQualityComponent(molecularSequenceQualityComponent));
        }
        if (src.hasReadCoverage()) {
            tgt.setReadCoverageElement(VersionConvertor_30_40.convertInteger(src.getReadCoverageElement()));
        }
        for (MolecularSequence.MolecularSequenceRepositoryComponent molecularSequenceRepositoryComponent : src.getRepository()) {
            tgt.addRepository(Sequence30_40.convertSequenceRepositoryComponent(molecularSequenceRepositoryComponent));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPointer()) {
            tgt.addPointer(VersionConvertor_30_40.convertReference(reference));
        }
        return tgt;
    }

    public static MolecularSequence convertSequence(Sequence src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence tgt = new MolecularSequence();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Sequence30_40.convertSequenceType(src.getTypeElement()));
        }
        if (src.hasCoordinateSystem()) {
            tgt.setCoordinateSystemElement(VersionConvertor_30_40.convertInteger(src.getCoordinateSystemElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(VersionConvertor_30_40.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_30_40.convertReference(src.getDevice()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_30_40.convertReference(src.getPerformer()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertQuantity(src.getQuantity()));
        }
        if (src.hasReferenceSeq()) {
            tgt.setReferenceSeq(Sequence30_40.convertSequenceReferenceSeqComponent(src.getReferenceSeq()));
        }
        for (Sequence.SequenceVariantComponent sequenceVariantComponent : src.getVariant()) {
            tgt.addVariant(Sequence30_40.convertSequenceVariantComponent(sequenceVariantComponent));
        }
        if (src.hasObservedSeq()) {
            tgt.setObservedSeqElement(VersionConvertor_30_40.convertString(src.getObservedSeqElement()));
        }
        for (Sequence.SequenceQualityComponent sequenceQualityComponent : src.getQuality()) {
            tgt.addQuality(Sequence30_40.convertSequenceQualityComponent(sequenceQualityComponent));
        }
        if (src.hasReadCoverage()) {
            tgt.setReadCoverageElement(VersionConvertor_30_40.convertInteger(src.getReadCoverageElement()));
        }
        for (Sequence.SequenceRepositoryComponent sequenceRepositoryComponent : src.getRepository()) {
            tgt.addRepository(Sequence30_40.convertSequenceRepositoryComponent(sequenceRepositoryComponent));
        }
        for (Reference reference : src.getPointer()) {
            tgt.addPointer(VersionConvertor_30_40.convertReference(reference));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceQualityComponent convertSequenceQualityComponent(Sequence.SequenceQualityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceQualityComponent tgt = new MolecularSequence.MolecularSequenceQualityComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(Sequence30_40.convertQualityType(src.getTypeElement()));
        }
        if (src.hasStandardSequence()) {
            tgt.setStandardSequence(VersionConvertor_30_40.convertCodeableConcept(src.getStandardSequence()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_40.convertInteger(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_40.convertInteger(src.getEndElement()));
        }
        if (src.hasScore()) {
            tgt.setScore(VersionConvertor_30_40.convertQuantity(src.getScore()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasTruthTP()) {
            tgt.setTruthTPElement(VersionConvertor_30_40.convertDecimal(src.getTruthTPElement()));
        }
        if (src.hasQueryTP()) {
            tgt.setQueryTPElement(VersionConvertor_30_40.convertDecimal(src.getQueryTPElement()));
        }
        if (src.hasTruthFN()) {
            tgt.setTruthFNElement(VersionConvertor_30_40.convertDecimal(src.getTruthFNElement()));
        }
        if (src.hasQueryFP()) {
            tgt.setQueryFPElement(VersionConvertor_30_40.convertDecimal(src.getQueryFPElement()));
        }
        if (src.hasGtFP()) {
            tgt.setGtFPElement(VersionConvertor_30_40.convertDecimal(src.getGtFPElement()));
        }
        if (src.hasPrecision()) {
            tgt.setPrecisionElement(VersionConvertor_30_40.convertDecimal(src.getPrecisionElement()));
        }
        if (src.hasRecall()) {
            tgt.setRecallElement(VersionConvertor_30_40.convertDecimal(src.getRecallElement()));
        }
        if (src.hasFScore()) {
            tgt.setFScoreElement(VersionConvertor_30_40.convertDecimal(src.getFScoreElement()));
        }
        return tgt;
    }

    public static Sequence.SequenceQualityComponent convertSequenceQualityComponent(MolecularSequence.MolecularSequenceQualityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Sequence.SequenceQualityComponent tgt = new Sequence.SequenceQualityComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(Sequence30_40.convertQualityType(src.getTypeElement()));
        }
        if (src.hasStandardSequence()) {
            tgt.setStandardSequence(VersionConvertor_30_40.convertCodeableConcept(src.getStandardSequence()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_40.convertInteger(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_40.convertInteger(src.getEndElement()));
        }
        if (src.hasScore()) {
            tgt.setScore(VersionConvertor_30_40.convertQuantity(src.getScore()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasTruthTP()) {
            tgt.setTruthTPElement(VersionConvertor_30_40.convertDecimal(src.getTruthTPElement()));
        }
        if (src.hasQueryTP()) {
            tgt.setQueryTPElement(VersionConvertor_30_40.convertDecimal(src.getQueryTPElement()));
        }
        if (src.hasTruthFN()) {
            tgt.setTruthFNElement(VersionConvertor_30_40.convertDecimal(src.getTruthFNElement()));
        }
        if (src.hasQueryFP()) {
            tgt.setQueryFPElement(VersionConvertor_30_40.convertDecimal(src.getQueryFPElement()));
        }
        if (src.hasGtFP()) {
            tgt.setGtFPElement(VersionConvertor_30_40.convertDecimal(src.getGtFPElement()));
        }
        if (src.hasPrecision()) {
            tgt.setPrecisionElement(VersionConvertor_30_40.convertDecimal(src.getPrecisionElement()));
        }
        if (src.hasRecall()) {
            tgt.setRecallElement(VersionConvertor_30_40.convertDecimal(src.getRecallElement()));
        }
        if (src.hasFScore()) {
            tgt.setFScoreElement(VersionConvertor_30_40.convertDecimal(src.getFScoreElement()));
        }
        return tgt;
    }

    public static Sequence.SequenceReferenceSeqComponent convertSequenceReferenceSeqComponent(MolecularSequence.MolecularSequenceReferenceSeqComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Sequence.SequenceReferenceSeqComponent tgt = new Sequence.SequenceReferenceSeqComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasChromosome()) {
            tgt.setChromosome(VersionConvertor_30_40.convertCodeableConcept(src.getChromosome()));
        }
        if (src.hasGenomeBuild()) {
            tgt.setGenomeBuildElement(VersionConvertor_30_40.convertString(src.getGenomeBuildElement()));
        }
        if (src.hasReferenceSeqId()) {
            tgt.setReferenceSeqId(VersionConvertor_30_40.convertCodeableConcept(src.getReferenceSeqId()));
        }
        if (src.hasReferenceSeqPointer()) {
            tgt.setReferenceSeqPointer(VersionConvertor_30_40.convertReference(src.getReferenceSeqPointer()));
        }
        if (src.hasReferenceSeqString()) {
            tgt.setReferenceSeqStringElement(VersionConvertor_30_40.convertString(src.getReferenceSeqStringElement()));
        }
        if (src.hasWindowStart()) {
            tgt.setWindowStartElement(VersionConvertor_30_40.convertInteger(src.getWindowStartElement()));
        }
        if (src.hasWindowEnd()) {
            tgt.setWindowEndElement(VersionConvertor_30_40.convertInteger(src.getWindowEndElement()));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceReferenceSeqComponent convertSequenceReferenceSeqComponent(Sequence.SequenceReferenceSeqComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceReferenceSeqComponent tgt = new MolecularSequence.MolecularSequenceReferenceSeqComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasChromosome()) {
            tgt.setChromosome(VersionConvertor_30_40.convertCodeableConcept(src.getChromosome()));
        }
        if (src.hasGenomeBuild()) {
            tgt.setGenomeBuildElement(VersionConvertor_30_40.convertString(src.getGenomeBuildElement()));
        }
        if (src.hasReferenceSeqId()) {
            tgt.setReferenceSeqId(VersionConvertor_30_40.convertCodeableConcept(src.getReferenceSeqId()));
        }
        if (src.hasReferenceSeqPointer()) {
            tgt.setReferenceSeqPointer(VersionConvertor_30_40.convertReference(src.getReferenceSeqPointer()));
        }
        if (src.hasReferenceSeqString()) {
            tgt.setReferenceSeqStringElement(VersionConvertor_30_40.convertString(src.getReferenceSeqStringElement()));
        }
        if (src.hasWindowStart()) {
            tgt.setWindowStartElement(VersionConvertor_30_40.convertInteger(src.getWindowStartElement()));
        }
        if (src.hasWindowEnd()) {
            tgt.setWindowEndElement(VersionConvertor_30_40.convertInteger(src.getWindowEndElement()));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceRepositoryComponent convertSequenceRepositoryComponent(Sequence.SequenceRepositoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceRepositoryComponent tgt = new MolecularSequence.MolecularSequenceRepositoryComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(Sequence30_40.convertRepositoryType(src.getTypeElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasDatasetId()) {
            tgt.setDatasetIdElement(VersionConvertor_30_40.convertString(src.getDatasetIdElement()));
        }
        if (src.hasVariantsetId()) {
            tgt.setVariantsetIdElement(VersionConvertor_30_40.convertString(src.getVariantsetIdElement()));
        }
        if (src.hasReadsetId()) {
            tgt.setReadsetIdElement(VersionConvertor_30_40.convertString(src.getReadsetIdElement()));
        }
        return tgt;
    }

    public static Sequence.SequenceRepositoryComponent convertSequenceRepositoryComponent(MolecularSequence.MolecularSequenceRepositoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Sequence.SequenceRepositoryComponent tgt = new Sequence.SequenceRepositoryComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(Sequence30_40.convertRepositoryType(src.getTypeElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasDatasetId()) {
            tgt.setDatasetIdElement(VersionConvertor_30_40.convertString(src.getDatasetIdElement()));
        }
        if (src.hasVariantsetId()) {
            tgt.setVariantsetIdElement(VersionConvertor_30_40.convertString(src.getVariantsetIdElement()));
        }
        if (src.hasReadsetId()) {
            tgt.setReadsetIdElement(VersionConvertor_30_40.convertString(src.getReadsetIdElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Sequence.SequenceType> convertSequenceType(Enumeration<MolecularSequence.SequenceType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Sequence.SequenceType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Sequence.SequenceType>(new Sequence.SequenceTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((MolecularSequence.SequenceType)((Object)src.getValue())) {
            case AA: {
                tgt.setValue((Object)Sequence.SequenceType.AA);
                break;
            }
            case DNA: {
                tgt.setValue((Object)Sequence.SequenceType.DNA);
                break;
            }
            case RNA: {
                tgt.setValue((Object)Sequence.SequenceType.RNA);
                break;
            }
            default: {
                tgt.setValue((Object)Sequence.SequenceType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MolecularSequence.SequenceType> convertSequenceType(org.hl7.fhir.dstu3.model.Enumeration<Sequence.SequenceType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MolecularSequence.SequenceType> tgt = new Enumeration<MolecularSequence.SequenceType>(new MolecularSequence.SequenceTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Sequence.SequenceType)((Object)src.getValue())) {
            case AA: {
                tgt.setValue((Object)MolecularSequence.SequenceType.AA);
                break;
            }
            case DNA: {
                tgt.setValue((Object)MolecularSequence.SequenceType.DNA);
                break;
            }
            case RNA: {
                tgt.setValue((Object)MolecularSequence.SequenceType.RNA);
                break;
            }
            default: {
                tgt.setValue((Object)MolecularSequence.SequenceType.NULL);
            }
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceVariantComponent convertSequenceVariantComponent(Sequence.SequenceVariantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceVariantComponent tgt = new MolecularSequence.MolecularSequenceVariantComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_40.convertInteger(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_40.convertInteger(src.getEndElement()));
        }
        if (src.hasObservedAllele()) {
            tgt.setObservedAlleleElement(VersionConvertor_30_40.convertString(src.getObservedAlleleElement()));
        }
        if (src.hasReferenceAllele()) {
            tgt.setReferenceAlleleElement(VersionConvertor_30_40.convertString(src.getReferenceAlleleElement()));
        }
        if (src.hasCigar()) {
            tgt.setCigarElement(VersionConvertor_30_40.convertString(src.getCigarElement()));
        }
        if (src.hasVariantPointer()) {
            tgt.setVariantPointer(VersionConvertor_30_40.convertReference(src.getVariantPointer()));
        }
        return tgt;
    }

    public static Sequence.SequenceVariantComponent convertSequenceVariantComponent(MolecularSequence.MolecularSequenceVariantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Sequence.SequenceVariantComponent tgt = new Sequence.SequenceVariantComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_40.convertInteger(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_40.convertInteger(src.getEndElement()));
        }
        if (src.hasObservedAllele()) {
            tgt.setObservedAlleleElement(VersionConvertor_30_40.convertString(src.getObservedAlleleElement()));
        }
        if (src.hasReferenceAllele()) {
            tgt.setReferenceAlleleElement(VersionConvertor_30_40.convertString(src.getReferenceAlleleElement()));
        }
        if (src.hasCigar()) {
            tgt.setCigarElement(VersionConvertor_30_40.convertString(src.getCigarElement()));
        }
        if (src.hasVariantPointer()) {
            tgt.setVariantPointer(VersionConvertor_30_40.convertReference(src.getVariantPointer()));
        }
        return tgt;
    }
}

